/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.command;

import arekkuusu.enderskills.api.capability.AdvancementCapability;
import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.common.CommonConfig;
import arekkuusu.enderskills.common.network.PacketHelper;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandAdvancement
extends CommandBase {
    public String func_71517_b() {
        return "enderskills_advancement";
    }

    public List<String> func_71514_a() {
        return ImmutableList.of((Object)"es_advancement");
    }

    public String func_71518_a(ICommandSender sender) {
        return "Usage: /" + this.func_71517_b() + "[entity/player/@p] [retries/level] [set/add/sub/query] [value]";
    }

    public int func_82362_a() {
        return 2;
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandAdvancement.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 2) {
            return CommandAdvancement.func_71530_a((String[])args, (String[])new String[]{"retries", "level"});
        }
        if (args.length == 3) {
            return CommandAdvancement.func_71530_a((String[])args, (String[])new String[]{"set", "add", "sub", "query"});
        }
        return super.func_184883_a(server, sender, args, targetPos);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityLivingBase entity = (EntityLivingBase)CommandAdvancement.func_184884_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0], EntityLivingBase.class);
        if (entity == null) {
            this.message(sender, "not_found.player", new Object[0]);
            return;
        }
        try {
            AdvancementCapability capability = Capabilities.advancement((Entity)entity).orElse(null);
            if (capability == null) {
                this.message(sender, "not_found.player", new Object[0]);
                return;
            }
            switch (args[1]) {
                case "retries": {
                    int valueToSet;
                    int n = valueToSet = args.length > 3 ? CommandAdvancement.func_175755_a((String)args[3]) : 0;
                    if (valueToSet < 0) {
                        this.message(sender, "advancement.invalid.retries", valueToSet);
                        return;
                    }
                    switch (args[2]) {
                        case "set": {
                            if (valueToSet > CommonConfig.getValues().advancement.maxResetUnlocks) {
                                this.message(sender, "advancement.invalid.retries", new Object[0]);
                                return;
                            }
                            capability.resetCount = valueToSet;
                            break;
                        }
                        case "add": {
                            int sum = Math.min(capability.resetCount + valueToSet, Integer.MAX_VALUE);
                            if (sum > CommonConfig.getValues().advancement.maxResetUnlocks) {
                                this.message(sender, "advancement.invalid.retries", valueToSet);
                                return;
                            }
                            capability.resetCount = sum;
                            break;
                        }
                        case "sub": {
                            int sub = Math.max(capability.resetCount - valueToSet, 0);
                            if (sub > CommonConfig.getValues().advancement.maxResetUnlocks) {
                                this.message(sender, "advancement.invalid.retries", valueToSet);
                                return;
                            }
                            capability.resetCount = sub;
                            break;
                        }
                        case "query": {
                            this.message(sender, "advancement.get.retries", capability.resetCount);
                            return;
                        }
                    }
                    this.message(sender, "advancement.set.retries", capability.resetCount);
                    break;
                }
                case "level": {
                    int levelToSet;
                    int n = levelToSet = args.length > 3 ? CommandAdvancement.func_175755_a((String)args[3]) : 0;
                    if (levelToSet < 0) {
                        this.message(sender, "advancement.invalid.level", levelToSet);
                        return;
                    }
                    switch (args[2]) {
                        case "set": {
                            capability.level = levelToSet;
                            capability.levelProgress = 0.0;
                            break;
                        }
                        case "add": {
                            int sum;
                            capability.level = sum = Math.min(capability.level + levelToSet, Integer.MAX_VALUE);
                            break;
                        }
                        case "sub": {
                            int sub;
                            capability.level = sub = Math.max(capability.level - levelToSet, 0);
                            break;
                        }
                        case "query": {
                            this.message(sender, "advancement.get.level", capability.level);
                            return;
                        }
                    }
                    this.message(sender, "advancement.set.level", capability.level);
                    break;
                }
                default: {
                    this.message(sender, "advancement.invalid", new Object[0]);
                    return;
                }
            }
            if (entity instanceof EntityPlayerMP) {
                PacketHelper.sendAdvancementSync((EntityPlayerMP)entity);
            }
        }
        catch (NumberFormatException ex) {
            this.message(sender, "invalid.number", new Object[0]);
        }
    }

    private void message(ICommandSender sender, String type, Object ... args) {
        String key = "command.enderskills." + type;
        CommandAdvancement.func_152373_a((ICommandSender)sender, (ICommand)this, (String)key, (Object[])args);
    }
}

