/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.command;

import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.api.capability.EnduranceCapability;
import arekkuusu.enderskills.common.network.PacketHelper;
import arekkuusu.enderskills.common.skill.attribute.mobility.Endurance;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandEnduranceReset
extends CommandBase {
    public String func_71517_b() {
        return "enderskills_endurance";
    }

    public List<String> func_71514_a() {
        return ImmutableList.of((Object)"es_endurance");
    }

    public String func_71518_a(ICommandSender sender) {
        return "Usage: /" + this.func_71517_b() + "[entity/player/@p] reset";
    }

    public int func_82362_a() {
        return 2;
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandEnduranceReset.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 2) {
            return CommandEnduranceReset.func_71530_a((String[])args, (String[])new String[]{"reset"});
        }
        return super.func_184883_a(server, sender, args, targetPos);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityLivingBase entity = (EntityLivingBase)CommandEnduranceReset.func_184884_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0], EntityLivingBase.class);
        if (entity == null) {
            this.message(sender, "not_found.player", new Object[0]);
            return;
        }
        EnduranceCapability capability = Capabilities.endurance((Entity)entity).orElse(null);
        if (capability == null) {
            this.message(sender, "not_found.player", new Object[0]);
            return;
        }
        switch (args[1]) {
            case "reset": {
                capability.setEndurance(entity.func_110148_a(Endurance.MAX_ENDURANCE).func_111126_e());
                this.message(sender, "endurance.reset", new Object[0]);
                break;
            }
            default: {
                this.message(sender, "endurance.invalid", new Object[0]);
                return;
            }
        }
        if (entity instanceof EntityPlayerMP) {
            PacketHelper.sendEnduranceSync((EntityPlayerMP)entity);
        }
    }

    private void message(ICommandSender sender, String type, Object ... args) {
        String key = "command.enderskills." + type;
        CommandEnduranceReset.func_152373_a((ICommandSender)sender, (ICommand)this, (String)key, (Object[])args);
    }
}

