/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.command;

import arekkuusu.enderskills.common.CommonConfig;
import arekkuusu.enderskills.common.EnderSkills;
import arekkuusu.enderskills.common.network.PacketHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.discovery.ASMDataTable;

public class CommandReload
extends CommandBase {
    public String func_71517_b() {
        return "enderskills_reload";
    }

    public List<String> func_71514_a() {
        return ImmutableList.of((Object)"es_reload");
    }

    public String func_71518_a(ICommandSender sender) {
        return "Usage: /" + this.func_71517_b();
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!CommonConfig.getValues().syncValuesToClient) {
            this.message(sender, "not_allowed.es_reload", new Object[0]);
            return;
        }
        Map asmData = (Map)ObfuscationReflectionHelper.getPrivateValue(ConfigManager.class, null, (String)"asm_data");
        Map configs = (Map)ObfuscationReflectionHelper.getPrivateValue(ConfigManager.class, null, (String)"CONFIGS");
        Method sync = ObfuscationReflectionHelper.findMethod(ConfigManager.class, (String)"sync", Void.TYPE, (Class[])new Class[]{Configuration.class, Class.class, String.class, String.class, Boolean.TYPE, Object.class});
        Multimap map = (Multimap)asmData.get("enderskills");
        ModClassLoader mcl = Loader.instance().getModClassLoader();
        File configDir = Loader.instance().getConfigDir();
        String modid = "enderskills";
        for (ASMDataTable.ASMData data : map.get((Object)Config.Type.INSTANCE)) {
            try {
                String category;
                Class<?> cls = Class.forName(data.getClassName(), true, (ClassLoader)mcl);
                String name = (String)data.getAnnotationInfo().get("name");
                if (name == null) {
                    name = modid;
                }
                if ((category = (String)data.getAnnotationInfo().get("category")) == null) {
                    category = "general";
                }
                File file = new File(configDir, name + ".cfg");
                Configuration configuration = new Configuration(file);
                configuration.load();
                configs.put(file.getAbsolutePath(), configuration);
                sync.invoke(null, configuration, cls, modid, category, true, null);
                configuration.save();
            }
            catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
                EnderSkills.LOG.fatal("[Config Reload] - Failed to reload Configuration from disk");
                e.printStackTrace();
            }
        }
        CommonConfig.initSyncConfig();
        for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
            PacketHelper.sendConfigReload(player);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("command.enderskills.config.reload.success", new Object[0]));
        }
    }

    private void message(ICommandSender sender, String type, Object ... args) {
        String key = "command.enderskills." + type;
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(key, args));
    }
}

