/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.command;

import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.api.capability.SkilledEntityCapability;
import arekkuusu.enderskills.api.capability.data.SkillInfo;
import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.common.network.PacketHelper;
import arekkuusu.enderskills.common.skill.BaseSkill;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class CommandSkill
extends CommandBase {
    public String func_71517_b() {
        return "enderskills_skill";
    }

    public List<String> func_71514_a() {
        return ImmutableList.of((Object)"es_skill");
    }

    public String func_71518_a(ICommandSender sender) {
        return "Usage: /" + this.func_71517_b() + "[entity/player/@p] [modid:skillname/reset] [set/add/sub/query/unlock/lock] [level]";
    }

    public int func_82362_a() {
        return 2;
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandSkill.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 2) {
            String[] skills = (String[])GameRegistry.findRegistry(Skill.class).getKeys().stream().map(ResourceLocation::toString).toArray(String[]::new);
            List list = CommandSkill.func_71530_a((String[])args, (String[])skills);
            list.add("reset");
            return list;
        }
        if (args.length == 3 && !args[1].equals("reset")) {
            return CommandSkill.func_71530_a((String[])args, (String[])new String[]{"set", "add", "sub", "query", "unlock", "lock"});
        }
        return super.func_184883_a(server, sender, args, targetPos);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityLivingBase entity = (EntityLivingBase)CommandSkill.func_184884_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0], EntityLivingBase.class);
        if (entity == null) {
            this.message(sender, "not_found.player", new Object[0]);
            return;
        }
        if (args.length < 2) {
            this.message(sender, "not_found.arguments", new Object[0]);
            return;
        }
        try {
            int levelToSet;
            String action;
            SkilledEntityCapability capability = Capabilities.get((Entity)entity).orElse(null);
            if (capability == null) {
                this.message(sender, "not_found.player", new Object[0]);
                return;
            }
            if (args[1].equals("reset")) {
                capability.clearOwned();
                if (entity instanceof EntityPlayerMP) {
                    PacketHelper.sendSkillsSync((EntityPlayerMP)entity);
                }
                this.message(sender, "skill.reset", new Object[0]);
                return;
            }
            Skill skill = (Skill)GameRegistry.findRegistry(Skill.class).getValue(new ResourceLocation(args[1]));
            if (skill == null) {
                this.message(sender, "skill.invalid", args[1]);
                return;
            }
            switch (action = args[2]) {
                case "unlock": 
                case "lock": {
                    if (action.equals("lock")) {
                        capability.removeOwned(skill);
                        this.message(sender, "skill.lock", args[1]);
                    } else {
                        capability.addOwned(skill);
                        this.message(sender, "skill.unlock", args[1]);
                    }
                    if (entity instanceof EntityPlayerMP) {
                        PacketHelper.sendSkillsSync((EntityPlayerMP)entity);
                    }
                    return;
                }
            }
            int n = levelToSet = args.length > 3 ? CommandSkill.func_175755_a((String)args[3]) : 0;
            if (levelToSet < 0) {
                this.message(sender, "skill.invalid.level", String.valueOf(levelToSet));
                return;
            }
            SkillInfo info = capability.getOwned(skill).orElse(null);
            if (info == null) {
                this.message(sender, "skill.invalid", args[1]);
                return;
            }
            if (!(skill.getProperties() instanceof BaseSkill.BaseProperties) || !(info instanceof SkillInfo.IInfoUpgradeable)) {
                this.message(sender, "skill.invalid", args[1]);
                return;
            }
            SkillInfo.IInfoUpgradeable skillLevel = (SkillInfo.IInfoUpgradeable)((Object)info);
            BaseSkill.BaseProperties properties = (BaseSkill.BaseProperties)skill.getProperties();
            switch (action) {
                case "set": {
                    if (levelToSet > properties.getMaxLevel()) {
                        this.message(sender, "skill.invalid.level", new Object[0]);
                        return;
                    }
                    skillLevel.setLevel(levelToSet);
                    break;
                }
                case "add": {
                    int sum = Math.min(skillLevel.getLevel() + levelToSet, Integer.MAX_VALUE);
                    if (sum > properties.getMaxLevel()) {
                        this.message(sender, "skill.invalid.level", String.valueOf(levelToSet));
                        return;
                    }
                    skillLevel.setLevel(sum);
                    break;
                }
                case "sub": {
                    int sub = Math.max(skillLevel.getLevel() - levelToSet, 0);
                    if (sub > properties.getMaxLevel()) {
                        this.message(sender, "skill.invalid.level", String.valueOf(levelToSet));
                        return;
                    }
                    skillLevel.setLevel(sub);
                    break;
                }
                case "query": {
                    this.message(sender, "skill.get.level", args[1], skillLevel.getLevel());
                    return;
                }
            }
            this.message(sender, "skill.set.level", args[1], skillLevel.getLevel());
            if (entity instanceof EntityPlayerMP) {
                PacketHelper.sendSkillSync((EntityPlayerMP)entity, skill);
            }
        }
        catch (NumberFormatException ex) {
            this.message(sender, "invalid.number", new Object[0]);
        }
    }

    private void message(ICommandSender sender, String type, Object ... args) {
        String key = "command.enderskills." + type;
        CommandSkill.func_152373_a((ICommandSender)sender, (ICommand)this, (String)key, (Object[])args);
    }
}

