/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.command;

import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.api.capability.SkillGroupCapability;
import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.common.network.PacketHelper;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class CommandWeight
extends CommandBase {
    public String func_71517_b() {
        return "enderskills_weight";
    }

    public List<String> func_71514_a() {
        return ImmutableList.of((Object)"es_weight");
    }

    public String func_71518_a(ICommandSender sender) {
        return "Usage: /" + this.func_71517_b() + "[entity/player/@p] [modid:skillname/hide_all] [Group-Name] [set/add/sub/query/before/after/hide] [weight]";
    }

    public int func_82362_a() {
        return 0;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandWeight.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 2) {
            String[] skills = (String[])GameRegistry.findRegistry(Skill.class).getKeys().stream().map(ResourceLocation::toString).toArray(String[]::new);
            List list = CommandWeight.func_71530_a((String[])args, (String[])skills);
            list.add("hide_all");
            return list;
        }
        if (args.length == 4 && !args[1].matches("hide_all")) {
            return CommandWeight.func_71530_a((String[])args, (String[])new String[]{"set", "add", "sub", "query", "before", "after", "hide"});
        }
        if (args.length == 5 && args[3].matches("before|after")) {
            String[] skills = (String[])GameRegistry.findRegistry(Skill.class).getKeys().stream().map(ResourceLocation::toString).toArray(String[]::new);
            return CommandWeight.func_71530_a((String[])args, (String[])skills);
        }
        return super.func_184883_a(server, sender, args, targetPos);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityLivingBase entity = (EntityLivingBase)CommandWeight.func_184884_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0], EntityLivingBase.class);
        if (sender.func_174793_f() != entity && !sender.func_70003_b(2, this.func_71517_b())) {
            this.message(sender, "not_found.player", new Object[0]);
        }
        if (entity == null) {
            this.message(sender, "not_found.player", new Object[0]);
            return;
        }
        if (args.length < 2) {
            this.message(sender, "not_found.arguments", new Object[0]);
            return;
        }
        try {
            String action;
            Skill skill;
            SkillGroupCapability capability = Capabilities.weight((Entity)entity).orElse(null);
            if (capability == null) {
                this.message(sender, "not_found.player", new Object[0]);
                return;
            }
            if (!args[1].matches("hide_all")) {
                skill = (Skill)GameRegistry.findRegistry(Skill.class).getValue(new ResourceLocation(args[1]));
                if (skill == null) {
                    this.message(sender, "skill.invalid.skill", args[1]);
                    return;
                }
            } else {
                capability.clearWeight();
                if (entity instanceof EntityPlayerMP) {
                    PacketHelper.sendWeightSync((EntityPlayerMP)entity);
                }
                return;
            }
            int weight = 0;
            int weightToSet = 0;
            String name = args[2];
            switch (action = args[3]) {
                case "set": {
                    weightToSet = args.length > 4 ? CommandWeight.func_175755_a((String)args[4]) : 0;
                    weightToSet = MathHelper.func_76125_a((int)weightToSet, (int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE);
                    capability.putWeight(name, skill, weightToSet);
                    this.message(sender, "weight.set.value", args[1], weightToSet);
                    break;
                }
                case "add": {
                    weight = capability.getWeight(name, skill);
                    weightToSet = args.length > 4 ? CommandWeight.func_175755_a((String)args[4]) : 0;
                    int sum = MathHelper.func_76125_a((int)(weight + weightToSet), (int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE);
                    capability.putWeight(name, skill, sum);
                    this.message(sender, "weight.set.value", args[1], weightToSet);
                    break;
                }
                case "sub": {
                    weight = capability.getWeight(name, skill);
                    weightToSet = args.length > 4 ? CommandWeight.func_175755_a((String)args[4]) : 0;
                    int sub = MathHelper.func_76125_a((int)(weight - weightToSet), (int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE);
                    capability.putWeight(name, skill, sub);
                    this.message(sender, "weight.set.value", args[1], weightToSet);
                    break;
                }
                case "query": {
                    weight = capability.getWeight(name, skill);
                    this.message(sender, "weight.get.value", args[1], weight);
                    return;
                }
                case "before": 
                case "after": {
                    boolean wasBefore;
                    weight = capability.getWeight(name, skill);
                    Skill skillOther = (Skill)GameRegistry.findRegistry(Skill.class).getValue(new ResourceLocation(args[3]));
                    if (skillOther == null) {
                        this.message(sender, "skill.invalid.skill", args[3]);
                        return;
                    }
                    int weightOther = capability.getWeight(name, skillOther);
                    int weightNew = 0;
                    int weightNewOther = 0;
                    boolean isBefore = action.equals("before");
                    boolean bl = wasBefore = weightOther > weight;
                    if (isBefore) {
                        if (wasBefore) {
                            weightNew = weightOther - 1;
                            weightNewOther = weightOther;
                        } else {
                            weightNew = weightOther - 1;
                            weightNewOther = weightOther;
                        }
                    } else if (wasBefore) {
                        weightNew = weightOther;
                        weightNewOther = weightOther - 1;
                    } else {
                        weightNew = weightOther + 1;
                        weightNewOther = weightOther;
                    }
                    if (weightNew == weight) {
                        return;
                    }
                    capability.putWeight(name, skill, weightNew);
                    capability.putWeight(name, skillOther, weightNewOther);
                    for (Skill s : capability.getGroup((String)name).map.keySet()) {
                        if (!capability.hasWeight(name, s)) continue;
                        int w = capability.getWeight(name, s);
                        if (!(wasBefore ? w < weightNew && w > weight : w > weightNewOther && w < weight) || s == skill || s == skillOther) continue;
                        capability.putWeight(name, s, wasBefore ? w - 1 : w + 1);
                    }
                    if (entity instanceof EntityPlayerMP) {
                        PacketHelper.sendWeightSync((EntityPlayerMP)entity);
                    }
                    return;
                }
                case "hide": {
                    if (capability.hasWeight(name, skill)) {
                        capability.removeWeight(name, skill);
                    }
                    if (entity instanceof EntityPlayerMP) {
                        PacketHelper.sendWeightRemovePacket((EntityPlayerMP)entity, skill);
                    }
                    return;
                }
            }
            if (entity instanceof EntityPlayerMP) {
                PacketHelper.sendWeightSetPacket((EntityPlayerMP)entity, skill, capability.getWeight(name, skill));
            }
        }
        catch (NumberFormatException ex) {
            this.message(sender, "invalid.number", new Object[0]);
        }
    }

    private void message(ICommandSender sender, String type, Object ... args) {
        String key = "command.enderskills." + type;
        CommandWeight.func_152373_a((ICommandSender)sender, (ICommand)this, (String)key, (Object[])args);
    }
}

