/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.entity;

import arekkuusu.enderskills.api.capability.data.SkillData;
import arekkuusu.enderskills.api.helper.TeamHelper;
import arekkuusu.enderskills.client.sounds.BlackHoleSound;
import arekkuusu.enderskills.common.entity.data.SkillExtendedData;
import arekkuusu.enderskills.common.entity.throwable.MotionHelper;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.ModEffects;
import arekkuusu.enderskills.common.skill.SkillHelper;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBlackHole
extends Entity {
    public static final DataParameter<SkillExtendedData> DATA = EntityDataManager.func_187226_a(EntityBlackHole.class, SkillExtendedData.SERIALIZER);
    public static final DataParameter<Integer> LIFE_TIME = EntityDataManager.func_187226_a(EntityBlackHole.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(EntityBlackHole.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Integer> SEED = EntityDataManager.func_187226_a(EntityBlackHole.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final int MIN_TIME = 10;
    public static double collapse = 0.95;
    public ArrayList<Float> pointsWidth = Lists.newArrayList();
    public ArrayList<Vec3d> points = Lists.newArrayList();
    public int tick;

    public EntityBlackHole(World worldIn) {
        super(worldIn);
        this.field_70145_X = true;
        this.field_70178_ae = true;
        this.field_70158_ak = true;
        this.func_70105_a(0.0f, 0.0f);
    }

    public EntityBlackHole(World worldIn, @Nullable EntityLivingBase owner, SkillData skillData, int lifeTime) {
        this(worldIn);
        if (owner != null) {
            this.field_70125_A = owner.field_70125_A;
            this.field_70177_z = owner.field_70177_z;
        }
        this.setData(skillData);
        this.setLifeTime(lifeTime);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(DATA, (Object)new SkillExtendedData(null));
        this.field_70180_af.func_187214_a(LIFE_TIME, (Object)0);
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(SEED, (Object)this.field_70170_p.field_73012_v.nextInt());
    }

    private void setupShape(Random rr) {
        this.points.clear();
        this.pointsWidth.clear();
        int steps = 9;
        float girth = this.getRadius() * 1.2f;
        Vec3d right = new Vec3d(0.0, (double)(this.getRadius() * 3.0f / (float)(steps + 1)), 0.0);
        right = right.func_178789_a(1.5707964f);
        right = right.func_178785_b((float)(rr.nextGaussian() * 360.0));
        Vec3d left = right.func_186678_a(-1.0);
        Vec3d lr = new Vec3d(0.0, 0.0, 0.0);
        Vec3d ll = new Vec3d(0.0, 0.0, 0.0);
        float dec = girth / (float)steps;
        for (int a = 0; a < steps; ++a) {
            lr = lr.func_178787_e(right);
            this.points.add(new Vec3d(lr.field_72450_a, lr.field_72448_b, lr.field_72449_c));
            this.pointsWidth.add(Float.valueOf((float)((double)(girth -= dec) * Math.pow(1.0f - (float)a / (float)steps, 3.0))));
            ll = ll.func_178787_e(left);
            this.points.add(0, new Vec3d(ll.field_72450_a, ll.field_72448_b, ll.field_72449_c));
            this.pointsWidth.add(0, Float.valueOf((float)((double)girth * Math.pow(1.0f - (float)a / (float)steps, 3.0))));
        }
        lr = lr.func_178787_e(right);
        this.points.add(new Vec3d(lr.field_72450_a, lr.field_72448_b, lr.field_72449_c));
        this.pointsWidth.add(Float.valueOf(0.0f));
        ll = ll.func_178787_e(left);
        this.points.add(0, new Vec3d(ll.field_72450_a, ll.field_72448_b, ll.field_72449_c));
        this.pointsWidth.add(0, Float.valueOf(0.0f));
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.makeSound();
        }
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.getRadius() != 0.0f && this.points.isEmpty()) {
            this.setupShape(new Random(this.getSeed()));
        }
        if (this.getRadius() > 0.0f) {
            if (this.getLifeTime() > this.tick) {
                if (this.tick == 0) {
                    this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.HOSTILE, 8.0f, 1.0f, true);
                }
                SkillData data = this.getData();
                EntityLivingBase owner = SkillHelper.getOwner(data);
                double radius = this.getRadius();
                double suckRange = radius * 2.0;
                AxisAlignedBB suckzone = new AxisAlignedBB(this.field_70165_t - suckRange, this.field_70163_u - suckRange, this.field_70161_v - suckRange, this.field_70165_t + suckRange, this.field_70163_u + suckRange, this.field_70161_v + suckRange);
                List succ = this.func_130014_f_().func_175647_a(EntityLivingBase.class, suckzone, (Predicate)TeamHelper.SELECTOR_ENEMY.apply((Object)owner));
                if (!succ.isEmpty()) {
                    for (EntityLivingBase entity : succ) {
                        if (!this.field_70170_p.field_72995_K || entity instanceof EntityPlayer) {
                            double dx = this.field_70165_t - entity.field_70165_t;
                            double dy = this.field_70163_u - entity.field_70163_u;
                            double dz = this.field_70161_v - entity.field_70161_v;
                            double lensquared = dx * dx + dy * dy + dz * dz;
                            double len = Math.sqrt(lensquared);
                            double lenn = len / suckRange;
                            if (len <= suckRange) {
                                double strength = (1.0 - lenn) * (1.0 - lenn);
                                double power = 0.075 * radius;
                                double motionX = entity.field_70159_w + dx / len * strength * power;
                                double motionY = entity.field_70181_x + dy / len * strength * power;
                                double motionZ = entity.field_70179_y + dz / len * strength * power;
                                if (Double.isFinite(motionX) && Double.isFinite(motionY) && Double.isFinite(motionZ)) {
                                    entity.field_70159_w = motionX;
                                    entity.field_70181_x = motionY;
                                    entity.field_70179_y = motionZ;
                                }
                            }
                        }
                        if (this.field_70170_p.field_72995_K) continue;
                        ModEffects.BLINDED.set(entity, this.getData());
                        ModEffects.VOIDED.set(entity, this.getData());
                        ModEffects.SLOWED.set(entity, this.getData(), 0.6);
                    }
                }
                float size = (float)this.getScale(this.tick) * this.getRadius();
                AxisAlignedBB bb = new AxisAlignedBB(this.field_70165_t - (double)size, this.field_70163_u - (double)size, this.field_70161_v - (double)size, this.field_70165_t + (double)size, this.field_70163_u + (double)size, this.field_70161_v + (double)size);
                this.func_174826_a(bb);
            } else {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0, 0.0, 0.0, new int[0]);
                if (!this.field_70170_p.field_72995_K) {
                    EntityLivingBase owner = SkillHelper.getOwner(this.getData());
                    List fucc = this.func_130014_f_().func_175647_a(EntityLivingBase.class, this.func_174813_aQ(), (Predicate)TeamHelper.SELECTOR_ENEMY.apply((Object)owner));
                    for (EntityLivingBase entity : fucc) {
                        MotionHelper.push(this.func_174791_d(), (Entity)entity, 2.0);
                        ModAbilities.BLACK_HOLE.apply(entity, this.getData().copy());
                    }
                }
                this.func_70106_y();
            }
        }
        if (this.field_70170_p.field_72995_K) {
            Vec3d pos = this.func_174791_d();
            double particlespeed = 4.5;
            for (int i = 0; i < 50; ++i) {
                Vec3d particlePos = new Vec3d(0.0, 0.0, (double)this.getRadius());
                particlePos = particlePos.func_178785_b(this.field_70146_Z.nextFloat() * 180.0f);
                particlePos = particlePos.func_178789_a(this.field_70146_Z.nextFloat() * 360.0f);
                Vec3d velocity = particlePos.func_72432_b();
                velocity = new Vec3d(velocity.field_72450_a * particlespeed, velocity.field_72448_b * particlespeed, velocity.field_72449_c * particlespeed);
                particlePos = particlePos.func_178787_e(pos);
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c, new int[0]);
            }
        }
        ++this.tick;
    }

    @SideOnly(value=Side.CLIENT)
    public void makeSound() {
        if (this.field_70148_d) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new BlackHoleSound(this));
        }
    }

    protected void func_70105_a(float width, float height) {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        double w = (double)width / 2.0;
        double h = (double)height / 2.0;
        this.field_70130_N = width;
        this.field_70131_O = height;
        this.func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a - w, axisalignedbb.field_72338_b - h, axisalignedbb.field_72339_c - w, axisalignedbb.field_72340_a + w, axisalignedbb.field_72338_b + h, axisalignedbb.field_72339_c + w));
    }

    public void func_174829_m() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        this.field_70165_t = (axisalignedbb.field_72340_a + axisalignedbb.field_72336_d) / 2.0;
        this.field_70163_u = (axisalignedbb.field_72338_b + axisalignedbb.field_72337_e) / 2.0;
        this.field_70161_v = (axisalignedbb.field_72339_c + axisalignedbb.field_72334_f) / 2.0;
        if (this.isAddedToWorld() && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72866_a((Entity)this, false);
        }
    }

    public void setSeed(int seed) {
        this.field_70180_af.func_187227_b(SEED, (Object)seed);
    }

    public int getSeed() {
        return (Integer)this.field_70180_af.func_187225_a(SEED);
    }

    public void setLifeTime(int age) {
        this.field_70180_af.func_187227_b(LIFE_TIME, (Object)age);
    }

    public int getLifeTime() {
        return (Integer)this.field_70180_af.func_187225_a(LIFE_TIME);
    }

    public void setRadius(double size) {
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf((float)size));
    }

    public float getRadius() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
    }

    public void setData(SkillData data) {
        this.field_70180_af.func_187227_b(DATA, (Object)new SkillExtendedData(data));
    }

    public SkillData getData() {
        return ((SkillExtendedData)this.field_70180_af.func_187225_a(EntityBlackHole.DATA)).data;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.setData(new SkillData(compound.func_74775_l("data")));
        this.setLifeTime(compound.func_74762_e("lifeTime"));
        this.setRadius(compound.func_74760_g("radius"));
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74782_a("data", (NBTBase)this.getData().serializeNBT());
        compound.func_74768_a("lifeTime", this.getLifeTime());
        compound.func_74776_a("radius", this.getRadius());
    }

    public double getScale(int age) {
        double life = (double)age / (double)this.getLifeTime();
        double curve = life < collapse ? 0.005 + EntityBlackHole.ease(1.0 - (collapse - life) / collapse) * 0.995 : EntityBlackHole.ease(1.0 - (life - collapse) / (1.0 - collapse));
        return curve;
    }

    private static double ease(double in) {
        double t = in - 1.0;
        return Math.sqrt(1.0 - t * t);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }
}

