/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.entity;

import arekkuusu.enderskills.api.capability.data.SkillData;
import arekkuusu.enderskills.api.event.SkillDamageEvent;
import arekkuusu.enderskills.api.event.SkillDamageSource;
import arekkuusu.enderskills.api.helper.TeamHelper;
import arekkuusu.enderskills.common.entity.data.SkillExtendedData;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.SkillHelper;
import arekkuusu.enderskills.common.sound.ModSounds;
import com.google.common.base.Predicate;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCrush
extends Entity {
    public static final DataParameter<SkillExtendedData> DATA = EntityDataManager.func_187226_a(EntityCrush.class, SkillExtendedData.SERIALIZER);
    public static final DataParameter<Float> SYNC_SIZE = EntityDataManager.func_187226_a(EntityCrush.class, (DataSerializer)DataSerializers.field_187193_c);
    public int warmupDelayTicks;
    public boolean sentSpikeEvent;
    public int lifeTicks = 22;
    public boolean clientSideAttackStarted;
    public float damage;

    public EntityCrush(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 0.0f);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(DATA, (Object)new SkillExtendedData(null));
        this.field_70180_af.func_187214_a(SYNC_SIZE, (Object)Float.valueOf(0.0f));
    }

    public void func_70071_h_() {
        if (this.field_70130_N != this.getSize()) {
            this.func_70105_a(this.getSize(), 0.0f);
        }
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.clientSideAttackStarted) {
                --this.lifeTicks;
                if (this.lifeTicks == 14) {
                    for (int i = 0; i < 12; ++i) {
                        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.field_70130_N * 0.5;
                        double d1 = this.field_70163_u + 0.05 + this.field_70146_Z.nextDouble() * 1.0;
                        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.field_70130_N * 0.5;
                        double d3 = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * 0.3;
                        double d4 = 0.3 + this.field_70146_Z.nextDouble() * 0.3;
                        double d5 = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * 0.3;
                        this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT, d0, d1 + 1.0, d2, d3, d4, d5, new int[0]);
                    }
                }
            }
        } else if (--this.warmupDelayTicks < 0) {
            SkillData data = this.getData();
            EntityLivingBase owner = SkillHelper.getOwner(data);
            if (this.warmupDelayTicks == -8) {
                for (EntityLivingBase target : this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ(), (Predicate)TeamHelper.SELECTOR_ENEMY.apply((Object)owner))) {
                    ModAbilities.CRUSH.apply(target, data);
                }
            }
            if (!this.sentSpikeEvent) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.func_70106_y();
            }
        }
        if (this.lifeTicks > 12) {
            double amount = (double)this.getSize() / 10.0;
            this.func_174826_a(this.func_174813_aQ().func_72321_a(0.0, amount, 0.0));
        }
    }

    @Nullable
    public EntityLivingBase getEntityByUUID(UUID uuid) {
        for (Entity entity : this.field_70170_p.field_72996_f) {
            if (!entity.func_110124_au().equals(uuid) || !(entity instanceof EntityLivingBase)) continue;
            return (EntityLivingBase)entity;
        }
        return null;
    }

    private void damage(EntityLivingBase owner, EntityLivingBase target) {
        SkillDamageSource damageSource = new SkillDamageSource("skill", (Entity)owner);
        SkillDamageEvent event = new SkillDamageEvent(owner, ModAbilities.CRUSH, (DamageSource)damageSource, this.damage);
        MinecraftForge.EVENT_BUS.post((Event)event);
        target.func_70097_a(event.getSource(), event.toFloat());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 4) {
            this.clientSideAttackStarted = true;
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_191242_bl, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.2f + 0.85f, false);
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSounds.CRUSH, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.2f + 0.85f, false);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getAnimationProgress(float partialTicks) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        int i = this.lifeTicks - 2;
        return i <= 0 ? 1.0f : 1.0f - ((float)i - partialTicks) / 20.0f;
    }

    protected void func_70105_a(float width, float height) {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        double w = (double)width / 2.0;
        double h = height;
        this.field_70130_N = width;
        this.field_70131_O = height;
        this.func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a - w, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c - w, axisalignedbb.field_72340_a + w, axisalignedbb.field_72338_b + h, axisalignedbb.field_72339_c + w));
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        if (this.isAddedToWorld() && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72866_a((Entity)this, false);
        }
        float f = this.field_70130_N / 2.0f;
        float f1 = this.field_70131_O;
        this.func_174826_a(new AxisAlignedBB(x - (double)f, y, z - (double)f, x + (double)f, y + (double)f1, z + (double)f));
    }

    public void func_174829_m() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        this.field_70165_t = (axisalignedbb.field_72340_a + axisalignedbb.field_72336_d) / 2.0;
        this.field_70163_u = axisalignedbb.field_72338_b;
        this.field_70161_v = (axisalignedbb.field_72339_c + axisalignedbb.field_72334_f) / 2.0;
        if (this.isAddedToWorld() && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72866_a((Entity)this, false);
        }
    }

    public void setData(SkillData data) {
        this.field_70180_af.func_187227_b(DATA, (Object)new SkillExtendedData(data));
    }

    public SkillData getData() {
        return ((SkillExtendedData)this.field_70180_af.func_187225_a(EntityCrush.DATA)).data;
    }

    public float getSize() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_SIZE)).floatValue();
    }

    public void setSize(float size) {
        this.field_70180_af.func_187227_b(SYNC_SIZE, (Object)Float.valueOf(size));
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getDamage() {
        return this.damage;
    }

    public void setYawFrom(EntityLivingBase owner) {
        float f = (float)MathHelper.func_181159_b((double)(owner.field_70161_v - this.field_70161_v), (double)(owner.field_70165_t - this.field_70165_t));
        this.field_70177_z = f * 57.295776f;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_74764_b("data")) {
            this.setData(new SkillData(compound.func_74775_l("data")));
        }
        this.setSize(compound.func_74760_g("size"));
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (this.getData() != null) {
            compound.func_74782_a("data", (NBTBase)this.getData().serializeNBT());
        }
        compound.func_74776_a("size", this.getSize());
    }
}

