/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.entity;

import arekkuusu.enderskills.client.sounds.PortalActiveSound;
import arekkuusu.enderskills.client.sounds.PortalInactiveSound;
import arekkuusu.enderskills.common.sound.ModSounds;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityPortal
extends Entity {
    public static final DataParameter<Optional<UUID>> TARGET_ID = EntityDataManager.func_187226_a(EntityPortal.class, (DataSerializer)DataSerializers.field_187203_m);
    public static final DataParameter<Integer> STATUS = EntityDataManager.func_187226_a(EntityPortal.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> LIFE_TIME = EntityDataManager.func_187226_a(EntityPortal.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> SEED = EntityDataManager.func_187226_a(EntityPortal.class, (DataSerializer)DataSerializers.field_187192_b);
    public ArrayList<Float> pointsWidth = Lists.newArrayList();
    public ArrayList<Vec3d> points = Lists.newArrayList();
    public Set<Entity> teleported = Collections.newSetFromMap(new WeakHashMap());
    public int tick;
    @SideOnly(value=Side.CLIENT)
    public boolean open;
    public int openAnimationTimer = -1;

    public EntityPortal(World world) {
        super(world);
        this.func_70105_a(1.5f, 2.0f);
        this.setupShape(new Random(this.getSeed()));
    }

    public EntityPortal(World worldIn, int lifeTime) {
        this(worldIn);
        this.setLifeTime(lifeTime);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TARGET_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(STATUS, (Object)0);
        this.field_70180_af.func_187214_a(LIFE_TIME, (Object)0);
        this.field_70180_af.func_187214_a(SEED, (Object)this.field_70170_p.field_73012_v.nextInt());
    }

    private void setupShape(Random rr) {
        this.points.clear();
        this.pointsWidth.clear();
        int steps = 6;
        float girth = this.field_70130_N;
        double angle = 0.15;
        Vec3d right = new Vec3d(0.0, (double)(this.field_70131_O / (float)(steps + 1)), 0.0);
        right = right.func_178785_b((float)(rr.nextGaussian() * 360.0));
        right = right.func_178789_a((float)(rr.nextGaussian() * 180.0));
        Vec3d left = right.func_186678_a(-1.0);
        Vec3d lr = new Vec3d(0.0, 0.0, 0.0);
        Vec3d ll = new Vec3d(0.0, 0.0, 0.0);
        float dec = girth / (float)steps;
        for (int a = 0; a < steps; ++a) {
            girth -= dec;
            right = right.func_178789_a((float)(rr.nextGaussian() * angle));
            right = right.func_178785_b((float)(rr.nextGaussian() * angle));
            lr = lr.func_178787_e(right);
            this.points.add(new Vec3d(lr.field_72450_a, lr.field_72448_b, lr.field_72449_c));
            this.pointsWidth.add(Float.valueOf(girth));
            left = left.func_178789_a((float)(rr.nextGaussian() * angle));
            left = left.func_178785_b((float)(rr.nextGaussian() * angle));
            ll = ll.func_178787_e(left);
            this.points.add(0, new Vec3d(ll.field_72450_a, ll.field_72448_b, ll.field_72449_c));
            this.pointsWidth.add(0, Float.valueOf(girth));
        }
        lr = lr.func_178787_e(right);
        this.points.add(new Vec3d(lr.field_72450_a, lr.field_72448_b, lr.field_72449_c));
        this.pointsWidth.add(Float.valueOf(0.0f));
        ll = ll.func_178787_e(left);
        this.points.add(0, new Vec3d(ll.field_72450_a, ll.field_72448_b, ll.field_72449_c));
        this.pointsWidth.add(0, Float.valueOf(0.0f));
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.makeSound();
        }
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.getLifeTime() > this.tick) {
                EntityPortal target = this.getTarget();
                if (target != null) {
                    if (this.tick == 0) {
                        this.teleported.addAll(this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ()));
                    }
                    List entities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ());
                    this.teleported.removeIf(e -> !entities.contains(e));
                    for (Entity entity : entities) {
                        if (this.teleported.contains(entity)) continue;
                        this.teleported.remove(entity);
                        entity.func_70634_a(target.field_70165_t, target.field_70163_u, target.field_70161_v);
                        target.teleported.add(entity);
                        if (!(this.field_70170_p instanceof WorldServer)) continue;
                        ((WorldServer)entity.field_70170_p).func_184148_a(null, entity.field_70169_q, entity.field_70167_r, entity.field_70166_s, ModSounds.PORTAL_OPEN, SoundCategory.PLAYERS, 1.0f, (1.0f + (entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                    }
                }
            } else {
                EntityPortal target = this.getTarget();
                if (target == null || target.tick >= target.getLifeTime()) {
                    this.func_70106_y();
                }
            }
        } else if (this.openAnimationTimer == -1 && this.isOpen()) {
            this.openAnimationTimer = 10;
        } else if (this.openAnimationTimer > 0) {
            --this.openAnimationTimer;
        }
        ++this.tick;
    }

    @SideOnly(value=Side.CLIENT)
    public void makeSound() {
        if (this.field_70148_d) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSounds.PORTAL_PLACE, SoundCategory.PLAYERS, 1.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            if (!this.isOpen()) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new PortalInactiveSound(this));
            }
        }
        if (this.isOpen() && !this.open) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new PortalActiveSound(this));
            this.open = true;
        }
    }

    protected void func_70105_a(float width, float height) {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        double w = (double)width / 2.0;
        double h = (double)height / 2.0;
        this.field_70130_N = width;
        this.field_70131_O = height;
        this.func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a - w, axisalignedbb.field_72338_b - h, axisalignedbb.field_72339_c - w, axisalignedbb.field_72340_a + w, axisalignedbb.field_72338_b + h, axisalignedbb.field_72339_c + w));
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        if (this.isAddedToWorld() && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72866_a((Entity)this, false);
        }
        float f = this.field_70130_N / 2.0f;
        float f1 = this.field_70131_O / 2.0f;
        this.func_174826_a(new AxisAlignedBB(x - (double)f, y - (double)f1, z - (double)f, x + (double)f, y + (double)f1, z + (double)f));
    }

    public void func_174829_m() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        this.field_70165_t = (axisalignedbb.field_72340_a + axisalignedbb.field_72336_d) / 2.0;
        this.field_70163_u = (axisalignedbb.field_72338_b + axisalignedbb.field_72337_e) / 2.0;
        this.field_70161_v = (axisalignedbb.field_72339_c + axisalignedbb.field_72334_f) / 2.0;
        if (this.isAddedToWorld() && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72866_a((Entity)this, false);
        }
    }

    public boolean isOpen() {
        return ((Optional)this.field_70180_af.func_187225_a(TARGET_ID)).isPresent();
    }

    public void setSeed(int seed) {
        this.field_70180_af.func_187227_b(SEED, (Object)seed);
    }

    public int getSeed() {
        return (Integer)this.field_70180_af.func_187225_a(SEED);
    }

    public void setLifeTime(int age) {
        this.field_70180_af.func_187227_b(LIFE_TIME, (Object)age);
    }

    public int getLifeTime() {
        return (Integer)this.field_70180_af.func_187225_a(LIFE_TIME);
    }

    public void setTarget(@Nullable EntityPortal owner) {
        this.field_70180_af.func_187227_b(TARGET_ID, (Object)(owner != null ? Optional.of((Object)owner.func_110124_au()) : Optional.absent()));
    }

    @Nullable
    public EntityPortal getTarget() {
        UUID uuid;
        Entity entity;
        EntityPortal owner = null;
        if (((Optional)this.field_70180_af.func_187225_a(TARGET_ID)).isPresent() && (entity = ((WorldServer)this.field_70170_p).func_175733_a(uuid = (UUID)((Optional)this.field_70180_af.func_187225_a(TARGET_ID)).get())) instanceof EntityPortal) {
            owner = (EntityPortal)entity;
        }
        return owner;
    }

    public boolean func_90999_ad() {
        return false;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        String uuidString;
        if (compound.func_150297_b("TargetUUID", 8)) {
            uuidString = compound.func_74779_i("TargetUUID");
        } else {
            String ownerString = compound.func_74779_i("Owner");
            uuidString = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)ownerString);
        }
        if (!uuidString.isEmpty()) {
            this.field_70180_af.func_187227_b(TARGET_ID, (Object)Optional.of((Object)UUID.fromString(uuidString)));
        }
        this.setLifeTime(compound.func_74762_e("lifeTime"));
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (!((Optional)this.field_70180_af.func_187225_a(TARGET_ID)).isPresent()) {
            compound.func_74778_a("TargetUUID", "");
        } else {
            compound.func_74778_a("TargetUUID", ((UUID)((Optional)this.field_70180_af.func_187225_a(TARGET_ID)).get()).toString());
        }
        compound.func_74768_a("lifeTime", this.getLifeTime());
    }
}

