/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.entity;

import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.SkillHelper;
import arekkuusu.enderskills.common.sound.ModSounds;
import com.google.common.base.Optional;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityShadow
extends Entity {
    public static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityShadow.class, (DataSerializer)DataSerializers.field_187203_m);
    public static final DataParameter<Float> MIRROR_DAMAGE = EntityDataManager.func_187226_a(EntityShadow.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Boolean> FADED = EntityDataManager.func_187226_a(EntityShadow.class, (DataSerializer)DataSerializers.field_187198_h);
    public WeakHashMap<EntityLivingBase, Float> attackMap = new WeakHashMap();
    public int fadedCountdown = 30;

    public EntityShadow(World world) {
        super(world);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            UUID uuid = this.getOwnerId();
            if (uuid != null) {
                EntityLivingBase owner = this.getEntityByUUID(uuid);
                if (owner != null) {
                    if (!SkillHelper.isActiveFrom((Entity)owner, ModAbilities.SHADOW)) {
                        this.func_70106_y();
                    }
                    if (owner.func_70032_d((Entity)this) > 10.0f) {
                        this.teleportNextToOwner();
                    }
                    if (this.field_70173_aa % 10 == 0 && !this.attackMap.isEmpty()) {
                        boolean animation = false;
                        for (Map.Entry<EntityLivingBase, Float> set : this.attackMap.entrySet()) {
                            EntityLivingBase entity = set.getKey();
                            float damage = set.getValue().floatValue() + set.getValue().floatValue() * this.getMirrorDamage();
                            entity.func_70097_a((DamageSource)new EntityDamageSource("shadow", (Entity)owner), damage);
                            if (animation) continue;
                            if (entity.field_70170_p instanceof WorldServer) {
                                ((WorldServer)entity.field_70170_p).func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, ModSounds.SHADOW_ATTACK, SoundCategory.PLAYERS, 1.0f, (1.0f + (entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                            }
                            this.teleportNextToOwner();
                            animation = true;
                        }
                        this.attackMap.clear();
                    }
                } else {
                    this.func_70106_y();
                }
            } else {
                this.func_70106_y();
            }
        }
        if (this.field_70170_p.field_72995_K && this.fadedCountdown > 0 && this.field_70173_aa % 2 == 0 && this.field_70170_p.field_73012_v.nextDouble() < 0.8) {
            double posX = this.field_70165_t + this.field_70170_p.field_73012_v.nextDouble() - 0.5;
            double posY = this.field_70163_u + (double)this.func_70047_e() * this.field_70170_p.field_73012_v.nextDouble();
            double posZ = this.field_70161_v + this.field_70170_p.field_73012_v.nextDouble() - 0.5;
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, posX, posY, posZ, 0.0, 0.0, 0.0, new int[0]);
        }
        if (this.fadedCountdown > 0) {
            --this.fadedCountdown;
        }
    }

    public void addAttack(EntityLivingBase entity, float amount) {
        if (this.attackMap.containsKey(entity)) {
            this.attackMap.put(entity, Float.valueOf(this.attackMap.get(entity).floatValue() + amount));
        } else {
            this.attackMap.put(entity, Float.valueOf(amount));
        }
    }

    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 66) {
            this.fadedCountdown = 30;
        }
    }

    public void teleportNextToOwner() {
        EntityLivingBase owner;
        UUID uuid = this.getOwnerId();
        if (uuid != null && (owner = this.getEntityByUUID(uuid)) != null) {
            Vec3d eyesVector = owner.func_174791_d();
            Vec3d lookVector = owner.func_70676_i(1.0f).func_186678_a(-1.0);
            lookVector = lookVector.func_178785_b(this.field_70146_Z.nextBoolean() ? -40.0f : 40.0f);
            Vec3d targetVector = eyesVector.func_72441_c(lookVector.field_72450_a, lookVector.field_72448_b, lookVector.field_72449_c);
            this.func_70634_a(targetVector.field_72450_a, targetVector.field_72448_b, targetVector.field_72449_c);
            this.field_70170_p.func_72960_a((Entity)this, (byte)66);
        }
    }

    @Nullable
    public EntityLivingBase getEntityByUUID(UUID uuid) {
        for (Entity entity : this.field_70170_p.field_72996_f) {
            if (!entity.func_110124_au().equals(uuid) || !(entity instanceof EntityLivingBase)) continue;
            return (EntityLivingBase)entity;
        }
        return null;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(MIRROR_DAMAGE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(FADED, (Object)false);
    }

    @Nullable
    public UUID getOwnerId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    public void setOwnerId(@Nullable UUID owner) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)owner));
    }

    public float getMirrorDamage() {
        return ((Float)this.field_70180_af.func_187225_a(MIRROR_DAMAGE)).floatValue();
    }

    public void setMirrorDamage(float damage) {
        this.field_70180_af.func_187227_b(MIRROR_DAMAGE, (Object)Float.valueOf(damage));
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }
}

