/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.entity;

import arekkuusu.enderskills.api.capability.data.SkillData;
import arekkuusu.enderskills.api.helper.TeamHelper;
import arekkuusu.enderskills.common.entity.AIFollowProvider;
import arekkuusu.enderskills.common.entity.AIOverride;
import arekkuusu.enderskills.common.entity.data.SkillExtendedData;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.ModEffects;
import arekkuusu.enderskills.common.skill.SkillHelper;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityStoneGolem
extends EntityGolem {
    public static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityStoneGolem.class, (DataSerializer)DataSerializers.field_187203_m);
    public static final DataParameter<SkillExtendedData> DATA = EntityDataManager.func_187226_a(EntityStoneGolem.class, SkillExtendedData.SERIALIZER);
    public static final DataParameter<Float> MAX_HEALTH = EntityDataManager.func_187226_a(EntityStoneGolem.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Float> MIRROR_DAMAGE = EntityDataManager.func_187226_a(EntityStoneGolem.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Float> DAMAGE = EntityDataManager.func_187226_a(EntityStoneGolem.class, (DataSerializer)DataSerializers.field_187193_c);
    public int growTime = 100;
    public boolean isGrown;
    public int attackTimer;
    public BlockPos spawn;

    public EntityStoneGolem(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.4f, 0.0f);
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 1.0, 32.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIFollowProvider((EntityLiving)this, () -> this.getOwnerId() != null ? this.getEntityByUUID(this.getOwnerId()) : null, 1.0, 5.0f, 64.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)AIOverride.INSTANCE);
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(MAX_HEALTH, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(DATA, (Object)new SkillExtendedData(null));
        this.field_70180_af.func_187214_a(MIRROR_DAMAGE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    protected boolean func_175448_a(ItemStack stack) {
        return false;
    }

    public void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)((Float)this.field_70180_af.func_187225_a(MAX_HEALTH)).floatValue());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    public boolean func_184191_r(Entity entityIn) {
        EntityLivingBase owner = null;
        UUID uuid = this.getOwnerId();
        if (uuid != null) {
            owner = this.getEntityByUUID(uuid);
        }
        return super.func_184191_r(entityIn) || owner != null && ((Predicate)TeamHelper.SELECTOR_ALLY.apply((Object)owner)).test((Object)entityIn);
    }

    public Team func_96124_cp() {
        EntityLivingBase owner = null;
        UUID uuid = this.getOwnerId();
        if (uuid != null) {
            owner = this.getEntityByUUID(uuid);
        }
        return owner != null ? owner.func_96124_cp() : super.func_96124_cp();
    }

    public int func_70682_h(int air) {
        return air;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa < this.growTime) {
            int k;
            int j;
            int i;
            IBlockState iblockstate;
            float progress = (float)this.field_70173_aa / (float)this.growTime;
            this.field_70131_O = 2.7f * progress;
            this.func_174826_a(this.func_174813_aQ().func_72321_a(0.0, (double)(2.7f / (float)this.growTime), 0.0));
            if (this.field_70170_p.field_72995_K && (iblockstate = this.field_70170_p.func_180495_p(new BlockPos(i = MathHelper.func_76128_c((double)this.field_70165_t), j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), k = MathHelper.func_76128_c((double)this.field_70161_v)))).func_185904_a() != Material.field_151579_a) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 1.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
            }
        } else if (!this.isGrown) {
            this.field_70714_bg.func_85156_a((EntityAIBase)AIOverride.INSTANCE);
            this.isGrown = true;
        }
    }

    public void func_70636_d() {
        int k;
        int j;
        int i;
        IBlockState iblockstate;
        super.func_70636_d();
        UUID uuid = this.getOwnerId();
        if (uuid != null) {
            EntityLivingBase owner = this.getEntityByUUID(uuid);
            if (owner != null) {
                this.func_175449_a(owner.func_180425_c(), 10);
                if (!SkillHelper.isActiveFrom((Entity)owner, ModAbilities.ANIMATED_STONE_GOLEM)) {
                    this.func_70106_y();
                }
                if (owner.func_70032_d((Entity)this) > 69.0f) {
                    this.teleportTo((Entity)owner);
                }
                if (owner.func_110144_aD() != this && owner.func_110144_aD() != null && ((Predicate)TeamHelper.SELECTOR_ENEMY.apply((Object)owner)).test((Object)owner.func_110144_aD())) {
                    this.func_70624_b(owner.func_110144_aD());
                }
                if (this.func_70643_av() != null && this.func_70643_av().func_184191_r((Entity)this)) {
                    this.func_70604_c(null);
                }
            } else {
                this.func_70106_y();
            }
        } else {
            this.func_70106_y();
        }
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 2.500000277905201E-7 && this.field_70146_Z.nextInt(5) == 0 && (iblockstate = this.field_70170_p.func_180495_p(new BlockPos(i = MathHelper.func_76128_c((double)this.field_70165_t), j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), k = MathHelper.func_76128_c((double)this.field_70161_v)))).func_185904_a() != Material.field_151579_a) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
        }
    }

    public void teleportTo(Entity entity) {
        for (int i = 0; i < 16; ++i) {
            double d3 = entity.field_70165_t + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 5.0;
            double d4 = MathHelper.func_151237_a((double)(entity.field_70163_u + (this.field_70170_p.field_73012_v.nextDouble() * 5.0 - 2.5)), (double)0.0, (double)(this.field_70170_p.func_72940_L() - 1));
            double d5 = entity.field_70161_v + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 5.0;
            if (this.func_184218_aH()) {
                this.func_184210_p();
            }
            if (!this.func_184595_k(d3, d4, d5)) continue;
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187544_ad, SoundCategory.PLAYERS, 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187544_ad, 1.0f, 1.0f);
            break;
        }
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af() && player.func_110124_au().equals(this.getOwnerId())) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    protected void func_70105_a(float width, float height) {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        double w = (double)width / 2.0;
        double h = height;
        this.field_70130_N = width;
        this.field_70131_O = height;
        this.func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a - w, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c - w, axisalignedbb.field_72340_a + w, axisalignedbb.field_72338_b + h, axisalignedbb.field_72339_c + w));
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        if (this.isAddedToWorld() && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72866_a((Entity)this, false);
        }
        float f = this.field_70130_N / 2.0f;
        float f1 = this.field_70131_O;
        this.func_174826_a(new AxisAlignedBB(x - (double)f, y, z - (double)f, x + (double)f, y + (double)f1, z + (double)f));
    }

    public void func_174829_m() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        this.field_70165_t = (axisalignedbb.field_72340_a + axisalignedbb.field_72336_d) / 2.0;
        this.field_70163_u = axisalignedbb.field_72338_b;
        this.field_70161_v = (axisalignedbb.field_72339_c + axisalignedbb.field_72334_f) / 2.0;
        if (this.isAddedToWorld() && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72866_a((Entity)this, false);
        }
    }

    public void func_70106_y() {
        EntityLivingBase owner;
        super.func_70106_y();
        UUID uuid = this.getOwnerId();
        if (uuid != null && (owner = this.getEntityByUUID(uuid)) != null) {
            ModAbilities.ANIMATED_STONE_GOLEM.unapply(owner, this.getData());
            ModAbilities.ANIMATED_STONE_GOLEM.async(owner, this.getData());
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        EntityLivingBase owner;
        this.attackTimer = 15;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        boolean attacked = false;
        UUID uuid = this.getOwnerId();
        if (uuid != null && (owner = this.getEntityByUUID(uuid)) != null) {
            float ownerDamage = (float)owner.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            float damage = this.getDamage() + ownerDamage + ownerDamage * this.getMirrorDamage();
            attacked = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage);
            if (entityIn instanceof EntityLivingBase) {
                SkillData data = this.getData().copy();
                ModEffects.STUNNED.apply((EntityLivingBase)entityIn, data);
                ModEffects.STUNNED.sync((EntityLivingBase)entityIn, data);
            }
            entityIn.field_70181_x += (double)0.4f;
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        return attacked;
    }

    @Nullable
    public EntityLivingBase getEntityByUUID(UUID uuid) {
        for (Entity entity : this.field_70170_p.field_72996_f) {
            if (!entity.func_110124_au().equals(uuid) || !(entity instanceof EntityLivingBase)) continue;
            return (EntityLivingBase)entity;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
            this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187602_cF;
    }

    public SoundEvent func_184615_bR() {
        return SoundEvents.field_187599_cE;
    }

    public void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
    }

    @Nullable
    public UUID getOwnerId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    public void setOwnerId(@Nullable UUID owner) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)owner));
    }

    public void setData(SkillData data) {
        this.field_70180_af.func_187227_b(DATA, (Object)new SkillExtendedData(data));
    }

    public SkillData getData() {
        return ((SkillExtendedData)this.field_70180_af.func_187225_a(EntityStoneGolem.DATA)).data;
    }

    public float getMirrorDamage() {
        return ((Float)this.field_70180_af.func_187225_a(MIRROR_DAMAGE)).floatValue();
    }

    public void setMirrorDamage(float damage) {
        this.field_70180_af.func_187227_b(MIRROR_DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(damage));
    }

    public void setMaxHealth(float health) {
        this.field_70180_af.func_187227_b(MAX_HEALTH, (Object)Float.valueOf(health));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)health);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }
}

