/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.entity;

import arekkuusu.enderskills.api.capability.data.SkillData;
import arekkuusu.enderskills.api.capability.data.nbt.WatcherManager;
import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.api.helper.TeamHelper;
import arekkuusu.enderskills.common.entity.AIFollowFlyingProvider;
import arekkuusu.enderskills.common.entity.ai.FlightMoveHelper;
import arekkuusu.enderskills.common.entity.ai.FlightPathNavigate;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.SkillHelper;
import arekkuusu.enderskills.common.sound.ModSounds;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWaterFlying;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityVoltaicSentinel
extends EntityGolem {
    public static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityVoltaicSentinel.class, (DataSerializer)DataSerializers.field_187203_m);
    public static final DataParameter<Optional<UUID>> FOLLOW_UNIQUE_ID = EntityDataManager.func_187226_a(EntityVoltaicSentinel.class, (DataSerializer)DataSerializers.field_187203_m);
    public static final DataParameter<Float> MAX_HEALTH = EntityDataManager.func_187226_a(EntityVoltaicSentinel.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Float> DAMAGE = EntityDataManager.func_187226_a(EntityVoltaicSentinel.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Boolean> AGGRO = EntityDataManager.func_187226_a(EntityVoltaicSentinel.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityVoltaicSentinel(World worldIn) {
        super(worldIn);
        this.field_70765_h = new FlightMoveHelper((EntityLiving)this);
        this.func_70105_a(1.0f, 1.0f);
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new SentinelAIAttack(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIFollowFlyingProvider((EntityLiving)this, () -> this.getFollowId() != null ? this.getEntityByUUID(this.getFollowId()) : null, 2.0, 5.0f, 64.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWaterFlying((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, Entity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 2, true, false, (Predicate)new AITargetSelector()));
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(FOLLOW_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(MAX_HEALTH, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(DAMAGE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(AGGRO, (Object)false);
    }

    protected boolean func_175448_a(ItemStack stack) {
        return false;
    }

    public void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)((Float)this.field_70180_af.func_187225_a(MAX_HEALTH)).floatValue());
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)((Float)this.field_70180_af.func_187225_a(DAMAGE)).floatValue());
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new FlightPathNavigate((EntityLiving)this, worldIn);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            UUID uuid = this.getFollowId();
            if (uuid != null) {
                EntityLivingBase owner = this.getEntityByUUID(uuid);
                if (owner != null) {
                    this.func_175449_a(owner.func_180425_c(), 10);
                    if (owner.func_70032_d((Entity)this) > 69.0f) {
                        this.teleportTo(owner);
                    }
                } else {
                    this.setFollowId(this.getOwnerId());
                }
            } else {
                this.setFollowId(this.getOwnerId());
            }
            if (this.getOwnerId() == null || !SkillHelper.isActiveFrom((Entity)this.getEntityByUUID(this.getOwnerId()), ModAbilities.VOLTAIC_SENTINEL)) {
                this.func_70106_y();
            }
        }
    }

    public void teleportTo(EntityLivingBase entity) {
        if (this.func_184595_k(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v)) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187544_ad, SoundCategory.PLAYERS, 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187544_ad, 1.0f, 1.0f);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        if (entityIn instanceof EntityLivingBase) {
            double damage = this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            NBTTagCompound compound = new NBTTagCompound();
            NBTHelper.setEntity(compound, (Entity)this, "owner");
            NBTHelper.setDouble(compound, "damage", damage);
            NBTHelper.setDouble(compound, "stun", 20.0);
            SkillData data = SkillData.of(ModAbilities.ZAP).by((Entity)this).with(0).put(compound, new WatcherManager.Watcher[0]).overrides(SkillData.Overrides.SAME).create();
            ModAbilities.ZAP.apply((EntityLivingBase)entityIn, data);
            ModAbilities.ZAP.sync((EntityLivingBase)entityIn, data);
            return true;
        }
        return false;
    }

    public void func_174826_a(AxisAlignedBB bb) {
        super.func_174826_a(bb);
        this.field_70130_N = (float)Math.max(Math.abs(bb.field_72336_d - bb.field_72340_a), Math.abs(bb.field_72334_f - bb.field_72339_c));
        this.field_70131_O = (float)Math.abs(bb.field_72337_e - bb.field_72338_b);
    }

    protected void func_70105_a(float width, float height) {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        double w = (double)width / 2.0;
        double h = (double)height / 2.0;
        this.field_70130_N = width;
        this.field_70131_O = height;
        this.func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a - w, axisalignedbb.field_72338_b - h, axisalignedbb.field_72339_c - w, axisalignedbb.field_72340_a + w, axisalignedbb.field_72338_b + h, axisalignedbb.field_72339_c + w));
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        if (this.isAddedToWorld() && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72866_a((Entity)this, false);
        }
        float f = this.field_70130_N / 2.0f;
        float f1 = this.field_70131_O / 2.0f;
        this.func_174826_a(new AxisAlignedBB(x - (double)f, y - (double)f1, z - (double)f, x + (double)f, y + (double)f1, z + (double)f));
    }

    public void func_174829_m() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        this.field_70165_t = (axisalignedbb.field_72340_a + axisalignedbb.field_72336_d) / 2.0;
        this.field_70163_u = (axisalignedbb.field_72338_b + axisalignedbb.field_72337_e) / 2.0;
        this.field_70161_v = (axisalignedbb.field_72339_c + axisalignedbb.field_72334_f) / 2.0;
        if (this.isAddedToWorld() && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72866_a((Entity)this, false);
        }
    }

    public float func_70047_e() {
        return this.field_70131_O / 2.0f;
    }

    public float func_70689_ay() {
        return super.func_70689_ay();
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af() && player.func_110124_au().equals(this.getOwnerId())) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_184191_r(Entity entityIn) {
        EntityLivingBase owner = null;
        UUID uuid = this.getOwnerId();
        if (uuid != null) {
            owner = this.getEntityByUUID(uuid);
        }
        return super.func_184191_r(entityIn) || owner != null && owner == entityIn;
    }

    public Team func_96124_cp() {
        EntityLivingBase owner = null;
        UUID uuid = this.getOwnerId();
        if (uuid != null) {
            owner = this.getEntityByUUID(uuid);
        }
        return owner != null ? owner.func_96124_cp() : super.func_96124_cp();
    }

    public boolean func_189652_ae() {
        return true;
    }

    public void func_189654_d(boolean noGravity) {
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public int func_82143_as() {
        return Integer.MAX_VALUE;
    }

    public int func_70682_h(int air) {
        return air;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return this.field_70146_Z.nextBoolean() ? ModSounds.VOLTAIC_SENTINEL_V2 : ModSounds.VOLTAIC_SENTINEL_V1;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSounds.ELECTRIC_HIT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return ModSounds.VOLTAIC_SENTINEL_V2;
    }

    @Nullable
    public EntityLivingBase getEntityByUUID(UUID uuid) {
        for (Entity entity : this.field_70170_p.field_72996_f) {
            if (!entity.func_110124_au().equals(uuid) || !(entity instanceof EntityLivingBase)) continue;
            return (EntityLivingBase)entity;
        }
        return null;
    }

    @Nullable
    public UUID getFollowId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(FOLLOW_UNIQUE_ID)).orNull();
    }

    public void setFollowId(@Nullable UUID owner) {
        this.field_70180_af.func_187227_b(FOLLOW_UNIQUE_ID, (Object)Optional.fromNullable((Object)owner));
    }

    @Nullable
    public UUID getOwnerId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    public void setOwnerId(@Nullable UUID owner) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)owner));
    }

    public float getDamage() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(damage));
    }

    public boolean getAggro() {
        return (Boolean)this.field_70180_af.func_187225_a(AGGRO);
    }

    public void setAggro(boolean aggro) {
        this.field_70180_af.func_187227_b(AGGRO, (Object)aggro);
    }

    public void setMaxHealth(float health) {
        this.field_70180_af.func_187227_b(MAX_HEALTH, (Object)Float.valueOf(health));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)health);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    private static class SentinelAIAttack
    extends EntityAIBase {
        private final EntityVoltaicSentinel sentinel;
        private int tickCounter;

        SentinelAIAttack(EntityVoltaicSentinel sentinel) {
            this.sentinel = sentinel;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            EntityLivingBase living = this.sentinel.func_70638_az();
            return living != null && living.func_70089_S();
        }

        public void func_75249_e() {
            if (this.sentinel.func_70032_d((Entity)this.sentinel.func_70638_az()) >= 2.0f) {
                this.sentinel.func_70661_as().func_75499_g();
                this.sentinel.func_70661_as().func_75497_a((Entity)this.sentinel.func_70638_az(), 0.25);
            } else {
                Vec3d vec = RandomPositionGenerator.func_75463_a((EntityCreature)this.sentinel, (int)2, (int)2);
                if (vec != null) {
                    this.sentinel.func_70661_as().func_75499_g();
                    this.sentinel.func_70661_as().func_75492_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 1.0);
                }
            }
            this.sentinel.setAggro(true);
            this.sentinel.field_70160_al = true;
            this.tickCounter = 0;
        }

        public void func_75251_c() {
            this.sentinel.setAggro(false);
            this.sentinel.func_70624_b(null);
        }

        public void func_75246_d() {
            EntityLivingBase target = this.sentinel.func_70638_az();
            if (!this.sentinel.func_70685_l((Entity)target)) {
                this.sentinel.func_70624_b(null);
            } else if (this.tickCounter++ >= 10 && !this.sentinel.field_70170_p.field_72995_K) {
                this.sentinel.func_70652_k((Entity)target);
                this.sentinel.func_70624_b(null);
            }
            this.sentinel.func_70671_ap().func_75650_a(target.field_70165_t, target.field_70163_u + (double)target.func_70047_e(), target.field_70161_v, (float)this.sentinel.func_184649_cE(), (float)this.sentinel.func_70646_bf());
        }
    }

    public class AITargetSelector
    implements Predicate<Entity> {
        public boolean apply(@Nullable Entity entity) {
            if (EntityVoltaicSentinel.this.getOwnerId() == null || entity == null) {
                return false;
            }
            EntityLivingBase owner = EntityVoltaicSentinel.this.getEntityByUUID(EntityVoltaicSentinel.this.getOwnerId());
            return owner != null && ((Predicate)Objects.requireNonNull(TeamHelper.SELECTOR_ENEMY.apply((Object)owner))).test((Object)entity);
        }
    }
}

