/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.entity;

import arekkuusu.enderskills.api.capability.data.SkillData;
import arekkuusu.enderskills.common.entity.EntityWallSegment;
import arekkuusu.enderskills.common.entity.data.ListUUIDExtendedData;
import arekkuusu.enderskills.common.entity.data.SkillExtendedData;
import arekkuusu.enderskills.common.entity.data.WallSegmentBehaviorExtendedData;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.sound.ModSounds;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityWall
extends Entity {
    public static final DataParameter<ListUUIDExtendedData> SYNC_UUID_DATA = EntityDataManager.func_187226_a(EntityWall.class, ListUUIDExtendedData.SERIALIZER);
    public static final DataParameter<SkillExtendedData> DATA = EntityDataManager.func_187226_a(EntityWall.class, SkillExtendedData.SERIALIZER);
    public static final DataParameter<Float> SYNC_LAUNCH = EntityDataManager.func_187226_a(EntityWall.class, (DataSerializer)DataSerializers.field_187193_c);
    public boolean goingDown;

    public EntityWall(World world) {
        super(world);
        this.func_70105_a(0.0f, 0.0f);
    }

    public EntityWall(World world, SkillData skillData) {
        super(world);
        this.setData(skillData);
        this.func_70105_a(0.0f, 0.0f);
    }

    public void func_70071_h_() {
        if (this.field_70128_L) {
            return;
        }
        if (this.field_70170_p.field_72995_K && !this.goingDown && this.getSegments().length > 0 && this.getSegments()[0] != null && this.getSegments()[0].getBehavior() != null && this.getSegments()[0].getBehavior().getClass() == WallSegmentBehaviorExtendedData.Drop.class) {
            if (this.getData().skill == ModAbilities.WALL) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSounds.WALL_DOWN, SoundCategory.PLAYERS, 1.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f, false);
            } else {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSounds.DOME_DOWN, SoundCategory.PLAYERS, 1.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f, false);
            }
            this.goingDown = true;
        }
        super.func_70071_h_();
        this.field_70158_ak = true;
        this.field_70145_X = true;
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        if (this.getSegments().length == 0) {
            this.func_70106_y();
        }
    }

    public void create(BlockPos pos, EnumFacing cardinal, int width, int height, int duration) {
        block0: for (int i = 0; i < width; ++i) {
            int j;
            int z;
            int y;
            int mod = -(width / 2) + i;
            int x = pos.func_177958_n() + (cardinal == EnumFacing.NORTH || cardinal == EnumFacing.SOUTH ? mod : 0);
            BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(x, (y = pos.func_177956_o() - height) + height - 1, z = pos.func_177952_p() + (cardinal == EnumFacing.EAST || cardinal == EnumFacing.WEST ? mod : 0));
            if (!this.isSolid(this.field_70170_p, (BlockPos)mPos)) {
                for (j = 0; j < 4; ++j) {
                    if (j == 3) continue block0;
                    mPos.func_189536_c(EnumFacing.DOWN);
                    --y;
                    if (!this.isSolid(this.field_70170_p, (BlockPos)mPos)) {
                        continue;
                    }
                    break;
                }
            } else if (this.isSolid(this.field_70170_p, mPos.func_177984_a())) {
                for (j = 0; j < 4; ++j) {
                    if (j == 3) continue block0;
                    mPos.func_189536_c(EnumFacing.UP);
                    ++y;
                    if (this.isSolid(this.field_70170_p, mPos.func_177984_a())) {
                        continue;
                    }
                    break;
                }
            }
            if (this.isOverlappingWall(this.field_70170_p, (BlockPos)mPos, 1)) continue;
            boolean foundLand = false;
            int foundLandIndex = 0;
            IBlockState[] states = new IBlockState[height];
            for (int j2 = height - 1; j2 >= 0; --j2) {
                IBlockState stateSeg = this.field_70170_p.func_180495_p((BlockPos)mPos);
                boolean solid = this.isSolid(this.field_70170_p, (BlockPos)mPos);
                if (!solid) {
                    stateSeg = !foundLand ? Blocks.field_150350_a.func_176223_P() : states[j2 + 1];
                } else if (!foundLand) {
                    foundLand = true;
                    foundLandIndex = height - (j2 + 1);
                }
                states[j2] = stateSeg;
                mPos.func_189536_c(EnumFacing.DOWN);
            }
            if (Arrays.stream(states).allMatch(s -> s == Blocks.field_150350_a.func_176223_P())) {
                return;
            }
            EntityWallSegment segment = new EntityWallSegment(this.field_70170_p);
            segment.setBlocks(states);
            segment.setSize(height - foundLandIndex);
            segment.func_70107_b((double)x + 0.5, y, (double)z + 0.5);
            segment.setDuration(duration);
            segment.setWall(this);
            this.field_70170_p.func_72838_d((Entity)segment);
            this.addSegment(segment);
        }
    }

    public boolean isOverlappingWall(World world, BlockPos pos, int size) {
        AxisAlignedBB bb = new AxisAlignedBB(pos).func_72314_b(0.0, (double)size, 0.0);
        return !world.func_72872_a(EntityWallSegment.class, bb).isEmpty();
    }

    public EntityWallSegment[] getSegments() {
        UUID[] uuids = ((ListUUIDExtendedData)this.field_70180_af.func_187225_a(EntityWall.SYNC_UUID_DATA)).uuids;
        if (uuids == null) {
            return new EntityWallSegment[0];
        }
        EntityWallSegment[] segments = new EntityWallSegment[uuids.length];
        block0: for (int i = 0; i < uuids.length; ++i) {
            UUID uuid = uuids[i];
            for (Entity entity : this.func_130014_f_().field_72996_f) {
                if (!entity.func_110124_au().equals(uuid) || !(entity instanceof EntityWallSegment)) continue;
                segments[i] = (EntityWallSegment)entity;
                continue block0;
            }
        }
        return segments;
    }

    public boolean isSolid(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_185890_d((IBlockAccess)world, pos) != Block.field_185506_k;
    }

    public void addSegment(EntityWallSegment segment) {
        ListUUIDExtendedData data = (ListUUIDExtendedData)this.field_70180_af.func_187225_a(SYNC_UUID_DATA);
        data.uuids = Arrays.copyOf(data.uuids, data.uuids.length + 1);
        data.uuids[data.uuids.length - 1] = segment.func_110124_au();
        this.field_70180_af.func_187227_b(SYNC_UUID_DATA, (Object)data);
    }

    public void setData(SkillData data) {
        this.field_70180_af.func_187227_b(DATA, (Object)new SkillExtendedData(data));
    }

    public SkillData getData() {
        return ((SkillExtendedData)this.field_70180_af.func_187225_a(EntityWall.DATA)).data;
    }

    public float getLaunch() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_LAUNCH)).floatValue();
    }

    public void setLaunch(float launch) {
        this.field_70180_af.func_187227_b(SYNC_LAUNCH, (Object)Float.valueOf(launch));
    }

    public boolean func_189652_ae() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70075_an() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SYNC_UUID_DATA, (Object)new ListUUIDExtendedData());
        this.field_70180_af.func_187214_a(DATA, (Object)new SkillExtendedData(null));
        this.field_70180_af.func_187214_a(SYNC_LAUNCH, (Object)Float.valueOf(0.0f));
    }

    protected void func_70037_a(NBTTagCompound compound) {
        ListUUIDExtendedData data = new ListUUIDExtendedData();
        data.deserializeNBT(compound.func_74775_l("SYNC_UUID_DATA"));
        this.field_70180_af.func_187227_b(SYNC_UUID_DATA, (Object)data);
        SkillExtendedData data1 = new SkillExtendedData();
        data1.deserializeNBT(compound.func_74775_l("DATA"));
        this.field_70180_af.func_187227_b(DATA, (Object)data1);
        this.field_70180_af.func_187227_b(SYNC_LAUNCH, (Object)Float.valueOf(compound.func_74760_g("SYNC_LAUNCH")));
        this.goingDown = compound.func_74767_n("goingDown");
        this.field_70173_aa = compound.func_74762_e("ticksExisted");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74782_a("SYNC_UUID_DATA", (NBTBase)((ListUUIDExtendedData)this.field_70180_af.func_187225_a(SYNC_UUID_DATA)).serializeNBT());
        compound.func_74782_a("DATA", (NBTBase)((SkillExtendedData)this.field_70180_af.func_187225_a(DATA)).serializeNBT());
        compound.func_74776_a("SYNC_LAUNCH", ((Float)this.field_70180_af.func_187225_a(SYNC_LAUNCH)).floatValue());
        compound.func_74768_a("ticksExisted", this.field_70173_aa);
    }
}

