/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.entity;

import arekkuusu.enderskills.common.entity.EntityWall;
import arekkuusu.enderskills.common.entity.data.ExtendedData;
import arekkuusu.enderskills.common.entity.data.ListBlockStateExtendedData;
import arekkuusu.enderskills.common.entity.data.WallSegmentBehaviorExtendedData;
import com.google.common.base.Optional;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityWallSegment
extends Entity {
    public static final DataParameter<WallSegmentBehaviorExtendedData> SYNC_BEHAVIOR = EntityDataManager.func_187226_a(EntityWallSegment.class, WallSegmentBehaviorExtendedData.SERIALIZER);
    public static final DataParameter<ListBlockStateExtendedData> SYNC_BLOCKS_DATA = EntityDataManager.func_187226_a(EntityWallSegment.class, ListBlockStateExtendedData.SERIALIZER);
    public static final DataParameter<Optional<UUID>> SYNC_WALL = EntityDataManager.func_187226_a(EntityWallSegment.class, (DataSerializer)DataSerializers.field_187203_m);
    public static final DataParameter<Integer> SYNC_DURATION = EntityDataManager.func_187226_a(EntityWallSegment.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> SYNC_SIZE = EntityDataManager.func_187226_a(EntityWallSegment.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityWallSegment(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
    }

    public void func_70071_h_() {
        if (this.field_70148_d) {
            this.func_70105_a(1.0f, this.getSize());
        }
        super.func_70071_h_();
        this.field_70158_ak = true;
        this.field_70145_X = true;
        if (!this.field_70170_p.field_72995_K) {
            if (this.getWall() == null || this.field_70173_aa > this.getDuration() + 10) {
                this.func_70106_y();
            }
            WallSegmentBehaviorExtendedData next = this.getBehavior().update(this);
            if (this.getBehavior() != next) {
                this.setBehavior(next);
            }
            this.func_70091_d(MoverType.SELF, 0.0, this.field_70181_x, 0.0);
            this.func_70018_K();
        }
        if (this.getBehavior().getClass() == WallSegmentBehaviorExtendedData.Rising.class) {
            this.collideWithNearbyEntities();
        }
    }

    public void collideWithNearbyEntities() {
        EntityWall wall = this.getWall();
        if (wall != null) {
            AxisAlignedBB bb = this.func_174813_aQ().func_72321_a(0.0, this.field_70181_x, 0.0);
            List list = this.field_70170_p.func_175674_a((Entity)this, bb, EntitySelectors.field_180132_d);
            for (Entity entity : list) {
                Vec3d pos = entity.func_174791_d();
                if (!this.canCollideWith(entity) || !(pos.field_72448_b > this.field_70163_u)) continue;
                double yOffset = this.field_70163_u + this.field_70181_x + (double)this.getSize();
                entity.func_70634_a(pos.field_72450_a, yOffset, pos.field_72449_c);
                if (entity.field_70181_x < 0.0) {
                    entity.field_70181_x = 0.0;
                }
                double launch = (1.0 + (double)wall.getLaunch() / 20.0) / 5.0;
                entity.field_70181_x += launch;
                entity.field_70133_I = true;
            }
        }
    }

    public boolean canCollideWith(Entity entity) {
        return !(entity instanceof EntityWall) && !(entity instanceof EntityWallSegment);
    }

    public boolean func_189652_ae() {
        return true;
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    public void func_70108_f(Entity entity) {
    }

    public boolean func_70075_an() {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.getWall() != null) {
            this.getWall().func_70106_y();
        }
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public float func_70047_e() {
        return this.field_70131_O / 2.0f;
    }

    public void setWall(EntityWall wall) {
        this.field_70180_af.func_187227_b(SYNC_WALL, (Object)Optional.of((Object)wall.func_110124_au()));
    }

    @Nullable
    public EntityWall getWall() {
        UUID uuid = (UUID)((Optional)this.field_70180_af.func_187225_a(SYNC_WALL)).orNull();
        if (uuid != null) {
            for (Entity entity : this.func_130014_f_().field_72996_f) {
                if (!entity.func_110124_au().equals(uuid) || !(entity instanceof EntityWall)) continue;
                return (EntityWall)entity;
            }
        }
        return null;
    }

    public IBlockState[] getBlocks() {
        return ((ListBlockStateExtendedData)this.field_70180_af.func_187225_a(EntityWallSegment.SYNC_BLOCKS_DATA)).states;
    }

    public void setBlocks(IBlockState[] states) {
        ListBlockStateExtendedData data = (ListBlockStateExtendedData)this.field_70180_af.func_187225_a(SYNC_BLOCKS_DATA);
        data.states = states;
        this.field_70180_af.func_187227_b(SYNC_BLOCKS_DATA, (Object)data);
    }

    @Nullable
    public WallSegmentBehaviorExtendedData getBehavior() {
        return (WallSegmentBehaviorExtendedData)this.field_70180_af.func_187225_a(SYNC_BEHAVIOR);
    }

    public void setBehavior(WallSegmentBehaviorExtendedData behavior) {
        this.field_70180_af.func_187227_b(SYNC_BEHAVIOR, (Object)behavior);
    }

    public int getDuration() {
        return (Integer)this.field_70180_af.func_187225_a(SYNC_DURATION);
    }

    public void setDuration(int duration) {
        this.field_70180_af.func_187227_b(SYNC_DURATION, (Object)duration);
    }

    public int getSize() {
        return (Integer)this.field_70180_af.func_187225_a(SYNC_SIZE);
    }

    public void setSize(int size) {
        this.field_70180_af.func_187227_b(SYNC_SIZE, (Object)size);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SYNC_SIZE, (Object)0);
        this.field_70180_af.func_187214_a(SYNC_DURATION, (Object)0);
        this.field_70180_af.func_187214_a(SYNC_WALL, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(SYNC_BLOCKS_DATA, (Object)new ListBlockStateExtendedData());
        this.field_70180_af.func_187214_a(SYNC_BEHAVIOR, (Object)new WallSegmentBehaviorExtendedData.Rising());
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.setSize(compound.func_74762_e("size"));
        this.setDuration(compound.func_74762_e("duration"));
        if (compound.func_74764_b("uuid")) {
            this.field_70180_af.func_187227_b(SYNC_WALL, (Object)Optional.fromNullable((Object)compound.func_186857_a("uuid")));
        } else {
            this.field_70180_af.func_187227_b(SYNC_WALL, (Object)Optional.absent());
        }
        NBTTagList stateList = compound.func_150295_c("states", 10);
        IBlockState[] states = new IBlockState[stateList.func_74745_c()];
        for (int i = 0; i < states.length; ++i) {
            states[i] = Block.func_176220_d((int)stateList.func_150305_b(i).func_74762_e("state"));
        }
        this.setBlocks(states);
        this.setBehavior((WallSegmentBehaviorExtendedData)ExtendedData.lookup(compound.func_74762_e("behavior")));
        ListBlockStateExtendedData data = new ListBlockStateExtendedData();
        data.deserializeNBT(compound.func_74775_l("SYNC_BLOCKS_DATA"));
        this.field_70180_af.func_187227_b(SYNC_BLOCKS_DATA, (Object)data);
        if (compound.func_74764_b("SYNC_WALL")) {
            this.field_70180_af.func_187227_b(SYNC_WALL, (Object)Optional.fromNullable((Object)compound.func_186857_a("SYNC_WALL")));
        }
        this.setDuration(compound.func_74762_e("SYNC_DURATION"));
        this.setSize(compound.func_74762_e("SYNC_SIZE"));
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("size", this.getSize());
        compound.func_74768_a("duration", this.getDuration());
        if (((Optional)this.field_70180_af.func_187225_a(SYNC_WALL)).isPresent()) {
            compound.func_186854_a("uuid", (UUID)((Optional)this.field_70180_af.func_187225_a(SYNC_WALL)).get());
        }
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.getBlocks().length; ++i) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("state", Block.func_176210_f((IBlockState)this.getBlocks()[i]));
            list.func_74742_a((NBTBase)nbt);
        }
        compound.func_74782_a("states", (NBTBase)list);
        compound.func_74768_a("behavior", this.getBehavior().getId());
        compound.func_74782_a("SYNC_BLOCKS_DATA", (NBTBase)((ListBlockStateExtendedData)this.field_70180_af.func_187225_a(SYNC_BLOCKS_DATA)).serializeNBT());
        if (((Optional)this.field_70180_af.func_187225_a(SYNC_WALL)).isPresent()) {
            compound.func_186854_a("SYNC_WALL", (UUID)((Optional)this.field_70180_af.func_187225_a(SYNC_WALL)).get());
        }
        compound.func_74768_a("SYNC_DURATION", ((Integer)this.field_70180_af.func_187225_a(SYNC_DURATION)).intValue());
        compound.func_74768_a("SYNC_SIZE", ((Integer)this.field_70180_af.func_187225_a(SYNC_SIZE)).intValue());
    }
}

