/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.entity.data;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;

public abstract class ExtendedData<T> {
    private static Int2ObjectMap<Class<? extends ExtendedData<?>>> int2ObjectMap;
    private static Object2IntMap<Class<? extends ExtendedData<?>>> object2IntMap;
    private static int nextId;

    public abstract void fromBytes(PacketBuffer var1);

    public abstract void toBytes(PacketBuffer var1);

    protected static int register(Class<? extends ExtendedData<?>> behaviorClass) {
        if (int2ObjectMap == null) {
            int2ObjectMap = new Int2ObjectArrayMap();
            object2IntMap = new Object2IntArrayMap();
        }
        int id = nextId++;
        int2ObjectMap.put(id, behaviorClass);
        object2IntMap.put(behaviorClass, id);
        return id;
    }

    public static ExtendedData<?> lookup(int id) {
        try {
            return (ExtendedData)((Class)int2ObjectMap.get(id)).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getId() {
        return (Integer)object2IntMap.get(this.getClass());
    }

    static {
        nextId = 0;
    }

    public static class ExtendedDataSerializer<T extends ExtendedData<?>>
    implements DataSerializer<T> {
        public void write(PacketBuffer buf, T value) {
            buf.writeInt(((ExtendedData)value).getId());
            ((ExtendedData)value).toBytes(buf);
        }

        public T read(PacketBuffer buf) {
            try {
                ExtendedData<?> behavior = ExtendedData.lookup(buf.readInt());
                behavior.fromBytes(buf);
                return (T)behavior;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public DataParameter<T> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public T copyValue(T behavior) {
            return behavior;
        }
    }
}

