/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.entity.data;

import arekkuusu.enderskills.common.entity.data.ExtendedData;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;

public class ListBlockPosExtendedData
extends ExtendedData<ListBlockPosExtendedData>
implements INBTSerializable<NBTTagCompound> {
    public static final ExtendedData.ExtendedDataSerializer<ListBlockPosExtendedData> SERIALIZER = new ExtendedData.ExtendedDataSerializer();
    public BlockPos[][] posArray = new BlockPos[0][0];

    @Override
    public void fromBytes(PacketBuffer buf) {
        int size = buf.readInt();
        this.posArray = new BlockPos[size][0];
        for (int i = 0; i < this.posArray.length; ++i) {
            int subSize = buf.readInt();
            BlockPos[] subArray = new BlockPos[subSize];
            for (int j = 0; j < subArray.length; ++j) {
                subArray[j] = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            }
            this.posArray[i] = subArray;
        }
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.posArray.length);
        for (BlockPos[] subArray : this.posArray) {
            buf.writeInt(subArray.length);
            for (BlockPos pos : subArray) {
                buf.writeInt(pos.func_177958_n());
                buf.writeInt(pos.func_177956_o());
                buf.writeInt(pos.func_177952_p());
            }
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("h", this.posArray.length);
        NBTTagList hList = new NBTTagList();
        for (BlockPos[] subPosArray : this.posArray) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("v", subPosArray.length);
            NBTTagList vList = new NBTTagList();
            for (BlockPos blockPos : subPosArray) {
                NBTTagCompound subNbt = new NBTTagCompound();
                subNbt.func_74768_a("x", blockPos.func_177958_n());
                subNbt.func_74768_a("y", blockPos.func_177956_o());
                subNbt.func_74768_a("z", blockPos.func_177952_p());
                vList.func_74742_a((NBTBase)subNbt);
            }
            nbt.func_74782_a("vl", (NBTBase)vList);
            hList.func_74742_a((NBTBase)nbt);
        }
        tag.func_74782_a("hl", (NBTBase)hList);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.posArray = new BlockPos[nbt.func_74762_e("h")][];
        NBTTagList hList = nbt.func_150295_c("hl", 10);
        for (int i = 0; i < this.posArray.length; ++i) {
            NBTTagCompound tag = hList.func_150305_b(i);
            this.posArray[i] = new BlockPos[tag.func_74762_e("v")];
            NBTTagList vList = tag.func_150295_c("vl", 10);
            BlockPos[] pos = this.posArray[i];
            for (int i1 = 0; i1 < pos.length; ++i1) {
                BlockPos blockPos;
                NBTTagCompound subTag = vList.func_150305_b(i1);
                this.posArray[i][i1] = blockPos = new BlockPos(subTag.func_74762_e("x"), subTag.func_74762_e("y"), subTag.func_74762_e("z"));
            }
        }
    }

    static {
        ListBlockPosExtendedData.register(ListBlockPosExtendedData.class);
    }
}

