/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.entity.data;

import arekkuusu.enderskills.common.entity.EntityWallSegment;
import arekkuusu.enderskills.common.entity.data.ExtendedData;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.AxisAlignedBB;

public abstract class WallSegmentBehaviorExtendedData
extends ExtendedData<WallSegmentBehaviorExtendedData> {
    public static final ExtendedData.ExtendedDataSerializer<WallSegmentBehaviorExtendedData> SERIALIZER = new ExtendedData.ExtendedDataSerializer();

    public abstract WallSegmentBehaviorExtendedData update(EntityWallSegment var1);

    @Override
    public void fromBytes(PacketBuffer buf) {
    }

    @Override
    public void toBytes(PacketBuffer buf) {
    }

    public double getCollided(EntityWallSegment segment, double moveUp) {
        AxisAlignedBB ebb = segment.func_174813_aQ();
        AxisAlignedBB bb = new AxisAlignedBB(ebb.field_72340_a, ebb.field_72338_b + (double)segment.getSize() - 0.9, ebb.field_72339_c, ebb.field_72336_d, ebb.field_72337_e, ebb.field_72334_f);
        List list = segment.field_70170_p.func_184144_a((Entity)segment, bb.func_72321_a(0.0, moveUp, 0.0));
        int l = list.size();
        for (int k = 0; k < l; ++k) {
            moveUp = ((AxisAlignedBB)list.get(k)).func_72323_b(bb, moveUp);
        }
        return Math.max(moveUp, 0.0);
    }

    static {
        WallSegmentBehaviorExtendedData.register(Drop.class);
        WallSegmentBehaviorExtendedData.register(Rising.class);
        WallSegmentBehaviorExtendedData.register(Waiting.class);
    }

    public static class Waiting
    extends WallSegmentBehaviorExtendedData {
        private int ticks = 0;

        @Override
        public WallSegmentBehaviorExtendedData update(EntityWallSegment entity) {
            ++this.ticks;
            entity.field_70181_x = 0.0;
            boolean drop = this.ticks >= entity.getDuration();
            return drop ? new Drop() : this;
        }
    }

    public static class Rising
    extends WallSegmentBehaviorExtendedData {
        private int ticks = 0;

        @Override
        public WallSegmentBehaviorExtendedData update(EntityWallSegment entity) {
            if (this.ticks == 1) {
                entity.field_70181_x = (double)entity.getSize() / 5.0;
            }
            entity.field_70181_x = this.getCollided(entity, entity.field_70181_x);
            ++this.ticks;
            return this.ticks > 5 ? new Waiting() : this;
        }
    }

    public static class Drop
    extends WallSegmentBehaviorExtendedData {
        private int ticks = 0;

        @Override
        public WallSegmentBehaviorExtendedData update(EntityWallSegment entity) {
            if (this.ticks == 1) {
                entity.field_70181_x = -((double)entity.getSize() / 5.0);
            }
            ++this.ticks;
            return this;
        }
    }
}

