/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.entity.placeable;

import arekkuusu.enderskills.api.capability.data.SkillData;
import arekkuusu.enderskills.common.entity.data.ListBlockPosExtendedData;
import arekkuusu.enderskills.common.entity.placeable.EntityPlaceableData;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityPlaceableBloodPool
extends EntityPlaceableData {
    public static final DataParameter<ListBlockPosExtendedData> SYNC_BLOCKS_DATA = EntityDataManager.func_187226_a(EntityPlaceableBloodPool.class, ListBlockPosExtendedData.SERIALIZER);
    public double cursor = 0.0;

    public EntityPlaceableBloodPool(World world) {
        super(world);
        this.func_70105_a(0.0f, 6.0f);
    }

    public EntityPlaceableBloodPool(World worldIn, @Nullable EntityLivingBase owner, SkillData skillData, int lifeTime) {
        super(worldIn, owner, skillData, lifeTime);
        this.func_70105_a(0.0f, 6.0f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_BLOCKS_DATA, (Object)new ListBlockPosExtendedData());
    }

    @Override
    public void func_70071_h_() {
        if (this.tick < 10) {
            this.updateSpread();
        }
        super.func_70071_h_();
    }

    public void updateSpread() {
        BlockPos[][] positions = ((ListBlockPosExtendedData)this.field_70180_af.func_187225_a(EntityPlaceableBloodPool.SYNC_BLOCKS_DATA)).posArray;
        double perTick = (double)positions.length / 10.0;
        this.cursor += perTick;
    }

    public void spreadOnTerrain() {
        ListBlockPosExtendedData data = new ListBlockPosExtendedData();
        BlockPos[][] positions = ((ListBlockPosExtendedData)this.field_70180_af.func_187225_a(EntityPlaceableBloodPool.SYNC_BLOCKS_DATA)).posArray;
        int radius = (int)Math.ceil(this.getRadius());
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        HashSet<BlockPos> queue = new HashSet<BlockPos>();
        BlockPos origin = this.func_180425_c().func_177977_b();
        BlockPos original = this.getValid(origin);
        if (original != null) {
            positions = (BlockPos[][])Arrays.copyOf(positions, positions.length + 1);
            positions[0] = new BlockPos[]{original};
            visited.add(original);
            this.addNext(queue, original);
            int i = 1;
            while (true) {
                positions = (BlockPos[][])Arrays.copyOf(positions, positions.length + 1);
                positions[i] = new BlockPos[0];
                HashSet<BlockPos> temp = new HashSet<BlockPos>();
                int j = 0;
                for (BlockPos pos : queue) {
                    BlockPos validated = this.getValid(pos);
                    if (validated == null || !this.isWithingRadius(original, validated, radius) || !visited.add(validated)) continue;
                    positions[i] = Arrays.copyOf(positions[i], positions[i].length + 1);
                    positions[i][j] = validated;
                    this.addNext(temp, validated);
                    ++j;
                }
                if (temp.isEmpty()) break;
                queue = temp;
                ++i;
            }
        }
        data.posArray = positions;
        this.field_70180_af.func_187227_b(SYNC_BLOCKS_DATA, (Object)data);
    }

    @Nullable
    public BlockPos getValid(BlockPos pos) {
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(pos);
        if (!this.isSolid((BlockPos)mPos)) {
            int j = 0;
            while (true) {
                if (j == 1) {
                    return null;
                }
                mPos.func_189536_c(EnumFacing.DOWN);
                if (this.isSolid((BlockPos)mPos)) {
                    return mPos.func_185334_h();
                }
                ++j;
            }
        }
        if (this.isSolid(mPos.func_177984_a())) {
            return null;
        }
        return mPos.func_185334_h();
    }

    public boolean isWithingRadius(BlockPos origin, BlockPos pos, int distance) {
        int x = origin.func_177958_n() - pos.func_177958_n();
        x = Math.abs(x);
        int y = origin.func_177956_o() - pos.func_177956_o();
        y = Math.abs(y);
        int z = origin.func_177952_p() - pos.func_177952_p();
        z = Math.abs(z);
        return x <= distance && y <= distance && z <= distance;
    }

    public boolean isSolid(BlockPos pos) {
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        return state.func_185890_d((IBlockAccess)this.field_70170_p, pos) != Block.field_185506_k;
    }

    public void addNext(Set<BlockPos> list, BlockPos origin) {
        list.add(origin.func_177972_a(EnumFacing.NORTH));
        list.add(origin.func_177972_a(EnumFacing.SOUTH));
        list.add(origin.func_177972_a(EnumFacing.EAST));
        list.add(origin.func_177972_a(EnumFacing.WEST));
    }

    public List<BlockPos> getTerrainBlocks() {
        ArrayList list = Lists.newArrayList();
        BlockPos[][] positions = ((ListBlockPosExtendedData)this.field_70180_af.func_187225_a(EntityPlaceableBloodPool.SYNC_BLOCKS_DATA)).posArray;
        for (int i = 0; (double)i < this.cursor && i < positions.length; ++i) {
            BlockPos[] position = positions[i];
            list.addAll(Arrays.asList(position));
        }
        return list;
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        ListBlockPosExtendedData data = new ListBlockPosExtendedData();
        data.deserializeNBT(compound.func_74775_l("SYNC_BLOCKS_DATA"));
        this.field_70180_af.func_187227_b(SYNC_BLOCKS_DATA, (Object)data);
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74782_a("SYNC_BLOCKS_DATA", (NBTBase)((ListBlockPosExtendedData)this.field_70180_af.func_187225_a(SYNC_BLOCKS_DATA)).serializeNBT());
    }
}

