/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.entity.placeable;

import arekkuusu.enderskills.api.capability.data.SkillData;
import arekkuusu.enderskills.common.entity.data.IExpand;
import arekkuusu.enderskills.common.entity.data.IFindEntity;
import arekkuusu.enderskills.common.entity.data.ILoopSound;
import arekkuusu.enderskills.common.entity.data.IScanEntities;
import arekkuusu.enderskills.common.entity.data.SkillExtendedData;
import arekkuusu.enderskills.common.skill.SkillHelper;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityPlaceableData
extends Entity {
    public static final DataParameter<SkillExtendedData> DATA = EntityDataManager.func_187226_a(EntityPlaceableData.class, SkillExtendedData.SERIALIZER);
    public static final DataParameter<Integer> LIFE_TIME = EntityDataManager.func_187226_a(EntityPlaceableData.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(EntityPlaceableData.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final int MIN_TIME = 10;
    public Set<Entity> affectedEntities = Sets.newHashSet();
    public int growTicks = 10;
    public int tick;

    public EntityPlaceableData(World worldIn) {
        super(worldIn);
        this.field_70145_X = true;
        this.func_70105_a(0.0f, 0.0f);
    }

    public EntityPlaceableData(World worldIn, @Nullable EntityLivingBase owner, SkillData skillData, int lifeTime) {
        this(worldIn);
        if (owner != null) {
            this.field_70125_A = owner.field_70125_A;
            this.field_70177_z = owner.field_70177_z;
        }
        this.setData(skillData);
        this.setLifeTime(lifeTime);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(DATA, (Object)new SkillExtendedData(null));
        this.field_70180_af.func_187214_a(LIFE_TIME, (Object)0);
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(1.0f));
    }

    public void func_70071_h_() {
        if (this.field_70148_d && this.field_70170_p.field_72995_K && this.getData().skill instanceof ILoopSound) {
            ((ILoopSound)((Object)this.getData().skill)).makeSound(this);
        }
        super.func_70071_h_();
        SkillData data = this.getData();
        EntityLivingBase owner = SkillHelper.getOwner(data);
        if (!this.field_70170_p.field_72995_K) {
            if (this.getLifeTime() > this.tick) {
                List<Entity> entities;
                if (data.skill instanceof IScanEntities && !(entities = ((IScanEntities)((Object)data.skill)).getScan(this, owner, data.copy(), this.getRadius() * ((float)this.tick / (float)this.getLifeTime()))).isEmpty()) {
                    for (Entity entity : entities) {
                        if (!(entity instanceof EntityLivingBase)) continue;
                        if (this.affectedEntities.add(entity) && data.skill instanceof IFindEntity) {
                            ((IFindEntity)((Object)data.skill)).onFound(this, owner, (EntityLivingBase)entity, data.copy());
                        }
                        if (!(data.skill instanceof IScanEntities)) continue;
                        ((IScanEntities)((Object)data.skill)).onScan(this, owner, (EntityLivingBase)entity, data.copy());
                    }
                }
            } else {
                this.func_70106_y();
            }
        }
        if (this.growTicks > this.tick && data.skill instanceof IExpand) {
            this.func_174826_a(((IExpand)((Object)data.skill)).expand(this, this.func_174813_aQ(), this.getRadius() / (float)this.growTicks));
        }
        ++this.tick;
    }

    public void func_174826_a(AxisAlignedBB bb) {
        super.func_174826_a(bb);
        this.field_70130_N = (float)Math.max(Math.abs(bb.field_72336_d - bb.field_72340_a), Math.abs(bb.field_72334_f - bb.field_72339_c));
        this.field_70131_O = (float)Math.abs(bb.field_72337_e - bb.field_72338_b);
    }

    protected void func_70105_a(float width, float height) {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        double w = (double)width / 2.0;
        double h = (double)height / 2.0;
        this.field_70130_N = width;
        this.field_70131_O = height;
        this.func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a - w, axisalignedbb.field_72338_b - h, axisalignedbb.field_72339_c - w, axisalignedbb.field_72340_a + w, axisalignedbb.field_72338_b + h, axisalignedbb.field_72339_c + w));
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        if (this.isAddedToWorld() && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72866_a((Entity)this, false);
        }
        float f = this.field_70130_N / 2.0f;
        float f1 = this.field_70131_O / 2.0f;
        this.func_174826_a(new AxisAlignedBB(x - (double)f, y - (double)f1, z - (double)f, x + (double)f, y + (double)f1, z + (double)f));
    }

    public void func_174829_m() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        this.field_70165_t = (axisalignedbb.field_72340_a + axisalignedbb.field_72336_d) / 2.0;
        this.field_70163_u = (axisalignedbb.field_72338_b + axisalignedbb.field_72337_e) / 2.0;
        this.field_70161_v = (axisalignedbb.field_72339_c + axisalignedbb.field_72334_f) / 2.0;
        if (this.isAddedToWorld() && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72866_a((Entity)this, false);
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public float func_70047_e() {
        return 0.0f;
    }

    public void setGrowTicks(int growTicks) {
        this.growTicks = growTicks;
    }

    public void setLifeTime(int age) {
        this.field_70180_af.func_187227_b(LIFE_TIME, (Object)age);
    }

    public int getLifeTime() {
        return (Integer)this.field_70180_af.func_187225_a(LIFE_TIME);
    }

    public void setRadius(double size) {
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf((float)size));
    }

    public float getRadius() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
    }

    public void setData(SkillData data) {
        this.field_70180_af.func_187227_b(DATA, (Object)new SkillExtendedData(data));
    }

    public SkillData getData() {
        return ((SkillExtendedData)this.field_70180_af.func_187225_a(EntityPlaceableData.DATA)).data;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_74764_b("data")) {
            this.setData(new SkillData(compound.func_74775_l("data")));
        }
        this.setLifeTime(compound.func_74762_e("lifeTime"));
        this.setRadius(compound.func_74769_h("radius"));
        this.growTicks = compound.func_74762_e("growTicks");
        this.tick = compound.func_74762_e("tick");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (this.getData() != null) {
            compound.func_74782_a("data", (NBTBase)this.getData().serializeNBT());
        }
        compound.func_74768_a("lifeTime", this.getLifeTime());
        compound.func_74780_a("radius", (double)this.getRadius());
        compound.func_74768_a("growTicks", this.growTicks);
        compound.func_74768_a("tick", this.tick);
    }
}

