/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.entity.placeable;

import arekkuusu.enderskills.api.capability.data.SkillData;
import arekkuusu.enderskills.common.entity.data.ListBlockPosExtendedData;
import arekkuusu.enderskills.common.entity.placeable.EntityPlaceableData;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityPlaceableShockwave
extends EntityPlaceableData {
    public static final DataParameter<ListBlockPosExtendedData> SYNC_BLOCKS_DATA = EntityDataManager.func_187226_a(EntityPlaceableShockwave.class, ListBlockPosExtendedData.SERIALIZER);
    public double[] curves = new double[0];
    public double cursor = 0.0;

    public EntityPlaceableShockwave(World world) {
        super(world);
    }

    public EntityPlaceableShockwave(World worldIn, @Nullable EntityLivingBase owner, SkillData skillData, int lifeTime) {
        super(worldIn, owner, skillData, lifeTime);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_BLOCKS_DATA, (Object)new ListBlockPosExtendedData());
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            this.updateSpread();
        }
        super.func_70071_h_();
    }

    public void updateSpread() {
        BlockPos[][] positions = ((ListBlockPosExtendedData)this.field_70180_af.func_187225_a(EntityPlaceableShockwave.SYNC_BLOCKS_DATA)).posArray;
        this.curves = new double[positions.length];
        double perTick = (double)(this.curves.length + 6) / 20.0;
        double maxLayer = this.getData().nbt.func_74769_h("push") * 0.5;
        double perLayer = maxLayer / 3.0;
        int num = (int)Math.ceil(this.cursor);
        for (int i = num - 3; i < num + 3; ++i) {
            if (i >= this.curves.length + 3 || i < -3) continue;
            int diff = i - num;
            if (diff > 0) {
                diff = -diff;
            }
            double layer = maxLayer + perLayer * (double)diff;
            if (i < 0 || i >= this.curves.length || !(layer > this.curves[i])) continue;
            this.curves[i] = layer;
        }
        this.cursor += perTick;
    }

    public void spreadOnTerrain() {
        ListBlockPosExtendedData data = new ListBlockPosExtendedData();
        BlockPos[][] positions = ((ListBlockPosExtendedData)this.field_70180_af.func_187225_a(EntityPlaceableShockwave.SYNC_BLOCKS_DATA)).posArray;
        int radius = (int)Math.ceil(this.getRadius());
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        HashSet<BlockPos> queue = new HashSet<BlockPos>();
        BlockPos origin = this.func_180425_c().func_177977_b();
        BlockPos original = this.getValid(origin);
        if (original != null) {
            positions = (BlockPos[][])Arrays.copyOf(positions, positions.length + 1);
            positions[0] = new BlockPos[]{original};
            visited.add(original);
            this.addNext(queue, original, original, radius);
            int i = 1;
            while (true) {
                positions = (BlockPos[][])Arrays.copyOf(positions, positions.length + 1);
                positions[i] = new BlockPos[0];
                HashSet<BlockPos> temp = new HashSet<BlockPos>();
                int j = 0;
                for (BlockPos pos : queue) {
                    BlockPos validated = this.getValid(pos);
                    if (validated == null || !this.isWithingRadius(original, validated, radius) || !visited.add(validated)) continue;
                    positions[i] = Arrays.copyOf(positions[i], positions[i].length + 1);
                    positions[i][j] = validated;
                    this.addNext(temp, origin, validated, radius);
                    ++j;
                }
                if (temp.isEmpty()) break;
                queue = temp;
                ++i;
            }
        }
        data.posArray = positions;
        this.field_70180_af.func_187227_b(SYNC_BLOCKS_DATA, (Object)data);
    }

    @Nullable
    public BlockPos getValid(BlockPos pos) {
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(pos);
        if (!this.isSolid((BlockPos)mPos)) {
            int j = 0;
            while (true) {
                if (j == 2) {
                    return null;
                }
                mPos.func_189536_c(EnumFacing.DOWN);
                if (this.isSolid((BlockPos)mPos)) {
                    return mPos.func_185334_h();
                }
                ++j;
            }
        }
        if (this.isSolid(mPos.func_177984_a())) {
            int j = 0;
            while (true) {
                if (j == 2) {
                    return null;
                }
                mPos.func_189536_c(EnumFacing.UP);
                if (!this.isSolid(mPos.func_177984_a())) {
                    return mPos.func_185334_h();
                }
                ++j;
            }
        }
        return mPos.func_185334_h();
    }

    public boolean isWithingRadius(BlockPos origin, BlockPos pos, int distance) {
        int x = origin.func_177958_n() - pos.func_177958_n();
        x = Math.abs(x);
        int y = origin.func_177956_o() - pos.func_177956_o();
        y = Math.abs(y);
        int z = origin.func_177952_p() - pos.func_177952_p();
        z = Math.abs(z);
        return x <= distance && y <= distance && z <= distance;
    }

    public boolean isSolid(BlockPos pos) {
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        return state.func_185890_d((IBlockAccess)this.field_70170_p, pos) != Block.field_185506_k;
    }

    public void addNext(Set<BlockPos> list, BlockPos origin, BlockPos pos, int distance) {
        BlockPos offset = pos.func_177972_a(EnumFacing.NORTH);
        if (this.isWithingRadius(origin, pos, distance)) {
            list.add(offset);
        }
        offset = pos.func_177972_a(EnumFacing.SOUTH);
        if (this.isWithingRadius(origin, pos, distance)) {
            list.add(offset);
        }
        offset = pos.func_177972_a(EnumFacing.EAST);
        if (this.isWithingRadius(origin, pos, distance)) {
            list.add(offset);
        }
        offset = pos.func_177972_a(EnumFacing.WEST);
        if (this.isWithingRadius(origin, pos, distance)) {
            list.add(offset);
        }
    }

    public BlockPos[][] getTerrainBlocks() {
        return ((ListBlockPosExtendedData)this.field_70180_af.func_187225_a(EntityPlaceableShockwave.SYNC_BLOCKS_DATA)).posArray;
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        ListBlockPosExtendedData data = new ListBlockPosExtendedData();
        data.deserializeNBT(compound.func_74775_l("SYNC_BLOCKS_DATA"));
        this.field_70180_af.func_187227_b(SYNC_BLOCKS_DATA, (Object)data);
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74782_a("SYNC_BLOCKS_DATA", (NBTBase)((ListBlockPosExtendedData)this.field_70180_af.func_187225_a(SYNC_BLOCKS_DATA)).serializeNBT());
    }
}

