/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.entity.throwable;

import arekkuusu.enderskills.api.helper.RayTraceHelper;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityThrowableCustom
extends Entity
implements IProjectile {
    public static final DataParameter<Integer> LIFE_TIME = EntityDataManager.func_187226_a(EntityThrowableCustom.class, (DataSerializer)DataSerializers.field_187192_b);
    public EntityLivingBase thrower;
    public int throwableShake;
    public String throwerName;
    public int ticksInAir;

    public EntityThrowableCustom(World worldIn) {
        super(worldIn);
        this.func_189654_d(true);
        this.func_70105_a(0.25f, 0.25f);
    }

    public EntityThrowableCustom(World worldIn, EntityLivingBase owner, int lifeTime) {
        this(worldIn);
        Vec3d posVec = new Vec3d(owner.field_70165_t, owner.field_70163_u + (double)owner.func_70047_e() - (double)0.1f, owner.field_70161_v);
        Vec3d lookVec = owner.func_70040_Z().func_72432_b();
        posVec = posVec.func_72441_c(lookVec.field_72450_a * 0.5, lookVec.field_72448_b * 0.5, lookVec.field_72449_c * 0.5);
        this.thrower = owner;
        this.func_70107_b(posVec.field_72450_a, posVec.field_72448_b, posVec.field_72449_c);
        this.func_189654_d(true);
        this.setLifeTime(lifeTime);
    }

    public void func_70088_a() {
        this.field_70180_af.func_187214_a(LIFE_TIME, (Object)0);
    }

    public abstract void onImpact(RayTraceResult var1);

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void shoot(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, double velocity, double inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, (float)velocity, (float)inaccuracy);
        this.field_70159_w += entityThrower.field_70159_w;
        this.field_70179_y += entityThrower.field_70179_y;
        if (!entityThrower.field_70122_E) {
            this.field_70181_x += entityThrower.field_70181_x;
        }
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.rotateTowardsMovement(this, 1.0f);
        if (this.field_70170_p.field_72995_K || (this.thrower == null || !this.thrower.field_70128_L) && this.field_70170_p.func_175667_e(new BlockPos((Entity)this))) {
            ++this.ticksInAir;
            if (this.getLifeTime() <= this.ticksInAir) {
                if (!this.field_70170_p.field_72995_K) {
                    RayTraceResult missResult = new RayTraceResult(RayTraceResult.Type.MISS, this.func_174791_d(), null, null);
                    this.onImpact(missResult);
                    this.func_70106_y();
                }
            } else {
                RayTraceResult raytraceresult;
                if (!this.field_70170_p.field_72995_K && (raytraceresult = RayTraceHelper.forwardsRaycast(this, true, this.ticksInAir >= 25, (Entity)this.thrower)) != null && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
                    this.onImpact(raytraceresult);
                    this.func_70106_y();
                }
                this.field_70165_t += this.field_70159_w;
                this.field_70163_u += this.field_70181_x;
                this.field_70161_v += this.field_70179_y;
                if (!this.func_189652_ae()) {
                    this.field_70181_x -= 0.09000000074505805;
                }
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            }
        } else {
            this.func_70106_y();
        }
    }

    public void rotateTowardsMovement(Entity projectile, float rotationSpeed) {
        double d0 = -projectile.field_70159_w;
        double d1 = -projectile.field_70181_x;
        double d2 = -projectile.field_70179_y;
        float f = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        projectile.field_70177_z = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) + 90.0f;
        projectile.field_70125_A = (float)(MathHelper.func_181159_b((double)f, (double)d1) * 57.29577951308232) - 90.0f;
        while (projectile.field_70125_A - projectile.field_70127_C < -180.0f) {
            projectile.field_70127_C -= 360.0f;
        }
        while (projectile.field_70125_A - projectile.field_70127_C >= 180.0f) {
            projectile.field_70127_C += 360.0f;
        }
        while (projectile.field_70177_z - projectile.field_70126_B < -180.0f) {
            projectile.field_70126_B -= 360.0f;
        }
        while (projectile.field_70177_z - projectile.field_70126_B >= 180.0f) {
            projectile.field_70126_B += 360.0f;
        }
        projectile.field_70125_A = projectile.field_70127_C + (projectile.field_70125_A - projectile.field_70127_C) * rotationSpeed;
        projectile.field_70177_z = projectile.field_70126_B + (projectile.field_70177_z - projectile.field_70126_B) * rotationSpeed;
    }

    public float func_70047_e() {
        return this.field_70131_O / 2.0f;
    }

    public void setLifeTime(int age) {
        this.field_70180_af.func_187227_b(LIFE_TIME, (Object)age);
    }

    public int getLifeTime() {
        return (Integer)this.field_70180_af.func_187225_a(LIFE_TIME);
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("lifeTime", this.getLifeTime());
        compound.func_74774_a("shake", (byte)this.throwableShake);
        if ((this.throwerName == null || this.throwerName.isEmpty()) && this.thrower instanceof EntityPlayer) {
            this.throwerName = this.thrower.func_70005_c_();
        }
        compound.func_74778_a("ownerName", this.throwerName == null ? "" : this.throwerName);
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.setLifeTime(compound.func_74762_e("lifeTime"));
        this.throwableShake = compound.func_74771_c("shake") & 0xFF;
        this.thrower = null;
        this.throwerName = compound.func_74779_i("ownerName");
        if (this.throwerName != null && this.throwerName.isEmpty()) {
            this.throwerName = null;
        }
        this.thrower = this.getThrower();
    }

    @Nullable
    public EntityLivingBase getThrower() {
        if (this.thrower == null && this.throwerName != null && !this.throwerName.isEmpty()) {
            this.thrower = this.field_70170_p.func_72924_a(this.throwerName);
            if (this.thrower == null && this.field_70170_p instanceof WorldServer) {
                try {
                    Entity entity = ((WorldServer)this.field_70170_p).func_175733_a(UUID.fromString(this.throwerName));
                    if (entity instanceof EntityLivingBase) {
                        this.thrower = (EntityLivingBase)entity;
                    }
                }
                catch (Throwable var2) {
                    this.thrower = null;
                }
            }
        }
        return this.thrower;
    }
}

