/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.network;

import arekkuusu.enderskills.common.EnderSkills;
import arekkuusu.enderskills.common.network.IPacketHandler;
import arekkuusu.enderskills.common.network.PacketHandler;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ClientToServerPacket
implements IMessage {
    private NBTTagCompound data;
    private IPacketHandler handler;

    public ClientToServerPacket() {
    }

    public ClientToServerPacket(IPacketHandler handler, NBTTagCompound data) {
        this.handler = handler;
        this.data = data;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer beef = new PacketBuffer(buf);
        try {
            this.handler = PacketHandler.HANDLERS.get(buf.readInt());
            this.data = beef.func_150793_b();
        }
        catch (Exception e) {
            EnderSkills.LOG.error("[Packet] Failed to receive packet");
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer beef = new PacketBuffer(buf);
        try {
            buf.writeInt(PacketHandler.HANDLERS.indexOf(this.handler));
            beef.func_150786_a(this.data);
        }
        catch (Exception e) {
            EnderSkills.LOG.error("[Packet] Failed to send packet");
            e.printStackTrace();
        }
    }

    public static class Handler
    implements IMessageHandler<ClientToServerPacket, IMessage> {
        @Nullable
        public IMessage onMessage(ClientToServerPacket message, MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.func_184102_h().func_152344_a(() -> {
                if (message.data != null && message.handler != null) {
                    message.handler.handleData(message.data, ctx);
                }
            });
            return null;
        }
    }
}

