/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.network;

import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.api.capability.data.SkillData;
import arekkuusu.enderskills.api.capability.data.SkillHolder;
import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.api.util.Vector;
import arekkuusu.enderskills.common.CommonConfig;
import arekkuusu.enderskills.common.network.ClientToServerPacket;
import arekkuusu.enderskills.common.network.PacketHandler;
import arekkuusu.enderskills.common.network.ServerToClientPacket;
import arekkuusu.enderskills.common.skill.IConfigSync;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;

public final class PacketHelper {
    public static void sendConfigReload(EntityPlayerMP player) {
        IForgeRegistry registry = GameRegistry.findRegistry(Skill.class);
        for (Map.Entry entry : registry.getEntries()) {
            if (!(entry.getValue() instanceof IConfigSync)) continue;
            PacketHelper.sendConfigPacket(player, (Skill)((Object)((IConfigSync)((Object)((Skill)((Object)entry.getValue()))))));
        }
        PacketHelper.sendGlobalConfigPacket(player);
    }

    private static void sendGlobalConfigPacket(EntityPlayerMP player) {
        NBTTagCompound compound = new NBTTagCompound();
        CommonConfig.writeSyncConfig(compound);
        PacketHandler.NETWORK.sendTo((IMessage)new ServerToClientPacket(PacketHandler.SYNC_GLOBAL_CONFIG, compound), player);
    }

    private static <T extends Skill> void sendConfigPacket(EntityPlayerMP player, T skill) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTHelper.setResourceLocation(compound, "location", Objects.requireNonNull(skill.getRegistryName()));
        ((IConfigSync)((Object)skill)).writeSyncConfig(compound);
        PacketHandler.NETWORK.sendTo((IMessage)new ServerToClientPacket(PacketHandler.SYNC_SKILLS_CONFIG, compound), player);
    }

    public static void sendSkillsSync(EntityPlayerMP player) {
        Capabilities.get((Entity)player).ifPresent(s -> PacketHandler.NETWORK.sendTo((IMessage)new ServerToClientPacket(PacketHandler.SYNC_SKILLS, s.serializeNBT()), player));
    }

    public static void sendSkillSync(EntityPlayerMP player, Skill skill) {
        Capabilities.get((Entity)player).flatMap(s -> s.getOwned(skill)).ifPresent(info -> {
            NBTTagCompound compound = new NBTTagCompound();
            NBTHelper.setResourceLocation(compound, "location", Objects.requireNonNull(skill.getRegistryName()));
            NBTHelper.setNBT(compound, "info", info.serializeNBT());
            PacketHandler.NETWORK.sendTo((IMessage)new ServerToClientPacket(PacketHandler.SYNC_SKILL, compound), player);
        });
    }

    public static void sendWeightSync(EntityPlayerMP player) {
        Capabilities.weight((Entity)player).ifPresent(s -> PacketHandler.NETWORK.sendTo((IMessage)new ServerToClientPacket(PacketHandler.SYNC_WEIGHT, s.serializeNBT()), player));
    }

    public static void sendWeightSetPacket(EntityPlayerMP player, Skill skill, int weight) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTHelper.setResourceLocation(compound, "location", Objects.requireNonNull(skill.getRegistryName()));
        NBTHelper.setInteger(compound, "weight", weight);
        PacketHandler.NETWORK.sendTo((IMessage)new ServerToClientPacket(PacketHandler.SYNC_WEIGHT, compound), player);
    }

    public static void sendWeightRemovePacket(EntityPlayerMP player, Skill skill) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTHelper.setResourceLocation(compound, "location", Objects.requireNonNull(skill.getRegistryName()));
        PacketHandler.NETWORK.sendTo((IMessage)new ServerToClientPacket(PacketHandler.SYNC_WEIGHT, compound), player);
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendSkillUpgradeRequestPacket(EntityPlayerSP entity, Skill skill) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTHelper.setResourceLocation(compound, "location", Objects.requireNonNull(skill.getRegistryName()));
        NBTHelper.setEntity(compound, (Entity)entity, "owner");
        PacketHandler.NETWORK.sendToServer((IMessage)new ClientToServerPacket(PacketHandler.SKILL_UPGRADE_REQUEST, compound));
    }

    public static void sendSkillUpgradeSync(EntityPlayerMP player) {
        PacketHandler.NETWORK.sendTo((IMessage)new ServerToClientPacket(PacketHandler.SKILL_UPGRADE_SYNC, new NBTTagCompound()), player);
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendSkillUseRequestPacket(EntityPlayerSP entity, Skill skill) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTHelper.setResourceLocation(compound, "location", Objects.requireNonNull(skill.getRegistryName()));
        NBTHelper.setEntity(compound, (Entity)entity, "owner");
        PacketHandler.NETWORK.sendToServer((IMessage)new ClientToServerPacket(PacketHandler.SKILL_USE_REQUEST, compound));
    }

    public static void sendSkillUseResponsePacket(EntityLivingBase entity, SkillData data) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTHelper.setInteger(compound, "uuid", entity.func_145782_y());
        NBTHelper.setWorld(compound, "world", entity.func_130014_f_());
        NBTHelper.setNBT(compound, "data", data.serializeNBT());
        PacketHandler.NETWORK.sendToAllAround((IMessage)new ServerToClientPacket(PacketHandler.SKILL_USE_RESPONSE, compound), PacketHelper.fromEntity((Entity)entity, 69));
    }

    public static void sendSkillHolderUseResponsePacket(EntityLivingBase entity, SkillHolder holder) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTHelper.setInteger(compound, "uuid", entity.func_145782_y());
        NBTHelper.setWorld(compound, "world", entity.func_130014_f_());
        NBTHelper.setNBT(compound, "holder", holder.serializeNBT());
        PacketHandler.NETWORK.sendToAllAround((IMessage)new ServerToClientPacket(PacketHandler.SKILL_HOLDER_USE_RESPONSE, compound), PacketHelper.fromEntity((Entity)entity, 69));
    }

    public static void sendSkillRemoveResponsePacket(EntityLivingBase entity, Skill skill) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTHelper.setResourceLocation(compound, "location", Objects.requireNonNull(skill.getRegistryName()));
        NBTHelper.setInteger(compound, "uuid", entity.func_145782_y());
        NBTHelper.setWorld(compound, "world", entity.func_130014_f_());
        PacketHandler.NETWORK.sendToAllAround((IMessage)new ServerToClientPacket(PacketHandler.SKILL_REMOVE_RESPONSE, compound), PacketHelper.fromEntity((Entity)entity, 69));
    }

    public static void sendSkillDataRemoveResponsePacket(EntityLivingBase entity, SkillData data) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTHelper.setResourceLocation(compound, "location", Objects.requireNonNull(data.skill.getRegistryName()));
        NBTHelper.setInteger(compound, "uuid", entity.func_145782_y());
        NBTHelper.setWorld(compound, "world", entity.func_130014_f_());
        NBTHelper.setNBT(compound, "data", data.serializeNBT());
        PacketHandler.NETWORK.sendToAllAround((IMessage)new ServerToClientPacket(PacketHandler.SKILL_DATA_REMOVE_RESPONSE, compound), PacketHelper.fromEntity((Entity)entity, 69));
    }

    public static void sendParticle(World world, Vec3d pos, Vec3d speed, float scale, int age, int rgb, ResourceLocation location) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTHelper.setWorld(compound, "world", world);
        NBTHelper.setVector(compound, "pos", pos);
        NBTHelper.setVector(compound, "speed", speed);
        NBTHelper.setFloat(compound, "scale", scale);
        NBTHelper.setInteger(compound, "age", age);
        NBTHelper.setInteger(compound, "rgb", rgb);
        NBTHelper.setResourceLocation(compound, "location", location);
        PacketHandler.NETWORK.sendToAllAround((IMessage)new ServerToClientPacket(PacketHandler.PARTICLE, compound), PacketHelper.fromWorldPos(world, new BlockPos(pos), 69));
    }

    public static void sendParticleLightning(World world, Vector from, Vector to, int generations, float offset, int age, int rgb, boolean branch) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTHelper.setWorld(compound, "world", world);
        NBTHelper.setVector(compound, "from", from.toVec3d());
        NBTHelper.setVector(compound, "to", to.toVec3d());
        NBTHelper.setInteger(compound, "generations", generations);
        NBTHelper.setFloat(compound, "offset", offset);
        NBTHelper.setInteger(compound, "age", age);
        NBTHelper.setInteger(compound, "rgb", rgb);
        NBTHelper.setBoolean(compound, "branch", branch);
        PacketHandler.NETWORK.sendToAllAround((IMessage)new ServerToClientPacket(PacketHandler.PARTICLE_LIGHTNING, compound), PacketHelper.fromWorldPos(world, new BlockPos(from.toVec3d()), 69));
    }

    public static void sendEnduranceSync(EntityPlayerMP player) {
        Capabilities.endurance((Entity)player).ifPresent(capability -> {
            NBTTagCompound compound = capability.serializeNBT();
            PacketHandler.NETWORK.sendTo((IMessage)new ServerToClientPacket(PacketHandler.SYNC_ENDURANCE, compound), player);
        });
    }

    public static void sendAdvancementSync(EntityPlayerMP player) {
        Capabilities.advancement((Entity)player).ifPresent(c -> {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("xp_advancement", (NBTBase)c.serializeNBT());
            compound.func_74768_a("lvl", player.field_71068_ca);
            compound.func_74776_a("lvl_progress", player.field_71106_cc);
            compound.func_74776_a("lvl_total", (float)player.field_71067_cb);
            PacketHandler.NETWORK.sendTo((IMessage)new ServerToClientPacket(PacketHandler.SYNC_ADVANCEMENT, compound), player);
        });
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendPinRequestPacket(EntityPlayerSP entity, int tabPin, int tabPagePin) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTHelper.setEntity(compound, (Entity)entity, "owner");
        compound.func_74768_a("tabPin", tabPin);
        compound.func_74768_a("tabPagePin", tabPagePin);
        PacketHandler.NETWORK.sendToServer((IMessage)new ClientToServerPacket(PacketHandler.GUI_PIN, compound));
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendDashUseRequestPacket(EntityPlayerSP entity, Vec3d vector) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTHelper.setEntity(compound, (Entity)entity, "owner");
        NBTHelper.setVector(compound, "vector", vector);
        PacketHandler.NETWORK.sendToServer((IMessage)new ClientToServerPacket(PacketHandler.USE_DASH_REQUEST, compound));
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendBlindedUseRequestPacket(EntityPlayerSP entity, SkillData data) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTHelper.setEntity(compound, (Entity)entity, "owner");
        NBTHelper.setNBT(compound, "data", data.serializeNBT());
        PacketHandler.NETWORK.sendToServer((IMessage)new ClientToServerPacket(PacketHandler.USE_BLINDED_REQUEST, compound));
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendWarpUseRequestPacket(EntityPlayerSP entity, Vec3d vector) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTHelper.setEntity(compound, (Entity)entity, "owner");
        NBTHelper.setVector(compound, "vector", vector);
        PacketHandler.NETWORK.sendToServer((IMessage)new ClientToServerPacket(PacketHandler.USE_WARP_REQUEST, compound));
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendResetSkillsRequestPacket(EntityPlayerSP entity) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTHelper.setEntity(compound, (Entity)entity, "owner");
        PacketHandler.NETWORK.sendToServer((IMessage)new ClientToServerPacket(PacketHandler.RESET_SKILLS_REQUEST, compound));
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendStoreXPRequestPacket(EntityPlayerSP entity) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTHelper.setEntity(compound, (Entity)entity, "owner");
        PacketHandler.NETWORK.sendToServer((IMessage)new ClientToServerPacket(PacketHandler.STORE_XP_REQUEST, compound));
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendTakeXPRequestPacket(EntityPlayerSP entity) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTHelper.setEntity(compound, (Entity)entity, "owner");
        PacketHandler.NETWORK.sendToServer((IMessage)new ClientToServerPacket(PacketHandler.TAKE_XP_REQUEST, compound));
    }

    public static void sendBleedSoundEffectResponsePacket(EntityLivingBase entity) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTHelper.setEntity(compound, (Entity)entity, "target");
        PacketHandler.NETWORK.sendToAllAround((IMessage)new ServerToClientPacket(PacketHandler.BLEED_SOUND_EFFECT_PLAY, compound), PacketHelper.fromEntity((Entity)entity, 69));
    }

    public static NetworkRegistry.TargetPoint fromWorldPos(World world, BlockPos pos, int range) {
        return new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)range);
    }

    public static NetworkRegistry.TargetPoint fromTileEntity(TileEntity te, int range) {
        return new NetworkRegistry.TargetPoint(te.func_145831_w().field_73011_w.getDimension(), (double)te.func_174877_v().func_177958_n(), (double)te.func_174877_v().func_177956_o(), (double)te.func_174877_v().func_177952_p(), (double)range);
    }

    public static NetworkRegistry.TargetPoint fromEntity(Entity entity, int range) {
        return new NetworkRegistry.TargetPoint(entity.field_70170_p.field_73011_w.getDimension(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (double)range);
    }
}

