/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.proxy;

import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.api.capability.data.SkillHolder;
import arekkuusu.enderskills.api.capability.data.SkillInfo;
import arekkuusu.enderskills.api.event.SkillActionableEvent;
import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.common.network.PacketHelper;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="enderskills")
public class Events {
    public static final Queue<Runnable> QUEUE = new LinkedList<Runnable>();

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            PacketHelper.sendConfigReload((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP) {
            PacketHelper.sendSkillsSync((EntityPlayerMP)event.getEntity());
            PacketHelper.sendEnduranceSync((EntityPlayerMP)event.getEntity());
            PacketHelper.sendAdvancementSync((EntityPlayerMP)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            if (!event.isEndConquered()) {
                player.func_70606_j(player.func_110138_aP());
            }
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        Capabilities.get(event.getEntity()).ifPresent(c -> {
            c.clearActive();
            c.getActives().forEach(h -> h.tick((EntityLivingBase)event.getEntity()));
            c.skillHolders.clear();
        });
    }

    @SubscribeEvent
    public static void onEntityDimensionChange(EntityTravelToDimensionEvent event) {
        Capabilities.get(event.getEntity()).ifPresent(c -> {
            c.clearActive();
            c.getActives().forEach(h -> h.tick((EntityLivingBase)event.getEntity()));
            c.skillHolders.clear();
        });
    }

    @SubscribeEvent
    public static void onPlayerDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        Capabilities.get((Entity)event.player).ifPresent(c -> {
            c.clearActive();
            c.getActives().forEach(h -> h.tick((EntityLivingBase)event.player));
            c.skillHolders.clear();
        });
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        EntityPlayer oldPlayer = event.getOriginal();
        EntityPlayer newPlayer = event.getEntityPlayer();
        if (oldPlayer instanceof EntityPlayerMP && newPlayer instanceof EntityPlayerMP) {
            if (event.isWasDeath()) {
                Capabilities.get((Entity)oldPlayer).ifPresent(original -> Capabilities.get((Entity)newPlayer).ifPresent(replacement -> replacement.deserializeNBT(original.serializeNBT())));
                Capabilities.advancement((Entity)oldPlayer).ifPresent(original -> Capabilities.advancement((Entity)newPlayer).ifPresent(replacement -> replacement.deserializeNBT(original.serializeNBT())));
                Capabilities.weight((Entity)oldPlayer).ifPresent(original -> Capabilities.weight((Entity)newPlayer).ifPresent(replacement -> replacement.deserializeNBT(original.serializeNBT())));
                Capabilities.powerBoost((Entity)oldPlayer).ifPresent(original -> Capabilities.powerBoost((Entity)newPlayer).ifPresent(replacement -> replacement.deserializeNBT(original.serializeNBT())));
            } else {
                Capabilities.get((Entity)oldPlayer).ifPresent(c -> {
                    c.clearActive();
                    c.getActives().forEach(h -> h.tick((EntityLivingBase)oldPlayer));
                    c.skillHolders.clear();
                });
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onNextTickExecute(TickEvent.ServerTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.START) {
            Runnable runnable;
            while ((runnable = QUEUE.poll()) != null) {
                try {
                    runnable.run();
                }
                catch (ConcurrentModificationException concurrentModificationException) {}
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityTickActive(LivingEvent.LivingUpdateEvent event) {
        if (!event.getEntityLiving().func_130014_f_().field_72995_K) {
            EntityLivingBase entity = event.getEntityLiving();
            Capabilities.get((Entity)entity).ifPresent(skills -> {
                Iterator<SkillHolder> iterator = skills.getActives().iterator();
                while (iterator.hasNext()) {
                    SkillHolder holder = iterator.next();
                    holder.tick(entity);
                    if (!holder.isDead()) continue;
                    iterator.remove();
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityTickCooldown(LivingEvent.LivingUpdateEvent event) {
        if (!event.getEntityLiving().func_130014_f_().field_72995_K) {
            EntityLivingBase entity = event.getEntityLiving();
            Capabilities.get((Entity)entity).ifPresent(skills -> {
                for (Map.Entry<Skill, SkillInfo> entry : skills.getAllOwned().entrySet()) {
                    SkillInfo skillInfo = entry.getValue();
                    if (!(skillInfo instanceof SkillInfo.IInfoCooldown) || !((SkillInfo.IInfoCooldown)((Object)skillInfo)).hasCooldown()) continue;
                    ((SkillInfo.IInfoCooldown)((Object)skillInfo)).setCooldown(((SkillInfo.IInfoCooldown)((Object)skillInfo)).getCooldown() - 1);
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onSkillActionable(SkillActionableEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer && ((EntityPlayer)event.getEntityLiving()).func_175149_v()) {
            event.setCanceled(true);
        }
    }
}

