/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.skill.ability;

import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.api.capability.data.SkillData;
import arekkuusu.enderskills.api.capability.data.SkillInfo;
import arekkuusu.enderskills.api.event.SkillActionableEvent;
import arekkuusu.enderskills.api.event.SkillActivateEvent;
import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.client.gui.data.ISkillAdvancement;
import arekkuusu.enderskills.common.skill.BaseSkill;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.ability.AbilityInfo;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class BaseAbility
extends BaseSkill {
    public static final String DAMAGE_HIT_TYPE = "skill";
    public static final String DAMAGE_DOT_TYPE = "indirectSkill";

    public BaseAbility(String id, Skill.Properties properties) {
        super(properties.setHasStatusIcon().setKeyBound().setHasTexture());
        ModAbilities.setRegistry(this, id);
    }

    @Override
    public void begin(EntityLivingBase entity, SkillData data) {
        this.update(entity, data, 0);
    }

    @Override
    public boolean canUpgrade(EntityLivingBase entity) {
        return Capabilities.advancement((Entity)entity).map(c -> {
            ISkillAdvancement.Requirement requirement = this.getRequirement(entity);
            int tokens = requirement.getLevels();
            int xp = requirement.getXp();
            return c.level >= tokens && c.getExperienceTotal(entity) >= xp;
        }).orElse(false);
    }

    @Override
    public void onUpgrade(EntityLivingBase entity) {
        Capabilities.advancement((Entity)entity).ifPresent(c -> {
            ISkillAdvancement.Requirement requirement = this.getRequirement(entity);
            int tokens = requirement.getLevels();
            int xp = requirement.getXp();
            if (c.level >= tokens && c.getExperienceTotal(entity) >= xp) {
                c.consumeExperienceFromTotal(entity, xp);
            }
        });
    }

    @Override
    public ISkillAdvancement.Requirement getRequirement(EntityLivingBase entity) {
        AbilityInfo info = Capabilities.get((Entity)entity).flatMap(a -> a.getOwned(this)).orElse(null);
        int tokensNeeded = 0;
        if (info == null) {
            int abilities = Capabilities.get((Entity)entity).map(c -> (int)c.getAllOwned().keySet().stream().filter(s -> s instanceof BaseAbility).count()).orElse(0);
            tokensNeeded = abilities > 0 ? abilities + 1 : 1;
        }
        int xpNeeded = this.getUpgradeCost(info);
        return new ISkillAdvancement.DefaultRequirement(tokensNeeded, this.getCostIncrement(entity, xpNeeded));
    }

    public abstract int getCostIncrement(EntityLivingBase var1, int var2);

    public abstract int getUpgradeCost(@Nullable AbilityInfo var1);

    public boolean isActionable(EntityLivingBase entity) {
        SkillActionableEvent event = new SkillActionableEvent(entity, this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    public boolean canActivate(EntityLivingBase entity) {
        SkillActivateEvent event = new SkillActivateEvent(entity, this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    public boolean isClientWorld(EntityLivingBase entity) {
        return entity.func_130014_f_().field_72995_K;
    }

    @Override
    @Nonnull
    public SkillInfo createInfo(NBTTagCompound compound) {
        return new AbilityInfo(compound);
    }

    public static class AbilityProperties
    extends BaseSkill.BaseProperties {
        public Function<AbilityInfo, Integer> cooldownFunction;

        public AbilityProperties setCooldownGetter(Function<AbilityInfo, Integer> cooldownFunction) {
            this.cooldownFunction = cooldownFunction;
            return this;
        }

        public int getCooldown(AbilityInfo abilityInfo) {
            return this.cooldownFunction.apply(abilityInfo);
        }
    }
}

