/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.skill.ability.defense.earth;

import arekkuusu.enderskills.api.capability.AdvancementCapability;
import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.api.capability.data.SkillData;
import arekkuusu.enderskills.api.capability.data.SkillInfo;
import arekkuusu.enderskills.api.capability.data.nbt.WatcherManager;
import arekkuusu.enderskills.api.helper.ExpressionHelper;
import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.api.helper.RayTraceHelper;
import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.client.util.helper.TextHelper;
import arekkuusu.enderskills.common.CommonConfig;
import arekkuusu.enderskills.common.entity.EntityStoneGolem;
import arekkuusu.enderskills.common.entity.data.IImpact;
import arekkuusu.enderskills.common.entity.throwable.EntityThrowableData;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.ModAttributes;
import arekkuusu.enderskills.common.skill.ModEffects;
import arekkuusu.enderskills.common.skill.SkillHelper;
import arekkuusu.enderskills.common.skill.ability.AbilityInfo;
import arekkuusu.enderskills.common.skill.ability.BaseAbility;
import arekkuusu.enderskills.common.sound.ModSounds;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AnimatedStoneGolem
extends BaseAbility
implements IImpact {
    public AnimatedStoneGolem() {
        super("animated_stone_golem", new BaseAbility.AbilityProperties());
        ((BaseAbility.AbilityProperties)this.getProperties()).setCooldownGetter(this::getCooldown).setMaxLevelGetter(this::getMaxLevel);
    }

    @Override
    public void use(EntityLivingBase owner, SkillInfo skillInfo) {
        if (this.isClientWorld(owner) || !this.isActionable(owner)) {
            return;
        }
        AbilityInfo abilityInfo = (AbilityInfo)skillInfo;
        if (!SkillHelper.isActiveFrom((Entity)owner, this)) {
            RayTraceHelper.getFloorLookedAt((Entity)owner, 5.0, 5.0).ifPresent(pos -> {
                pos = pos.func_177984_a();
                if (!((SkillInfo.IInfoCooldown)((Object)skillInfo)).hasCooldown() && this.isActionable(owner) && this.canActivate(owner)) {
                    if (!(owner instanceof EntityPlayer) || !((EntityPlayer)owner).field_71075_bZ.field_75098_d) {
                        abilityInfo.setCooldown(this.getCooldown(abilityInfo));
                    }
                    EntityStoneGolem golem = new EntityStoneGolem(owner.field_70170_p);
                    int stunTime = this.getStunTime(abilityInfo);
                    SkillData status = SkillData.of(ModEffects.STUNNED).by((Entity)owner).with(stunTime).overrides(SkillData.Overrides.EQUAL).create();
                    golem.setData(status);
                    golem.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.01, (double)pos.func_177952_p() + 0.5);
                    golem.setOwnerId(owner.func_110124_au());
                    golem.setMaxHealth(this.getHealth(abilityInfo));
                    golem.func_70606_j(this.getHealth(abilityInfo));
                    golem.setMirrorDamage(this.getMirror(abilityInfo));
                    golem.setDamage(this.getDamage(abilityInfo));
                    owner.field_70170_p.func_72838_d((Entity)golem);
                    int time = this.getTime(abilityInfo);
                    NBTTagCompound compound = new NBTTagCompound();
                    NBTHelper.setEntity(compound, (Entity)owner, "owner");
                    NBTHelper.setEntity(compound, (Entity)golem, "golem");
                    SkillData data = SkillData.of(this).by((Entity)owner).with(time).put(compound, new WatcherManager.Watcher[0]).overrides(SkillData.Overrides.EQUAL).create();
                    EntityThrowableData.throwFor(owner, 5.0, SkillData.of(this).create(), false);
                    this.apply(owner, data);
                    this.sync(owner, data);
                    this.sync(owner);
                    if (owner.field_70170_p instanceof WorldServer) {
                        ((WorldServer)owner.field_70170_p).func_184148_a(null, owner.field_70165_t, owner.field_70163_u, owner.field_70161_v, ModSounds.ANIMATED_STONE, SoundCategory.PLAYERS, 5.0f, (1.0f + (owner.field_70170_p.field_73012_v.nextFloat() - owner.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                    }
                }
            });
        } else {
            SkillHelper.getActiveFrom((Entity)owner, this).ifPresent(data -> Optional.ofNullable(NBTHelper.getEntity(EntityStoneGolem.class, data.nbt, "golem")).ifPresent(e -> {
                e.teleportTo((Entity)owner);
                e.func_70604_c(null);
                e.func_70624_b(null);
                owner.func_130011_c(null);
            }));
        }
    }

    @Override
    public void onImpact(Entity source, @Nullable EntityLivingBase owner, SkillData skillData, RayTraceResult trace) {
    }

    @Override
    public void update(EntityLivingBase owner, SkillData data, int tick) {
        if (this.isClientWorld(owner)) {
            return;
        }
        if (NBTHelper.getEntity(EntityStoneGolem.class, data.nbt, "golem") == null) {
            this.unapply(owner, data);
            this.async(owner, data);
        }
    }

    public int getLevel(SkillInfo.IInfoUpgradeable info) {
        return info.getLevel();
    }

    public int getMaxLevel() {
        return Configuration.getSyncValues().maxLevel;
    }

    public float getDamage(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().extra.damage, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.extra.globalPositiveEffect;
        return (float)(result * this.getEffectiveness());
    }

    public float getMirror(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().extra.mirror, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.extra.globalPositiveEffect;
        return (float)(result * this.getEffectiveness());
    }

    public float getHealth(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().extra.health, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.extra.globalNegativeEffect;
        return (float)(result * this.getEffectiveness());
    }

    public int getStunTime(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().extra.health, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalTime;
        return (int)(result * this.getEffectiveness());
    }

    public int getCooldown(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().cooldown, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalCooldown;
        return (int)(result * this.getEffectiveness());
    }

    public int getTime(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().time, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalTime;
        return (int)(result * this.getEffectiveness());
    }

    public double getEffectiveness() {
        return Configuration.getSyncValues().effectiveness * CommonConfig.getSyncValues().skill.globalEffectiveness;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDescription(List<String> description) {
        Capabilities.get((Entity)Minecraft.func_71410_x().field_71439_g).ifPresent(c -> {
            if (c.isOwned(this)) {
                if (!GuiScreen.func_146272_n()) {
                    description.add("");
                    description.add("Hold SHIFT for stats.");
                } else {
                    c.getOwned(this).ifPresent(skillInfo -> {
                        AbilityInfo abilityInfo = (AbilityInfo)skillInfo;
                        description.clear();
                        description.add("Endurance Drain: " + ModAttributes.ENDURANCE.getEnduranceDrain(this));
                        description.add("");
                        if (abilityInfo.getLevel() >= this.getMaxLevel()) {
                            description.add("Max Level:");
                        } else {
                            description.add("Current Level:");
                        }
                        description.add("Cooldown: " + TextHelper.format2FloatPoint((double)this.getCooldown(abilityInfo) / 20.0) + "s");
                        description.add("Duration: " + TextHelper.format2FloatPoint((double)this.getTime(abilityInfo) / 20.0) + "s");
                        description.add("Mirror Damage: +" + TextHelper.format2FloatPoint((double)this.getMirror(abilityInfo) * 100.0) + "%");
                        description.add("Stun Duration: " + TextHelper.format2FloatPoint((double)this.getStunTime(abilityInfo) / 20.0) + "s");
                        description.add("Golem Health: " + TextHelper.format2FloatPoint((double)this.getHealth(abilityInfo) / 2.0) + " Hearts");
                        description.add("Golem Base Damage: " + TextHelper.format2FloatPoint((double)this.getDamage(abilityInfo) / 2.0) + " Hearts");
                        if (abilityInfo.getLevel() < this.getMaxLevel()) {
                            AbilityInfo infoNew = new AbilityInfo(abilityInfo.serializeNBT());
                            infoNew.setLevel(infoNew.getLevel() + 1);
                            description.add("");
                            description.add("Next Level:");
                            description.add("Cooldown: " + TextHelper.format2FloatPoint((double)this.getCooldown(infoNew) / 20.0) + "s");
                            description.add("Duration: " + TextHelper.format2FloatPoint((double)this.getTime(infoNew) / 20.0) + "s");
                            description.add("Mirror Damage: +" + TextHelper.format2FloatPoint((double)this.getMirror(infoNew) * 100.0) + "%");
                            description.add("Stun Duration: " + TextHelper.format2FloatPoint((double)this.getStunTime(infoNew) / 20.0) + "s");
                            description.add("Golem Health: " + TextHelper.format2FloatPoint((double)this.getHealth(infoNew) / 2.0) + " Hearts");
                            description.add("Golem Base Damage: " + TextHelper.format2FloatPoint((double)this.getDamage(infoNew) / 2.0) + " Hearts");
                        }
                    });
                }
            }
        });
    }

    @Override
    public int getCostIncrement(EntityLivingBase entity, int total) {
        Optional<AdvancementCapability> optional = Capabilities.advancement((Entity)entity);
        if (optional.isPresent()) {
            AdvancementCapability advancement = optional.get();
            List<Skill> skillUnlockOrder = Arrays.asList(advancement.skillUnlockOrder);
            int index = skillUnlockOrder.indexOf((Object)ModAbilities.TAUNT);
            if (index == -1) {
                index = advancement.skillUnlockOrder.length;
            }
            return (int)((double)total * (1.0 + (double)index * CommonConfig.getSyncValues().advancement.xp.costIncrement));
        }
        return total;
    }

    @Override
    public int getUpgradeCost(@Nullable AbilityInfo info) {
        int level = info != null ? this.getLevel(info) + 1 : 0;
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().advancement.upgrade, level, levelMax);
        return (int)(func * CommonConfig.getSyncValues().advancement.xp.globalCostMultiplier);
    }

    @Override
    public void initSyncConfig() {
        Configuration.getSyncValues().maxLevel = Configuration.getValues().maxLevel;
        Configuration.getSyncValues().cooldown = Configuration.getValues().cooldown;
        Configuration.getSyncValues().time = Configuration.getValues().time;
        Configuration.getSyncValues().effectiveness = Configuration.getValues().effectiveness;
        Configuration.getSyncValues().extra.damage = Configuration.getValues().extra.damage;
        Configuration.getSyncValues().extra.mirror = Configuration.getValues().extra.mirror;
        Configuration.getSyncValues().extra.stunTime = Configuration.getValues().extra.stunTime;
        Configuration.getSyncValues().extra.health = Configuration.getValues().extra.health;
        Configuration.getSyncValues().advancement.upgrade = Configuration.getValues().advancement.upgrade;
    }

    @Override
    public void writeSyncConfig(NBTTagCompound compound) {
        compound.func_74768_a("maxLevel", Configuration.getValues().maxLevel);
        NBTHelper.setArray(compound, "cooldown", Configuration.getValues().cooldown);
        NBTHelper.setArray(compound, "time", Configuration.getValues().time);
        compound.func_74780_a("effectiveness", Configuration.getValues().effectiveness);
        NBTHelper.setArray(compound, "extra.damage", Configuration.getValues().extra.damage);
        NBTHelper.setArray(compound, "extra.mirror", Configuration.getValues().extra.mirror);
        NBTHelper.setArray(compound, "extra.stunTime", Configuration.getValues().extra.stunTime);
        NBTHelper.setArray(compound, "extra.health", Configuration.getValues().extra.health);
        NBTHelper.setArray(compound, "advancement.upgrade", Configuration.getValues().advancement.upgrade);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readSyncConfig(NBTTagCompound compound) {
        Configuration.getSyncValues().maxLevel = compound.func_74762_e("maxLevel");
        Configuration.getSyncValues().cooldown = NBTHelper.getArray(compound, "cooldown");
        Configuration.getSyncValues().time = NBTHelper.getArray(compound, "time");
        Configuration.getSyncValues().effectiveness = compound.func_74769_h("effectiveness");
        Configuration.getSyncValues().extra.damage = NBTHelper.getArray(compound, "extra.damage");
        Configuration.getSyncValues().extra.mirror = NBTHelper.getArray(compound, "extra.mirror");
        Configuration.getSyncValues().extra.stunTime = NBTHelper.getArray(compound, "extra.stunTime");
        Configuration.getSyncValues().extra.health = NBTHelper.getArray(compound, "extra.health");
        Configuration.getSyncValues().advancement.upgrade = NBTHelper.getArray(compound, "advancement.upgrade");
    }

    @Config(modid="enderskills", name="enderskills/Ability/animated_stone_golem")
    public static class Configuration {
        @Config.Comment(value={"Ability Values"})
        @Config.LangKey(value="enderskills.config.animated_stone_golem")
        public static Values CONFIG = new Values();
        @Config.Ignore
        protected static Values CONFIG_SYNC = new Values();

        public static Values getValues() {
            return CONFIG;
        }

        public static Values getSyncValues() {
            return CONFIG_SYNC;
        }

        public static class Values {
            @Config.Comment(value={"Skill specific extra Configuration"})
            public final Extra extra = new Extra();
            @Config.Comment(value={"Skill specific Advancement Configuration"})
            public final Advancement advancement = new Advancement();
            @Config.Comment(value={"Max level obtainable"})
            @Config.RangeInt(min=0)
            public int maxLevel = 50;
            @Config.Comment(value={"Cooldown Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] cooldown = new String[]{"(0+){105 * 20 + 15 * 20 * (1 - ((1 - (e^(-2.1 * (x/24)))) / (1 - e^(-2.1))))}", "(25+){100 * 20 + 5 * 20 * (1- (((e^(0.1 * ((x-24) / (y-24))) - 1)/((e^0.1) - 1))))}", "(50){90 * 20}"};
            @Config.Comment(value={"Duration Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] time = new String[]{"(0+){45 * 20 + 25 * 20 * (1 - (e^(-2.1 * (x/24)))) / (1 - e^(-2.1))}", "(25+){70 * 20 + 10 * 20 * ((e^(0.1 * ((x - 24) / (y - 24))) - 1)/((e^0.1) - 1))}", "(50){90 * 20}"};
            @Config.Comment(value={"Effectiveness Modifier"})
            @Config.RangeDouble
            public double effectiveness = 1.0;

            public static class Advancement {
                @Config.Comment(value={"Function f(x)=? where 'x' is [Next Level] and 'y' is [Max Level], XP Cost is in units [NOT LEVELS]"})
                public String[] upgrade = new String[]{"(0){900}", "(1+){4 * x}", "(50){4 * x + 4 * x * 0.1}"};
            }

            public static class Extra {
                @Config.Comment(value={"Golem Damage Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
                public String[] damage = new String[]{"(0+){5 + ((e^(0.1 * (x / 49)) - 1)/((e^0.1) - 1)) * (6.44 - 5)}", "(25+){6.44 + ((e^(3.25 * ((x-24) / (y-24))) - 1)/((e^3.25) - 1)) * (22 - 6.44)}", "(50){25}"};
                @Config.Comment(value={"Golem Damage Multiplier Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
                public String[] mirror = new String[]{"(0+){0.75 + ((e^(2.1 * (x / y)) - 1)/((e^2.1) - 1)) * (1.5 - 0.75)}"};
                @Config.Comment(value={"Golem Health Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
                public String[] stunTime = new String[]{"(0+){3 * 20}"};
                @Config.Comment(value={"Golem Health Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
                public String[] health = new String[]{"(0+){150 + (100 * 0.1 * x)}"};
            }
        }
    }
}

