/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.skill.ability.defense.earth;

import arekkuusu.enderskills.api.capability.AdvancementCapability;
import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.api.capability.data.SkillData;
import arekkuusu.enderskills.api.capability.data.SkillInfo;
import arekkuusu.enderskills.api.capability.data.nbt.WatcherManager;
import arekkuusu.enderskills.api.event.SkillActionableEvent;
import arekkuusu.enderskills.api.helper.ExpressionHelper;
import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.client.gui.data.ISkillAdvancement;
import arekkuusu.enderskills.client.util.helper.TextHelper;
import arekkuusu.enderskills.common.CommonConfig;
import arekkuusu.enderskills.common.entity.data.IExpand;
import arekkuusu.enderskills.common.entity.data.IFindEntity;
import arekkuusu.enderskills.common.entity.data.IScanEntities;
import arekkuusu.enderskills.common.entity.placeable.EntityPlaceableData;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.ModAttributes;
import arekkuusu.enderskills.common.skill.ModEffects;
import arekkuusu.enderskills.common.skill.SkillHelper;
import arekkuusu.enderskills.common.skill.ability.AbilityInfo;
import arekkuusu.enderskills.common.skill.ability.BaseAbility;
import arekkuusu.enderskills.common.sound.ModSounds;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Taunt
extends BaseAbility
implements IScanEntities,
IExpand,
IFindEntity {
    public static final UUID TAUNT_UUID = UUID.fromString("c0fef459-78da-47df-8c6c-62c95c2f5609");

    public Taunt() {
        super("taunt", new BaseAbility.AbilityProperties());
        ((BaseAbility.AbilityProperties)this.getProperties()).setCooldownGetter(this::getCooldown).setMaxLevelGetter(this::getMaxLevel);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void use(EntityLivingBase owner, SkillInfo skillInfo) {
        if (((SkillInfo.IInfoCooldown)((Object)skillInfo)).hasCooldown() || this.isClientWorld(owner)) {
            return;
        }
        AbilityInfo abilityInfo = (AbilityInfo)skillInfo;
        if (this.isActionable(owner) && this.canActivate(owner)) {
            if (!(owner instanceof EntityPlayer) || !((EntityPlayer)owner).field_71075_bZ.field_75098_d) {
                abilityInfo.setCooldown(this.getCooldown(abilityInfo));
            }
            double range = this.getRange(abilityInfo);
            int time = this.getTime(abilityInfo);
            NBTTagCompound compound = new NBTTagCompound();
            NBTHelper.setEntity(compound, (Entity)owner, "owner");
            SkillData data = SkillData.of(this).by(TAUNT_UUID).with(time).put(compound, new WatcherManager.Watcher[0]).overrides(SkillData.Overrides.ID).create();
            EntityPlaceableData spawn = new EntityPlaceableData(owner.field_70170_p, owner, data, 10);
            spawn.func_70107_b(owner.field_70165_t, owner.field_70163_u + (double)(owner.field_70131_O / 2.0f), owner.field_70161_v);
            spawn.setRadius(range);
            owner.field_70170_p.func_72838_d((Entity)spawn);
            this.sync(owner);
            if (owner.field_70170_p instanceof WorldServer) {
                ((WorldServer)owner.field_70170_p).func_184148_a(null, owner.field_70165_t, owner.field_70163_u, owner.field_70161_v, ModSounds.TAUNT, SoundCategory.PLAYERS, 5.0f, (1.0f + (owner.field_70170_p.field_73012_v.nextFloat() - owner.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            }
        }
    }

    @Override
    public void onFound(Entity source, @Nullable EntityLivingBase owner, EntityLivingBase target, SkillData skillData) {
        this.apply(target, skillData);
        this.sync(target, skillData);
    }

    @Override
    public void update(EntityLivingBase target, SkillData data, int tick) {
        if (this.isClientWorld(target) && !(target instanceof EntityPlayer)) {
            return;
        }
        if (this.isStunnedByAbility(target)) {
            return;
        }
        Optional.ofNullable(SkillHelper.getOwner(data)).ifPresent(owner -> {
            if (target instanceof EntityLiving) {
                ((EntityLiving)target).func_70661_as().func_75499_g();
                if (((EntityLiving)target).func_70638_az() != owner) {
                    ((EntityLiving)target).func_70624_b(owner);
                }
            }
            if (target.field_70123_F && target.field_70122_E) {
                target.field_70181_x = 0.4f;
            }
            target.field_70159_w += (Math.signum(owner.field_70165_t - target.field_70165_t) * 0.5 - target.field_70159_w) * 0.100000000372529;
            target.field_70179_y += (Math.signum(owner.field_70161_v - target.field_70161_v) * 0.5 - target.field_70179_y) * 0.100000000372529;
            if (target.func_184218_aH()) {
                target.func_184210_p();
            }
        });
    }

    public boolean isStunnedByAbility(EntityLivingBase entity) {
        return Capabilities.get((Entity)entity).map(c -> c.isActive(ModEffects.STUNNED)).orElse(false);
    }

    @SubscribeEvent
    public void onSkillShouldUse(SkillActionableEvent event) {
        if (this.isClientWorld(event.getEntityLiving())) {
            return;
        }
        if (SkillHelper.isActive((Entity)event.getEntityLiving(), this)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void inputListener(InputUpdateEvent event) {
        if (SkillHelper.isActive((Entity)event.getEntityLiving(), this)) {
            event.getMovementInput().field_187255_c = false;
            event.getMovementInput().field_187258_f = false;
            event.getMovementInput().field_187256_d = false;
            event.getMovementInput().field_187257_e = false;
            event.getMovementInput().field_78899_d = false;
            event.getMovementInput().field_78901_c = false;
            event.getMovementInput().field_192832_b = 0.0f;
            event.getMovementInput().field_78902_a = 0.0f;
        }
    }

    public int getLevel(SkillInfo.IInfoUpgradeable info) {
        return info.getLevel();
    }

    public int getMaxLevel() {
        return Configuration.getSyncValues().maxLevel;
    }

    public double getRange(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().range, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalRange;
        return result * this.getEffectiveness();
    }

    public int getCooldown(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().cooldown, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalCooldown;
        return (int)(result * this.getEffectiveness());
    }

    public int getTime(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().time, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalTime;
        return (int)(result * this.getEffectiveness());
    }

    public double getEffectiveness() {
        return Configuration.getSyncValues().effectiveness * CommonConfig.getSyncValues().skill.globalEffectiveness;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDescription(List<String> description) {
        Capabilities.get((Entity)Minecraft.func_71410_x().field_71439_g).ifPresent(c -> {
            if (c.isOwned(this)) {
                if (!GuiScreen.func_146272_n()) {
                    description.add("");
                    description.add("Hold SHIFT for stats.");
                } else {
                    c.getOwned(this).ifPresent(skillInfo -> {
                        AbilityInfo abilityInfo = (AbilityInfo)skillInfo;
                        description.clear();
                        description.add("Endurance Drain: " + ModAttributes.ENDURANCE.getEnduranceDrain(this));
                        description.add("");
                        if (abilityInfo.getLevel() >= this.getMaxLevel()) {
                            description.add("Max Level:");
                        } else {
                            description.add("Current Level:");
                        }
                        description.add("Cooldown: " + TextHelper.format2FloatPoint((double)this.getCooldown(abilityInfo) / 20.0) + "s");
                        description.add("Range: " + TextHelper.format2FloatPoint(this.getRange(abilityInfo)) + " Blocks");
                        description.add("Duration: " + TextHelper.format2FloatPoint((double)this.getTime(abilityInfo) / 20.0) + "s");
                        if (abilityInfo.getLevel() < this.getMaxLevel()) {
                            AbilityInfo infoNew = new AbilityInfo(abilityInfo.serializeNBT());
                            infoNew.setLevel(infoNew.getLevel() + 1);
                            description.add("");
                            description.add("Next Level:");
                            description.add("Cooldown: " + TextHelper.format2FloatPoint((double)this.getCooldown(infoNew) / 20.0) + "s");
                            description.add("Range: " + TextHelper.format2FloatPoint(this.getRange(infoNew)) + " Blocks");
                            description.add("Duration: " + TextHelper.format2FloatPoint((double)this.getTime(infoNew) / 20.0) + "s");
                        }
                    });
                }
            }
        });
    }

    @Override
    public void onUpgrade(EntityLivingBase entity) {
        Capabilities.advancement((Entity)entity).ifPresent(c -> {
            ISkillAdvancement.Requirement requirement = this.getRequirement(entity);
            int tokens = requirement.getLevels();
            int xp = requirement.getXp();
            if (c.level >= tokens && c.getExperienceTotal(entity) >= xp) {
                Capabilities.get((Entity)entity).filter(a -> !a.isOwned(this)).ifPresent(a -> {
                    Skill[] skillUnlockOrder = Arrays.copyOf(c.skillUnlockOrder, c.skillUnlockOrder.length + 1);
                    skillUnlockOrder[skillUnlockOrder.length - 1] = this;
                    c.skillUnlockOrder = skillUnlockOrder;
                });
                c.consumeExperienceFromTotal(entity, xp);
            }
        });
    }

    @Override
    public int getCostIncrement(EntityLivingBase entity, int total) {
        Optional<AdvancementCapability> optional = Capabilities.advancement((Entity)entity);
        if (optional.isPresent()) {
            AdvancementCapability advancement = optional.get();
            List<Skill> skillUnlockOrder = Arrays.asList(advancement.skillUnlockOrder);
            int index = skillUnlockOrder.indexOf((Object)ModAbilities.TAUNT);
            if (index == -1) {
                index = advancement.skillUnlockOrder.length;
            }
            return (int)((double)total * (1.0 + (double)index * CommonConfig.getSyncValues().advancement.xp.costIncrement));
        }
        return total;
    }

    @Override
    public int getUpgradeCost(@Nullable AbilityInfo info) {
        int level = info != null ? this.getLevel(info) + 1 : 0;
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().advancement.upgrade, level, levelMax);
        return (int)(func * CommonConfig.getSyncValues().advancement.xp.globalCostMultiplier);
    }

    @Override
    public void initSyncConfig() {
        Configuration.getSyncValues().maxLevel = Configuration.getValues().maxLevel;
        Configuration.getSyncValues().cooldown = Configuration.getValues().cooldown;
        Configuration.getSyncValues().time = Configuration.getValues().time;
        Configuration.getSyncValues().range = Configuration.getValues().range;
        Configuration.getSyncValues().effectiveness = Configuration.getValues().effectiveness;
        Configuration.getSyncValues().advancement.upgrade = Configuration.getValues().advancement.upgrade;
    }

    @Override
    public void writeSyncConfig(NBTTagCompound compound) {
        compound.func_74768_a("maxLevel", Configuration.getValues().maxLevel);
        NBTHelper.setArray(compound, "cooldown", Configuration.getValues().cooldown);
        NBTHelper.setArray(compound, "time", Configuration.getValues().time);
        NBTHelper.setArray(compound, "range", Configuration.getValues().range);
        compound.func_74780_a("effectiveness", Configuration.getValues().effectiveness);
        NBTHelper.setArray(compound, "advancement.upgrade", Configuration.getValues().advancement.upgrade);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readSyncConfig(NBTTagCompound compound) {
        Configuration.getSyncValues().maxLevel = compound.func_74762_e("maxLevel");
        Configuration.getSyncValues().cooldown = NBTHelper.getArray(compound, "cooldown");
        Configuration.getSyncValues().time = NBTHelper.getArray(compound, "time");
        Configuration.getSyncValues().range = NBTHelper.getArray(compound, "range");
        Configuration.getSyncValues().effectiveness = compound.func_74769_h("effectiveness");
        Configuration.getSyncValues().advancement.upgrade = NBTHelper.getArray(compound, "advancement.upgrade");
    }

    @Config(modid="enderskills", name="enderskills/Ability/taunt")
    public static class Configuration {
        @Config.Comment(value={"Ability Values"})
        @Config.LangKey(value="enderskills.config.taunt")
        public static Values CONFIG = new Values();
        @Config.Ignore
        protected static Values CONFIG_SYNC = new Values();

        public static Values getValues() {
            return CONFIG;
        }

        public static Values getSyncValues() {
            return CONFIG_SYNC;
        }

        public static class Values {
            @Config.Comment(value={"Skill specific Advancement Configuration"})
            public final Advancement advancement = new Advancement();
            @Config.Comment(value={"Max level obtainable"})
            @Config.RangeInt(min=0)
            public int maxLevel = 50;
            @Config.Comment(value={"Cooldown Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] cooldown = new String[]{"(0+){20 * 20 + 15 * 20 * (1 - ((1 - (e^(-2.1 * (x/24)))) / (1 - e^(-2.1))))}", "(25+){12 * 20 + 8 * 20 * (1- (((e^(0.1 * ((x-24) / (y-24))) - 1)/((e^0.1) - 1))))}", "(50){10 * 20}"};
            @Config.Comment(value={"Duration Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] time = new String[]{"(0+){10 * 20 + 12 * 20 * (1 - (e^(-2.1 * (x/24)))) / (1 - e^(-2.1))}", "(25+){22 * 20 + 6 * 20 * ((e^(0.1 * ((x - 24) / (y - 24))) - 1)/((e^0.1) - 1))}", "(50){30 * 20}"};
            @Config.Comment(value={"Range Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] range = new String[]{"(0+){8 + 16 * (1 - (e^(-2.1 * (x/24)))) / (1 - e^(-2.1))}", "(25+){24 + 6 * ((e^(0.1 * ((x - 24) / (y - 24))) - 1)/((e^0.1) - 1))}"};
            @Config.Comment(value={"Effectiveness Modifier"})
            @Config.RangeDouble
            public double effectiveness = 1.0;

            public static class Advancement {
                @Config.Comment(value={"Function f(x)=? where 'x' is [Next Level] and 'y' is [Max Level], XP Cost is in units [NOT LEVELS]"})
                public String[] upgrade = new String[]{"(0){170}", "(1+){4 * x}", "(50){4 * x + 4 * x * 0.1}"};
            }
        }
    }
}

