/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.skill.ability.defense.electric;

import arekkuusu.enderskills.api.capability.AdvancementCapability;
import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.api.capability.data.SkillData;
import arekkuusu.enderskills.api.capability.data.SkillInfo;
import arekkuusu.enderskills.api.capability.data.nbt.WatcherManager;
import arekkuusu.enderskills.api.helper.ExpressionHelper;
import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.api.helper.TeamHelper;
import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.api.util.Vector;
import arekkuusu.enderskills.client.util.ResourceLibrary;
import arekkuusu.enderskills.client.util.helper.TextHelper;
import arekkuusu.enderskills.common.CommonConfig;
import arekkuusu.enderskills.common.EnderSkills;
import arekkuusu.enderskills.common.entity.data.IExpand;
import arekkuusu.enderskills.common.entity.data.IFindEntity;
import arekkuusu.enderskills.common.entity.placeable.EntityPlaceableData;
import arekkuusu.enderskills.common.network.PacketHelper;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.ModAttributes;
import arekkuusu.enderskills.common.skill.ModEffects;
import arekkuusu.enderskills.common.skill.SkillHelper;
import arekkuusu.enderskills.common.skill.ability.AbilityInfo;
import arekkuusu.enderskills.common.skill.ability.BaseAbility;
import arekkuusu.enderskills.common.sound.ModSounds;
import com.google.common.base.Predicate;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PowerDrain
extends BaseAbility
implements IFindEntity,
IExpand {
    public PowerDrain() {
        super("power_drain", new BaseAbility.AbilityProperties());
        ((BaseAbility.AbilityProperties)this.getProperties()).setCooldownGetter(this::getCooldown).setMaxLevelGetter(this::getMaxLevel);
    }

    @Override
    public void use(EntityLivingBase owner, SkillInfo skillInfo) {
        if (((SkillInfo.IInfoCooldown)((Object)skillInfo)).hasCooldown() || this.isClientWorld(owner)) {
            return;
        }
        AbilityInfo abilityInfo = (AbilityInfo)skillInfo;
        if (this.isActionable(owner) && this.canActivate(owner)) {
            if (!(owner instanceof EntityPlayer) || !((EntityPlayer)owner).field_71075_bZ.field_75098_d) {
                abilityInfo.setCooldown(this.getCooldown(abilityInfo));
            }
            double power = this.getPower(abilityInfo);
            double stun = this.getStun(abilityInfo);
            double range = this.getRange(abilityInfo);
            NBTTagCompound compound = new NBTTagCompound();
            NBTHelper.setEntity(compound, (Entity)owner, "owner");
            NBTHelper.setDouble(compound, "stun", stun);
            NBTHelper.setDouble(compound, "power", power);
            SkillData data = SkillData.of(this).by((Entity)owner).with(0).put(compound, new WatcherManager.Watcher[0]).create();
            EntityPlaceableData spawn = new EntityPlaceableData(owner.field_70170_p, owner, data, 10);
            spawn.func_70107_b(owner.field_70165_t, owner.field_70163_u + (double)(owner.field_70131_O / 2.0f), owner.field_70161_v);
            spawn.setRadius(range);
            owner.field_70170_p.func_72838_d((Entity)spawn);
            this.sync(owner);
            if (owner.field_70170_p instanceof WorldServer) {
                ((WorldServer)owner.field_70170_p).func_184148_a(null, owner.field_70165_t, owner.field_70163_u, owner.field_70161_v, ModSounds.POWER_DRAIN, SoundCategory.PLAYERS, 5.0f, (1.0f + (owner.field_70170_p.field_73012_v.nextFloat() - owner.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            }
        }
    }

    @Override
    public List<Entity> getScan(Entity source, @Nullable EntityLivingBase owner, SkillData skillData, double size) {
        return source.func_130014_f_().func_175647_a(Entity.class, source.func_174813_aQ(), (Predicate)TeamHelper.SELECTOR_ENEMY.apply((Object)owner));
    }

    @Override
    public void onFound(Entity source, @Nullable EntityLivingBase owner, EntityLivingBase target, SkillData skillData) {
        this.apply(target, skillData);
        this.sync(target, skillData);
    }

    @Override
    public void onScan(Entity source, @Nullable EntityLivingBase owner, EntityLivingBase target, SkillData skillData) {
        if (SkillHelper.isActive((Entity)target, ModEffects.ELECTRIFIED)) {
            int stun = NBTHelper.getInteger(skillData.nbt, "stun");
            ModEffects.ELECTRIFIED.propagate(target, skillData, stun);
        }
        if (source.func_70026_G() && source.field_70173_aa % 20 == 0) {
            source.func_70097_a(DamageSource.field_180137_b, 2.0f);
        }
    }

    @Override
    public void begin(EntityLivingBase entity, SkillData data) {
        EntityLivingBase owner = SkillHelper.getOwner(data);
        if (owner != null) {
            Capabilities.endurance((Entity)entity).ifPresent(capability -> {
                double power = NBTHelper.getDouble(data.nbt, "power");
                double drain = power - capability.drain(power);
                if (drain > 0.0 && !this.isClientWorld(entity)) {
                    if (entity instanceof EntityPlayerMP) {
                        PacketHelper.sendEnduranceSync((EntityPlayerMP)entity);
                    }
                    EnderSkills.getProxy().addToQueue(() -> ModEffects.OVERCHARGE.set(owner, drain));
                    Vec3d vec = entity.func_174791_d();
                    double posX = vec.field_72450_a;
                    double posY = vec.field_72448_b + (double)entity.field_70131_O + 0.5;
                    double posZ = vec.field_72449_c;
                    EnderSkills.getProxy().spawnParticle(entity.field_70170_p, new Vec3d(posX, posY, posZ), new Vec3d(0.0, 0.0, 0.0), 3.0f, 50, 16772264, ResourceLibrary.MINUS);
                    vec = owner.func_174791_d();
                    posX = vec.field_72450_a;
                    posY = vec.field_72448_b + (double)owner.field_70131_O + 0.5;
                    posZ = vec.field_72449_c;
                    EnderSkills.getProxy().spawnParticle(owner.field_70170_p, new Vec3d(posX, posY, posZ), new Vec3d(0.0, 0.0, 0.0), 3.0f, 50, 0xFFA8A8, ResourceLibrary.PLUS);
                    EntityLivingBase from = entity;
                    EntityLivingBase to = owner;
                    Vector posFrom = new Vector(from.func_174791_d()).addVector(from.field_70170_p.field_73012_v.nextDouble() * 0.05, (double)from.field_70131_O / 2.0 + from.field_70170_p.field_73012_v.nextDouble() * 0.05, from.field_70170_p.field_73012_v.nextDouble() * 0.05);
                    Vector posTo = new Vector(to.func_174791_d()).addVector(to.field_70170_p.field_73012_v.nextDouble() * 0.05, (double)to.field_70131_O / 2.0 + to.field_70170_p.field_73012_v.nextDouble() * 0.05, to.field_70170_p.field_73012_v.nextDouble() * 0.05);
                    EnderSkills.getProxy().spawnLightning(to.field_70170_p, posFrom, posTo, 4, 0.6f, 5, 16053129, false);
                    if (to.field_70170_p instanceof WorldServer) {
                        ((WorldServer)to.field_70170_p).func_184148_a(null, posTo.x, posTo.y, posTo.z, ModSounds.SPARK, SoundCategory.BLOCKS, 0.5f, (1.0f + (to.field_70170_p.field_73012_v.nextFloat() - to.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                    }
                }
            });
        }
    }

    public int getLevel(SkillInfo.IInfoUpgradeable info) {
        return info.getLevel();
    }

    public int getMaxLevel() {
        return Configuration.getSyncValues().maxLevel;
    }

    public float getPower(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().extra.power, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.extra.globalPositiveEffect;
        return (float)(result * this.getEffectiveness());
    }

    public float getStun(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().extra.stun, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.extra.globalPositiveEffect;
        return (float)(result * this.getEffectiveness());
    }

    public double getRange(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().range, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalRange;
        return result * this.getEffectiveness();
    }

    public int getCooldown(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().cooldown, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalCooldown;
        return (int)(result * this.getEffectiveness());
    }

    public double getEffectiveness() {
        return Configuration.getSyncValues().effectiveness * CommonConfig.getSyncValues().skill.globalEffectiveness;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDescription(List<String> description) {
        Capabilities.get((Entity)Minecraft.func_71410_x().field_71439_g).ifPresent(c -> {
            if (c.isOwned(this)) {
                if (!GuiScreen.func_146272_n()) {
                    description.add("");
                    description.add("Hold SHIFT for stats.");
                } else {
                    c.getOwned(this).ifPresent(skillInfo -> {
                        AbilityInfo abilityInfo = (AbilityInfo)skillInfo;
                        description.clear();
                        description.add("Endurance Drain: " + ModAttributes.ENDURANCE.getEnduranceDrain(this));
                        description.add("");
                        if (abilityInfo.getLevel() >= this.getMaxLevel()) {
                            description.add("Max Level:");
                        } else {
                            description.add("Current Level:");
                        }
                        description.add("Cooldown: " + TextHelper.format2FloatPoint((double)this.getCooldown(abilityInfo) / 20.0) + "s");
                        description.add("Range: " + TextHelper.format2FloatPoint(this.getRange(abilityInfo)) + " Blocks");
                        description.add("Endurance Drain: " + TextHelper.format2FloatPoint(this.getPower(abilityInfo)));
                        description.add("Stun: " + TextHelper.format2FloatPoint((double)this.getStun(abilityInfo) / 20.0) + "s");
                        if (abilityInfo.getLevel() < this.getMaxLevel()) {
                            AbilityInfo infoNew = new AbilityInfo(abilityInfo.serializeNBT());
                            infoNew.setLevel(infoNew.getLevel() + 1);
                            description.add("");
                            description.add("Next Level:");
                            description.add("Cooldown: " + TextHelper.format2FloatPoint((double)this.getCooldown(infoNew) / 20.0) + "s");
                            description.add("Range: " + TextHelper.format2FloatPoint(this.getRange(infoNew)) + " Blocks");
                            description.add("Endurance Drain: " + TextHelper.format2FloatPoint(this.getPower(infoNew)));
                            description.add("Stun: " + TextHelper.format2FloatPoint((double)this.getStun(infoNew) / 20.0) + "s");
                        }
                    });
                }
            }
        });
    }

    @Override
    public int getCostIncrement(EntityLivingBase entity, int total) {
        Optional<AdvancementCapability> optional = Capabilities.advancement((Entity)entity);
        if (optional.isPresent()) {
            AdvancementCapability advancement = optional.get();
            List<Skill> skillUnlockOrder = Arrays.asList(advancement.skillUnlockOrder);
            int index = skillUnlockOrder.indexOf((Object)ModAbilities.SHOCKING_AURA);
            if (index == -1) {
                index = advancement.skillUnlockOrder.length;
            }
            return (int)((double)total * (1.0 + (double)index * CommonConfig.getSyncValues().advancement.xp.costIncrement));
        }
        return total;
    }

    @Override
    public int getUpgradeCost(@Nullable AbilityInfo info) {
        int level = info != null ? this.getLevel(info) + 1 : 0;
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().advancement.upgrade, level, levelMax);
        return (int)(func * CommonConfig.getSyncValues().advancement.xp.globalCostMultiplier);
    }

    @Override
    public void initSyncConfig() {
        Configuration.getSyncValues().maxLevel = Configuration.getValues().maxLevel;
        Configuration.getSyncValues().cooldown = Configuration.getValues().cooldown;
        Configuration.getSyncValues().range = Configuration.getValues().range;
        Configuration.getSyncValues().effectiveness = Configuration.getValues().effectiveness;
        Configuration.getSyncValues().extra.power = Configuration.getValues().extra.power;
        Configuration.getSyncValues().extra.stun = Configuration.getValues().extra.stun;
        Configuration.getSyncValues().advancement.upgrade = Configuration.getValues().advancement.upgrade;
    }

    @Override
    public void writeSyncConfig(NBTTagCompound compound) {
        compound.func_74768_a("maxLevel", Configuration.getValues().maxLevel);
        NBTHelper.setArray(compound, "cooldown", Configuration.getValues().cooldown);
        NBTHelper.setArray(compound, "range", Configuration.getValues().range);
        compound.func_74780_a("effectiveness", Configuration.getValues().effectiveness);
        NBTHelper.setArray(compound, "extra.power", Configuration.getValues().extra.power);
        NBTHelper.setArray(compound, "extra.stun", Configuration.getValues().extra.stun);
        NBTHelper.setArray(compound, "advancement.upgrade", Configuration.getValues().advancement.upgrade);
    }

    @Override
    public void readSyncConfig(NBTTagCompound compound) {
        Configuration.getSyncValues().maxLevel = compound.func_74762_e("maxLevel");
        Configuration.getSyncValues().cooldown = NBTHelper.getArray(compound, "cooldown");
        Configuration.getSyncValues().range = NBTHelper.getArray(compound, "range");
        Configuration.getSyncValues().effectiveness = compound.func_74769_h("effectiveness");
        Configuration.getSyncValues().extra.power = NBTHelper.getArray(compound, "extra.power");
        Configuration.getSyncValues().extra.stun = NBTHelper.getArray(compound, "extra.stun");
        Configuration.getSyncValues().advancement.upgrade = NBTHelper.getArray(compound, "advancement.upgrade");
    }

    @Config(modid="enderskills", name="enderskills/Ability/power_drain")
    public static class Configuration {
        @Config.Comment(value={"Ability Values"})
        @Config.LangKey(value="enderskills.config.power_drain")
        public static Values CONFIG = new Values();
        @Config.Ignore
        protected static Values CONFIG_SYNC = new Values();

        public static Values getValues() {
            return CONFIG;
        }

        public static Values getSyncValues() {
            return CONFIG_SYNC;
        }

        public static class Values {
            @Config.Comment(value={"Skill specific extra Configuration"})
            public final Extra extra = new Extra();
            @Config.Comment(value={"Skill specific Advancement Configuration"})
            public final Advancement advancement = new Advancement();
            @Config.Comment(value={"Max level obtainable"})
            @Config.RangeInt(min=0)
            public int maxLevel = 50;
            @Config.Comment(value={"Cooldown Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] cooldown = new String[]{"(0+){32 * 20 + 28 * 20 * (1 - ((1 - (e^(-2.1 * (x/24)))) / (1 - e^(-2.1))))}", "(25+){22 * 20 + 10 * 20 * (1- (((e^(0.1 * ((x-24) / (y-24))) - 1)/((e^0.1) - 1))))}", "(50){(18 * 20)}"};
            @Config.Comment(value={"Range Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] range = new String[]{"(0+){3 + 2 * (1 - (e^(-2.1 * (x/24)))) / (1 - e^(-2.1))}", "(25+){5 + 2 * ((e^(0.1 * ((x - 24) / (y - 24))) - 1)/((e^0.1) - 1))}"};
            @Config.Comment(value={"Effectiveness Modifier"})
            @Config.RangeDouble
            public double effectiveness = 1.0;

            public static class Advancement {
                @Config.Comment(value={"Function f(x)=? where 'x' is [Next Level] and 'y' is [Max Level], XP Cost is in units [NOT LEVELS]"})
                public String[] upgrade = new String[]{"(0){600}", "(1+){4 * x}", "(50){4 * x + 4 * x * 0.1}"};
            }

            public static class Extra {
                @Config.Comment(value={"Power drain Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
                public String[] power = new String[]{"(0+){6 + ((e^(2.1 * (x / y)) - 1)/((e^2.1) - 1)) * (12 - 6)}"};
                @Config.Comment(value={"Stun time Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
                public String[] stun = new String[]{"(0+){20}"};
            }
        }
    }
}

