/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.skill.ability.defense.electric;

import arekkuusu.enderskills.api.capability.AdvancementCapability;
import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.api.capability.data.SkillData;
import arekkuusu.enderskills.api.capability.data.SkillInfo;
import arekkuusu.enderskills.api.capability.data.nbt.WatcherManager;
import arekkuusu.enderskills.api.helper.ExpressionHelper;
import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.api.helper.TeamHelper;
import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.client.gui.data.ISkillAdvancement;
import arekkuusu.enderskills.client.sounds.ShockingAuraSound;
import arekkuusu.enderskills.client.util.helper.TextHelper;
import arekkuusu.enderskills.common.CommonConfig;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.ModAttributes;
import arekkuusu.enderskills.common.skill.ModEffects;
import arekkuusu.enderskills.common.skill.SkillHelper;
import arekkuusu.enderskills.common.skill.ability.AbilityInfo;
import arekkuusu.enderskills.common.skill.ability.BaseAbility;
import com.google.common.base.Predicate;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ShockingAura
extends BaseAbility {
    public ShockingAura() {
        super("shocking_aura", new BaseAbility.AbilityProperties());
        ((BaseAbility.AbilityProperties)this.getProperties()).setCooldownGetter(this::getCooldown).setMaxLevelGetter(this::getMaxLevel);
    }

    @Override
    public void use(EntityLivingBase owner, SkillInfo skillInfo) {
        if (this.isClientWorld(owner)) {
            return;
        }
        AbilityInfo abilityInfo = (AbilityInfo)skillInfo;
        if (!SkillHelper.isActiveFrom((Entity)owner, this)) {
            if (!((SkillInfo.IInfoCooldown)((Object)skillInfo)).hasCooldown() && this.isActionable(owner) && this.canActivate(owner)) {
                if (!(owner instanceof EntityPlayer) || !((EntityPlayer)owner).field_71075_bZ.field_75098_d) {
                    abilityInfo.setCooldown(this.getCooldown(abilityInfo));
                }
                double range = this.getRange(abilityInfo);
                double stun = this.getStun(abilityInfo);
                double slow = this.getSlow(abilityInfo);
                NBTTagCompound compound = new NBTTagCompound();
                NBTHelper.setEntity(compound, (Entity)owner, "owner");
                NBTHelper.setDouble(compound, "range", range);
                NBTHelper.setDouble(compound, "stun", stun);
                NBTHelper.setDouble(compound, "slow", slow);
                SkillData data2 = SkillData.of(this).by((Entity)owner).with(-1).put(compound, new WatcherManager.Watcher[0]).overrides(SkillData.Overrides.EQUAL).create();
                this.apply(owner, data2);
                this.sync(owner, data2);
                this.sync(owner);
            }
        } else {
            SkillHelper.getActiveFrom((Entity)owner, this).ifPresent(data -> {
                this.unapply(owner, (SkillData)data);
                this.async(owner, (SkillData)data);
            });
        }
    }

    @Override
    public void begin(EntityLivingBase owner, SkillData data) {
        if (this.isClientWorld(owner)) {
            this.makeSound(owner);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void makeSound(EntityLivingBase entity) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new ShockingAuraSound(entity));
    }

    @Override
    public void update(EntityLivingBase owner, SkillData data, int tick) {
        if (this.isClientWorld(owner)) {
            return;
        }
        double distance = NBTHelper.getDouble(data.nbt, "range") * MathHelper.func_151237_a((double)((double)tick / 10.0), (double)0.0, (double)1.0);
        double slow = NBTHelper.getDouble(data.nbt, "slow");
        Vec3d pos = owner.func_174791_d();
        pos = new Vec3d(pos.field_72450_a, pos.field_72448_b + (double)(owner.field_70131_O / 2.0f), pos.field_72449_c);
        Vec3d min = pos.func_178786_a(0.5, 0.5, 0.5);
        Vec3d max = pos.func_72441_c(0.5, 0.5, 0.5);
        AxisAlignedBB bb = new AxisAlignedBB(min.field_72450_a, min.field_72448_b, min.field_72449_c, max.field_72450_a, max.field_72448_b, max.field_72449_c);
        owner.field_70170_p.func_175647_a(EntityLivingBase.class, bb.func_186662_g(distance), (Predicate)TeamHelper.SELECTOR_ENEMY.apply((Object)owner)).forEach(target -> {
            if (SkillHelper.isActive((Entity)target, ModEffects.ELECTRIFIED)) {
                int stun = NBTHelper.getInteger(data.nbt, "stun");
                ModEffects.ELECTRIFIED.propagate((EntityLivingBase)target, data, stun);
            }
            if (target.func_70026_G() && tick % 20 == 0) {
                target.func_70097_a(DamageSource.field_180137_b, 2.0f);
            }
            ModEffects.SLOWED.set((EntityLivingBase)target, data, slow);
        });
    }

    public int getLevel(SkillInfo.IInfoUpgradeable info) {
        return info.getLevel();
    }

    public int getMaxLevel() {
        return Configuration.getSyncValues().maxLevel;
    }

    public double getSlow(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().extra.slow, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.extra.globalNeutralEffect;
        return result * this.getEffectiveness();
    }

    public float getStun(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().extra.stun, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.extra.globalPositiveEffect;
        return (float)(result * this.getEffectiveness());
    }

    public double getRange(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().range, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalRange;
        return result * this.getEffectiveness();
    }

    public int getCooldown(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().cooldown, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalCooldown;
        return (int)(result * this.getEffectiveness());
    }

    public double getEffectiveness() {
        return Configuration.getSyncValues().effectiveness * CommonConfig.getSyncValues().skill.globalEffectiveness;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDescription(List<String> description) {
        Capabilities.get((Entity)Minecraft.func_71410_x().field_71439_g).ifPresent(c -> {
            if (c.isOwned(this)) {
                if (!GuiScreen.func_146272_n()) {
                    description.add("");
                    description.add("Hold SHIFT for stats.");
                } else {
                    c.getOwned(this).ifPresent(skillInfo -> {
                        AbilityInfo abilityInfo = (AbilityInfo)skillInfo;
                        description.clear();
                        description.add("Endurance Drain: " + ModAttributes.ENDURANCE.getEnduranceDrain(this));
                        description.add("");
                        if (abilityInfo.getLevel() >= this.getMaxLevel()) {
                            description.add("Max Level:");
                        } else {
                            description.add("Current Level:");
                        }
                        description.add("Cooldown: " + TextHelper.format2FloatPoint((double)this.getCooldown(abilityInfo) / 20.0) + "s");
                        description.add("Range: " + TextHelper.format2FloatPoint(this.getRange(abilityInfo)) + " Blocks");
                        description.add("Slow: " + TextHelper.format2FloatPoint(this.getSlow(abilityInfo)) + "%");
                        description.add("Stun: " + TextHelper.format2FloatPoint((double)this.getStun(abilityInfo) / 20.0) + "s");
                        if (abilityInfo.getLevel() < this.getMaxLevel()) {
                            AbilityInfo infoNew = new AbilityInfo(abilityInfo.serializeNBT());
                            infoNew.setLevel(infoNew.getLevel() + 1);
                            description.add("");
                            description.add("Next Level:");
                            description.add("Cooldown: " + TextHelper.format2FloatPoint((double)this.getCooldown(infoNew) / 20.0) + "s");
                            description.add("Range: " + TextHelper.format2FloatPoint(this.getRange(infoNew)) + " Blocks");
                            description.add("Slow: " + TextHelper.format2FloatPoint(this.getSlow(infoNew)) + "%");
                            description.add("Stun: " + TextHelper.format2FloatPoint((double)this.getStun(infoNew) / 20.0) + "s");
                        }
                    });
                }
            }
        });
    }

    @Override
    public void onUpgrade(EntityLivingBase entity) {
        Capabilities.advancement((Entity)entity).ifPresent(c -> {
            ISkillAdvancement.Requirement requirement = this.getRequirement(entity);
            int tokens = requirement.getLevels();
            int xp = requirement.getXp();
            if (c.level >= tokens && c.getExperienceTotal(entity) >= xp) {
                Capabilities.get((Entity)entity).filter(a -> !a.isOwned(this)).ifPresent(a -> {
                    Skill[] skillUnlockOrder = Arrays.copyOf(c.skillUnlockOrder, c.skillUnlockOrder.length + 1);
                    skillUnlockOrder[skillUnlockOrder.length - 1] = this;
                    c.skillUnlockOrder = skillUnlockOrder;
                });
                c.consumeExperienceFromTotal(entity, xp);
            }
        });
    }

    @Override
    public int getCostIncrement(EntityLivingBase entity, int total) {
        Optional<AdvancementCapability> optional = Capabilities.advancement((Entity)entity);
        if (optional.isPresent()) {
            AdvancementCapability advancement = optional.get();
            List<Skill> skillUnlockOrder = Arrays.asList(advancement.skillUnlockOrder);
            int index = skillUnlockOrder.indexOf((Object)ModAbilities.SHOCKING_AURA);
            if (index == -1) {
                index = advancement.skillUnlockOrder.length;
            }
            return (int)((double)total * (1.0 + (double)index * CommonConfig.getSyncValues().advancement.xp.costIncrement));
        }
        return total;
    }

    @Override
    public int getUpgradeCost(@Nullable AbilityInfo info) {
        int level = info != null ? this.getLevel(info) + 1 : 0;
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().advancement.upgrade, level, levelMax);
        return (int)(func * CommonConfig.getSyncValues().advancement.xp.globalCostMultiplier);
    }

    @Override
    public void initSyncConfig() {
        Configuration.getSyncValues().maxLevel = Configuration.getValues().maxLevel;
        Configuration.getSyncValues().cooldown = Configuration.getValues().cooldown;
        Configuration.getSyncValues().range = Configuration.getValues().range;
        Configuration.getSyncValues().effectiveness = Configuration.getValues().effectiveness;
        Configuration.getSyncValues().extra.slow = Configuration.getValues().extra.slow;
        Configuration.getSyncValues().extra.stun = Configuration.getValues().extra.stun;
        Configuration.getSyncValues().advancement.upgrade = Configuration.getValues().advancement.upgrade;
    }

    @Override
    public void writeSyncConfig(NBTTagCompound compound) {
        compound.func_74768_a("maxLevel", Configuration.getValues().maxLevel);
        NBTHelper.setArray(compound, "cooldown", Configuration.getValues().cooldown);
        NBTHelper.setArray(compound, "range", Configuration.getValues().range);
        compound.func_74780_a("effectiveness", Configuration.getValues().effectiveness);
        NBTHelper.setArray(compound, "extra.slow", Configuration.getValues().extra.slow);
        NBTHelper.setArray(compound, "extra.stun", Configuration.getValues().extra.stun);
        NBTHelper.setArray(compound, "advancement.upgrade", Configuration.getValues().advancement.upgrade);
    }

    @Override
    public void readSyncConfig(NBTTagCompound compound) {
        Configuration.getSyncValues().maxLevel = compound.func_74762_e("maxLevel");
        Configuration.getSyncValues().cooldown = NBTHelper.getArray(compound, "cooldown");
        Configuration.getSyncValues().range = NBTHelper.getArray(compound, "range");
        Configuration.getSyncValues().effectiveness = compound.func_74769_h("effectiveness");
        Configuration.getSyncValues().extra.slow = NBTHelper.getArray(compound, "extra.slow");
        Configuration.getSyncValues().extra.stun = NBTHelper.getArray(compound, "extra.stun");
        Configuration.getSyncValues().advancement.upgrade = NBTHelper.getArray(compound, "advancement.upgrade");
    }

    @Config(modid="enderskills", name="enderskills/Ability/shocking_aura")
    public static class Configuration {
        @Config.Comment(value={"Ability Values"})
        @Config.LangKey(value="enderskills.config.shocking_aura")
        public static Values CONFIG = new Values();
        @Config.Ignore
        protected static Values CONFIG_SYNC = new Values();

        public static Values getValues() {
            return CONFIG;
        }

        public static Values getSyncValues() {
            return CONFIG_SYNC;
        }

        public static class Values {
            @Config.Comment(value={"Skill specific extra Configuration"})
            public final Extra extra = new Extra();
            @Config.Comment(value={"Skill specific Advancement Configuration"})
            public final Advancement advancement = new Advancement();
            @Config.Comment(value={"Max level obtainable"})
            @Config.RangeInt(min=0)
            public int maxLevel = 50;
            @Config.Comment(value={"Cooldown Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] cooldown = new String[]{"(0+){32 * 20 + 28 * 20 * (1 - ((1 - (e^(-2.1 * (x/24)))) / (1 - e^(-2.1))))}", "(25+){22 * 20 + 10 * 20 * (1- (((e^(0.1 * ((x-24) / (y-24))) - 1)/((e^0.1) - 1))))}", "(50){(18 * 20)}"};
            @Config.Comment(value={"Range Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] range = new String[]{"(0+){3 + 2 * (1 - (e^(-2.1 * (x/24)))) / (1 - e^(-2.1))}", "(25+){5 + 2 * ((e^(0.1 * ((x - 24) / (y - 24))) - 1)/((e^0.1) - 1))}"};
            @Config.Comment(value={"Effectiveness Modifier"})
            @Config.RangeDouble
            public double effectiveness = 1.0;

            public static class Advancement {
                @Config.Comment(value={"Function f(x)=? where 'x' is [Next Level] and 'y' is [Max Level], XP Cost is in units [NOT LEVELS]"})
                public String[] upgrade = new String[]{"(0){170}", "(1+){4 * x}", "(50){4 * x + 4 * x * 0.1}"};
            }

            public static class Extra {
                @Config.Comment(value={"Push Force Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
                public String[] slow = new String[]{"(0+){0.5}"};
                @Config.Comment(value={"Stun time Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
                public String[] stun = new String[]{"(0+){20}"};
            }
        }
    }
}

