/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.skill.ability.defense.light;

import arekkuusu.enderskills.api.capability.AdvancementCapability;
import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.api.capability.SkilledEntityCapability;
import arekkuusu.enderskills.api.capability.data.SkillData;
import arekkuusu.enderskills.api.capability.data.SkillHolder;
import arekkuusu.enderskills.api.capability.data.SkillInfo;
import arekkuusu.enderskills.api.capability.data.nbt.WatcherManager;
import arekkuusu.enderskills.api.event.SkillDamageEvent;
import arekkuusu.enderskills.api.helper.ExpressionHelper;
import arekkuusu.enderskills.api.helper.MathUtil;
import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.api.helper.RayTraceHelper;
import arekkuusu.enderskills.api.helper.TeamHelper;
import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.client.util.helper.TextHelper;
import arekkuusu.enderskills.common.CommonConfig;
import arekkuusu.enderskills.common.entity.data.IImpact;
import arekkuusu.enderskills.common.entity.throwable.EntityThrowableData;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.ModAttributes;
import arekkuusu.enderskills.common.skill.SkillHelper;
import arekkuusu.enderskills.common.skill.ability.AbilityInfo;
import arekkuusu.enderskills.common.skill.ability.BaseAbility;
import arekkuusu.enderskills.common.sound.ModSounds;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PowerBoost
extends BaseAbility
implements IImpact {
    public static final List<String> GROW_LIST = new ArrayList<String>();

    public PowerBoost() {
        super("power_boost", new BaseAbility.AbilityProperties());
        ((BaseAbility.AbilityProperties)this.getProperties()).setCooldownGetter(this::getCooldown).setMaxLevelGetter(this::getMaxLevel);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void use(EntityLivingBase owner, SkillInfo skillInfo) {
        if (((SkillInfo.IInfoCooldown)((Object)skillInfo)).hasCooldown() || this.isClientWorld(owner)) {
            return;
        }
        AbilityInfo abilityInfo = (AbilityInfo)skillInfo;
        double distance = this.getRange(abilityInfo);
        if (this.isActionable(owner) && this.canActivate(owner)) {
            if (!(owner instanceof EntityPlayer) || !((EntityPlayer)owner).field_71075_bZ.field_75098_d) {
                abilityInfo.setCooldown(this.getCooldown(abilityInfo));
            }
            int time = this.getTime(abilityInfo);
            double power = this.getPower(abilityInfo);
            NBTTagCompound compound = new NBTTagCompound();
            NBTHelper.setEntity(compound, (Entity)owner, "owner");
            NBTHelper.setDouble(compound, "power", power);
            SkillData data = SkillData.of(this).by((Entity)owner).with(time).put(compound, new WatcherManager.Watcher[0]).overrides(SkillData.Overrides.EQUAL).create();
            EntityThrowableData.throwFor(owner, distance, data, false);
            this.sync(owner);
            if (owner.field_70170_p instanceof WorldServer) {
                ((WorldServer)owner.field_70170_p).func_184148_a(null, owner.field_70165_t, owner.field_70163_u, owner.field_70161_v, ModSounds.POWER_BOOST, SoundCategory.PLAYERS, 5.0f, (1.0f + (owner.field_70170_p.field_73012_v.nextFloat() - owner.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            }
        }
    }

    @Override
    public void onImpact(Entity source, @Nullable EntityLivingBase owner, SkillData skillData, RayTraceResult trace) {
        if (RayTraceHelper.isEntityTrace(trace, (Predicate<Entity>)((Predicate)TeamHelper.SELECTOR_ALLY.apply((Object)owner)))) {
            this.apply((EntityLivingBase)trace.field_72308_g, skillData);
            this.sync((EntityLivingBase)trace.field_72308_g, skillData);
            if (trace.field_72308_g.field_70170_p instanceof WorldServer) {
                ((WorldServer)trace.field_72308_g.field_70170_p).func_184148_a(null, trace.field_72308_g.field_70165_t, trace.field_72308_g.field_70163_u, trace.field_72308_g.field_70161_v, ModSounds.LIGHT_HIT, SoundCategory.PLAYERS, 5.0f, (1.0f + (trace.field_72308_g.field_70170_p.field_73012_v.nextFloat() - trace.field_72308_g.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSkillDamage(SkillDamageEvent event) {
        if (event.getEntityLiving() == null) {
            return;
        }
        if (this.isClientWorld(event.getEntityLiving()) || !SkillHelper.isSkillDamage(event.getSource())) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        Capabilities.get((Entity)entity).ifPresent(capability -> {
            if (capability.isActive(this)) {
                capability.getActives().stream().filter(h -> h.data.skill == this).forEach(h -> {
                    double power = NBTHelper.getDouble(h.data.nbt, "power");
                    event.setAmount(event.getAmount() + event.getAmount() * power);
                });
            }
        });
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityPlayer) {
            return;
        }
        Capabilities.powerBoost((Entity)entity).ifPresent(c -> {
            String key = this.entityToString((Entity)entity);
            if (GROW_LIST.contains(key)) {
                if (SkillHelper.isActive((Entity)entity, this)) {
                    float size = 0.0f;
                    SkilledEntityCapability capability = Capabilities.get(event.getEntity()).orElse(null);
                    for (SkillHolder active : Objects.requireNonNull(capability).getActives()) {
                        if (active.data.skill != ModAbilities.POWER_BOOST) continue;
                        double power = NBTHelper.getDouble(active.data.nbt, "power");
                        if (size == 0.0f) {
                            size = (float)power;
                            continue;
                        }
                        size *= (float)power;
                    }
                    float scale = 1.0f + size;
                    if (!MathUtil.fuzzyEqual(c.eyeNew, c.eyeOriginal * scale)) {
                        c.eyeNew = c.eyeOriginal * scale;
                    }
                    if (!MathUtil.fuzzyEqual(c.widthNew, c.widthOriginal * scale) || !MathUtil.fuzzyEqual(c.heightNew, c.heightOriginal * scale)) {
                        this.setSize(entity, c.widthOriginal * scale, c.heightOriginal * scale);
                        c.widthNew = c.widthOriginal * scale;
                        c.heightNew = c.heightOriginal * scale;
                    }
                } else {
                    this.setSize(entity, c.widthOriginal, c.heightOriginal);
                    c.widthNew = 0.0f;
                    c.heightNew = 0.0f;
                    GROW_LIST.remove(key);
                }
            } else if (SkillHelper.isActive((Entity)entity, this)) {
                GROW_LIST.add(key);
                c.widthOriginal = entity.field_70130_N;
                c.heightOriginal = entity.field_70131_O;
            }
        });
    }

    @SubscribeEvent
    public void onPlayerUpdate(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            EntityPlayer entity = event.player;
            Capabilities.powerBoost((Entity)entity).ifPresent(c -> {
                String key = this.entityToString((Entity)entity);
                if (GROW_LIST.contains(key)) {
                    if (SkillHelper.isActive((Entity)entity, this)) {
                        float size = 0.0f;
                        SkilledEntityCapability capability = Capabilities.get((Entity)event.player).orElse(null);
                        for (SkillHolder active : Objects.requireNonNull(capability).getActives()) {
                            if (active.data.skill != ModAbilities.POWER_BOOST) continue;
                            double power = NBTHelper.getDouble(active.data.nbt, "power");
                            if (size == 0.0f) {
                                size = (float)power;
                                continue;
                            }
                            size *= (float)power;
                        }
                        float scale = 1.0f + size;
                        if (!MathUtil.fuzzyEqual(entity.eyeHeight, c.eyeOriginal * scale)) {
                            entity.eyeHeight = c.eyeOriginal * scale;
                            c.eyeNew = c.eyeOriginal * scale;
                        }
                        if (!MathUtil.fuzzyEqual(entity.field_70130_N, c.widthOriginal * scale) || !MathUtil.fuzzyEqual(entity.field_70131_O, c.heightOriginal * scale)) {
                            this.setSize((EntityLivingBase)entity, c.widthOriginal * scale, c.heightOriginal * scale);
                            c.widthNew = c.widthOriginal * scale;
                            c.heightNew = c.heightOriginal * scale;
                        }
                    } else {
                        this.setSize((EntityLivingBase)entity, c.widthOriginal, c.heightOriginal);
                        entity.eyeHeight = entity.getDefaultEyeHeight();
                        c.eyeNew = 0.0f;
                        c.widthNew = 0.0f;
                        c.heightNew = 0.0f;
                        GROW_LIST.remove(key);
                    }
                } else if (SkillHelper.isActive((Entity)entity, this)) {
                    GROW_LIST.add(key);
                    c.widthOriginal = entity.field_70130_N;
                    c.heightOriginal = entity.field_70131_O;
                    c.eyeOriginal = entity.eyeHeight;
                }
            });
        }
    }

    public String entityToString(Entity entity) {
        return entity.func_110124_au().toString() + ":" + entity.field_70170_p.field_72995_K;
    }

    public void setSize(EntityLivingBase entity, float width, float height) {
        entity.field_70130_N = width;
        entity.field_70131_O = height;
        Vec3d pos = entity.func_174791_d();
        entity.func_174826_a(new AxisAlignedBB(pos.field_72450_a - (double)(width / 2.0f), pos.field_72448_b, pos.field_72449_c - (double)(width / 2.0f), pos.field_72450_a + (double)(width / 2.0f), pos.field_72448_b + (double)entity.field_70131_O, pos.field_72449_c + (double)(width / 2.0f)));
        entity.func_174829_m();
    }

    public int getLevel(SkillInfo.IInfoUpgradeable info) {
        return info.getLevel();
    }

    public int getMaxLevel() {
        return Configuration.getSyncValues().maxLevel;
    }

    public float getPower(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().extra.power, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.extra.globalPositiveEffect;
        return (float)(result * this.getEffectiveness());
    }

    public double getRange(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().range, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalRange;
        return result * this.getEffectiveness();
    }

    public int getCooldown(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().cooldown, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalCooldown;
        return (int)(result * this.getEffectiveness());
    }

    public int getTime(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().time, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalTime;
        return (int)(result * this.getEffectiveness());
    }

    public double getEffectiveness() {
        return Configuration.getSyncValues().effectiveness * CommonConfig.getSyncValues().skill.globalEffectiveness;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDescription(List<String> description) {
        Capabilities.get((Entity)Minecraft.func_71410_x().field_71439_g).ifPresent(c -> {
            if (c.isOwned(this)) {
                if (!GuiScreen.func_146272_n()) {
                    description.add("");
                    description.add("Hold SHIFT for stats.");
                } else {
                    c.getOwned(this).ifPresent(skillInfo -> {
                        AbilityInfo abilityInfo = (AbilityInfo)skillInfo;
                        description.clear();
                        description.add("Endurance Drain: " + ModAttributes.ENDURANCE.getEnduranceDrain(this));
                        description.add("");
                        if (abilityInfo.getLevel() >= this.getMaxLevel()) {
                            description.add("Max Level:");
                        } else {
                            description.add("Current Level:");
                        }
                        description.add("Cooldown: " + TextHelper.format2FloatPoint((double)this.getCooldown(abilityInfo) / 20.0) + "s");
                        description.add("Duration: " + TextHelper.format2FloatPoint((double)this.getTime(abilityInfo) / 20.0) + "s");
                        description.add("Boost: " + TextHelper.format2FloatPoint(this.getPower(abilityInfo) * 100.0f) + "%");
                        if (abilityInfo.getLevel() < this.getMaxLevel()) {
                            AbilityInfo infoNew = new AbilityInfo(abilityInfo.serializeNBT());
                            infoNew.setLevel(infoNew.getLevel() + 1);
                            description.add("");
                            description.add("Next Level:");
                            description.add("Cooldown: " + TextHelper.format2FloatPoint((double)this.getCooldown(infoNew) / 20.0) + "s");
                            description.add("Duration: " + TextHelper.format2FloatPoint((double)this.getTime(infoNew) / 20.0) + "s");
                            description.add("Boost: " + TextHelper.format2FloatPoint(this.getPower(infoNew) * 100.0f) + "%");
                        }
                    });
                }
            }
        });
    }

    @Override
    public int getCostIncrement(EntityLivingBase entity, int total) {
        Optional<AdvancementCapability> optional = Capabilities.advancement((Entity)entity);
        if (optional.isPresent()) {
            AdvancementCapability advancement = optional.get();
            List<Skill> skillUnlockOrder = Arrays.asList(advancement.skillUnlockOrder);
            int index = skillUnlockOrder.indexOf((Object)ModAbilities.CHARM);
            if (index == -1) {
                index = advancement.skillUnlockOrder.length;
            }
            return (int)((double)total * (1.0 + (double)index * CommonConfig.getSyncValues().advancement.xp.costIncrement));
        }
        return total;
    }

    @Override
    public int getUpgradeCost(@Nullable AbilityInfo info) {
        int level = info != null ? this.getLevel(info) + 1 : 0;
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().advancement.upgrade, level, levelMax);
        return (int)(func * CommonConfig.getSyncValues().advancement.xp.globalCostMultiplier);
    }

    @Override
    public void initSyncConfig() {
        Configuration.getSyncValues().maxLevel = Configuration.getValues().maxLevel;
        Configuration.getSyncValues().cooldown = Configuration.getValues().cooldown;
        Configuration.getSyncValues().time = Configuration.getValues().time;
        Configuration.getSyncValues().range = Configuration.getValues().range;
        Configuration.getSyncValues().effectiveness = Configuration.getValues().effectiveness;
        Configuration.getSyncValues().extra.power = Configuration.getValues().extra.power;
        Configuration.getSyncValues().advancement.upgrade = Configuration.getValues().advancement.upgrade;
    }

    @Override
    public void writeSyncConfig(NBTTagCompound compound) {
        compound.func_74768_a("maxLevel", Configuration.getValues().maxLevel);
        NBTHelper.setArray(compound, "cooldown", Configuration.getValues().cooldown);
        NBTHelper.setArray(compound, "time", Configuration.getValues().time);
        NBTHelper.setArray(compound, "range", Configuration.getValues().range);
        compound.func_74780_a("effectiveness", Configuration.getValues().effectiveness);
        NBTHelper.setArray(compound, "extra.power", Configuration.getValues().extra.power);
        NBTHelper.setArray(compound, "advancement.upgrade", Configuration.getValues().advancement.upgrade);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readSyncConfig(NBTTagCompound compound) {
        Configuration.getSyncValues().maxLevel = compound.func_74762_e("maxLevel");
        Configuration.getSyncValues().cooldown = NBTHelper.getArray(compound, "cooldown");
        Configuration.getSyncValues().time = NBTHelper.getArray(compound, "time");
        Configuration.getSyncValues().range = NBTHelper.getArray(compound, "range");
        Configuration.getSyncValues().effectiveness = compound.func_74769_h("effectiveness");
        Configuration.getSyncValues().extra.power = NBTHelper.getArray(compound, "extra.power");
        Configuration.getSyncValues().advancement.upgrade = NBTHelper.getArray(compound, "advancement.upgrade");
    }

    @Config(modid="enderskills", name="enderskills/Ability/power_boost")
    public static class Configuration {
        @Config.Comment(value={"Ability Values"})
        @Config.LangKey(value="enderskills.config.power_boost")
        public static Values CONFIG = new Values();
        @Config.Ignore
        protected static Values CONFIG_SYNC = new Values();

        public static Values getValues() {
            return CONFIG;
        }

        public static Values getSyncValues() {
            return CONFIG_SYNC;
        }

        public static class Values {
            @Config.Comment(value={"Skill specific extra Configuration"})
            public final Extra extra = new Extra();
            @Config.Comment(value={"Skill specific Advancement Configuration"})
            public final Advancement advancement = new Advancement();
            @Config.Comment(value={"Max level obtainable"})
            @Config.RangeInt(min=0)
            public int maxLevel = 50;
            @Config.Comment(value={"Cooldown Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] cooldown = new String[]{"(0+){23 * 20 + 12 * 20 * (1 - ((1 - (e^(-2.1 * (x/24)))) / (1 - e^(-2.1))))}", "(25+){18 * 20 + 5 * 20 * (1- (((e^(0.1 * ((x-24) / (y-24))) - 1)/((e^0.1) - 1))))}", "(50){(16 * 20)}"};
            @Config.Comment(value={"Duration Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] time = new String[]{"(0+){10 * 20 + 14 * 20 * (1 - (e^(-2.1 * (x/24)))) / (1 - e^(-2.1))}", "(25+){24 * 20 + 5 * 20 * ((e^(0.1 * ((x - 24) / (y - 24))) - 1)/((e^0.1) - 1))}", "(50){30 * 20}"};
            @Config.Comment(value={"Range Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] range = new String[]{"(0+){5}"};
            @Config.Comment(value={"Effectiveness Modifier"})
            @Config.RangeDouble
            public double effectiveness = 1.0;

            public static class Advancement {
                @Config.Comment(value={"Function f(x)=? where 'x' is [Next Level] and 'y' is [Max Level], XP Cost is in units [NOT LEVELS]"})
                public String[] upgrade = new String[]{"(0){300}", "(1+){4 * x}", "(50){4 * x + 4 * x * 0.1}"};
            }

            public static class Extra {
                @Config.Comment(value={"Power Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
                public String[] power = new String[]{"(0+){0.25 + ((e^(2.1 * (x / y)) - 1)/((e^2.1) - 1)) * (2 - 0.25)}"};
            }
        }
    }
}

