/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.skill.ability.mobility.ender;

import arekkuusu.enderskills.api.capability.AdvancementCapability;
import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.api.capability.data.SkillData;
import arekkuusu.enderskills.api.capability.data.SkillInfo;
import arekkuusu.enderskills.api.capability.data.nbt.WatcherManager;
import arekkuusu.enderskills.api.helper.ExpressionHelper;
import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.client.gui.data.ISkillAdvancement;
import arekkuusu.enderskills.client.sounds.HoverSound;
import arekkuusu.enderskills.client.util.helper.TextHelper;
import arekkuusu.enderskills.common.CommonConfig;
import arekkuusu.enderskills.common.network.PacketHelper;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.ModAttributes;
import arekkuusu.enderskills.common.skill.ability.AbilityInfo;
import arekkuusu.enderskills.common.skill.ability.BaseAbility;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Hover
extends BaseAbility
implements ISkillAdvancement {
    @SideOnly(value=Side.CLIENT)
    public static int ticksSinceLastTap;
    @SideOnly(value=Side.CLIENT)
    public static int hoverTime;
    @SideOnly(value=Side.CLIENT)
    public static boolean hovering;
    @SideOnly(value=Side.CLIENT)
    public static boolean canHover;

    public Hover() {
        super("hover", new BaseAbility.AbilityProperties(){

            @Override
            public boolean isKeyBound() {
                return false;
            }
        });
        ((BaseAbility.AbilityProperties)this.getProperties()).setCooldownGetter(this::getCooldown).setMaxLevelGetter(this::getMaxLevel);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void use(EntityLivingBase owner, SkillInfo skillInfo) {
        if (this.isActionable(owner) && this.canActivate(owner)) {
            AbilityInfo abilityInfo = (AbilityInfo)skillInfo;
            int maxHover = this.getTime(abilityInfo);
            NBTTagCompound compound = new NBTTagCompound();
            NBTHelper.setEntity(compound, (Entity)owner, "owner");
            SkillData data = SkillData.of(this).by((Entity)owner).with(maxHover).put(compound, new WatcherManager.Watcher[0]).overrides(SkillData.Overrides.SAME).create();
            this.apply(owner, data);
            this.sync(owner, data);
            this.sync(owner);
        }
    }

    @Override
    public void begin(EntityLivingBase owner, SkillData data) {
        if (this.isClientWorld(owner) && !(owner instanceof EntityPlayer)) {
            return;
        }
        owner.field_70143_R = 0.0f;
        if (this.isClientWorld(owner)) {
            this.makeSound(owner);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void makeSound(EntityLivingBase entity) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new HoverSound(entity));
    }

    @Override
    public void update(EntityLivingBase owner, SkillData data, int tick) {
        if (this.isClientWorld(owner) && !(owner instanceof EntityPlayer)) {
            return;
        }
        if (owner.field_70181_x < 0.0) {
            owner.field_70181_x *= 0.4;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onKeyPress(InputEvent.KeyInputEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        Capabilities.get((Entity)player).flatMap(c -> c.getOwned(this)).ifPresent(skillInfo -> {
            AbilityInfo abilityInfo = (AbilityInfo)skillInfo;
            int maxHover = this.getTime(abilityInfo);
            if (maxHover <= 0) {
                return;
            }
            boolean pressed = Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d();
            boolean tapped = Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151468_f();
            if (tapped && !player.field_70122_E) {
                if (ticksSinceLastTap <= 7 && canHover) {
                    hovering = true;
                    canHover = false;
                } else {
                    ticksSinceLastTap = 0;
                }
            }
            if (!pressed && hovering) {
                PacketHelper.sendSkillRemoveResponsePacket((EntityLivingBase)player, this);
                hovering = false;
                hoverTime = 0;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onKeyTapUpdate(TickEvent.ClientTickEvent event) {
        EntityPlayerSP player;
        if (ticksSinceLastTap < 10) {
            ++ticksSinceLastTap;
        }
        if ((player = Minecraft.func_71410_x().field_71439_g) != null && player.field_70122_E && !canHover) {
            canHover = true;
        }
        if (player == null || !hovering) {
            return;
        }
        if (player.field_70122_E) {
            PacketHelper.sendSkillRemoveResponsePacket((EntityLivingBase)player, this);
            hovering = false;
            hoverTime = 0;
            return;
        }
        Capabilities.get((Entity)player).flatMap(c -> c.getOwned(this)).ifPresent(skillInfo -> {
            AbilityInfo abilityInfo = (AbilityInfo)skillInfo;
            int maxHover = this.getTime(abilityInfo);
            if (maxHover <= 0) {
                return;
            }
            if (hoverTime > maxHover) {
                PacketHelper.sendSkillRemoveResponsePacket((EntityLivingBase)player, this);
                hovering = false;
                hoverTime = 0;
            } else {
                Capabilities.endurance((Entity)player).ifPresent(endurance -> {
                    int amount = ModAttributes.ENDURANCE.getEnduranceDrain(this);
                    if (endurance.getEndurance() - (double)amount >= 0.0) {
                        if (hovering && hoverTime++ == 0) {
                            PacketHelper.sendSkillUseRequestPacket(player, this);
                        }
                    } else {
                        PacketHelper.sendSkillRemoveResponsePacket((EntityLivingBase)player, this);
                        hovering = false;
                        hoverTime = 0;
                    }
                });
            }
        });
    }

    public int getLevel(SkillInfo.IInfoUpgradeable info) {
        return info.getLevel();
    }

    public int getMaxLevel() {
        return Configuration.getSyncValues().maxLevel;
    }

    public int getCooldown(AbilityInfo info) {
        return 0;
    }

    public int getTime(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().time, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalTime;
        return (int)(result * this.getEffectiveness());
    }

    public double getEffectiveness() {
        return Configuration.getSyncValues().effectiveness * CommonConfig.getSyncValues().skill.globalEffectiveness;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDescription(List<String> description) {
        Capabilities.get((Entity)Minecraft.func_71410_x().field_71439_g).ifPresent(c -> {
            if (c.isOwned(this)) {
                if (!GuiScreen.func_146272_n()) {
                    description.add("");
                    description.add("Hold SHIFT for stats.");
                } else {
                    c.getOwned(this).ifPresent(skillInfo -> {
                        AbilityInfo abilityInfo = (AbilityInfo)skillInfo;
                        description.clear();
                        description.add("Endurance Drain: " + ModAttributes.ENDURANCE.getEnduranceDrain(this));
                        description.add("");
                        if (abilityInfo.getLevel() >= this.getMaxLevel()) {
                            description.add("Max Level:");
                        } else {
                            description.add("Current Level:");
                        }
                        description.add("Duration: " + TextHelper.format2FloatPoint((double)this.getTime(abilityInfo) / 20.0) + "s");
                        if (abilityInfo.getLevel() < this.getMaxLevel()) {
                            AbilityInfo infoNew = new AbilityInfo(abilityInfo.serializeNBT());
                            infoNew.setLevel(infoNew.getLevel() + 1);
                            description.add("");
                            description.add("Next Level:");
                            description.add("Duration: " + TextHelper.format2FloatPoint((double)this.getTime(infoNew) / 20.0) + "s");
                        }
                    });
                }
            }
        });
    }

    @Override
    public int getCostIncrement(EntityLivingBase entity, int total) {
        Optional<AdvancementCapability> optional = Capabilities.advancement((Entity)entity);
        if (optional.isPresent()) {
            AdvancementCapability advancement = optional.get();
            List<Skill> skillUnlockOrder = Arrays.asList(advancement.skillUnlockOrder);
            int index = skillUnlockOrder.indexOf(ModAbilities.WARP);
            if (index == -1) {
                index = advancement.skillUnlockOrder.length;
            }
            return (int)((double)total * (1.0 + (double)index * CommonConfig.getSyncValues().advancement.xp.costIncrement));
        }
        return total;
    }

    @Override
    public int getUpgradeCost(@Nullable AbilityInfo info) {
        int level = info != null ? this.getLevel(info) + 1 : 0;
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().advancement.upgrade, level, levelMax);
        return (int)(func * CommonConfig.getSyncValues().advancement.xp.globalCostMultiplier);
    }

    @Override
    public void initSyncConfig() {
        Configuration.getSyncValues().maxLevel = Configuration.getValues().maxLevel;
        Configuration.getSyncValues().time = Configuration.getValues().time;
        Configuration.getSyncValues().effectiveness = Configuration.getValues().effectiveness;
        Configuration.getSyncValues().advancement.upgrade = Configuration.getValues().advancement.upgrade;
    }

    @Override
    public void writeSyncConfig(NBTTagCompound compound) {
        compound.func_74768_a("maxLevel", Configuration.getValues().maxLevel);
        NBTHelper.setArray(compound, "time", Configuration.getValues().time);
        compound.func_74780_a("effectiveness", Configuration.getValues().effectiveness);
        NBTHelper.setArray(compound, "advancement.upgrade", Configuration.getValues().advancement.upgrade);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readSyncConfig(NBTTagCompound compound) {
        Configuration.getSyncValues().maxLevel = compound.func_74762_e("maxLevel");
        Configuration.getSyncValues().time = NBTHelper.getArray(compound, "time");
        Configuration.getSyncValues().effectiveness = compound.func_74769_h("effectiveness");
        Configuration.getSyncValues().advancement.upgrade = NBTHelper.getArray(compound, "advancement.upgrade");
    }

    static {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            canHover = true;
        }
    }

    @Config(modid="enderskills", name="enderskills/Ability/hover")
    public static class Configuration {
        @Config.Comment(value={"Ability Values"})
        @Config.LangKey(value="enderskills.config.hover")
        public static Values CONFIG = new Values();
        @Config.Ignore
        protected static Values CONFIG_SYNC = new Values();

        public static Values getValues() {
            return CONFIG;
        }

        public static Values getSyncValues() {
            return CONFIG_SYNC;
        }

        public static class Values {
            @Config.Comment(value={"Skill specific Advancement Configuration"})
            public final Advancement advancement = new Advancement();
            @Config.Comment(value={"Max level obtainable"})
            @Config.RangeInt(min=0)
            public int maxLevel = 5;
            @Config.Comment(value={"Duration Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] time = new String[]{"(0+){(1 * 20) + ((1 * 20 * (x + 1)) - 1 * 20)}"};
            @Config.Comment(value={"Effectiveness Modifier"})
            @Config.RangeDouble
            public double effectiveness = 1.0;

            public static class Advancement {
                @Config.Comment(value={"Function f(x)=? where 'x' is [Next Level] and 'y' is [Max Level], XP Cost is in units [NOT LEVELS]"})
                public String[] upgrade = new String[]{"(0){300}", "(1+){4 * x}", "(50){4 * x + 4 * x * 0.1}"};
            }
        }
    }
}

