/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.skill.ability.mobility.ender;

import arekkuusu.enderskills.api.capability.AdvancementCapability;
import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.api.capability.data.SkillData;
import arekkuusu.enderskills.api.capability.data.SkillInfo;
import arekkuusu.enderskills.api.capability.data.nbt.WatcherManager;
import arekkuusu.enderskills.api.helper.ExpressionHelper;
import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.api.helper.RayTraceHelper;
import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.client.gui.data.ISkillAdvancement;
import arekkuusu.enderskills.client.keybind.KeyBounds;
import arekkuusu.enderskills.client.render.skill.WarpRenderer;
import arekkuusu.enderskills.client.util.helper.TextHelper;
import arekkuusu.enderskills.common.CommonConfig;
import arekkuusu.enderskills.common.network.PacketHelper;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.ModAttributes;
import arekkuusu.enderskills.common.skill.ability.AbilityInfo;
import arekkuusu.enderskills.common.skill.ability.BaseAbility;
import arekkuusu.enderskills.common.sound.ModSounds;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Warp
extends BaseAbility
implements ISkillAdvancement {
    @SideOnly(value=Side.CLIENT)
    public static int ticksSinceLastTap;
    @SideOnly(value=Side.CLIENT)
    public static boolean keyWasPressed;
    @SideOnly(value=Side.CLIENT)
    public static boolean wasTapped;
    @SideOnly(value=Side.CLIENT)
    public static int ticksForNextTap;

    public Warp() {
        super("warp", new BaseAbility.AbilityProperties(){

            @Override
            public boolean isKeyBound() {
                return false;
            }
        });
        ((BaseAbility.AbilityProperties)this.getProperties()).setCooldownGetter(this::getCooldown).setMaxLevelGetter(this::getMaxLevel);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void use(EntityLivingBase owner, SkillInfo skillInfo, Vec3d vector) {
        Vec3d targetVector;
        if (((SkillInfo.IInfoCooldown)((Object)skillInfo)).hasCooldown() || this.isClientWorld(owner)) {
            return;
        }
        AbilityInfo abilityInfo = (AbilityInfo)skillInfo;
        Vec3d eyesVector = owner.func_174824_e(1.0f);
        RayTraceResult traceBlocks = RayTraceHelper.rayTraceBlocks(owner.field_70170_p, eyesVector, targetVector = eyesVector.func_178787_e(vector));
        if (traceBlocks != null) {
            targetVector = traceBlocks.field_72307_f;
            targetVector = new Vec3d((double)MathHelper.func_76128_c((double)targetVector.field_72450_a) + 0.5, (double)MathHelper.func_76128_c((double)targetVector.field_72448_b) + 0.1, (double)MathHelper.func_76128_c((double)targetVector.field_72449_c) + 0.5);
        }
        double distance = this.getRange(abilityInfo);
        if (owner.func_70011_f(targetVector.field_72450_a, targetVector.field_72448_b, targetVector.field_72449_c) > distance + 1.0) {
            return;
        }
        BlockPos posFloor = new BlockPos(targetVector);
        BlockPos posCeiling = posFloor.func_177984_a();
        if (this.isSafePos(owner.field_70170_p, posFloor) && this.isSafePos(owner.field_70170_p, posCeiling) && this.isActionable(owner) && this.canActivate(owner)) {
            NBTTagCompound compound = new NBTTagCompound();
            NBTHelper.setEntity(compound, (Entity)owner, "owner");
            NBTHelper.setVector(compound, "origin", owner.func_174791_d());
            NBTHelper.setVector(compound, "target", targetVector);
            if (!(owner instanceof EntityPlayer) || !((EntityPlayer)owner).field_71075_bZ.field_75098_d) {
                abilityInfo.setCooldown(this.getCooldown(abilityInfo));
            }
            SkillData data = SkillData.of(this).by((Entity)owner).with(0).put(compound, new WatcherManager.Watcher[0]).overrides(SkillData.Overrides.EQUAL).create();
            this.apply(owner, data);
            this.sync(owner, data);
            this.sync(owner);
        }
    }

    @Override
    public void begin(EntityLivingBase entity, SkillData data) {
        if (this.isClientWorld(entity)) {
            return;
        }
        Vec3d vec = NBTHelper.getVector(data.nbt, "target");
        entity.func_70634_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        if (entity.field_70170_p instanceof WorldServer) {
            ((WorldServer)entity.field_70170_p).func_184148_a(null, entity.field_70169_q, entity.field_70167_r, entity.field_70166_s, ModSounds.WARP, SoundCategory.PLAYERS, 1.0f, (1.0f + (entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            ((WorldServer)entity.field_70170_p).func_184148_a(null, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, ModSounds.WARP, SoundCategory.PLAYERS, 1.0f, (1.0f + (entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
    }

    @Override
    public void end(EntityLivingBase entity, SkillData data) {
        if (this.isClientWorld(entity)) {
            this.spawnRift(entity, data);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnRift(EntityLivingBase entity, SkillData data) {
        Vec3d offset = new Vec3d(0.0, (double)entity.field_70131_O / 2.0, 0.0);
        WarpRenderer.WarpRift riftOrigin = new WarpRenderer.WarpRift(entity, NBTHelper.getVector(data.nbt, "origin"), false);
        WarpRenderer.WarpRift riftTarget = new WarpRenderer.WarpRift(entity, NBTHelper.getVector(data.nbt, "target").func_178787_e(offset), true);
        WarpRenderer.WARP_RIFTS.add(riftOrigin);
        WarpRenderer.WARP_RIFTS.add(riftTarget);
    }

    public boolean isSafePos(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_185890_d((IBlockAccess)world, pos) == Block.field_185506_k;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onKeyPress(InputEvent.KeyInputEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (!KeyBounds.warp.func_151470_d()) {
            return;
        }
        Capabilities.get((Entity)player).flatMap(c -> c.getOwned(this)).ifPresent(skillInfo -> {
            AbilityInfo abilityInfo = (AbilityInfo)skillInfo;
            if (abilityInfo.hasCooldown()) {
                return;
            }
            boolean tapped = KeyBounds.warp.func_151470_d();
            if (tapped && !wasTapped) {
                if (ticksSinceLastTap <= 14) {
                    Capabilities.endurance((Entity)player).ifPresent(endurance -> {
                        int amount = ModAttributes.ENDURANCE.getEnduranceDrain(this);
                        if (endurance.getEndurance() - (double)amount >= 0.0) {
                            double distance = this.getRange(abilityInfo);
                            Vec3d lookVec = player.func_70040_Z();
                            double x = lookVec.field_72450_a * distance;
                            double y = lookVec.field_72448_b * distance;
                            double z = lookVec.field_72449_c * distance;
                            Vec3d moveVec = new Vec3d(0.0, 0.0, 0.0);
                            if (Minecraft.func_71410_x().field_71474_y.field_74351_w.func_151470_d()) {
                                moveVec = moveVec.func_178787_e(new Vec3d(x, y, z));
                            }
                            if (Minecraft.func_71410_x().field_71474_y.field_74366_z.func_151470_d()) {
                                moveVec = moveVec.func_178787_e(new Vec3d(-z, 0.0, x));
                            }
                            if (Minecraft.func_71410_x().field_71474_y.field_74370_x.func_151470_d()) {
                                moveVec = moveVec.func_178787_e(new Vec3d(z, 0.0, -x));
                            }
                            if (Minecraft.func_71410_x().field_71474_y.field_74368_y.func_151470_d()) {
                                moveVec = moveVec.func_178787_e(new Vec3d(-x, -y, -z));
                            }
                            PacketHelper.sendWarpUseRequestPacket(player, moveVec);
                        }
                    });
                    keyWasPressed = true;
                } else {
                    ticksSinceLastTap = 0;
                }
            }
            if (tapped && !wasTapped) {
                wasTapped = true;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onKeyTapUpdate(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71474_y.field_151444_V.func_151470_d()) {
            keyWasPressed = false;
        }
        if (ticksSinceLastTap < 17) {
            ++ticksSinceLastTap;
        }
        boolean tapped = Minecraft.func_71410_x().field_71474_y.field_151444_V.func_151470_d();
        if (wasTapped && !tapped) {
            wasTapped = false;
        }
    }

    public int getLevel(SkillInfo.IInfoUpgradeable info) {
        return info.getLevel();
    }

    public int getMaxLevel() {
        return Configuration.getSyncValues().maxLevel;
    }

    public double getRange(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().range, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalRange;
        return result * this.getEffectiveness();
    }

    public int getCooldown(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().cooldown, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalCooldown;
        return (int)(result * this.getEffectiveness());
    }

    public double getEffectiveness() {
        return Configuration.getSyncValues().effectiveness * CommonConfig.getSyncValues().skill.globalEffectiveness;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDescription(List<String> description) {
        Capabilities.get((Entity)Minecraft.func_71410_x().field_71439_g).ifPresent(c -> {
            if (c.isOwned(this)) {
                if (!GuiScreen.func_146272_n()) {
                    description.add("");
                    description.add("Hold SHIFT for stats.");
                } else {
                    c.getOwned(this).ifPresent(skillInfo -> {
                        AbilityInfo abilityInfo = (AbilityInfo)skillInfo;
                        description.clear();
                        description.add("Endurance Drain: " + ModAttributes.ENDURANCE.getEnduranceDrain(this));
                        description.add("");
                        if (abilityInfo.getLevel() >= this.getMaxLevel()) {
                            description.add("Max Level:");
                        } else {
                            description.add("Current Level:");
                        }
                        description.add("Cooldown: " + TextHelper.format2FloatPoint((double)this.getCooldown(abilityInfo) / 20.0) + "s");
                        description.add("Range: " + TextHelper.format2FloatPoint(this.getRange(abilityInfo)) + " Blocks");
                        if (abilityInfo.getLevel() < this.getMaxLevel()) {
                            AbilityInfo infoNew = new AbilityInfo(abilityInfo.serializeNBT());
                            infoNew.setLevel(infoNew.getLevel() + 1);
                            description.add("");
                            description.add("Next Level:");
                            description.add("Cooldown: " + TextHelper.format2FloatPoint((double)this.getCooldown(infoNew) / 20.0) + "s");
                            description.add("Range: " + TextHelper.format2FloatPoint(this.getRange(infoNew)) + " Blocks");
                        }
                    });
                }
            }
        });
    }

    @Override
    public void onUpgrade(EntityLivingBase entity) {
        Capabilities.advancement((Entity)entity).ifPresent(c -> {
            ISkillAdvancement.Requirement requirement = this.getRequirement(entity);
            int tokens = requirement.getLevels();
            int xp = requirement.getXp();
            if (c.level >= tokens && c.getExperienceTotal(entity) >= xp) {
                Capabilities.get((Entity)entity).filter(a -> !a.isOwned(this)).ifPresent(a -> {
                    Skill[] skillUnlockOrder = Arrays.copyOf(c.skillUnlockOrder, c.skillUnlockOrder.length + 1);
                    skillUnlockOrder[skillUnlockOrder.length - 1] = this;
                    c.skillUnlockOrder = skillUnlockOrder;
                });
                c.consumeExperienceFromTotal(entity, xp);
            }
        });
    }

    @Override
    public int getCostIncrement(EntityLivingBase entity, int total) {
        Optional<AdvancementCapability> optional = Capabilities.advancement((Entity)entity);
        if (optional.isPresent()) {
            AdvancementCapability advancement = optional.get();
            List<Skill> skillUnlockOrder = Arrays.asList(advancement.skillUnlockOrder);
            int index = skillUnlockOrder.indexOf(ModAbilities.WARP);
            if (index == -1) {
                index = advancement.skillUnlockOrder.length;
            }
            return (int)((double)total * (1.0 + (double)index * CommonConfig.getSyncValues().advancement.xp.costIncrement));
        }
        return total;
    }

    @Override
    public int getUpgradeCost(@Nullable AbilityInfo info) {
        int level = info != null ? this.getLevel(info) + 1 : 0;
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().advancement.upgrade, level, levelMax);
        return (int)(func * CommonConfig.getSyncValues().advancement.xp.globalCostMultiplier);
    }

    @Override
    public void initSyncConfig() {
        Configuration.getSyncValues().maxLevel = Configuration.getValues().maxLevel;
        Configuration.getSyncValues().cooldown = Configuration.getValues().cooldown;
        Configuration.getSyncValues().range = Configuration.getValues().range;
        Configuration.getSyncValues().effectiveness = Configuration.getValues().effectiveness;
        Configuration.getSyncValues().advancement.upgrade = Configuration.getValues().advancement.upgrade;
    }

    @Override
    public void writeSyncConfig(NBTTagCompound compound) {
        compound.func_74768_a("maxLevel", Configuration.getValues().maxLevel);
        NBTHelper.setArray(compound, "cooldown", Configuration.getValues().cooldown);
        NBTHelper.setArray(compound, "range", Configuration.getValues().range);
        compound.func_74780_a("effectiveness", Configuration.getValues().effectiveness);
        NBTHelper.setArray(compound, "advancement.upgrade", Configuration.getValues().advancement.upgrade);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readSyncConfig(NBTTagCompound compound) {
        Configuration.getSyncValues().maxLevel = compound.func_74762_e("maxLevel");
        Configuration.getSyncValues().cooldown = NBTHelper.getArray(compound, "cooldown");
        Configuration.getSyncValues().range = NBTHelper.getArray(compound, "range");
        Configuration.getSyncValues().effectiveness = compound.func_74769_h("effectiveness");
        Configuration.getSyncValues().advancement.upgrade = NBTHelper.getArray(compound, "advancement.upgrade");
    }

    @Config(modid="enderskills", name="enderskills/Ability/warp")
    public static class Configuration {
        @Config.Comment(value={"Ability Values"})
        @Config.LangKey(value="enderskills.config.warp")
        public static Values CONFIG = new Values();
        @Config.Ignore
        protected static Values CONFIG_SYNC = new Values();

        public static Values getValues() {
            return CONFIG;
        }

        public static Values getSyncValues() {
            return CONFIG_SYNC;
        }

        public static class Values {
            @Config.Comment(value={"Skill specific Advancement Configuration"})
            public final Advancement advancement = new Advancement();
            @Config.Comment(value={"Max level obtainable"})
            @Config.RangeInt(min=0)
            public int maxLevel = 50;
            @Config.Comment(value={"Cooldown Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] cooldown = new String[]{"(0+){10 * 20 + 2 * 20 * (1 - ((1 - (e^(-2.1 * (x/24)))) / (1 - e^(-2.1))))}", "(25+){9 * 20 + 1 * 20 * (1- (((e^(0.1 * ((x-24) / (y-24))) - 1)/((e^0.1) - 1))))}", "(50){8 * 20}"};
            @Config.Comment(value={"Range Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] range = new String[]{"(0+){4 + (x / y) * (8 - 4)}"};
            @Config.Comment(value={"Effectiveness Modifier"})
            @Config.RangeDouble
            public double effectiveness = 1.0;

            public static class Advancement {
                @Config.Comment(value={"Function f(x)=? where 'x' is [Next Level] and 'y' is [Max Level], XP Cost is in units [NOT LEVELS]"})
                public String[] upgrade = new String[]{"(0){170}", "(1+){4 * x}", "(50){4 * x + 4 * x * 0.1}"};
            }
        }
    }
}

