/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.skill.ability.mobility.wind;

import arekkuusu.enderskills.api.capability.AdvancementCapability;
import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.api.capability.data.SkillData;
import arekkuusu.enderskills.api.capability.data.SkillInfo;
import arekkuusu.enderskills.api.capability.data.nbt.WatcherManager;
import arekkuusu.enderskills.api.event.SkillActivateEvent;
import arekkuusu.enderskills.api.helper.ExpressionHelper;
import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.client.gui.data.ISkillAdvancement;
import arekkuusu.enderskills.client.util.helper.TextHelper;
import arekkuusu.enderskills.common.CommonConfig;
import arekkuusu.enderskills.common.network.PacketHelper;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.ModAttributes;
import arekkuusu.enderskills.common.skill.ability.AbilityInfo;
import arekkuusu.enderskills.common.skill.ability.BaseAbility;
import arekkuusu.enderskills.common.sound.ModSounds;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Hasten
extends BaseAbility
implements ISkillAdvancement {
    public Hasten() {
        super("hasten", new BaseAbility.AbilityProperties());
        MinecraftForge.EVENT_BUS.register((Object)this);
        ((BaseAbility.AbilityProperties)this.getProperties()).setCooldownGetter(this::getCooldown).setMaxLevelGetter(this::getMaxLevel);
    }

    @Override
    public void use(EntityLivingBase owner, SkillInfo skillInfo) {
        if (((SkillInfo.IInfoCooldown)((Object)skillInfo)).hasCooldown() || this.isClientWorld(owner)) {
            return;
        }
        AbilityInfo abilityInfo = (AbilityInfo)skillInfo;
        if (this.isActionable(owner) && this.canActivate(owner)) {
            if (!(owner instanceof EntityPlayer) || !((EntityPlayer)owner).field_71075_bZ.field_75098_d) {
                abilityInfo.setCooldown(this.getCooldown(abilityInfo));
            }
            int time = this.getTime(abilityInfo);
            NBTTagCompound compound = new NBTTagCompound();
            NBTHelper.setNBT(compound, "list", new NBTTagList());
            NBTHelper.setEntity(compound, (Entity)owner, "owner");
            SkillData data = SkillData.of(this).with(time).put(compound, new WatcherManager.Watcher[0]).overrides(SkillData.Overrides.SAME).create();
            this.apply(owner, data);
            this.sync(owner, data);
            this.sync(owner);
        }
    }

    @Override
    public void begin(EntityLivingBase entity, SkillData data) {
        if (entity.field_70170_p instanceof WorldServer) {
            ((WorldServer)entity.field_70170_p).func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, ModSounds.HASTEN, SoundCategory.PLAYERS, 1.0f, (1.0f + (entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
    }

    @Override
    public void update(EntityLivingBase entity, SkillData data, int tick) {
        if (this.isClientWorld(entity)) {
            return;
        }
        Capabilities.get((Entity)entity).flatMap(s -> s.getOwned(this)).ifPresent(skillInfo -> {
            AbilityInfo abilityInfo = (AbilityInfo)skillInfo;
            NBTHelper.getNBTList(data.nbt, "list").ifPresent(list -> {
                ArrayList locations = new ArrayList();
                list.iterator().forEachRemaining(nbt -> locations.add(NBTHelper.getResourceLocation((NBTTagCompound)nbt, "location")));
                double crd = this.getCDR(abilityInfo);
                Capabilities.get((Entity)entity).map(c -> c.getAllOwned().entrySet()).ifPresent(entries -> {
                    for (Map.Entry entry : entries) {
                        SkillInfo info = (SkillInfo)entry.getValue();
                        Skill skill = (Skill)((Object)((Object)((Object)((Object)entry.getKey()))));
                        ResourceLocation location = skill.getRegistryName();
                        if (!(skill.getProperties() instanceof BaseAbility.AbilityProperties) || locations.contains(location) || !(info instanceof SkillInfo.IInfoCooldown) || location == null || skill == this || !((SkillInfo.IInfoCooldown)((Object)info)).hasCooldown()) continue;
                        ((SkillInfo.IInfoCooldown)((Object)info)).setCooldown(Math.max(0, ((SkillInfo.IInfoCooldown)((Object)info)).getCooldown() - (int)((double)((BaseAbility.AbilityProperties)skill.getProperties()).getCooldown((AbilityInfo)info) * crd)));
                        if (entity instanceof EntityPlayer) {
                            PacketHelper.sendSkillSync((EntityPlayerMP)entity, skill);
                        }
                        NBTTagCompound tag = new NBTTagCompound();
                        NBTHelper.setResourceLocation(tag, "location", location);
                        list.func_74742_a((NBTBase)tag);
                    }
                });
            });
        });
    }

    @SubscribeEvent
    public void onSkillUse(SkillActivateEvent event) {
        if (this.isClientWorld(event.getEntityLiving())) {
            return;
        }
        Capabilities.get((Entity)event.getEntityLiving()).flatMap(s -> s.getActive(this)).ifPresent(holder -> NBTHelper.getNBTList(holder.data.nbt, "list").ifPresent(list -> {
            Skill skill = event.getSkill();
            ResourceLocation location = skill.getRegistryName();
            int index = -1;
            for (int i = 0; i < list.func_74745_c(); ++i) {
                ResourceLocation savedLocation = NBTHelper.getResourceLocation(list.func_150305_b(i), "location");
                if (!savedLocation.equals((Object)location)) continue;
                index = i;
                break;
            }
            if (index != -1) {
                list.func_74744_a(index);
            }
        }));
    }

    public int getLevel(SkillInfo.IInfoUpgradeable info) {
        return info.getLevel();
    }

    public int getMaxLevel() {
        return Configuration.getSyncValues().maxLevel;
    }

    public double getCDR(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().extra.cdr, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.extra.globalPositiveEffect;
        return result * this.getEffectiveness();
    }

    public int getCooldown(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().cooldown, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalCooldown;
        return (int)(result * this.getEffectiveness());
    }

    public int getTime(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().time, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalTime;
        return (int)(result * this.getEffectiveness());
    }

    public double getEffectiveness() {
        return Configuration.getSyncValues().effectiveness * CommonConfig.getSyncValues().skill.globalEffectiveness;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDescription(List<String> description) {
        Capabilities.get((Entity)Minecraft.func_71410_x().field_71439_g).ifPresent(c -> {
            if (c.isOwned(this)) {
                if (!GuiScreen.func_146272_n()) {
                    description.add("");
                    description.add("Hold SHIFT for stats.");
                } else {
                    c.getOwned(this).ifPresent(skillInfo -> {
                        AbilityInfo abilityInfo = (AbilityInfo)skillInfo;
                        description.clear();
                        description.add("Endurance Drain: " + ModAttributes.ENDURANCE.getEnduranceDrain(this));
                        description.add("");
                        if (abilityInfo.getLevel() >= this.getMaxLevel()) {
                            description.add("Max Level:");
                        } else {
                            description.add("Current Level:");
                        }
                        description.add("Cooldown: " + TextHelper.format2FloatPoint((double)this.getCooldown(abilityInfo) / 20.0) + "s");
                        description.add("Duration: " + TextHelper.format2FloatPoint((double)this.getTime(abilityInfo) / 20.0) + "s");
                        description.add("Cooldown Reduction: +" + TextHelper.format2FloatPoint(this.getCDR(abilityInfo) * 100.0) + "%");
                        if (abilityInfo.getLevel() < this.getMaxLevel()) {
                            AbilityInfo infoNew = new AbilityInfo(abilityInfo.serializeNBT());
                            infoNew.setLevel(infoNew.getLevel() + 1);
                            description.add("");
                            description.add("Next Level:");
                            description.add("Cooldown: " + TextHelper.format2FloatPoint((double)this.getCooldown(infoNew) / 20.0) + "s");
                            description.add("Duration: " + TextHelper.format2FloatPoint((double)this.getTime(infoNew) / 20.0) + "s");
                            description.add("Cooldown Reduction: +" + TextHelper.format2FloatPoint(this.getCDR(infoNew) * 100.0) + "%");
                        }
                    });
                }
            }
        });
    }

    @Override
    public int getCostIncrement(EntityLivingBase entity, int total) {
        Optional<AdvancementCapability> optional = Capabilities.advancement((Entity)entity);
        if (optional.isPresent()) {
            AdvancementCapability advancement = optional.get();
            List<Skill> skillUnlockOrder = Arrays.asList(advancement.skillUnlockOrder);
            int index = skillUnlockOrder.indexOf(ModAbilities.DASH);
            if (index == -1) {
                index = advancement.skillUnlockOrder.length;
            }
            return (int)((double)total * (1.0 + (double)index * CommonConfig.getSyncValues().advancement.xp.costIncrement));
        }
        return total;
    }

    @Override
    public int getUpgradeCost(@Nullable AbilityInfo info) {
        int level = info != null ? this.getLevel(info) + 1 : 0;
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().advancement.upgrade, level, levelMax);
        return (int)(func * CommonConfig.getSyncValues().advancement.xp.globalCostMultiplier);
    }

    @Override
    public void initSyncConfig() {
        Configuration.getSyncValues().maxLevel = Configuration.getValues().maxLevel;
        Configuration.getSyncValues().cooldown = Configuration.getValues().cooldown;
        Configuration.getSyncValues().time = Configuration.getValues().time;
        Configuration.getSyncValues().effectiveness = Configuration.getValues().effectiveness;
        Configuration.getSyncValues().extra.cdr = Configuration.getValues().extra.cdr;
        Configuration.getSyncValues().advancement.upgrade = Configuration.getValues().advancement.upgrade;
    }

    @Override
    public void writeSyncConfig(NBTTagCompound compound) {
        compound.func_74768_a("maxLevel", Configuration.getValues().maxLevel);
        NBTHelper.setArray(compound, "cooldown", Configuration.getValues().cooldown);
        NBTHelper.setArray(compound, "time", Configuration.getValues().time);
        compound.func_74780_a("effectiveness", Configuration.getValues().effectiveness);
        NBTHelper.setArray(compound, "extra.cdr", Configuration.getValues().extra.cdr);
        NBTHelper.setArray(compound, "advancement.upgrade", Configuration.getValues().advancement.upgrade);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readSyncConfig(NBTTagCompound compound) {
        Configuration.getSyncValues().maxLevel = compound.func_74762_e("maxLevel");
        Configuration.getSyncValues().cooldown = NBTHelper.getArray(compound, "cooldown");
        Configuration.getSyncValues().time = NBTHelper.getArray(compound, "time");
        Configuration.getSyncValues().effectiveness = compound.func_74769_h("effectiveness");
        Configuration.getSyncValues().extra.cdr = NBTHelper.getArray(compound, "extra.cdr");
        Configuration.getSyncValues().advancement.upgrade = NBTHelper.getArray(compound, "advancement.upgrade");
    }

    @Config(modid="enderskills", name="enderskills/Ability/hasten")
    public static class Configuration {
        @Config.Comment(value={"Ability Values"})
        @Config.LangKey(value="enderskills.config.hasten")
        public static Values CONFIG = new Values();
        @Config.Ignore
        protected static Values CONFIG_SYNC = new Values();

        public static Values getValues() {
            return CONFIG;
        }

        public static Values getSyncValues() {
            return CONFIG_SYNC;
        }

        public static class Values {
            @Config.Comment(value={"Skill specific extra Configuration"})
            public final Extra extra = new Extra();
            @Config.Comment(value={"Skill specific Advancement Configuration"})
            public final Advancement advancement = new Advancement();
            @Config.Comment(value={"Max level obtainable"})
            @Config.RangeInt(min=0)
            public int maxLevel = 10;
            @Config.Comment(value={"Cooldown Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] cooldown = new String[]{"(0+){30 * 20 + 30 * 20 * (1 - ((1 - (e^(-2.1 * (x/4)))) / (1 - e^(-2.1))))}", "(5+){15 * 20 + 15 * 20 * (1- (((e^(0.1 * ((x-4) / (y-4))) - 1)/((e^0.1) - 1))))}", "(10){0}"};
            @Config.Comment(value={"Duration Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] time = new String[]{"(0+){(5 * 20) + (x / y) * ((10 * 20) - (5 * 20))}"};
            @Config.Comment(value={"Effectiveness Modifier"})
            @Config.RangeDouble
            public double effectiveness = 1.0;

            public static class Advancement {
                @Config.Comment(value={"Function f(x)=? where 'x' is [Next Level] and 'y' is [Max Level], XP Cost is in units [NOT LEVELS]"})
                public String[] upgrade = new String[]{"(0){600}", "(1+){4 * x}", "(50){4 * x + 4 * x * 0.1}"};
            }

            public static class Extra {
                @Config.Comment(value={"Damage Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
                public String[] cdr = new String[]{"(0+){0.5 + (x / y) * (0.9 - 0.5)}"};
            }
        }
    }
}

