/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.skill.ability.mobility.wind;

import arekkuusu.enderskills.api.capability.AdvancementCapability;
import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.api.capability.data.SkillData;
import arekkuusu.enderskills.api.capability.data.SkillInfo;
import arekkuusu.enderskills.api.capability.data.nbt.WatcherManager;
import arekkuusu.enderskills.api.helper.ExpressionHelper;
import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.client.gui.data.ISkillAdvancement;
import arekkuusu.enderskills.client.keybind.KeyBounds;
import arekkuusu.enderskills.client.util.helper.TextHelper;
import arekkuusu.enderskills.common.CommonConfig;
import arekkuusu.enderskills.common.entity.data.IExpand;
import arekkuusu.enderskills.common.entity.data.IFindEntity;
import arekkuusu.enderskills.common.entity.data.IScanEntities;
import arekkuusu.enderskills.common.entity.placeable.EntityPlaceableSmash;
import arekkuusu.enderskills.common.network.PacketHelper;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.ModAttributes;
import arekkuusu.enderskills.common.skill.ModEffects;
import arekkuusu.enderskills.common.skill.SkillHelper;
import arekkuusu.enderskills.common.skill.ability.AbilityInfo;
import arekkuusu.enderskills.common.skill.ability.BaseAbility;
import arekkuusu.enderskills.common.sound.ModSounds;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Smash
extends BaseAbility
implements IScanEntities,
IExpand,
IFindEntity,
ISkillAdvancement {
    public Smash() {
        super("smash", new BaseAbility.AbilityProperties(){

            @Override
            public boolean isKeyBound() {
                return false;
            }
        });
        ((BaseAbility.AbilityProperties)this.getProperties()).setCooldownGetter(this::getCooldown).setMaxLevelGetter(this::getMaxLevel);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void use(EntityLivingBase owner, SkillInfo skillInfo) {
        if (this.isClientWorld(owner) || owner instanceof EntityPlayer && ((EntityPlayer)owner).field_71075_bZ.field_75098_d) {
            return;
        }
        AbilityInfo abilityInfo = (AbilityInfo)skillInfo;
        if (!owner.field_70122_E && !((SkillInfo.IInfoCooldown)((Object)skillInfo)).hasCooldown() && this.isActionable(owner) && this.canActivate(owner)) {
            abilityInfo.setCooldown(this.getCooldown(abilityInfo));
            double range = this.getRange(abilityInfo);
            int time = this.getTime(abilityInfo);
            NBTTagCompound compound = new NBTTagCompound();
            NBTHelper.setEntity(compound, (Entity)owner, "owner");
            NBTHelper.setEntity(compound, (Entity)owner, "owner");
            NBTHelper.setDouble(compound, "range", range);
            NBTHelper.setInteger(compound, "time", time);
            SkillData data = SkillData.of(this).by((Entity)owner).with(-1).put(compound, new WatcherManager.Watcher[0]).overrides(SkillData.Overrides.EQUAL).create();
            this.apply(owner, data);
            this.sync(owner, data);
            this.sync(owner);
        }
    }

    @Override
    public AxisAlignedBB expand(Entity source, AxisAlignedBB bb, float amount) {
        return bb.func_72314_b((double)amount, 0.0, (double)amount);
    }

    @Override
    public void onFound(Entity source, @Nullable EntityLivingBase owner, EntityLivingBase target, SkillData skillData) {
        DamageSource damageSource = new DamageSource("smash");
        target.func_70097_a(damageSource, skillData.nbt.func_74760_g("damage"));
        ModEffects.STUNNED.set(target, skillData, skillData.nbt.func_74762_e("time"));
    }

    @Override
    public void begin(EntityLivingBase entity, SkillData data) {
        if (entity.field_70170_p instanceof WorldServer) {
            ((WorldServer)entity.field_70170_p).func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, ModSounds.SMASH_START, SoundCategory.PLAYERS, 1.0f, (1.0f + (entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
    }

    @Override
    public void update(EntityLivingBase owner, SkillData data, int tick) {
        if (!this.isClientWorld(owner) && owner.field_70122_E) {
            this.unapply(owner, data);
            this.async(owner, data);
        }
        if (owner.field_70181_x < 0.0) {
            owner.field_70181_x *= 1.05;
        }
    }

    @Override
    public void end(EntityLivingBase entity, SkillData data) {
        if (entity.field_70170_p instanceof WorldServer) {
            ((WorldServer)entity.field_70170_p).func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, ModSounds.SMASH_HIT, SoundCategory.PLAYERS, 1.0f, (1.0f + (entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onFallDamage(LivingFallEvent event) {
        if (this.isClientWorld(event.getEntityLiving())) {
            return;
        }
        EntityLivingBase owner = event.getEntityLiving();
        SkillHelper.getActiveFrom((Entity)owner, this).ifPresent(data -> {
            double range = NBTHelper.getDouble(data.nbt, "range");
            float damage = MathHelper.func_76123_f((float)(event.getDistance() - 3.0f));
            SkillData copy = data.copy();
            NBTHelper.setFloat(copy.nbt, "damage", damage + damage * -((float)owner.field_70181_x));
            EntityPlaceableSmash spawn = new EntityPlaceableSmash(owner.field_70170_p, owner, copy, 10);
            spawn.func_70107_b(owner.field_70165_t, owner.field_70163_u, owner.field_70161_v);
            spawn.setRadius(range);
            owner.field_70170_p.func_72838_d((Entity)spawn);
            this.unapply(owner, (SkillData)data);
            this.async(owner, (SkillData)data);
        });
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onKeyPress(InputEvent.KeyInputEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        Capabilities.get((Entity)player).flatMap(c -> c.getOwned(this)).ifPresent(skillInfo -> {
            AbilityInfo abilityInfo = (AbilityInfo)skillInfo;
            if (abilityInfo.hasCooldown()) {
                return;
            }
            if (KeyBounds.smash.func_151470_d() && !player.field_70122_E) {
                Capabilities.endurance((Entity)player).ifPresent(endurance -> {
                    int amount = ModAttributes.ENDURANCE.getEnduranceDrain(this);
                    if (endurance.getEndurance() - (double)amount >= 0.0) {
                        PacketHelper.sendSkillUseRequestPacket(player, this);
                    }
                });
            }
        });
    }

    public int getLevel(SkillInfo.IInfoUpgradeable info) {
        return info.getLevel();
    }

    public int getMaxLevel() {
        return Configuration.getSyncValues().maxLevel;
    }

    public double getRange(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().range, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalRange;
        return result * this.getEffectiveness();
    }

    public int getCooldown(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().cooldown, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalCooldown;
        return (int)(result * this.getEffectiveness());
    }

    public int getTime(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().time, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalTime;
        return (int)(result * this.getEffectiveness());
    }

    public double getEffectiveness() {
        return Configuration.getSyncValues().effectiveness * CommonConfig.getSyncValues().skill.globalEffectiveness;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDescription(List<String> description) {
        Capabilities.get((Entity)Minecraft.func_71410_x().field_71439_g).ifPresent(c -> {
            if (c.isOwned(this)) {
                if (!GuiScreen.func_146272_n()) {
                    description.add("");
                    description.add("Hold SHIFT for stats.");
                } else {
                    c.getOwned(this).ifPresent(skillInfo -> {
                        AbilityInfo abilityInfo = (AbilityInfo)skillInfo;
                        description.clear();
                        description.add("Endurance Drain: " + ModAttributes.ENDURANCE.getEnduranceDrain(this));
                        description.add("");
                        if (abilityInfo.getLevel() >= this.getMaxLevel()) {
                            description.add("Max Level:");
                        } else {
                            description.add("Current Level:");
                        }
                        description.add("Cooldown: " + TextHelper.format2FloatPoint((double)this.getCooldown(abilityInfo) / 20.0) + "s");
                        description.add("Range: " + TextHelper.format2FloatPoint(this.getRange(abilityInfo)) + " Blocks");
                        description.add("Duration: " + TextHelper.format2FloatPoint((double)this.getTime(abilityInfo) / 20.0) + "s");
                        if (abilityInfo.getLevel() < this.getMaxLevel()) {
                            AbilityInfo infoNew = new AbilityInfo(abilityInfo.serializeNBT());
                            infoNew.setLevel(infoNew.getLevel() + 1);
                            description.add("");
                            description.add("Next Level:");
                            description.add("Cooldown: " + TextHelper.format2FloatPoint((double)this.getCooldown(infoNew) / 20.0) + "s");
                            description.add("Range: " + TextHelper.format2FloatPoint(this.getRange(infoNew)) + " Blocks");
                            description.add("Duration: " + TextHelper.format2FloatPoint((double)this.getTime(infoNew) / 20.0) + "s");
                        }
                    });
                }
            }
        });
    }

    @Override
    public int getCostIncrement(EntityLivingBase entity, int total) {
        Optional<AdvancementCapability> optional = Capabilities.advancement((Entity)entity);
        if (optional.isPresent()) {
            AdvancementCapability advancement = optional.get();
            List<Skill> skillUnlockOrder = Arrays.asList(advancement.skillUnlockOrder);
            int index = skillUnlockOrder.indexOf(ModAbilities.DASH);
            if (index == -1) {
                index = advancement.skillUnlockOrder.length;
            }
            return (int)((double)total * (1.0 + (double)index * CommonConfig.getSyncValues().advancement.xp.costIncrement));
        }
        return total;
    }

    @Override
    public int getUpgradeCost(@Nullable AbilityInfo info) {
        int level = info != null ? this.getLevel(info) + 1 : 0;
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().advancement.upgrade, level, levelMax);
        return (int)(func * CommonConfig.getSyncValues().advancement.xp.globalCostMultiplier);
    }

    @Override
    public void initSyncConfig() {
        Configuration.getSyncValues().maxLevel = Configuration.getValues().maxLevel;
        Configuration.getSyncValues().cooldown = Configuration.getValues().cooldown;
        Configuration.getSyncValues().time = Configuration.getValues().time;
        Configuration.getSyncValues().range = Configuration.getValues().range;
        Configuration.getSyncValues().effectiveness = Configuration.getValues().effectiveness;
        Configuration.getSyncValues().advancement.upgrade = Configuration.getValues().advancement.upgrade;
    }

    @Override
    public void writeSyncConfig(NBTTagCompound compound) {
        compound.func_74768_a("maxLevel", Configuration.getValues().maxLevel);
        NBTHelper.setArray(compound, "cooldown", Configuration.getValues().cooldown);
        NBTHelper.setArray(compound, "time", Configuration.getValues().time);
        NBTHelper.setArray(compound, "range", Configuration.getValues().range);
        compound.func_74780_a("effectiveness", Configuration.getValues().effectiveness);
        NBTHelper.setArray(compound, "advancement.upgrade", Configuration.getValues().advancement.upgrade);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readSyncConfig(NBTTagCompound compound) {
        Configuration.getSyncValues().maxLevel = compound.func_74762_e("maxLevel");
        Configuration.getSyncValues().cooldown = NBTHelper.getArray(compound, "cooldown");
        Configuration.getSyncValues().time = NBTHelper.getArray(compound, "time");
        Configuration.getSyncValues().range = NBTHelper.getArray(compound, "range");
        Configuration.getSyncValues().effectiveness = compound.func_74769_h("effectiveness");
        Configuration.getSyncValues().advancement.upgrade = NBTHelper.getArray(compound, "advancement.upgrade");
    }

    @Config(modid="enderskills", name="enderskills/Ability/smash")
    public static class Configuration {
        @Config.Comment(value={"Ability Values"})
        @Config.LangKey(value="enderskills.config.smash")
        public static Values CONFIG = new Values();
        @Config.Ignore
        protected static Values CONFIG_SYNC = new Values();

        public static Values getValues() {
            return CONFIG;
        }

        public static Values getSyncValues() {
            return CONFIG_SYNC;
        }

        public static class Values {
            @Config.Comment(value={"Skill specific Advancement Configuration"})
            public final Advancement advancement = new Advancement();
            @Config.Comment(value={"Max level obtainable"})
            @Config.RangeInt(min=0)
            public int maxLevel = 5;
            @Config.Comment(value={"Cooldown Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] cooldown = new String[]{"(0+){36 * 20 + 10 * 20 * (1 - ((1 - (e^(-2.1 * (x/2)))) / (1 - e^(-2.1))))}", "(3+){32 * 20 + 4 * 20 * (1- (((e^(0.1 * ((x-2) / (y-2))) - 1)/((e^0.1) - 1))))}", "(5){(28 * 20)}"};
            @Config.Comment(value={"Duration Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] time = new String[]{"(0+){3 * 20 + 3 * 20 * (1 - (e^(-2.1 * (x/24)))) / (1 - e^(-2.1))}", "(25+){6 * 20 + 1 * 20 * ((e^(0.1 * ((x - 24) / (y - 24))) - 1)/((e^0.1) - 1))}", "(50){8 * 20}"};
            @Config.Comment(value={"Range Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] range = new String[]{"(0+){4 + 4 * (1 - (e^(-2.1 * (x/24)))) / (1 - e^(-2.1))}", "(25+){8 + 2 * ((e^(0.1 * ((x - 24) / (y - 24))) - 1)/((e^0.1) - 1))}"};
            @Config.Comment(value={"Effectiveness Modifier"})
            @Config.RangeDouble
            public double effectiveness = 1.0;

            public static class Advancement {
                @Config.Comment(value={"Function f(x)=? where 'x' is [Next Level] and 'y' is [Max Level], XP Cost is in units [NOT LEVELS]"})
                public String[] upgrade = new String[]{"(0){600}", "(1+){4 * x}", "(50){4 * x + 4 * x * 0.1}"};
            }
        }
    }
}

