/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.skill.ability.mobility.wind;

import arekkuusu.enderskills.api.capability.AdvancementCapability;
import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.api.capability.data.SkillData;
import arekkuusu.enderskills.api.capability.data.SkillInfo;
import arekkuusu.enderskills.api.capability.data.nbt.WatcherManager;
import arekkuusu.enderskills.api.helper.ExpressionHelper;
import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.client.gui.data.ISkillAdvancement;
import arekkuusu.enderskills.client.util.helper.TextHelper;
import arekkuusu.enderskills.common.CommonConfig;
import arekkuusu.enderskills.common.skill.DynamicModifier;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.ModAttributes;
import arekkuusu.enderskills.common.skill.SkillHelper;
import arekkuusu.enderskills.common.skill.ability.AbilityInfo;
import arekkuusu.enderskills.common.skill.ability.BaseAbility;
import arekkuusu.enderskills.common.sound.ModSounds;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SpeedBoost
extends BaseAbility
implements ISkillAdvancement {
    public static final DynamicModifier SPEED_ATTRIBUTE = new DynamicModifier("c6668d81-8274-418e-b598-37b2cabd3813", "enderskills:speed_boost", SharedMonsterAttributes.field_111263_d);
    public static final String NBT_STEP = "enderskills:stepHeight";
    public static final float STEP_HEIGHT = 0.60001f;
    public static final float STEP_HEIGHT_SNEAK = 1.25f;
    public static final float STEP_HEIGHT_DEFAULT = 0.6f;
    public static final List<String> STEP_LIST = new ArrayList<String>();

    public SpeedBoost() {
        super("speed_boost", new BaseAbility.AbilityProperties());
        ((BaseAbility.AbilityProperties)this.getProperties()).setCooldownGetter(this::getCooldown).setMaxLevelGetter(this::getMaxLevel);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void use(EntityLivingBase owner, SkillInfo skillInfo) {
        if (((SkillInfo.IInfoCooldown)((Object)skillInfo)).hasCooldown() || this.isClientWorld(owner)) {
            return;
        }
        AbilityInfo abilityInfo = (AbilityInfo)skillInfo;
        if (this.isActionable(owner) && this.canActivate(owner)) {
            if (!(owner instanceof EntityPlayer) || !((EntityPlayer)owner).field_71075_bZ.field_75098_d) {
                abilityInfo.setCooldown(this.getCooldown(abilityInfo));
            }
            int time = this.getTime(abilityInfo);
            double speed = this.getSpeed(abilityInfo);
            NBTTagCompound compound = new NBTTagCompound();
            NBTHelper.setEntity(compound, (Entity)owner, "owner");
            NBTHelper.setDouble(compound, "speed", speed);
            SkillData data = SkillData.of(this).by((Entity)owner).with(time).put(compound, new WatcherManager.Watcher[0]).overrides(SkillData.Overrides.EQUAL).create();
            this.apply(owner, data);
            this.sync(owner, data);
            this.sync(owner);
        }
    }

    @Override
    public void begin(EntityLivingBase entity, SkillData data) {
        if (entity.field_70170_p instanceof WorldServer) {
            ((WorldServer)entity.field_70170_p).func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, ModSounds.SPEED, SoundCategory.PLAYERS, 1.0f, (1.0f + (entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        String key = this.entityToString((Entity)entity);
        if (STEP_LIST.contains(key)) {
            if (SkillHelper.isActiveFrom((Entity)entity, this)) {
                SkillHelper.getActiveFrom((Entity)entity, this).ifPresent(data -> {
                    if (!this.isClientWorld(event.getEntityLiving())) {
                        double speed = NBTHelper.getDouble(data.nbt, "speed");
                        SPEED_ATTRIBUTE.apply(entity, speed);
                    }
                    if (entity.getEntityData().func_74760_g(NBT_STEP) == 0.6f) {
                        entity.field_70138_W = entity.func_70093_af() ? 0.60001f : 1.25f;
                    } else if (entity.field_70138_W == 0.6f) {
                        entity.getEntityData().func_74776_a(NBT_STEP, entity.field_70138_W);
                    }
                });
            } else {
                if (!this.isClientWorld(event.getEntityLiving())) {
                    SPEED_ATTRIBUTE.remove(entity);
                }
                if (entity.field_70138_W == 0.60001f || entity.field_70138_W == 1.25f) {
                    entity.field_70138_W = 0.6f;
                }
                STEP_LIST.remove(key);
            }
        } else if (SkillHelper.isActiveFrom((Entity)entity, this)) {
            STEP_LIST.add(key);
            entity.getEntityData().func_74776_a(NBT_STEP, entity.field_70138_W);
        }
    }

    public String entityToString(Entity entity) {
        return entity.func_110124_au().toString() + ":" + entity.field_70170_p.field_72995_K;
    }

    public int getLevel(SkillInfo.IInfoUpgradeable info) {
        return info.getLevel();
    }

    public int getMaxLevel() {
        return Configuration.getSyncValues().maxLevel;
    }

    public float getSpeed(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().extra.speed, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.extra.globalNeutralEffect;
        return (float)(result * this.getEffectiveness());
    }

    public int getCooldown(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().cooldown, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalCooldown;
        return (int)(result * this.getEffectiveness());
    }

    public int getTime(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().time, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalTime;
        return (int)(result * this.getEffectiveness());
    }

    public double getEffectiveness() {
        return Configuration.getSyncValues().effectiveness * CommonConfig.getSyncValues().skill.globalEffectiveness;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDescription(List<String> description) {
        Capabilities.get((Entity)Minecraft.func_71410_x().field_71439_g).ifPresent(c -> {
            if (c.isOwned(this)) {
                if (!GuiScreen.func_146272_n()) {
                    description.add("");
                    description.add("Hold SHIFT for stats.");
                } else {
                    c.getOwned(this).ifPresent(skillInfo -> {
                        AbilityInfo abilityInfo = (AbilityInfo)skillInfo;
                        description.clear();
                        description.add("Endurance Drain: " + ModAttributes.ENDURANCE.getEnduranceDrain(this));
                        description.add("");
                        if (abilityInfo.getLevel() >= this.getMaxLevel()) {
                            description.add("Max Level:");
                        } else {
                            description.add("Current Level:");
                        }
                        description.add("Cooldown: " + TextHelper.format2FloatPoint((double)this.getCooldown(abilityInfo) / 20.0) + "s");
                        description.add("Duration: " + TextHelper.format2FloatPoint((double)this.getTime(abilityInfo) / 20.0) + "s");
                        description.add("Boost: +" + TextHelper.format2FloatPoint(this.getSpeed(abilityInfo) * 100.0f) + "%");
                        if (abilityInfo.getLevel() < this.getMaxLevel()) {
                            AbilityInfo infoNew = new AbilityInfo(abilityInfo.serializeNBT());
                            infoNew.setLevel(infoNew.getLevel() + 1);
                            description.add("");
                            description.add("Next Level:");
                            description.add("Cooldown: " + TextHelper.format2FloatPoint((double)this.getCooldown(infoNew) / 20.0) + "s");
                            description.add("Duration: " + TextHelper.format2FloatPoint((double)this.getTime(infoNew) / 20.0) + "s");
                            description.add("Boost: +" + TextHelper.format2FloatPoint(this.getSpeed(infoNew) * 100.0f) + "%");
                        }
                    });
                }
            }
        });
    }

    @Override
    public int getCostIncrement(EntityLivingBase entity, int total) {
        Optional<AdvancementCapability> optional = Capabilities.advancement((Entity)entity);
        if (optional.isPresent()) {
            AdvancementCapability advancement = optional.get();
            List<Skill> skillUnlockOrder = Arrays.asList(advancement.skillUnlockOrder);
            int index = skillUnlockOrder.indexOf(ModAbilities.DASH);
            if (index == -1) {
                index = advancement.skillUnlockOrder.length;
            }
            return (int)((double)total * (1.0 + (double)index * CommonConfig.getSyncValues().advancement.xp.costIncrement));
        }
        return total;
    }

    @Override
    public int getUpgradeCost(@Nullable AbilityInfo info) {
        int level = info != null ? this.getLevel(info) + 1 : 0;
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().advancement.upgrade, level, levelMax);
        return (int)(func * CommonConfig.getSyncValues().advancement.xp.globalCostMultiplier);
    }

    @Override
    public void initSyncConfig() {
        Configuration.getSyncValues().maxLevel = Configuration.getValues().maxLevel;
        Configuration.getSyncValues().cooldown = Configuration.getValues().cooldown;
        Configuration.getSyncValues().time = Configuration.getValues().time;
        Configuration.getSyncValues().effectiveness = Configuration.getValues().effectiveness;
        Configuration.getSyncValues().extra.speed = Configuration.getValues().extra.speed;
        Configuration.getSyncValues().advancement.upgrade = Configuration.getValues().advancement.upgrade;
    }

    @Override
    public void writeSyncConfig(NBTTagCompound compound) {
        compound.func_74768_a("maxLevel", Configuration.getValues().maxLevel);
        NBTHelper.setArray(compound, "cooldown", Configuration.getValues().cooldown);
        NBTHelper.setArray(compound, "time", Configuration.getValues().time);
        compound.func_74780_a("effectiveness", Configuration.getValues().effectiveness);
        NBTHelper.setArray(compound, "extra.speed", Configuration.getValues().extra.speed);
        NBTHelper.setArray(compound, "advancement.upgrade", Configuration.getValues().advancement.upgrade);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readSyncConfig(NBTTagCompound compound) {
        Configuration.getSyncValues().maxLevel = compound.func_74762_e("maxLevel");
        Configuration.getSyncValues().cooldown = NBTHelper.getArray(compound, "cooldown");
        Configuration.getSyncValues().time = NBTHelper.getArray(compound, "time");
        Configuration.getSyncValues().effectiveness = compound.func_74769_h("effectiveness");
        Configuration.getSyncValues().extra.speed = NBTHelper.getArray(compound, "extra.speed");
        Configuration.getSyncValues().advancement.upgrade = NBTHelper.getArray(compound, "advancement.upgrade");
    }

    @Config(modid="enderskills", name="enderskills/Ability/speed_boost")
    public static class Configuration {
        @Config.Comment(value={"Ability Values"})
        @Config.LangKey(value="enderskills.config.speed_boost")
        public static Values CONFIG = new Values();
        @Config.Ignore
        protected static Values CONFIG_SYNC = new Values();

        public static Values getValues() {
            return CONFIG;
        }

        public static Values getSyncValues() {
            return CONFIG_SYNC;
        }

        public static class Values {
            @Config.Comment(value={"Skill specific extra Configuration"})
            public final Extra extra = new Extra();
            @Config.Comment(value={"Skill specific Advancement Configuration"})
            public final Advancement advancement = new Advancement();
            @Config.Comment(value={"Max level obtainable"})
            @Config.RangeInt(min=0)
            public int maxLevel = 50;
            @Config.Comment(value={"Cooldown Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] cooldown = new String[]{"(0+){105 * 20 + 15 * 20 * (1 - ((1 - (e^(-2.1 * (x/24)))) / (1 - e^(-2.1))))}", "(25+){100 * 20 + 5 * 20 * (1- (((e^(0.1 * ((x-24) / (y-24))) - 1)/((e^0.1) - 1))))}", "(50){90 * 20}"};
            @Config.Comment(value={"Duration Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] time = new String[]{"(0+){10 * 20 + 13 * 20 * (1 - (e^(-2.1 * (x/24)))) / (1 - e^(-2.1))}", "(25+){28 * 20 + 5 * 20 * ((e^(0.1 * ((x - 24) / (y - 24))) - 1)/((e^0.1) - 1))}", "(50){30 * 20}"};
            @Config.Comment(value={"Effectiveness Modifier"})
            @Config.RangeDouble
            public double effectiveness = 1.0;

            public static class Advancement {
                @Config.Comment(value={"Function f(x)=? where 'x' is [Next Level] and 'y' is [Max Level], XP Cost is in units [NOT LEVELS]"})
                public String[] upgrade = new String[]{"(0){900}", "(1+){4 * x}", "(50){4 * x + 4 * x * 0.1}"};
            }

            public static class Extra {
                @Config.Comment(value={"Speed Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
                public String[] speed = new String[]{"(0+){1 + ((e^(2.1 * (x / y)) - 1)/((e^2.1) - 1)) * (4 - 1)}"};
            }
        }
    }
}

