/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.skill.ability.offence.blood;

import arekkuusu.enderskills.api.capability.AdvancementCapability;
import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.api.capability.data.SkillData;
import arekkuusu.enderskills.api.capability.data.SkillInfo;
import arekkuusu.enderskills.api.capability.data.nbt.WatcherManager;
import arekkuusu.enderskills.api.helper.ExpressionHelper;
import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.api.helper.TeamHelper;
import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.client.gui.data.ISkillAdvancement;
import arekkuusu.enderskills.client.sounds.BloodPoolSound;
import arekkuusu.enderskills.client.util.helper.TextHelper;
import arekkuusu.enderskills.common.CommonConfig;
import arekkuusu.enderskills.common.entity.data.IExpand;
import arekkuusu.enderskills.common.entity.data.IImpact;
import arekkuusu.enderskills.common.entity.data.ILoopSound;
import arekkuusu.enderskills.common.entity.data.IScanEntities;
import arekkuusu.enderskills.common.entity.placeable.EntityPlaceableBloodPool;
import arekkuusu.enderskills.common.entity.placeable.EntityPlaceableData;
import arekkuusu.enderskills.common.entity.throwable.EntityThrowableData;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.ModAttributes;
import arekkuusu.enderskills.common.skill.ModEffects;
import arekkuusu.enderskills.common.skill.ability.AbilityInfo;
import arekkuusu.enderskills.common.skill.ability.BaseAbility;
import arekkuusu.enderskills.common.sound.ModSounds;
import com.google.common.base.Predicate;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BloodPool
extends BaseAbility
implements IImpact,
ILoopSound,
IExpand,
IScanEntities,
ISkillAdvancement {
    public BloodPool() {
        super("blood_pool", new BaseAbility.AbilityProperties());
        ((BaseAbility.AbilityProperties)this.getProperties()).setCooldownGetter(this::getCooldown).setMaxLevelGetter(this::getMaxLevel);
    }

    @Override
    public void use(EntityLivingBase owner, SkillInfo skillInfo) {
        if (((SkillInfo.IInfoCooldown)((Object)skillInfo)).hasCooldown() || this.isClientWorld(owner)) {
            return;
        }
        AbilityInfo abilityInfo = (AbilityInfo)skillInfo;
        if (this.isActionable(owner) && this.canActivate(owner)) {
            if (!(owner instanceof EntityPlayer) || !((EntityPlayer)owner).field_71075_bZ.field_75098_d) {
                abilityInfo.setCooldown(this.getCooldown(abilityInfo));
            }
            double range = this.getPoolRange(abilityInfo);
            int time = this.getPoolDuration(abilityInfo);
            double dot = this.getDoT(abilityInfo);
            int dotDuration = this.getTime(abilityInfo);
            NBTTagCompound compound = new NBTTagCompound();
            NBTHelper.setEntity(compound, (Entity)owner, "owner");
            NBTHelper.setDouble(compound, "range", range);
            NBTHelper.setInteger(compound, "time", time);
            NBTHelper.setDouble(compound, "dot", dot);
            NBTHelper.setInteger(compound, "dotDuration", dotDuration);
            SkillData data = SkillData.of(this).by((Entity)owner).put(compound, new WatcherManager.Watcher[0]).create();
            EntityThrowableData.throwFor(owner, 2.147483647E9, data, true);
            this.sync(owner);
            if (owner.field_70170_p instanceof WorldServer) {
                ((WorldServer)owner.field_70170_p).func_184148_a(null, owner.field_70165_t, owner.field_70163_u, owner.field_70161_v, ModSounds.BLOODPOOL, SoundCategory.PLAYERS, 1.0f, (1.0f + (owner.field_70170_p.field_73012_v.nextFloat() - owner.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            }
        }
    }

    @Override
    public void onImpact(Entity source, @Nullable EntityLivingBase owner, SkillData skillData, RayTraceResult trace) {
        if (trace.field_72313_a != RayTraceResult.Type.MISS) {
            Vec3d hitVector = trace.field_72307_f;
            int time = skillData.nbt.func_74762_e("time");
            double radius = skillData.nbt.func_74769_h("range");
            EntityPlaceableBloodPool spawn = new EntityPlaceableBloodPool(source.field_70170_p, owner, skillData, time);
            spawn.func_70107_b(hitVector.field_72450_a, hitVector.field_72448_b, hitVector.field_72449_c);
            spawn.setRadius(radius);
            spawn.spreadOnTerrain();
            source.field_70170_p.func_72838_d((Entity)spawn);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void makeSound(Entity source) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new BloodPoolSound((EntityPlaceableData)source));
    }

    @Override
    public AxisAlignedBB expand(Entity source, AxisAlignedBB bb, float amount) {
        return bb.func_72314_b((double)amount, 0.0, (double)amount);
    }

    @Override
    public List<Entity> getScan(Entity source, @Nullable EntityLivingBase owner, SkillData skillData, double size) {
        List entities = source.func_130014_f_().func_175647_a(Entity.class, source.func_174813_aQ(), (Predicate)TeamHelper.SELECTOR_ENEMY.apply((Object)owner));
        List<BlockPos> terrain = ((EntityPlaceableBloodPool)source).getTerrainBlocks();
        entities.removeIf(entity -> {
            BlockPos entityPos = entity.func_180425_c();
            boolean withinHeight = false;
            for (int i = 1; i <= 2; ++i) {
                BlockPos pos = entityPos.func_177979_c(i);
                if (!terrain.contains(pos)) continue;
                withinHeight = (double)pos.func_177956_o() - entity.field_70163_u <= 0.1;
                break;
            }
            return !withinHeight;
        });
        return entities;
    }

    @Override
    public void onScan(Entity source, @Nullable EntityLivingBase owner, EntityLivingBase target, SkillData skillData) {
        ModEffects.BLEEDING.set(target, skillData);
    }

    public int getLevel(SkillInfo.IInfoUpgradeable info) {
        return info.getLevel();
    }

    public int getMaxLevel() {
        return Configuration.getSyncValues().maxLevel;
    }

    public float getPoolRange(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().extra.poolRange, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalRange;
        return (float)(result * this.getEffectiveness());
    }

    public int getPoolDuration(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().extra.poolDuration, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalTime;
        return (int)(result * this.getEffectiveness());
    }

    public double getDoT(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().extra.dot, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.extra.globalNegativeEffect;
        return result * this.getEffectiveness();
    }

    public int getCooldown(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().cooldown, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalCooldown;
        return (int)(result * this.getEffectiveness());
    }

    public int getTime(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().time, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalTime;
        return (int)(result * this.getEffectiveness());
    }

    public double getEffectiveness() {
        return Configuration.getSyncValues().effectiveness * CommonConfig.getSyncValues().skill.globalEffectiveness;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDescription(List<String> description) {
        Capabilities.get((Entity)Minecraft.func_71410_x().field_71439_g).ifPresent(c -> {
            if (c.isOwned(this)) {
                if (!GuiScreen.func_146272_n()) {
                    description.add("");
                    description.add("Hold SHIFT for stats.");
                } else {
                    c.getOwned(this).ifPresent(skillInfo -> {
                        AbilityInfo abilityInfo = (AbilityInfo)skillInfo;
                        description.clear();
                        description.add("Endurance Drain: " + ModAttributes.ENDURANCE.getEnduranceDrain(this));
                        description.add("");
                        if (abilityInfo.getLevel() >= this.getMaxLevel()) {
                            description.add("Max Level:");
                        } else {
                            description.add("Current Level:");
                        }
                        description.add("Cooldown: " + TextHelper.format2FloatPoint((double)this.getCooldown(abilityInfo) / 20.0) + "s");
                        description.add("Bleed: " + TextHelper.format2FloatPoint(this.getTime(abilityInfo)) + "s");
                        description.add("Pool Duration: " + TextHelper.format2FloatPoint(this.getPoolDuration(abilityInfo)) + "s");
                        description.add("Pool Size: " + TextHelper.format2FloatPoint(this.getPoolRange(abilityInfo)) + " Blocks");
                        description.add("DoT: " + TextHelper.format2FloatPoint(this.getDoT(abilityInfo) / 2.0) + " Hearts");
                        if (abilityInfo.getLevel() < this.getMaxLevel()) {
                            AbilityInfo infoNew = new AbilityInfo(abilityInfo.serializeNBT());
                            infoNew.setLevel(infoNew.getLevel() + 1);
                            description.add("");
                            description.add("Next Level:");
                            description.add("Cooldown: " + TextHelper.format2FloatPoint((double)this.getCooldown(infoNew) / 20.0) + "s");
                            description.add("Bleed: " + TextHelper.format2FloatPoint(this.getTime(infoNew)) + "s");
                            description.add("Pool Duration: " + TextHelper.format2FloatPoint(this.getPoolDuration(infoNew)) + "s");
                            description.add("Pool Size: " + TextHelper.format2FloatPoint(this.getPoolRange(infoNew)) + " Blocks");
                            description.add("DoT: " + TextHelper.format2FloatPoint(this.getDoT(infoNew) / 2.0) + " Hearts");
                        }
                    });
                }
            }
        });
    }

    @Override
    public int getCostIncrement(EntityLivingBase entity, int total) {
        Optional<AdvancementCapability> optional = Capabilities.advancement((Entity)entity);
        if (optional.isPresent()) {
            AdvancementCapability advancement = optional.get();
            List<Skill> skillUnlockOrder = Arrays.asList(advancement.skillUnlockOrder);
            int index = skillUnlockOrder.indexOf(ModAbilities.BLEED);
            if (index == -1) {
                index = advancement.skillUnlockOrder.length;
            }
            return (int)((double)total * (1.0 + (double)index * CommonConfig.getSyncValues().advancement.xp.costIncrement));
        }
        return total;
    }

    @Override
    public int getUpgradeCost(@Nullable AbilityInfo info) {
        int level = info != null ? this.getLevel(info) + 1 : 0;
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().advancement.upgrade, level, levelMax);
        return (int)(func * CommonConfig.getSyncValues().advancement.xp.globalCostMultiplier);
    }

    @Override
    public void initSyncConfig() {
        Configuration.getSyncValues().maxLevel = Configuration.getValues().maxLevel;
        Configuration.getSyncValues().cooldown = Configuration.getValues().cooldown;
        Configuration.getSyncValues().time = Configuration.getValues().time;
        Configuration.getSyncValues().effectiveness = Configuration.getValues().effectiveness;
        Configuration.getSyncValues().extra.dot = Configuration.getValues().extra.dot;
        Configuration.getSyncValues().extra.poolDuration = Configuration.getValues().extra.poolDuration;
        Configuration.getSyncValues().extra.poolRange = Configuration.getValues().extra.poolRange;
        Configuration.getSyncValues().advancement.upgrade = Configuration.getValues().advancement.upgrade;
    }

    @Override
    public void writeSyncConfig(NBTTagCompound compound) {
        compound.func_74768_a("maxLevel", Configuration.getValues().maxLevel);
        NBTHelper.setArray(compound, "cooldown", Configuration.getValues().cooldown);
        NBTHelper.setArray(compound, "time", Configuration.getValues().time);
        compound.func_74780_a("effectiveness", Configuration.getValues().effectiveness);
        NBTHelper.setArray(compound, "extra.poolDuration", Configuration.getValues().extra.poolDuration);
        NBTHelper.setArray(compound, "extra.poolRange", Configuration.getValues().extra.poolRange);
        NBTHelper.setArray(compound, "advancement.upgrade", Configuration.getValues().advancement.upgrade);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readSyncConfig(NBTTagCompound compound) {
        Configuration.getSyncValues().maxLevel = compound.func_74762_e("maxLevel");
        Configuration.getSyncValues().cooldown = NBTHelper.getArray(compound, "cooldown");
        Configuration.getSyncValues().time = NBTHelper.getArray(compound, "time");
        Configuration.getSyncValues().effectiveness = compound.func_74769_h("effectiveness");
        Configuration.getSyncValues().extra.poolDuration = NBTHelper.getArray(compound, "extra.poolDuration");
        Configuration.getSyncValues().extra.poolRange = NBTHelper.getArray(compound, "extra.poolRange");
        Configuration.getSyncValues().advancement.upgrade = NBTHelper.getArray(compound, "advancement.upgrade");
    }

    @Config(modid="enderskills", name="enderskills/Ability/blood_pool")
    public static class Configuration {
        @Config.Comment(value={"Ability Values"})
        @Config.LangKey(value="enderskills.config.blood_pool")
        public static Values CONFIG = new Values();
        @Config.Ignore
        protected static Values CONFIG_SYNC = new Values();

        public static Values getValues() {
            return CONFIG;
        }

        public static Values getSyncValues() {
            return CONFIG_SYNC;
        }

        public static class Values {
            @Config.Comment(value={"Skill specific extra Configuration"})
            public final Extra extra = new Extra();
            @Config.Comment(value={"Skill specific Advancement Configuration"})
            public final Advancement advancement = new Advancement();
            @Config.Comment(value={"Max level obtainable"})
            @Config.RangeInt(min=0)
            public int maxLevel = 5;
            @Config.Comment(value={"Cooldown Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] cooldown = new String[]{"(0+){40 * 20 + 20 * 20 * (1 - ((1 - (e^(-1.1 * (x/2)))) / (1 - e^(-1.1))))}", "(3+){35 * 20 + 5 * 20 * (1- (((e^(0.1 * ((x-2) / (y-2))) - 1)/((e^0.1) - 1))))}", "(5){30 * 20}"};
            @Config.Comment(value={"Duration Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] time = new String[]{"(0+){3 * 20}"};
            @Config.Comment(value={"Effectiveness Modifier"})
            @Config.RangeDouble
            public double effectiveness = 1.0;

            public static class Advancement {
                @Config.Comment(value={"Function f(x)=? where 'x' is [Next Level] and 'y' is [Max Level], XP Cost is in units [NOT LEVELS]"})
                public String[] upgrade = new String[]{"(0){300}", "(1+){4 * x}", "(50){4 * x + 4 * x * 0.1}"};
            }

            public static class Extra {
                @Config.Comment(value={"Damage Over Time Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
                public String[] dot = new String[]{"(0+){8 + ((e^(0.1 * (x / 2)) - 1)/((e^0.1) - 1)) * (13.62 - 8)}", "(3+){13.62 + ((e^(1.25 * ((x-2) / (y-2))) - 1)/((e^1.25) - 1)) * (29 - 13.62)}", "(5){30}"};
                @Config.Comment(value={"Pool Duration Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
                public String[] poolDuration = new String[]{"(0+){6 * 20 + 9 * 20 * (1 - (e^(-2.1 * (x/2)))) / (1 - e^(-2.1))}", "(3+){15 * 20 + 4 * 20 * ((e^(0.1 * ((x - 2) / (y - 2))) - 1)/((e^0.1) - 1))}", "(5){20 * 20}"};
                @Config.Comment(value={"Pool Range Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
                public String[] poolRange = new String[]{"(0+){2 + 1 * (1 - (e^(-2.1 * (x/2)))) / (1 - e^(-2.1))}", "(3+){3 + 1 * ((e^(0.1 * ((x - 2) / (y - 2))) - 1)/((e^0.1) - 1))}"};
            }
        }
    }
}

