/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.skill.ability.offence.blood;

import arekkuusu.enderskills.api.capability.AdvancementCapability;
import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.api.capability.data.SkillData;
import arekkuusu.enderskills.api.capability.data.SkillInfo;
import arekkuusu.enderskills.api.capability.data.nbt.WatcherManager;
import arekkuusu.enderskills.api.event.SkillDamageEvent;
import arekkuusu.enderskills.api.event.SkillDamageSource;
import arekkuusu.enderskills.api.helper.ExpressionHelper;
import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.api.helper.RayTraceHelper;
import arekkuusu.enderskills.api.helper.TeamHelper;
import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.client.gui.data.ISkillAdvancement;
import arekkuusu.enderskills.client.util.helper.TextHelper;
import arekkuusu.enderskills.common.CommonConfig;
import arekkuusu.enderskills.common.EnderSkills;
import arekkuusu.enderskills.common.entity.data.IImpact;
import arekkuusu.enderskills.common.entity.throwable.EntityThrowableData;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.ModAttributes;
import arekkuusu.enderskills.common.skill.ModEffects;
import arekkuusu.enderskills.common.skill.SkillHelper;
import arekkuusu.enderskills.common.skill.ability.AbilityInfo;
import arekkuusu.enderskills.common.skill.ability.BaseAbility;
import arekkuusu.enderskills.common.sound.ModSounds;
import com.google.common.base.Predicate;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Contaminate
extends BaseAbility
implements IImpact,
ISkillAdvancement {
    public Contaminate() {
        super("contaminate", new BaseAbility.AbilityProperties());
        ((BaseAbility.AbilityProperties)this.getProperties()).setCooldownGetter(this::getCooldown).setMaxLevelGetter(this::getMaxLevel);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void use(EntityLivingBase owner, SkillInfo skillInfo) {
        if (this.isClientWorld(owner)) {
            return;
        }
        AbilityInfo abilityInfo = (AbilityInfo)skillInfo;
        double distance = this.getRange(abilityInfo);
        if (this.isActionable(owner) && this.canActivate(owner)) {
            if (!(owner instanceof EntityPlayer) || !((EntityPlayer)owner).field_71075_bZ.field_75098_d) {
                abilityInfo.setCooldown(this.getCooldown(abilityInfo));
            }
            int time = this.getTime(abilityInfo);
            NBTTagCompound compound = new NBTTagCompound();
            NBTHelper.setEntity(compound, (Entity)owner, "owner");
            NBTHelper.setDouble(compound, "dot", this.getDoT(abilityInfo));
            NBTHelper.setInteger(compound, "time", this.getTime(abilityInfo));
            NBTHelper.setDouble(compound, "damage", this.getDamage(abilityInfo));
            SkillData data = SkillData.of(this).with(time).put(compound, new WatcherManager.Watcher[0]).create();
            EntityThrowableData.throwFor(owner, distance, data, false);
            this.sync(owner);
            if (owner.field_70170_p instanceof WorldServer) {
                ((WorldServer)owner.field_70170_p).func_184148_a(null, owner.field_70165_t, owner.field_70163_u, owner.field_70161_v, ModSounds.CONTAMINATE, SoundCategory.PLAYERS, 1.0f, (1.0f + (owner.field_70170_p.field_73012_v.nextFloat() - owner.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            }
        }
    }

    @Override
    public void onImpact(Entity source, @Nullable EntityLivingBase owner, SkillData skillData, RayTraceResult trace) {
        if (RayTraceHelper.isEntityTrace(trace, (Predicate<Entity>)((Predicate)TeamHelper.SELECTOR_ENEMY.apply((Object)owner)))) {
            this.apply((EntityLivingBase)trace.field_72308_g, skillData);
            this.sync((EntityLivingBase)trace.field_72308_g, skillData);
        }
    }

    @Override
    public void begin(EntityLivingBase entity, SkillData data) {
        if (this.isClientWorld(entity)) {
            return;
        }
        EntityLivingBase owner = SkillHelper.getOwner(data);
        double damage = data.nbt.func_74769_h("damage");
        SkillDamageSource source = new SkillDamageSource("skill", (Entity)owner);
        SkillDamageEvent event = new SkillDamageEvent(owner, this, (DamageSource)source, damage);
        MinecraftForge.EVENT_BUS.post((Event)event);
        entity.func_70097_a(event.getSource(), event.toFloat());
    }

    @Override
    public void update(EntityLivingBase entity, SkillData data, int tick) {
        if (this.isClientWorld(entity)) {
            return;
        }
        EntityLivingBase owner = SkillHelper.getOwner(data);
        double damage = data.nbt.func_74769_h("dot");
        SkillDamageSource source = new SkillDamageSource("indirectSkill", (Entity)owner);
        source.func_82726_p();
        SkillDamageEvent event = new SkillDamageEvent(owner, this, (DamageSource)source, damage);
        MinecraftForge.EVENT_BUS.post((Event)event);
        entity.func_70097_a(event.getSource(), event.toFloat() / (float)data.time);
        EnderSkills.getProxy().addToQueue(() -> ModEffects.SLOWED.set(entity, data, 0.6));
    }

    public int getLevel(SkillInfo.IInfoUpgradeable info) {
        return info.getLevel();
    }

    public int getMaxLevel() {
        return Configuration.getSyncValues().maxLevel;
    }

    public double getDoT(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().extra.dot, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.extra.globalNegativeEffect;
        return result * this.getEffectiveness();
    }

    public double getDamage(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().extra.damage, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.extra.globalNegativeEffect;
        return result * this.getEffectiveness();
    }

    public double getRange(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().range, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalRange;
        return result * this.getEffectiveness();
    }

    public int getCooldown(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().cooldown, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalCooldown;
        return (int)(result * this.getEffectiveness());
    }

    public int getTime(AbilityInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().time, level, levelMax);
        double result = func * CommonConfig.getSyncValues().skill.globalTime;
        return (int)(result * this.getEffectiveness());
    }

    public double getEffectiveness() {
        return Configuration.getSyncValues().effectiveness * CommonConfig.getSyncValues().skill.globalEffectiveness;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDescription(List<String> description) {
        Capabilities.get((Entity)Minecraft.func_71410_x().field_71439_g).ifPresent(c -> {
            if (c.isOwned(this)) {
                if (!GuiScreen.func_146272_n()) {
                    description.add("");
                    description.add("Hold SHIFT for stats.");
                } else {
                    c.getOwned(this).ifPresent(skillInfo -> {
                        AbilityInfo abilityInfo = (AbilityInfo)skillInfo;
                        description.clear();
                        description.add("Endurance Drain: " + ModAttributes.ENDURANCE.getEnduranceDrain(this));
                        description.add("");
                        if (abilityInfo.getLevel() >= this.getMaxLevel()) {
                            description.add("Max Level:");
                        } else {
                            description.add("Current Level:");
                        }
                        description.add("Cooldown: " + TextHelper.format2FloatPoint((double)this.getCooldown(abilityInfo) / 20.0) + "s");
                        description.add("Range: " + TextHelper.format2FloatPoint(this.getRange(abilityInfo)) + " Blocks");
                        description.add("Duration: " + TextHelper.format2FloatPoint((double)this.getTime(abilityInfo) / 20.0) + "s");
                        description.add("Initial Damage: " + TextHelper.format2FloatPoint(this.getDamage(abilityInfo) / 2.0) + " Hearts");
                        description.add("DoT: " + TextHelper.format2FloatPoint(this.getDoT(abilityInfo) / 2.0) + " Hearts");
                        if (abilityInfo.getLevel() < this.getMaxLevel()) {
                            AbilityInfo infoNew = new AbilityInfo(abilityInfo.serializeNBT());
                            infoNew.setLevel(infoNew.getLevel() + 1);
                            description.add("");
                            description.add("Next Level:");
                            description.add("Cooldown: " + TextHelper.format2FloatPoint((double)this.getCooldown(infoNew) / 20.0) + "s");
                            description.add("Range: " + TextHelper.format2FloatPoint(this.getRange(infoNew)) + " Blocks");
                            description.add("Duration: " + TextHelper.format2FloatPoint((double)this.getTime(infoNew) / 20.0) + "s");
                            description.add("Initial Damage: " + TextHelper.format2FloatPoint(this.getDamage(infoNew) / 2.0) + " Hearts");
                            description.add("DoT: " + TextHelper.format2FloatPoint(this.getDoT(infoNew) / 2.0) + " Hearts");
                        }
                    });
                }
            }
        });
    }

    @Override
    public int getCostIncrement(EntityLivingBase entity, int total) {
        Optional<AdvancementCapability> optional = Capabilities.advancement((Entity)entity);
        if (optional.isPresent()) {
            AdvancementCapability advancement = optional.get();
            List<Skill> skillUnlockOrder = Arrays.asList(advancement.skillUnlockOrder);
            int index = skillUnlockOrder.indexOf(ModAbilities.BLEED);
            if (index == -1) {
                index = advancement.skillUnlockOrder.length;
            }
            return (int)((double)total * (1.0 + (double)index * CommonConfig.getSyncValues().advancement.xp.costIncrement));
        }
        return total;
    }

    @Override
    public int getUpgradeCost(@Nullable AbilityInfo info) {
        int level = info != null ? this.getLevel(info) + 1 : 0;
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().advancement.upgrade, level, levelMax);
        return (int)(func * CommonConfig.getSyncValues().advancement.xp.globalCostMultiplier);
    }

    @Override
    public void initSyncConfig() {
        Configuration.getSyncValues().maxLevel = Configuration.getValues().maxLevel;
        Configuration.getSyncValues().cooldown = Configuration.getValues().cooldown;
        Configuration.getSyncValues().time = Configuration.getValues().time;
        Configuration.getSyncValues().range = Configuration.getValues().range;
        Configuration.getSyncValues().effectiveness = Configuration.getValues().effectiveness;
        Configuration.getSyncValues().extra.dot = Configuration.getValues().extra.dot;
        Configuration.getSyncValues().advancement.upgrade = Configuration.getValues().advancement.upgrade;
    }

    @Override
    public void writeSyncConfig(NBTTagCompound compound) {
        compound.func_74768_a("maxLevel", Configuration.getValues().maxLevel);
        NBTHelper.setArray(compound, "cooldown", Configuration.getValues().cooldown);
        NBTHelper.setArray(compound, "time", Configuration.getValues().time);
        NBTHelper.setArray(compound, "range", Configuration.getValues().range);
        compound.func_74780_a("effectiveness", Configuration.getValues().effectiveness);
        NBTHelper.setArray(compound, "extra.dot", Configuration.getValues().extra.dot);
        NBTHelper.setArray(compound, "advancement.upgrade", Configuration.getValues().advancement.upgrade);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readSyncConfig(NBTTagCompound compound) {
        Configuration.getSyncValues().maxLevel = compound.func_74762_e("maxLevel");
        Configuration.getSyncValues().cooldown = NBTHelper.getArray(compound, "cooldown");
        Configuration.getSyncValues().time = NBTHelper.getArray(compound, "time");
        Configuration.getSyncValues().range = NBTHelper.getArray(compound, "range");
        Configuration.getSyncValues().effectiveness = compound.func_74769_h("effectiveness");
        Configuration.getSyncValues().extra.dot = NBTHelper.getArray(compound, "extra.dot");
        Configuration.getSyncValues().advancement.upgrade = NBTHelper.getArray(compound, "advancement.upgrade");
    }

    @Config(modid="enderskills", name="enderskills/Ability/contaminate")
    public static class Configuration {
        @Config.Comment(value={"Ability Values"})
        @Config.LangKey(value="enderskills.config.contaminate")
        public static Values CONFIG = new Values();
        @Config.Ignore
        protected static Values CONFIG_SYNC = new Values();

        public static Values getValues() {
            return CONFIG;
        }

        public static Values getSyncValues() {
            return CONFIG_SYNC;
        }

        public static class Values {
            @Config.Comment(value={"Skill specific extra Configuration"})
            public final Extra extra = new Extra();
            @Config.Comment(value={"Skill specific Advancement Configuration"})
            public final Advancement advancement = new Advancement();
            @Config.Comment(value={"Max level obtainable"})
            @Config.RangeInt(min=0)
            public int maxLevel = 50;
            @Config.Comment(value={"Cooldown Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] cooldown = new String[]{"(0+){15 * 20 + 10 * 20 * (1 - ((1 - (e^(-2.1 * (x/24)))) / (1 - e^(-2.1))))}", "(25+){12 * 20 + 3 * 20 * (1- (((e^(0.1 * ((x-24) / (y-24))) - 1)/((e^0.1) - 1))))}", "(50){10 * 20}"};
            @Config.Comment(value={"Duration Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] time = new String[]{"(0+){3 * 20}"};
            @Config.Comment(value={"Range Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] range = new String[]{"(0+){3 + 2 * (1 - (e^(-2.1 * (x/24)))) / (1 - e^(-2.1))}", "(25+){5 + 1 * ((e^(0.1 * ((x - 24) / (y - 24))) - 1)/((e^0.1) - 1))}"};
            @Config.Comment(value={"Effectiveness Modifier"})
            @Config.RangeDouble
            public double effectiveness = 1.0;

            public static class Advancement {
                @Config.Comment(value={"Function f(x)=? where 'x' is [Next Level] and 'y' is [Max Level], XP Cost is in units [NOT LEVELS]"})
                public String[] upgrade = new String[]{"(0){300}", "(1+){4 * x}", "(50){4 * x + 4 * x * 0.1}"};
            }

            public static class Extra {
                @Config.Comment(value={"Damage Over Time Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
                public String[] dot = new String[]{"(0+){6 + ((e^(0.1 * (x / 49)) - 1)/((e^0.1) - 1)) * (9.11 - 6)}", "(25+){9.11 + ((e^(2.25 * ((x-24) / (y-24))) - 1)/((e^2.25) - 1)) * (16 - 9.11)}", "(50){18}"};
                @Config.Comment(value={"Initial Damage Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
                public String[] damage = new String[]{"(0+){4 + ((e^(0.1 * (x / 49)) - 1)/((e^0.1) - 1)) * (4.518450 - 4)}", "(25+){4.518450 + ((e^(1.25 * ((x-24) / (y-24))) - 1)/((e^1.25) - 1)) * (5 - 4.518450)}", "(50){6}"};
            }
        }
    }
}

