/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.skill.attribute.mobility;

import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.api.capability.data.SkillInfo;
import arekkuusu.enderskills.api.event.SkillActionableEvent;
import arekkuusu.enderskills.api.event.SkillActivateEvent;
import arekkuusu.enderskills.api.helper.ExpressionHelper;
import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.client.gui.data.ISkillAdvancement;
import arekkuusu.enderskills.common.CommonConfig;
import arekkuusu.enderskills.common.network.PacketHelper;
import arekkuusu.enderskills.common.skill.BaseSkill;
import arekkuusu.enderskills.common.skill.DynamicModifier;
import arekkuusu.enderskills.common.skill.attribute.AttributeInfo;
import arekkuusu.enderskills.common.skill.attribute.BaseAttribute;
import arekkuusu.enderskills.common.skill.attribute.deffense.DamageResistance;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Endurance
extends BaseAttribute
implements ISkillAdvancement {
    public static final IAttribute MAX_ENDURANCE = new RangedAttribute(null, "enderskills.generic.maxEndurance", 40.0, (double)1.4E-45f, 3.4028234663852886E38).func_111117_a("Max Endurance").func_111112_a(true);
    public static final DynamicModifier ENDURANCE_ATTRIBUTE = new DynamicModifier("010bf31b-320d-4ef9-91ed-6f84adc38600", "enderskills:endurance", MAX_ENDURANCE);

    public Endurance() {
        super("endurance", new BaseSkill.BaseProperties());
        MinecraftForge.EVENT_BUS.register((Object)this);
        ((BaseSkill.BaseProperties)this.getProperties()).setMaxLevelGetter(this::getMaxLevel);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (this.isClientWorld(event.getEntityLiving())) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.field_70173_aa % 20 != 0) {
            return;
        }
        Capabilities.get((Entity)entity).ifPresent(capability -> {
            if (capability.isOwned(this)) {
                capability.getOwned(this).ifPresent(skillInfo -> {
                    AttributeInfo attributeInfo = (AttributeInfo)skillInfo;
                    ENDURANCE_ATTRIBUTE.apply(entity, this.getModifier(attributeInfo));
                });
            } else if (ENDURANCE_ATTRIBUTE.remove(entity)) {
                Capabilities.endurance((Entity)entity).ifPresent(enduranceCapability -> {
                    double amount = entity.func_110148_a(MAX_ENDURANCE).func_111126_e();
                    if (enduranceCapability.getEndurance() > amount) {
                        enduranceCapability.setEndurance(amount);
                    }
                });
            }
        });
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityLivingBase) {
            ((EntityLivingBase)event.getObject()).func_110140_aT().func_111150_b(MAX_ENDURANCE).func_111128_a(40.0);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEnduranceTick(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer || !event.getEntityLiving().func_130014_f_().field_72995_K) {
            Capabilities.endurance((Entity)event.getEntityLiving()).ifPresent(capability -> {
                if (capability.getEnduranceDelay() > 0.0) {
                    capability.setEnduranceDelay(capability.getEnduranceDelay() - 1.0);
                } else if (capability.getEndurance() < event.getEntityLiving().func_110148_a(MAX_ENDURANCE).func_111126_e()) {
                    capability.setEnduranceDelay(10.0);
                    capability.setEndurance(capability.getEndurance() + 1.0);
                }
            });
        }
    }

    @SubscribeEvent
    public void onSkillShouldUse(SkillActionableEvent event) {
        if (this.isClientWorld(event.getEntityLiving()) || event.isCanceled()) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        Capabilities.endurance((Entity)entity).ifPresent(capability -> {
            if (this.hasEnduranceDrain(event.getSkill())) {
                int enduranceNeeded = this.getEnduranceDrain(event.getSkill());
                if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
                    enduranceNeeded = 0;
                }
                if (capability.getEndurance() + capability.getAbsorption() < (double)enduranceNeeded) {
                    event.setCanceled(true);
                }
            }
        });
    }

    @SubscribeEvent
    public void onSkillUse(SkillActivateEvent event) {
        if (this.isClientWorld(event.getEntityLiving()) || event.isCanceled()) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        Capabilities.endurance((Entity)entity).ifPresent(capability -> {
            if (this.hasEnduranceDrain(event.getSkill())) {
                int enduranceNeeded = this.getEnduranceDrain(event.getSkill());
                if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
                    enduranceNeeded = 0;
                }
                if (capability.getEndurance() + capability.getAbsorption() < (double)enduranceNeeded) {
                    event.setCanceled(true);
                    return;
                }
                capability.drain(enduranceNeeded);
                if (entity instanceof EntityPlayerMP) {
                    PacketHelper.sendEnduranceSync((EntityPlayerMP)entity);
                }
            }
        });
    }

    public boolean hasEnduranceDrain(Skill skill) {
        return this.getEnduranceDrain(skill) != 0;
    }

    public int getEnduranceDrain(Skill skill) {
        String skillRegistryName = Objects.requireNonNull(skill.getRegistryName()).toString();
        return Configuration.getSyncValues().extra.enduranceMap.get(skillRegistryName);
    }

    public int getLevel(SkillInfo.IInfoUpgradeable info) {
        return info.getLevel();
    }

    public int getMaxLevel() {
        return Configuration.getSyncValues().maxLevel;
    }

    public int getModifier(AttributeInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().modifier, level, levelMax);
        return (int)(func * this.getEffectiveness());
    }

    public double getEffectiveness() {
        return Configuration.getSyncValues().effectiveness * CommonConfig.getSyncValues().skill.globalEffectiveness;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDescription(List<String> description) {
        Capabilities.get((Entity)Minecraft.func_71410_x().field_71439_g).ifPresent(c -> {
            if (c.isOwned(this)) {
                if (!GuiScreen.func_146272_n()) {
                    description.add("");
                    description.add("Hold SHIFT for stats.");
                } else {
                    c.getOwned(this).ifPresent(skillInfo -> {
                        AttributeInfo attributeInfo = (AttributeInfo)skillInfo;
                        description.clear();
                        if (attributeInfo.getLevel() >= this.getMaxLevel()) {
                            description.add("Max Level:");
                        } else {
                            description.add("Current Level:");
                        }
                        description.add("Boost: +" + this.getModifier(attributeInfo) + " Endurance");
                        if (attributeInfo.getLevel() < this.getMaxLevel()) {
                            AttributeInfo infoNew = new AttributeInfo(attributeInfo.serializeNBT());
                            infoNew.setLevel(infoNew.getLevel() + 1);
                            description.add("");
                            description.add("Next Level:");
                            description.add("Boost: +" + this.getModifier(infoNew) + " Endurance");
                        }
                    });
                }
            }
        });
    }

    @Override
    public boolean canUpgrade(EntityLivingBase entity) {
        return Capabilities.advancement((Entity)entity).map(c -> {
            ISkillAdvancement.Requirement requirement = this.getRequirement(entity);
            int xp = requirement.getXp();
            return c.getExperienceTotal(entity) >= xp;
        }).orElse(false);
    }

    @Override
    public void onUpgrade(EntityLivingBase entity) {
        Capabilities.advancement((Entity)entity).ifPresent(c -> {
            ISkillAdvancement.Requirement requirement = this.getRequirement(entity);
            int xp = requirement.getXp();
            if (c.getExperienceTotal(entity) >= xp) {
                c.consumeExperienceFromTotal(entity, xp);
            }
        });
    }

    @Override
    public ISkillAdvancement.Requirement getRequirement(EntityLivingBase entity) {
        AttributeInfo info = Capabilities.get((Entity)entity).flatMap(a -> a.getOwned(this)).orElse(null);
        return new ISkillAdvancement.DefaultRequirement(0, this.getUpgradeCost(info));
    }

    @Override
    public int getUpgradeCost(@Nullable AttributeInfo info) {
        int level = info != null ? this.getLevel(info) + 1 : 0;
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().advancement.upgrade, level, levelMax);
        return (int)(func * CommonConfig.getSyncValues().advancement.xp.globalCostMultiplier);
    }

    @Override
    public void initSyncConfig() {
        Configuration.getSyncValues().maxLevel = Configuration.getValues().maxLevel;
        Configuration.getSyncValues().modifier = Configuration.getValues().modifier;
        Configuration.getSyncValues().effectiveness = Configuration.getValues().effectiveness;
        Configuration.getSyncValues().extra.enduranceMap = new HashMap<String, Integer>(Configuration.getValues().extra.enduranceMap);
        DamageResistance.Configuration.getSyncValues().advancement.upgrade = DamageResistance.Configuration.getValues().advancement.upgrade;
    }

    @Override
    public void writeSyncConfig(NBTTagCompound compound) {
        compound.func_74768_a("maxLevel", Configuration.getValues().maxLevel);
        NBTHelper.setArray(compound, "modifier", Configuration.getValues().modifier);
        compound.func_74780_a("effectiveness", Configuration.getValues().effectiveness);
        NBTHelper.setArray(compound, "advancement.upgrade", Configuration.getValues().advancement.upgrade);
        NBTTagList list = new NBTTagList();
        for (Map.Entry<String, Integer> entry : Configuration.getValues().extra.enduranceMap.entrySet()) {
            NBTTagCompound nbt = new NBTTagCompound();
            NBTHelper.setString(nbt, "skill", entry.getKey());
            NBTHelper.setInteger(nbt, "cost", entry.getValue());
            list.func_74742_a((NBTBase)nbt);
        }
        compound.func_74782_a("extra.enduranceMap", (NBTBase)list);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readSyncConfig(NBTTagCompound compound) {
        Configuration.getSyncValues().maxLevel = compound.func_74762_e("maxLevel");
        Configuration.getSyncValues().modifier = NBTHelper.getArray(compound, "modifier");
        Configuration.getSyncValues().effectiveness = compound.func_74769_h("effectiveness");
        Configuration.getSyncValues().advancement.upgrade = NBTHelper.getArray(compound, "advancement.upgrade");
        NBTTagList list = compound.func_150295_c("extra.enduranceMap", 10);
        Configuration.getSyncValues().extra.enduranceMap.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            String skill = nbt.func_74779_i("skill");
            Integer cost = nbt.func_74762_e("cost");
            Configuration.getSyncValues().extra.enduranceMap.put(skill, cost);
        }
    }

    @Config(modid="enderskills", name="enderskills/Attribute/endurance")
    public static class Configuration {
        @Config.Comment(value={"Attribute Values"})
        @Config.LangKey(value="enderskills.config.endurance")
        public static Values CONFIG = new Values();
        @Config.Ignore
        protected static Values CONFIG_SYNC = new Values();

        public static Values getValues() {
            return CONFIG;
        }

        public static Values getSyncValues() {
            return CONFIG_SYNC;
        }

        public static class Values {
            @Config.Comment(value={"Skill specific extra Configuration"})
            public final Extra extra = new Extra();
            @Config.Comment(value={"Skill specific Advancement Configuration"})
            public final Advancement advancement = new Advancement();
            @Config.Comment(value={"The Maximum level of this Skill"})
            @Config.RangeInt(min=0)
            public int maxLevel = Integer.MAX_VALUE;
            @Config.Comment(value={"Modifier Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] modifier = new String[]{"(0+){x * 1}"};
            @Config.Comment(value={"Effectiveness Modifier"})
            @Config.RangeDouble
            public double effectiveness = 1.0;

            public static class Advancement {
                @Config.Comment(value={"Function f(x)=? where 'x' is [Next Level] and 'y' is [Max Level], XP Cost is in units [NOT LEVELS]"})
                public String[] upgrade = new String[]{"(0+){(50 * (1 - (0 ^ (0 ^ x)))) + 20 + 15 * x}"};
            }

            public static class Extra {
                @Config.Comment(value={"Endurance drain by skill"})
                public Map<String, Integer> enduranceMap = new HashMap<String, Integer>((Map<String, Integer>)new ImmutableMap.Builder().put((Object)"enderskills:charm", (Object)6).put((Object)"enderskills:heal_aura", (Object)8).put((Object)"enderskills:power_boost", (Object)8).put((Object)"enderskills:heal_other", (Object)12).put((Object)"enderskills:heal_self", (Object)12).put((Object)"enderskills:nearby_invincibility", (Object)16).put((Object)"enderskills:taunt", (Object)8).put((Object)"enderskills:wall", (Object)9).put((Object)"enderskills:dome", (Object)9).put((Object)"enderskills:thorny", (Object)12).put((Object)"enderskills:shockwave", (Object)14).put((Object)"enderskills:animated_stone_golem", (Object)16).put((Object)"enderskills:shocking_aura", (Object)1).put((Object)"enderskills:electric_pulse", (Object)4).put((Object)"enderskills:magnetic_pull", (Object)4).put((Object)"enderskills:power_drain", (Object)12).put((Object)"enderskills:energize", (Object)12).put((Object)"enderskills:voltaic_sentinel", (Object)16).put((Object)"enderskills:dash", (Object)4).put((Object)"enderskills:extra_jump", (Object)2).put((Object)"enderskills:fog", (Object)16).put((Object)"enderskills:smash", (Object)14).put((Object)"enderskills:hasten", (Object)16).put((Object)"enderskills:speed_boost", (Object)18).put((Object)"enderskills:warp", (Object)6).put((Object)"enderskills:invisibility", (Object)18).put((Object)"enderskills:hover", (Object)2).put((Object)"enderskills:unstable_portal", (Object)14).put((Object)"enderskills:portal", (Object)16).put((Object)"enderskills:teleport", (Object)20).put((Object)"enderskills:shadow", (Object)1).put((Object)"enderskills:gloom", (Object)4).put((Object)"enderskills:shadow_jab", (Object)4).put((Object)"enderskills:gas_cloud", (Object)8).put((Object)"enderskills:grasp", (Object)8).put((Object)"enderskills:black_hole", (Object)18).put((Object)"enderskills:bleed", (Object)1).put((Object)"enderskills:blood_pool", (Object)6).put((Object)"enderskills:contaminate", (Object)6).put((Object)"enderskills:life_steal", (Object)1).put((Object)"enderskills:syphon", (Object)8).put((Object)"enderskills:sacrifice", (Object)18).put((Object)"enderskills:slash", (Object)2).put((Object)"enderskills:push", (Object)4).put((Object)"enderskills:pull", (Object)4).put((Object)"enderskills:crush", (Object)8).put((Object)"enderskills:updraft", (Object)6).put((Object)"enderskills:suffocate", (Object)18).put((Object)"enderskills:fire_spirit", (Object)1).put((Object)"enderskills:flaming_breath", (Object)8).put((Object)"enderskills:flaming_rain", (Object)10).put((Object)"enderskills:focus_flame", (Object)16).put((Object)"enderskills:fireball", (Object)16).put((Object)"enderskills:explode", (Object)20).build());
            }
        }
    }
}

