/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.skill.attribute.mobility;

import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.api.capability.data.SkillInfo;
import arekkuusu.enderskills.api.event.SkillDamageSource;
import arekkuusu.enderskills.api.helper.ExpressionHelper;
import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.client.gui.data.ISkillAdvancement;
import arekkuusu.enderskills.client.util.helper.TextHelper;
import arekkuusu.enderskills.common.CommonConfig;
import arekkuusu.enderskills.common.skill.BaseSkill;
import arekkuusu.enderskills.common.skill.attribute.AttributeInfo;
import arekkuusu.enderskills.common.skill.attribute.BaseAttribute;
import arekkuusu.enderskills.common.skill.attribute.deffense.DamageResistance;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StealthDamage
extends BaseAttribute
implements ISkillAdvancement {
    public StealthDamage() {
        super("stealth_damage", new BaseSkill.BaseProperties());
        MinecraftForge.EVENT_BUS.register((Object)this);
        ((BaseSkill.BaseProperties)this.getProperties()).setMaxLevelGetter(this::getMaxLevel);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onEntityDamage(LivingHurtEvent event) {
        if (this.isClientWorld(event.getEntityLiving()) || event.getSource().func_76355_l().equals("ability")) {
            return;
        }
        DamageSource source = event.getSource();
        if (!source.func_76355_l().matches("player|mob")) {
            return;
        }
        if (!(source.func_76346_g() instanceof EntityLivingBase) || source instanceof SkillDamageSource || source.func_76364_f() != source.func_76346_g()) {
            return;
        }
        EntityLivingBase target = event.getEntityLiving();
        EntityLivingBase attacker = (EntityLivingBase)source.func_76346_g();
        Capabilities.get((Entity)attacker).ifPresent(capability -> {
            if (capability.isOwned(this) && attacker.func_70093_af() && this.isNotSeenByTarget(attacker, target)) {
                capability.getOwned(this).ifPresent(skillInfo -> {
                    AttributeInfo attributeInfo = (AttributeInfo)skillInfo;
                    event.setAmount(event.getAmount() + event.getAmount() * this.getModifier(attributeInfo));
                });
            }
        });
    }

    public boolean isNotSeenByTarget(EntityLivingBase attacker, EntityLivingBase target) {
        Vec3d positionTarget = target.func_174824_e(1.0f);
        Vec3d lookTarget = target.func_70040_Z().func_72432_b();
        Vec3d positionAttacker = attacker.func_174824_e(1.0f);
        Vec3d origin = new Vec3d(0.0, 0.0, 0.0);
        Vec3d pointA = lookTarget.func_178787_e(positionTarget).func_178788_d(positionTarget);
        Vec3d pointB = positionAttacker.func_178788_d(positionTarget);
        double pointADistance = pointA.func_72438_d(pointB);
        double pointBDistance = pointB.func_72438_d(origin);
        if (pointBDistance <= 5.0 && pointADistance > pointBDistance) {
            double b;
            double ab = pointA.field_72450_a * pointB.field_72450_a + pointA.field_72448_b * pointB.field_72448_b + pointA.field_72449_c * pointB.field_72449_c;
            double a = Math.sqrt(Math.pow(pointA.field_72450_a, 2.0) + Math.pow(pointA.field_72448_b, 2.0) + Math.pow(pointA.field_72449_c, 2.0));
            double angle = Math.acos(ab / (a * (b = Math.sqrt(Math.pow(pointB.field_72450_a, 2.0) + Math.pow(pointB.field_72448_b, 2.0) + Math.pow(pointB.field_72449_c, 2.0))))) * 57.29577951308232;
            return angle < 280.0 && angle > 80.0;
        }
        return false;
    }

    public int getLevel(SkillInfo.IInfoUpgradeable info) {
        return info.getLevel();
    }

    public int getMaxLevel() {
        return Configuration.getSyncValues().maxLevel;
    }

    public float getModifier(AttributeInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().modifier, level, levelMax);
        return (float)(func * this.getEffectiveness());
    }

    public double getEffectiveness() {
        return Configuration.getSyncValues().effectiveness * CommonConfig.getSyncValues().skill.globalEffectiveness;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDescription(List<String> description) {
        Capabilities.get((Entity)Minecraft.func_71410_x().field_71439_g).ifPresent(c -> {
            if (c.isOwned(this)) {
                if (!GuiScreen.func_146272_n()) {
                    description.add("");
                    description.add("Hold SHIFT for stats.");
                } else {
                    c.getOwned(this).ifPresent(skillInfo -> {
                        AttributeInfo attributeInfo = (AttributeInfo)skillInfo;
                        description.clear();
                        if (attributeInfo.getLevel() >= this.getMaxLevel()) {
                            description.add("Max Level:");
                        } else {
                            description.add("Current Level:");
                        }
                        description.add("Dmg: +" + TextHelper.format2FloatPoint(this.getModifier(attributeInfo) * 100.0f) + "%");
                        if (attributeInfo.getLevel() < this.getMaxLevel()) {
                            AttributeInfo infoNew = new AttributeInfo(attributeInfo.serializeNBT());
                            infoNew.setLevel(infoNew.getLevel() + 1);
                            description.add("");
                            description.add("Next Level:");
                            description.add("Dmg: +" + TextHelper.format2FloatPoint(this.getModifier(infoNew) * 100.0f) + "%");
                        }
                    });
                }
            }
        });
    }

    @Override
    public boolean canUpgrade(EntityLivingBase entity) {
        return Capabilities.advancement((Entity)entity).map(c -> {
            ISkillAdvancement.Requirement requirement = this.getRequirement(entity);
            int xp = requirement.getXp();
            return c.getExperienceTotal(entity) >= xp;
        }).orElse(false);
    }

    @Override
    public void onUpgrade(EntityLivingBase entity) {
        Capabilities.advancement((Entity)entity).ifPresent(c -> {
            ISkillAdvancement.Requirement requirement = this.getRequirement(entity);
            int xp = requirement.getXp();
            if (c.getExperienceTotal(entity) >= xp) {
                c.consumeExperienceFromTotal(entity, xp);
            }
        });
    }

    @Override
    public ISkillAdvancement.Requirement getRequirement(EntityLivingBase entity) {
        AttributeInfo info = Capabilities.get((Entity)entity).flatMap(a -> a.getOwned(this)).orElse(null);
        return new ISkillAdvancement.DefaultRequirement(0, this.getUpgradeCost(info));
    }

    @Override
    public int getUpgradeCost(@Nullable AttributeInfo info) {
        int level = info != null ? this.getLevel(info) + 1 : 0;
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().advancement.upgrade, level, levelMax);
        return (int)(func * CommonConfig.getSyncValues().advancement.xp.globalCostMultiplier);
    }

    @Override
    public void initSyncConfig() {
        Configuration.getSyncValues().maxLevel = Configuration.getValues().maxLevel;
        Configuration.getSyncValues().modifier = Configuration.getValues().modifier;
        Configuration.getSyncValues().effectiveness = Configuration.getValues().effectiveness;
        DamageResistance.Configuration.getSyncValues().advancement.upgrade = DamageResistance.Configuration.getValues().advancement.upgrade;
    }

    @Override
    public void writeSyncConfig(NBTTagCompound compound) {
        compound.func_74768_a("maxLevel", Configuration.getValues().maxLevel);
        NBTHelper.setArray(compound, "modifier", Configuration.getValues().modifier);
        compound.func_74780_a("effectiveness", Configuration.getValues().effectiveness);
        NBTHelper.setArray(compound, "advancement.upgrade", Configuration.getValues().advancement.upgrade);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readSyncConfig(NBTTagCompound compound) {
        Configuration.getSyncValues().maxLevel = compound.func_74762_e("maxLevel");
        Configuration.getSyncValues().modifier = NBTHelper.getArray(compound, "modifier");
        Configuration.getSyncValues().effectiveness = compound.func_74769_h("effectiveness");
        Configuration.getSyncValues().advancement.upgrade = NBTHelper.getArray(compound, "advancement.upgrade");
    }

    @Config(modid="enderskills", name="enderskills/Attribute/stealth_damage")
    public static class Configuration {
        @Config.Comment(value={"Attribute Values"})
        @Config.LangKey(value="enderskills.config.stealth_damage")
        public static Values CONFIG = new Values();
        @Config.Ignore
        protected static Values CONFIG_SYNC = new Values();

        public static Values getValues() {
            return CONFIG;
        }

        public static Values getSyncValues() {
            return CONFIG_SYNC;
        }

        public static class Values {
            @Config.Comment(value={"Skill specific Advancement Configuration"})
            public final Advancement advancement = new Advancement();
            @Config.Comment(value={"The Maximum level of this Skill"})
            @Config.RangeInt(min=0)
            public int maxLevel = Integer.MAX_VALUE;
            @Config.Comment(value={"Modifier Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] modifier = new String[]{"(0+){1 - e^(-0.05 * x)}"};
            @Config.Comment(value={"Effectiveness Modifier"})
            @Config.RangeDouble
            public double effectiveness = 1.0;

            public static class Advancement {
                @Config.Comment(value={"Function f(x)=? where 'x' is [Next Level] and 'y' is [Max Level], XP Cost is in units [NOT LEVELS]"})
                public String[] upgrade = new String[]{"(0+){(65 * (1 - (0 ^ (0 ^ x)))) + 4 * x}"};
            }
        }
    }
}

