/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.skill.attribute.offense;

import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.api.capability.data.SkillInfo;
import arekkuusu.enderskills.api.helper.ExpressionHelper;
import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.client.gui.data.ISkillAdvancement;
import arekkuusu.enderskills.client.util.helper.TextHelper;
import arekkuusu.enderskills.common.CommonConfig;
import arekkuusu.enderskills.common.skill.BaseSkill;
import arekkuusu.enderskills.common.skill.DynamicModifier;
import arekkuusu.enderskills.common.skill.attribute.AttributeInfo;
import arekkuusu.enderskills.common.skill.attribute.BaseAttribute;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AttackSpeed
extends BaseAttribute
implements ISkillAdvancement {
    public static final UUID ITEM_ATTACK_SPEED_MODIFIER = (UUID)ObfuscationReflectionHelper.getPrivateValue(Item.class, null, (String[])new String[]{"ATTACK_SPEED_MODIFIER", "field_185050_h"});
    public static final DynamicModifier SPEED_ATTRIBUTE = new DynamicModifier("2b3b2ec9-00d5-43e7-86f4-bb51d6c5c1e7", "enderskills:attack_speed", SharedMonsterAttributes.field_188790_f);

    public AttackSpeed() {
        super("attack_speed", new BaseSkill.BaseProperties());
        MinecraftForge.EVENT_BUS.register((Object)this);
        ((BaseSkill.BaseProperties)this.getProperties()).setMaxLevelGetter(this::getMaxLevel);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (this.isClientWorld(event.getEntityLiving())) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.field_70173_aa % 40 != 0) {
            return;
        }
        Capabilities.get((Entity)entity).ifPresent(capability -> {
            if (capability.isOwned(this)) {
                capability.getOwned(this).ifPresent(skillInfo -> {
                    AttributeInfo attributeInfo = (AttributeInfo)skillInfo;
                    ItemStack heldMain = entity.func_184614_ca();
                    ItemStack heldOff = entity.func_184592_cb();
                    double heldMainSpeed = this.getItemStackSpeedModifier(entity, heldMain);
                    double heldOffSpeed = this.getItemStackSpeedModifier(entity, heldOff);
                    double bigChungus = Math.min(heldMainSpeed, heldOffSpeed);
                    SPEED_ATTRIBUTE.apply(entity, this.getModifier(attributeInfo) * this.getChungness(bigChungus));
                });
            } else {
                SPEED_ATTRIBUTE.remove(entity);
            }
        });
    }

    public double getChungness(double chungusThicc) {
        return MathHelper.func_151237_a((double)(chungusThicc / SharedMonsterAttributes.field_188790_f.func_111110_b()), (double)0.0, (double)1.0);
    }

    public double getItemStackSpeedModifier(EntityLivingBase entity, ItemStack stack) {
        double amountAttribute = 0.0;
        Multimap modifiers = stack.func_111283_C(EntityEquipmentSlot.MAINHAND);
        for (Map.Entry entry : modifiers.entries()) {
            AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
            if (attributemodifier.func_111167_a() != ITEM_ATTACK_SPEED_MODIFIER) continue;
            amountAttribute = entity.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111125_b();
            break;
        }
        return amountAttribute;
    }

    public int getLevel(SkillInfo.IInfoUpgradeable info) {
        return info.getLevel();
    }

    public int getMaxLevel() {
        return Configuration.getSyncValues().maxLevel;
    }

    public double getModifier(AttributeInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().modifier, level, levelMax);
        return func * this.getEffectiveness();
    }

    public double getEffectiveness() {
        return Configuration.getSyncValues().effectiveness * CommonConfig.getSyncValues().skill.globalEffectiveness;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDescription(List<String> description) {
        Capabilities.get((Entity)Minecraft.func_71410_x().field_71439_g).ifPresent(c -> {
            if (c.isOwned(this)) {
                if (!GuiScreen.func_146272_n()) {
                    description.add("");
                    description.add("Hold SHIFT for stats.");
                } else {
                    c.getOwned(this).ifPresent(skillInfo -> {
                        AttributeInfo attributeInfo = (AttributeInfo)skillInfo;
                        description.clear();
                        if (attributeInfo.getLevel() >= this.getMaxLevel()) {
                            description.add("Max Level:");
                        } else {
                            description.add("Current Level:");
                        }
                        description.add("Boost: +" + TextHelper.format2FloatPoint(this.getModifier(attributeInfo) * 100.0) + "%");
                        if (attributeInfo.getLevel() < this.getMaxLevel()) {
                            AttributeInfo infoNew = new AttributeInfo(attributeInfo.serializeNBT());
                            infoNew.setLevel(infoNew.getLevel() + 1);
                            description.add("");
                            description.add("Next Level:");
                            description.add("Boost: +" + TextHelper.format2FloatPoint(this.getModifier(infoNew) * 100.0) + "%");
                        }
                    });
                }
            }
        });
    }

    @Override
    public boolean canUpgrade(EntityLivingBase entity) {
        return Capabilities.advancement((Entity)entity).map(c -> {
            ISkillAdvancement.Requirement requirement = this.getRequirement(entity);
            int xp = requirement.getXp();
            return c.getExperienceTotal(entity) >= xp;
        }).orElse(false);
    }

    @Override
    public void onUpgrade(EntityLivingBase entity) {
        Capabilities.advancement((Entity)entity).ifPresent(c -> {
            ISkillAdvancement.Requirement requirement = this.getRequirement(entity);
            int xp = requirement.getXp();
            if (c.getExperienceTotal(entity) >= xp) {
                c.consumeExperienceFromTotal(entity, xp);
            }
        });
    }

    @Override
    public ISkillAdvancement.Requirement getRequirement(EntityLivingBase entity) {
        AttributeInfo info = Capabilities.get((Entity)entity).flatMap(a -> a.getOwned(this)).orElse(null);
        return new ISkillAdvancement.DefaultRequirement(0, this.getUpgradeCost(info));
    }

    @Override
    public int getUpgradeCost(@Nullable AttributeInfo info) {
        int level = info != null ? this.getLevel(info) + 1 : 0;
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().advancement.upgrade, level, levelMax);
        return (int)(func * CommonConfig.getSyncValues().advancement.xp.globalCostMultiplier);
    }

    @Override
    public void initSyncConfig() {
        Configuration.getSyncValues().maxLevel = Configuration.getValues().maxLevel;
        Configuration.getSyncValues().modifier = Configuration.getValues().modifier;
        Configuration.getSyncValues().effectiveness = Configuration.getValues().effectiveness;
        Configuration.getSyncValues().advancement.upgrade = Configuration.getValues().advancement.upgrade;
    }

    @Override
    public void writeSyncConfig(NBTTagCompound compound) {
        compound.func_74768_a("maxLevel", Configuration.getValues().maxLevel);
        NBTHelper.setArray(compound, "modifier", Configuration.getValues().modifier);
        compound.func_74780_a("effectiveness", Configuration.getValues().effectiveness);
        NBTHelper.setArray(compound, "advancement.upgrade", Configuration.getValues().advancement.upgrade);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readSyncConfig(NBTTagCompound compound) {
        Configuration.getSyncValues().maxLevel = compound.func_74762_e("maxLevel");
        Configuration.getSyncValues().modifier = NBTHelper.getArray(compound, "modifier");
        Configuration.getSyncValues().effectiveness = compound.func_74769_h("effectiveness");
        Configuration.getSyncValues().advancement.upgrade = NBTHelper.getArray(compound, "advancement.upgrade");
    }

    @Config(modid="enderskills", name="enderskills/Attribute/attack_speed")
    public static class Configuration {
        @Config.Comment(value={"Attribute Values"})
        @Config.LangKey(value="enderskills.config.attack_speed")
        public static Values CONFIG = new Values();
        @Config.Ignore
        protected static Values CONFIG_SYNC = new Values();

        public static Values getValues() {
            return CONFIG;
        }

        public static Values getSyncValues() {
            return CONFIG_SYNC;
        }

        public static class Values {
            @Config.Comment(value={"Skill specific Advancement Configuration"})
            public final Advancement advancement = new Advancement();
            @Config.Comment(value={"The Maximum level of this Skill"})
            @Config.RangeInt(min=0)
            public int maxLevel = Integer.MAX_VALUE;
            @Config.Comment(value={"Modifier Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] modifier = new String[]{"(0+){x * 0.08}"};
            @Config.Comment(value={"Effectiveness Modifier"})
            @Config.RangeDouble
            public double effectiveness = 1.0;

            public static class Advancement {
                @Config.Comment(value={"Function f(x)=? where 'x' is [Next Level] and 'y' is [Max Level], XP Cost is in units [NOT LEVELS]"})
                public String[] upgrade = new String[]{"(0+){(136 * (1 - (0 ^ (0 ^ x)))) + 7 * x}"};
            }
        }
    }
}

