/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.skill.attribute.offense;

import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.api.capability.data.SkillInfo;
import arekkuusu.enderskills.api.helper.ExpressionHelper;
import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.client.gui.data.ISkillAdvancement;
import arekkuusu.enderskills.client.util.helper.TextHelper;
import arekkuusu.enderskills.common.CommonConfig;
import arekkuusu.enderskills.common.skill.BaseSkill;
import arekkuusu.enderskills.common.skill.attribute.AttributeInfo;
import arekkuusu.enderskills.common.skill.attribute.BaseAttribute;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CriticalChance
extends BaseAttribute
implements ISkillAdvancement {
    public CriticalChance() {
        super("critical_chance", new BaseSkill.BaseProperties());
        MinecraftForge.EVENT_BUS.register((Object)this);
        ((BaseSkill.BaseProperties)this.getProperties()).setMaxLevelGetter(this::getMaxLevel);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onEntityDamage(LivingHurtEvent event) {
        if (!(event.getEntity() instanceof EntityLivingBase) || !(event.getSource().func_76346_g() instanceof EntityLivingBase) || this.isClientWorld(event.getEntityLiving())) {
            return;
        }
        DamageSource source = event.getSource();
        EntityLivingBase attacker = (EntityLivingBase)source.func_76346_g();
        if (attacker != null && source.func_76355_l().equals("mob")) {
            Capabilities.get((Entity)attacker).ifPresent(capability -> {
                if (capability.isOwned(this)) {
                    capability.getOwned(this).ifPresent(skillInfo -> {
                        AttributeInfo attributeInfo = (AttributeInfo)skillInfo;
                        if (attacker.field_70170_p.field_73012_v.nextDouble() < (double)this.getModifier(attributeInfo)) {
                            event.setAmount(event.getAmount() * 1.5f);
                        }
                    });
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onEntityCritical(CriticalHitEvent event) {
        if (event.getDamageModifier() > 1.0f || !(event.getEntity() instanceof EntityLivingBase) || this.isClientWorld(event.getEntityLiving())) {
            return;
        }
        EntityLivingBase attacker = event.getEntityLiving();
        Capabilities.get((Entity)attacker).ifPresent(capability -> {
            if (capability.isOwned(this)) {
                capability.getOwned(this).ifPresent(skillInfo -> {
                    AttributeInfo attributeInfo = (AttributeInfo)skillInfo;
                    if (attacker.field_70170_p.field_73012_v.nextDouble() < (double)this.getModifier(attributeInfo)) {
                        event.setDamageModifier(1.5f);
                        event.setResult(Event.Result.ALLOW);
                    }
                });
            }
        });
    }

    public int getLevel(SkillInfo.IInfoUpgradeable info) {
        return info.getLevel();
    }

    public int getMaxLevel() {
        return Configuration.getSyncValues().maxLevel;
    }

    public float getModifier(AttributeInfo info) {
        int level = this.getLevel(info);
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().modifier, level, levelMax);
        return (float)(func * this.getEffectiveness());
    }

    public double getEffectiveness() {
        return Configuration.getSyncValues().effectiveness * CommonConfig.getSyncValues().skill.globalEffectiveness;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDescription(List<String> description) {
        Capabilities.get((Entity)Minecraft.func_71410_x().field_71439_g).ifPresent(c -> {
            if (c.isOwned(this)) {
                if (!GuiScreen.func_146272_n()) {
                    description.add("");
                    description.add("Hold SHIFT for stats.");
                } else {
                    c.getOwned(this).ifPresent(skillInfo -> {
                        AttributeInfo attributeInfo = (AttributeInfo)skillInfo;
                        description.clear();
                        if (attributeInfo.getLevel() >= this.getMaxLevel()) {
                            description.add("Max Level:");
                        } else {
                            description.add("Current Level:");
                        }
                        description.add("Chance: " + TextHelper.format2FloatPoint(this.getModifier(attributeInfo) * 100.0f) + "%");
                        if (attributeInfo.getLevel() < this.getMaxLevel()) {
                            AttributeInfo infoNew = new AttributeInfo(attributeInfo.serializeNBT());
                            infoNew.setLevel(infoNew.getLevel() + 1);
                            description.add("");
                            description.add("Next Level:");
                            description.add("Chance: " + TextHelper.format2FloatPoint(this.getModifier(infoNew) * 100.0f) + "%");
                        }
                    });
                }
            }
        });
    }

    @Override
    public int getUpgradeCost(@Nullable AttributeInfo info) {
        int level = info != null ? this.getLevel(info) + 1 : 0;
        int levelMax = this.getMaxLevel();
        double func = ExpressionHelper.getExpression((Skill)this, Configuration.getSyncValues().advancement.upgrade, level, levelMax);
        return (int)(func * CommonConfig.getSyncValues().advancement.xp.globalCostMultiplier);
    }

    @Override
    public void initSyncConfig() {
        Configuration.getSyncValues().maxLevel = Configuration.getValues().maxLevel;
        Configuration.getSyncValues().modifier = Configuration.getValues().modifier;
        Configuration.getSyncValues().effectiveness = Configuration.getValues().effectiveness;
        Configuration.getSyncValues().advancement.upgrade = Configuration.getValues().advancement.upgrade;
    }

    @Override
    public void writeSyncConfig(NBTTagCompound compound) {
        compound.func_74768_a("maxLevel", Configuration.getValues().maxLevel);
        NBTHelper.setArray(compound, "modifier", Configuration.getValues().modifier);
        compound.func_74780_a("effectiveness", Configuration.getValues().effectiveness);
        NBTHelper.setArray(compound, "advancement.upgrade", Configuration.getValues().advancement.upgrade);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readSyncConfig(NBTTagCompound compound) {
        Configuration.getSyncValues().maxLevel = compound.func_74762_e("maxLevel");
        Configuration.getSyncValues().modifier = NBTHelper.getArray(compound, "modifier");
        Configuration.getSyncValues().effectiveness = compound.func_74769_h("effectiveness");
        Configuration.getSyncValues().advancement.upgrade = NBTHelper.getArray(compound, "advancement.upgrade");
    }

    @Config(modid="enderskills", name="enderskills/Attribute/critical_chance")
    public static class Configuration {
        @Config.Comment(value={"Attribute Values"})
        @Config.LangKey(value="enderskills.config.critical_chance")
        public static Values CONFIG = new Values();
        @Config.Ignore
        protected static Values CONFIG_SYNC = new Values();

        public static Values getValues() {
            return CONFIG;
        }

        public static Values getSyncValues() {
            return CONFIG_SYNC;
        }

        public static class Values {
            @Config.Comment(value={"Skill specific Advancement Configuration"})
            public final Advancement advancement = new Advancement();
            @Config.Comment(value={"The Maximum level of this Skill"})
            @Config.RangeInt(min=0)
            public int maxLevel = 20;
            @Config.Comment(value={"Modifier Function f(x,y)=? where 'x' is [Current Level] and 'y' is [Max Level]"})
            public String[] modifier = new String[]{"(0+){x * 0.05}"};
            @Config.Comment(value={"Effectiveness Modifier"})
            @Config.RangeDouble
            public double effectiveness = 0.99;

            public static class Advancement {
                @Config.Comment(value={"Function f(x)=? where 'x' is [Next Level] and 'y' is [Max Level], XP Cost is in units [NOT LEVELS]"})
                public String[] upgrade = new String[]{"(0+){(75 * (1 - (0 ^ (0 ^ x)))) + 800 * (x / y)}"};
            }
        }
    }
}

