/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.skill.effect;

import arekkuusu.enderskills.api.capability.data.SkillData;
import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.api.util.Vector;
import arekkuusu.enderskills.common.EnderSkills;
import arekkuusu.enderskills.common.skill.ModEffects;
import arekkuusu.enderskills.common.skill.SkillHelper;
import arekkuusu.enderskills.common.skill.effect.BaseEffect;
import arekkuusu.enderskills.common.sound.ModSounds;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class Electrified
extends BaseEffect {
    public List<Delay> propagators = new LinkedList<Delay>();

    public Electrified() {
        super("electrified", new Skill.Properties());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void update(EntityLivingBase entity, SkillData data, int tick) {
        if (this.isClientWorld(entity)) {
            return;
        }
        if (SkillHelper.isActive((Entity)entity, ModEffects.STUNNED)) {
            this.unapply(entity, data);
            this.async(entity, data);
        }
    }

    @Override
    public void end(EntityLivingBase entity, SkillData data) {
        if (this.isClientWorld(entity)) {
            return;
        }
        entity.getEntityData().func_74757_a("enderskills:propagated", false);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSeverUpdate(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Iterator<Delay> iterator = this.propagators.iterator();
            while (iterator.hasNext()) {
                Delay delay = iterator.next();
                if (delay.i++ <= 10) continue;
                if (this.canArc((Entity)delay.entityTo, delay.data)) {
                    delay.entityTo.func_70097_a(DamageSource.field_180137_b, 1.0f);
                    ModEffects.STUNNED.set(delay.entityTo, delay.data, delay.time);
                    EnderSkills.getProxy().addToQueue(delay::apply);
                    EntityLivingBase from = delay.entityFrom;
                    EntityLivingBase to = delay.entityTo;
                    Vector posFrom = new Vector(from.func_174791_d()).addVector(from.field_70170_p.field_73012_v.nextDouble() * 0.05, (double)from.field_70131_O / 2.0 + from.field_70170_p.field_73012_v.nextDouble() * 0.05, from.field_70170_p.field_73012_v.nextDouble() * 0.05);
                    Vector posTo = new Vector(to.func_174791_d()).addVector(to.field_70170_p.field_73012_v.nextDouble() * 0.05, (double)to.field_70131_O / 2.0 + to.field_70170_p.field_73012_v.nextDouble() * 0.05, to.field_70170_p.field_73012_v.nextDouble() * 0.05);
                    EnderSkills.getProxy().spawnLightning(to.field_70170_p, posFrom, posTo, 4, 0.6f, 5, 16053129, false);
                    if (to.field_70170_p instanceof WorldServer) {
                        ((WorldServer)to.field_70170_p).func_184148_a(null, posTo.x, posTo.y, posTo.z, ModSounds.ELECTRIC_HIT, SoundCategory.BLOCKS, 0.5f, (1.0f + (to.field_70170_p.field_73012_v.nextFloat() - to.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                    }
                }
                iterator.remove();
            }
        }
    }

    public void propagate(EntityLivingBase source, SkillData data, int time) {
        ModEffects.STUNNED.set(source, data, time);
        this.arc(source, data, time);
    }

    public void arc(EntityLivingBase source, SkillData data, int time) {
        source.field_70170_p.func_72839_b((Entity)source, source.func_174813_aQ().func_186662_g(1.5)).stream().filter(e -> this.canArc((Entity)e, data)).limit(1 + source.field_70170_p.field_73012_v.nextInt(1)).forEach(entity -> this.propagators.add(new Delay(source, (EntityLivingBase)entity, data, time)));
    }

    public boolean canArc(Entity entity, SkillData data) {
        return SkillHelper.isActive(entity, this) && !SkillHelper.isActive(entity, ModEffects.STUNNED, data.id + ":" + data.skill.getRegistryName());
    }

    @Override
    public void set(EntityLivingBase entity, SkillData data) {
        SkillData status = SkillData.of(this).by(data.id).with(280).put(data.nbt, data.watcher.copy()).overrides(SkillData.Overrides.EQUAL).create();
        this.apply(entity, status);
        this.sync(entity, status);
    }

    public static class Delay {
        EntityLivingBase entityFrom;
        EntityLivingBase entityTo;
        SkillData data;
        int time;
        int i;

        public Delay(EntityLivingBase entityFrom, EntityLivingBase entityTo, SkillData data, int time) {
            this.entityFrom = entityFrom;
            this.entityTo = entityTo;
            this.data = data;
            this.time = time;
        }

        public void apply() {
            ModEffects.ELECTRIFIED.arc(this.entityTo, this.data, this.time);
        }
    }
}

