/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.skill.effect;

import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.api.capability.data.SkillData;
import arekkuusu.enderskills.api.capability.data.nbt.WatcherManager;
import arekkuusu.enderskills.api.helper.MathUtil;
import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.common.skill.attribute.mobility.Endurance;
import arekkuusu.enderskills.common.skill.effect.BaseEffect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Overcharge
extends BaseEffect {
    public Overcharge() {
        super("overcharge", new Skill.Properties());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void update(EntityLivingBase entity, SkillData data, int tick) {
        if (tick % 20 != 0) {
            return;
        }
        double charge = NBTHelper.getDouble(data.nbt, "over_charge") - 1.0;
        if (charge > 0.0) {
            NBTHelper.setDouble(data.nbt, "over_charge", charge);
        } else if (!this.isClientWorld(entity)) {
            this.unapply(entity, data);
            this.async(entity, data);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        Capabilities.endurance((Entity)entity).ifPresent(capability -> {
            double amount = this.getOvercharge(entity);
            if (!MathUtil.fuzzyEqual(capability.getAbsorption(), amount)) {
                capability.setAbsorption(amount);
            }
        });
    }

    public double getOvercharge(EntityLivingBase entity) {
        return Capabilities.get((Entity)entity).map(c -> c.getActives().stream().filter(h -> h.data.skill == this).mapToDouble(h -> NBTHelper.getDouble(h.data.nbt, "over_charge")).sum()).orElse(0.0);
    }

    @Override
    public void set(EntityLivingBase entity, SkillData data) {
        this.set(entity, 0.0);
    }

    public void set(EntityLivingBase entity, double amount) {
        Capabilities.endurance((Entity)entity).ifPresent(capability -> {
            double maxEndurance = entity.func_110148_a(Endurance.MAX_ENDURANCE).func_111126_e();
            double endurance = capability.getEndurance();
            double remainingCharge = MathHelper.func_151237_a((double)(amount + endurance - maxEndurance), (double)0.0, (double)(maxEndurance * 1.5));
            capability.setEndurance(Math.min(endurance + amount, maxEndurance));
            if (remainingCharge > 0.0) {
                NBTTagCompound compound = new NBTTagCompound();
                NBTHelper.setDouble(compound, "over_charge", remainingCharge);
                SkillData data = SkillData.of(this).with(-1).put(compound, new WatcherManager.Watcher[0]).create();
                this.apply(entity, data);
                this.sync(entity, data);
            }
        });
    }
}

