/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.skill.effect;

import arekkuusu.enderskills.api.capability.data.SkillData;
import arekkuusu.enderskills.api.capability.data.nbt.WatcherManager;
import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.common.skill.effect.BaseEffect;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;

public class Overheal
extends BaseEffect {
    public Overheal() {
        super("overheal", new Skill.Properties());
    }

    @Override
    public void begin(EntityLivingBase entity, SkillData data) {
        float overHeal = data.nbt.func_74760_g("over_heal");
        entity.func_110149_m(entity.func_110139_bj() + overHeal);
    }

    @Override
    public void end(EntityLivingBase entity, SkillData data) {
        float overHeal = data.nbt.func_74760_g("over_heal");
        entity.func_110149_m(entity.func_110139_bj() - overHeal);
    }

    @Override
    public void set(EntityLivingBase entity, SkillData data) {
        this.set(entity, 0.0f);
    }

    public void set(EntityLivingBase entity, float amount) {
        float maxHeal = entity.func_110138_aP();
        float health = entity.func_110143_aJ();
        float remainingHeal = MathHelper.func_76131_a((float)(amount + health - maxHeal), (float)0.0f, (float)(maxHeal * 1.5f));
        entity.func_70691_i(amount);
        if (remainingHeal > 0.0f) {
            NBTTagCompound compound = new NBTTagCompound();
            NBTHelper.setFloat(compound, "over_heal", remainingHeal);
            SkillData data = SkillData.of(this).with(100).put(compound, new WatcherManager.Watcher[0]).create();
            this.apply(entity, data);
            this.sync(entity, data);
        }
    }
}

