/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.skill.effect;

import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.api.capability.data.SkillData;
import arekkuusu.enderskills.api.capability.data.SkillHolder;
import arekkuusu.enderskills.api.capability.data.nbt.WatcherManager;
import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.common.skill.SkillHelper;
import arekkuusu.enderskills.common.skill.effect.BaseEffect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Slowed
extends BaseEffect {
    public Slowed() {
        super("slowed", new Skill.Properties());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if ((!this.isClientWorld(entity) || entity instanceof EntityPlayer) && SkillHelper.isActive((Entity)entity, this)) {
            Capabilities.get((Entity)entity).ifPresent(c -> {
                double maxSlow = 1.0;
                for (SkillHolder h : c.getActives()) {
                    double slow;
                    if (h.data.skill != this || !((slow = h.data.nbt.func_74769_h("slow")) < maxSlow)) continue;
                    maxSlow = slow;
                }
                entity.field_70159_w *= maxSlow;
                entity.field_70179_y *= maxSlow;
            });
        }
    }

    @Override
    public void set(EntityLivingBase entity, SkillData data) {
        this.set(entity, data, 0.0);
    }

    public void set(EntityLivingBase entity, SkillData data, double slow) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTHelper.setDouble(compound, "slow", slow);
        SkillData status = SkillData.of(this).by(data.id + ":" + data.skill.getRegistryName()).with(10).put(compound, new WatcherManager.Watcher[0]).overrides(SkillData.Overrides.EQUAL).create();
        this.apply(entity, status);
        this.sync(entity, status);
    }
}

