/*
 * Decompiled with CFR 0.152.
 */
package com.expression.parser;

import com.expression.parser.exception.CalculatorException;
import com.expression.parser.function.Complex;
import com.expression.parser.function.ComplexFunction;
import com.expression.parser.function.FunctionX;
import com.expression.parser.function.FunctionXs;
import com.expression.parser.util.ParserResult;
import com.expression.parser.util.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Parser {
    public static ParserResult eval(String function, Point ... values) {
        ParserResult result = new ParserResult();
        FunctionX f_x = null;
        FunctionXs f_xs = null;
        ComplexFunction complexFunction = null;
        if (function != null && !function.isEmpty()) {
            if (Parser.pointIsComplex(values) || function.toLowerCase().contains("j")) {
                complexFunction = new ComplexFunction(function);
                List<Complex> valuesList = Parser.pointToComplexValue(values);
                List<String> varsList = Parser.pointToVar(values);
                try {
                    result.setComplexValue(complexFunction.getValue(valuesList, varsList));
                }
                catch (CalculatorException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    if (values != null) {
                        if (values.length == 1) {
                            f_x = new FunctionX(function);
                            if (values[0].getStringValue() != null && !values[0].getStringValue().isEmpty()) {
                                ParserResult evaluatedValue = Parser.eval(values[0].getStringValue());
                                result.setValue(f_x.getF_xo(evaluatedValue.getValue()));
                            } else {
                                result.setValue(f_x.getF_xo(values[0].getValue()));
                            }
                        } else if (values.length > 1) {
                            f_xs = new FunctionXs(function);
                            List<Double> valuesList = Parser.pointToValue(values);
                            List<String> varsList = Parser.pointToVar(values);
                            result.setValue(f_xs.getValue(valuesList, varsList));
                        }
                    } else {
                        f_x = new FunctionX(function);
                        result.setValue(f_x.getF_xo(0.0));
                    }
                }
                catch (CalculatorException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static double eval(String function, String[] vars, Double[] values) {
        double result = 0.0;
        FunctionX f_x = null;
        FunctionXs f_xs = null;
        if (function != null && !function.equals("")) {
            try {
                if ((vars == null || vars.length < 1) && values == null || values.length < 1) {
                    f_x = new FunctionX(function);
                    result = f_x.getF_xo(0.0);
                } else if (values != null && values.length == 1) {
                    f_x = new FunctionX(function);
                    result = f_x.getF_xo(values[0]);
                } else if (vars != null && vars.length > 1 && values != null && values.length > 1) {
                    f_xs = new FunctionXs(function);
                    List<Double> valuesList = Arrays.asList(values);
                    List<String> varsList = Arrays.asList(vars);
                    result = f_xs.getValue(valuesList, varsList);
                }
            }
            catch (CalculatorException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static ParserResult eval(String function) {
        ParserResult result;
        block5: {
            result = new ParserResult();
            FunctionX f_x = null;
            if (function != null && !function.equals("")) {
                try {
                    if ((function.toLowerCase().contains("j") || function.toLowerCase().contains("i")) && !function.toLowerCase().contains("x")) {
                        result = Parser.eval(function, new Point("x", new Complex(1.0, 0.0)));
                        break block5;
                    }
                    if (!function.toLowerCase().contains("x")) {
                        f_x = new FunctionX(function);
                        result.setValue(f_x.getF_xo(0.0));
                        break block5;
                    }
                    throw new CalculatorException("function is not well defined");
                }
                catch (CalculatorException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    private static List<Double> pointToValue(Point ... values) {
        ArrayList<Double> result = new ArrayList<Double>();
        for (int i = 0; i < values.length; ++i) {
            if (values[i].getStringValue() != null && !values[i].getStringValue().isEmpty()) {
                ParserResult evaluatedValue = Parser.eval(values[i].getStringValue());
                result.add(evaluatedValue.getValue());
                continue;
            }
            result.add(values[i].getValue());
        }
        return result;
    }

    private static List<Complex> pointToComplexValue(Point ... values) {
        ArrayList<Complex> result = new ArrayList<Complex>();
        for (int i = 0; i < values.length; ++i) {
            if (values[i].isComplex() && (values[i].getStringValue() == null || values[i].getStringValue().isEmpty())) {
                result.add(values[i].getComplexValue());
                continue;
            }
            if (values[i].getStringValue() != null && !values[i].getStringValue().isEmpty()) {
                ParserResult evaluatedValue = Parser.eval(values[i].getStringValue());
                if (evaluatedValue.isComplex()) {
                    result.add(evaluatedValue.getComplexValue());
                    continue;
                }
                result.add(new Complex(evaluatedValue.getValue(), 0.0));
                continue;
            }
            result.add(new Complex(values[i].getValue(), 0.0));
        }
        return result;
    }

    private static boolean pointIsComplex(Point ... values) {
        boolean result = false;
        for (int i = 0; i < values.length; ++i) {
            ParserResult evaluatedValue;
            if (values[i].isComplex() && (values[i].getStringValue() == null || values[i].getStringValue().isEmpty())) {
                result = true;
                break;
            }
            if (values[i].getStringValue() == null || values[i].getStringValue().isEmpty() || !(evaluatedValue = Parser.eval(values[i].getStringValue())).isComplex()) continue;
            result = true;
            break;
        }
        return result;
    }

    private static List<String> pointToVar(Point ... values) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            result.add(values[i].getVar());
        }
        return result;
    }
}

