/*
 * Decompiled with CFR 0.152.
 */
package com.expression.parser.function;

import com.expression.parser.exception.CalculatorException;

public class Complex {
    private double r;
    private double i;

    public Complex(double r, double i) {
        this.r = r;
        this.i = i;
    }

    public Complex() {
        this.r = 0.0;
        this.i = 0.0;
    }

    public double getR() {
        return this.r;
    }

    public void setR(double r) {
        this.r = r;
    }

    public double getI() {
        return this.i;
    }

    public void setI(double i) {
        this.i = i;
    }

    public static Complex add(Complex a, Complex b) {
        double real = a.r + b.r;
        double imag = a.i + b.i;
        return new Complex(real, imag);
    }

    public static Complex add(double real, Complex c) {
        return new Complex(c.r + real, c.i);
    }

    public static Complex sub(Complex a, Complex b) {
        double real = a.r - b.r;
        double imag = a.i - b.i;
        return new Complex(real, imag);
    }

    public static Complex sub(double real, Complex c) {
        return new Complex(c.r - real, c.i);
    }

    public static Complex mul(Complex a, Complex b) {
        double real = a.r * b.r - a.i * b.i;
        double imag = a.i * b.r + a.r * b.i;
        return new Complex(real, imag);
    }

    public static Complex conjugate(Complex c) {
        return new Complex(c.r, -c.i);
    }

    public static Complex div(Complex a, Complex b) throws CalculatorException {
        if (b.r == 0.0 && b.i == 0.0) {
            throw new CalculatorException("The complex number b is 0");
        }
        double c = Math.pow(b.r, 2.0);
        double d = Math.pow(b.i, 2.0);
        double real = a.r * b.r + a.i * b.i;
        double imag = a.i * b.r - a.r * b.i;
        return new Complex(real /= c + d, imag /= c + d);
    }

    public static double abs(Complex z) {
        double ans;
        double x = Math.abs(z.r);
        double y = Math.abs(z.i);
        if (x == 0.0) {
            ans = y;
        } else if (y == 0.0) {
            ans = x;
        } else if (x > y) {
            double temp = y / x;
            ans = x * Math.sqrt(1.0 + temp * temp);
        } else {
            double temp = x / y;
            ans = y * Math.sqrt(1.0 + temp * temp);
        }
        return ans;
    }

    public static Complex sqrt(Complex c) {
        Complex result = null;
        if (c.r == 0.0 && c.i == 0.0) {
            result = new Complex();
        } else {
            double imag;
            double real;
            double w;
            double y;
            double x = Math.abs(c.r);
            if (x >= (y = Math.abs(c.i))) {
                double r = y / x;
                w = Math.sqrt(x) * Math.sqrt(0.5 * (1.0 + Math.sqrt(1.0 + r * r)));
            } else {
                double r = x / y;
                w = Math.sqrt(y) * Math.sqrt(0.5 * (r + Math.sqrt(1.0 + r * r)));
            }
            if (c.r >= 0.0) {
                real = w;
                imag = c.i / (2.0 * w);
            } else {
                imag = c.i >= 0.0 ? w : -w;
                real = c.i / (2.0 * imag);
            }
            result = new Complex(real, imag);
        }
        return result;
    }

    public static Complex mul(double x, Complex c) {
        Complex result = new Complex();
        result.r = c.r * x;
        result.i = c.i * x;
        return result;
    }

    public static Complex div(double x, Complex c) throws CalculatorException {
        if (x == 0.0) {
            throw new CalculatorException("scalar is 0");
        }
        Complex result = new Complex();
        result.r = c.r / x;
        result.i = c.i / x;
        return result;
    }

    public Complex inverse() {
        Complex result = new Complex();
        double a = this.r * this.r;
        double b = this.i * this.i;
        if (a == 0.0 && b == 0.0) {
            result.r = 0.0;
            result.i = 0.0;
        } else {
            result.r = this.r / (a + b);
            result.i = this.i / (a + b);
        }
        return result;
    }

    public static Complex pow(Complex c, Double exp) {
        return c.pow(exp);
    }

    public static Complex pow(Complex c, Complex exp) {
        return c.pow(exp);
    }

    public double module() {
        return Math.sqrt(this.r * this.r + this.i * this.i);
    }

    public double arg() {
        double angle = Math.atan2(this.i, this.r);
        if (angle < 0.0) {
            angle = Math.PI * 2 + angle;
        }
        return angle * 180.0 / Math.PI;
    }

    public Complex negate() {
        return new Complex(-this.r, -this.i);
    }

    public Complex exp() {
        double exp_x = Math.exp(this.r);
        return new Complex(exp_x * Math.cos(this.i), exp_x * Math.sin(this.i));
    }

    public Complex log10() {
        double rpart = Math.sqrt(this.r * this.r + this.i * this.i);
        double ipart = Math.atan2(this.i, this.r);
        if (ipart > Math.PI) {
            ipart -= Math.PI * 2;
        }
        return new Complex(Math.log10(rpart), 1.0 / Math.log(10.0) * ipart);
    }

    public Complex log() {
        return new Complex(Math.log(Complex.abs(this)), Math.atan2(this.i, this.r));
    }

    public Complex sqrt() {
        double r = Math.sqrt(this.r * this.r + this.i * this.i);
        double rpart = Math.sqrt(0.5 * (r + this.r));
        double ipart = Math.sqrt(0.5 * (r - this.r));
        if (this.i < 0.0) {
            ipart = -ipart;
        }
        return new Complex(rpart, ipart);
    }

    public static Complex cbrt(Complex a) {
        Complex z = new Complex();
        if (a.i != 0.0) {
            z.r = Math.cbrt(Complex.abs(a)) * Math.cos(a.arg() / 3.0);
            z.i = Math.cbrt(Complex.abs(a)) * Math.sin(a.arg() / 3.0);
        } else {
            z = new Complex(Math.cbrt(a.r), 0.0);
        }
        return z;
    }

    public Complex pow(Complex exp) {
        Complex a = this.log();
        a = Complex.mul(exp, a);
        return a.exp();
    }

    public Complex pow(double exp) {
        Complex a = this.log();
        a = Complex.mul(exp, a);
        return a.exp();
    }

    public Complex sin() {
        return new Complex(Math.sin(this.r) * Math.cosh(this.i), Math.cos(this.r) * Math.sinh(this.i));
    }

    public Complex cos() {
        return new Complex(Math.cos(this.r) * Math.cosh(this.i), -StrictMath.sin(this.r) * Math.sinh(this.i));
    }

    public Complex tan() throws CalculatorException {
        return Complex.div(this.sin(), this.cos());
    }

    public Complex asin() {
        Complex IM = new Complex(0.0, -1.0);
        Complex ZP = Complex.mul(this, IM);
        Complex ZM = Complex.add(Complex.sub(new Complex(1.0, 0.0), Complex.mul(this, this)).sqrt(), ZP);
        return Complex.mul(ZM.log(), new Complex(0.0, 1.0));
    }

    public Complex acos() {
        Complex IM = new Complex(0.0, -1.0);
        Complex ZM = Complex.add(Complex.mul(Complex.sub(new Complex(1.0, 0.0), Complex.mul(this, this)).sqrt(), IM), this);
        return Complex.mul(ZM.log(), new Complex(0.0, 1.0));
    }

    public Complex atan() throws CalculatorException {
        Complex IM = new Complex(0.0, -1.0);
        Complex ZP = new Complex(this.r, this.i - 1.0);
        Complex ZM = new Complex(-this.r, -this.i - 1.0);
        return Complex.div(2.0, Complex.mul(IM, Complex.div(ZP, ZM).log()));
    }

    public Complex sinh() {
        return new Complex(Math.sinh(this.r) * Math.cos(this.i), Math.cosh(this.r) * Math.sin(this.i));
    }

    public Complex cosh() {
        return new Complex(Math.cosh(this.r) * Math.cos(this.i), Math.sinh(this.r) * Math.sin(this.i));
    }

    public Complex tanh() throws CalculatorException {
        return Complex.div(this.sinh(), this.cosh());
    }

    public Complex atanh() throws CalculatorException {
        return Complex.sub(Complex.add(1.0, this).log(), Complex.div(2.0, Complex.sub(1.0, this).negate().log()));
    }
}

