/*
 * Decompiled with CFR 0.152.
 */
package com.expression.parser.function;

import com.expression.parser.ParserManager;
import com.expression.parser.exception.CalculatorException;
import com.expression.parser.function.Complex;
import java.util.ArrayList;
import java.util.List;

public class ComplexFunction {
    public static final String SIN = "sin";
    public static final String COS = "cos";
    public static final String SINH = "sinh";
    public static final String COSH = "cosh";
    public static final String TAN = "tan";
    public static final String TANH = "tanh";
    public static final String ASIN = "asin";
    public static final String ACOS = "acos";
    public static final String ATAN = "atan";
    public static final String E = "e";
    public static final String PI = "pi";
    public static final String LN = "ln";
    public static final String LOG = "log";
    public static final String SQRT = "sqrt";
    public static final String CBRT = "cbrt";
    public boolean degree = false;
    private String f;

    public ComplexFunction(String f) {
        this.f = f.trim().replaceAll(" ", "");
        this.degree = ParserManager.getInstance().isDeegre();
    }

    public String getF() {
        return this.f;
    }

    public void setF(String f) {
        this.f = f;
    }

    public Complex getValue(List<Complex> values, List<String> variables) throws CalculatorException {
        ArrayList<String> vars = new ArrayList<String>();
        for (String string : variables) {
            vars.add(string.toLowerCase());
        }
        return this.eval(this.f, values, vars);
    }

    private Complex eval(String f, List<Complex> values, List<String> variables) throws CalculatorException {
        f = f.trim().toLowerCase();
        Complex value = new Complex(0.0, 0.0);
        String number = "";
        String function = "";
        boolean hasNumber = false;
        boolean hasFunction = false;
        boolean isImaginary = false;
        block23: for (int i = 0; i < f.length(); ++i) {
            char character = f.charAt(i);
            switch (character) {
                case '*': {
                    String new_f;
                    Double numb;
                    if (hasNumber && !isImaginary) {
                        numb = new Double(number);
                        String new_f2 = this.nextFunction(f.substring(i + 1, f.length()));
                        value = Complex.mul(new Complex(numb, 0.0), this.eval(new_f2, values, variables));
                        i += new_f2.length();
                        hasNumber = false;
                        number = "";
                        continue block23;
                    }
                    if (hasNumber && isImaginary) {
                        numb = new Double(number);
                        String new_f3 = this.nextFunction(f.substring(i + 1, f.length()));
                        value = Complex.mul(new Complex(0.0, numb), this.eval(new_f3, values, variables));
                        i += new_f3.length();
                        hasNumber = false;
                        isImaginary = false;
                        number = "";
                        continue block23;
                    }
                    if (hasFunction) {
                        new_f = this.nextFunction(f.substring(i + 1, f.length()));
                        value = Complex.mul(this.eval(function, values, variables), this.eval(new_f, values, variables));
                        i += new_f.length();
                        hasFunction = false;
                        function = "";
                        continue block23;
                    }
                    new_f = this.nextFunction(f.substring(i + 1, f.length()));
                    value = Complex.mul(value, this.eval(new_f, values, variables));
                    i += new_f.length();
                    continue block23;
                }
                case '+': {
                    String new_f;
                    Double numb;
                    if (hasNumber && !isImaginary) {
                        numb = new Double(number);
                        String new_f4 = f.substring(i + 1, f.length());
                        value = Complex.add(new Complex(numb, 0.0), this.eval(new_f4, values, variables));
                        i += new_f4.length();
                        hasNumber = false;
                        number = "";
                        continue block23;
                    }
                    if (hasNumber && isImaginary) {
                        numb = new Double(number);
                        String new_f5 = f.substring(i + 1, f.length());
                        value = Complex.add(new Complex(0.0, numb), this.eval(new_f5, values, variables));
                        i += new_f5.length();
                        hasNumber = false;
                        isImaginary = false;
                        number = "";
                        continue block23;
                    }
                    if (hasFunction) {
                        new_f = f.substring(i + 1, f.length());
                        value = Complex.add(this.eval(function, values, variables), this.eval(new_f, values, variables));
                        i += new_f.length();
                        hasFunction = false;
                        function = "";
                        continue block23;
                    }
                    new_f = f.substring(i + 1, f.length());
                    value = Complex.add(value, this.eval(new_f, values, variables));
                    i += new_f.length();
                    continue block23;
                }
                case '-': {
                    String new_f;
                    Double numb;
                    if (hasNumber && !isImaginary) {
                        numb = new Double(number);
                        String new_f6 = this.nextMinusFunction(f.substring(i + 1, f.length()));
                        value = Complex.sub(new Complex(numb, 0.0), this.eval(new_f6, values, variables));
                        i += new_f6.length();
                        hasNumber = false;
                        number = "";
                        continue block23;
                    }
                    if (hasNumber && isImaginary) {
                        numb = new Double(number);
                        String new_f7 = this.nextMinusFunction(f.substring(i + 1, f.length()));
                        value = Complex.sub(new Complex(0.0, numb), this.eval(new_f7, values, variables));
                        i += new_f7.length();
                        hasNumber = false;
                        isImaginary = false;
                        number = "";
                        continue block23;
                    }
                    if (hasFunction) {
                        new_f = this.nextMinusFunction(f.substring(i + 1, f.length()));
                        value = Complex.sub(this.eval(function, values, variables), this.eval(new_f, values, variables));
                        i += new_f.length();
                        hasFunction = false;
                        function = "";
                        continue block23;
                    }
                    new_f = this.nextMinusFunction(f.substring(i + 1, f.length()));
                    value = Complex.sub(value, this.eval(new_f, values, variables));
                    i += new_f.length();
                    continue block23;
                }
                case '/': {
                    String new_f;
                    Double numb;
                    if (hasNumber && !isImaginary) {
                        numb = new Double(number);
                        String new_f8 = this.nextFunction(f.substring(i + 1, f.length()));
                        value = Complex.div(new Complex(numb, 0.0), this.eval(new_f8, values, variables));
                        i += new_f8.length();
                        hasNumber = false;
                        number = "";
                        continue block23;
                    }
                    if (hasNumber && isImaginary) {
                        numb = new Double(number);
                        String new_f9 = this.nextFunction(f.substring(i + 1, f.length()));
                        value = Complex.div(new Complex(0.0, numb), this.eval(new_f9, values, variables));
                        i += new_f9.length();
                        hasNumber = false;
                        isImaginary = false;
                        number = "";
                        continue block23;
                    }
                    if (hasFunction) {
                        new_f = this.nextFunction(f.substring(i + 1, f.length()));
                        value = Complex.div(this.eval(function, values, variables), this.eval(new_f, values, variables));
                        i += new_f.length();
                        hasFunction = false;
                        function = "";
                        continue block23;
                    }
                    new_f = this.nextFunction(f.substring(i + 1, f.length()));
                    value = Complex.div(value, this.eval(new_f, values, variables));
                    i += new_f.length();
                    continue block23;
                }
                case '^': {
                    String new_f;
                    Double numb;
                    if (hasNumber && !isImaginary) {
                        numb = new Double(number);
                        String new_f10 = this.nextFunction(f.substring(i + 1, f.length()));
                        value = Complex.pow(this.eval(new_f10, values, variables), numb);
                        i += new_f10.length();
                        hasNumber = false;
                        number = "";
                        continue block23;
                    }
                    if (hasNumber && isImaginary) {
                        numb = new Double(number);
                        String new_f11 = this.nextFunction(f.substring(i + 1, f.length()));
                        value = Complex.pow(this.eval(new_f11, values, variables), new Complex(0.0, numb));
                        i += new_f11.length();
                        hasNumber = false;
                        isImaginary = false;
                        number = "";
                        continue block23;
                    }
                    if (hasFunction) {
                        new_f = this.nextFunction(f.substring(i + 1, f.length()));
                        value = Complex.pow(this.eval(function, values, variables), this.eval(new_f, values, variables));
                        i += new_f.length();
                        hasFunction = false;
                        function = "";
                        continue block23;
                    }
                    new_f = this.nextFunction(f.substring(i + 1, f.length()));
                    value = Complex.pow(value, this.eval(new_f, values, variables));
                    i += new_f.length();
                    continue block23;
                }
                case '0': {
                    hasNumber = true;
                    number = number + character;
                    if (i != f.length() - 1) continue block23;
                    value = new Complex(new Double(number), 0.0);
                    number = "";
                    hasNumber = false;
                    continue block23;
                }
                case '1': {
                    hasNumber = true;
                    number = number + character;
                    if (i != f.length() - 1) continue block23;
                    value = new Complex(new Double(number), 0.0);
                    number = "";
                    hasNumber = false;
                    continue block23;
                }
                case '2': {
                    hasNumber = true;
                    number = number + character;
                    if (i != f.length() - 1) continue block23;
                    value = new Complex(new Double(number), 0.0);
                    number = "";
                    hasNumber = false;
                    continue block23;
                }
                case '3': {
                    hasNumber = true;
                    number = number + character;
                    if (i != f.length() - 1) continue block23;
                    value = new Complex(new Double(number), 0.0);
                    number = "";
                    hasNumber = false;
                    continue block23;
                }
                case '4': {
                    hasNumber = true;
                    number = number + character;
                    if (i != f.length() - 1) continue block23;
                    value = new Complex(new Double(number), 0.0);
                    number = "";
                    hasNumber = false;
                    continue block23;
                }
                case '5': {
                    hasNumber = true;
                    number = number + character;
                    if (i != f.length() - 1) continue block23;
                    value = new Complex(new Double(number), 0.0);
                    number = "";
                    hasNumber = false;
                    continue block23;
                }
                case '6': {
                    hasNumber = true;
                    number = number + character;
                    if (i != f.length() - 1) continue block23;
                    value = new Complex(new Double(number), 0.0);
                    number = "";
                    hasNumber = false;
                    continue block23;
                }
                case '7': {
                    hasNumber = true;
                    number = number + character;
                    if (i != f.length() - 1) continue block23;
                    value = new Complex(new Double(number), 0.0);
                    number = "";
                    hasNumber = false;
                    continue block23;
                }
                case '8': {
                    hasNumber = true;
                    number = number + character;
                    if (i != f.length() - 1) continue block23;
                    value = new Complex(new Double(number), 0.0);
                    number = "";
                    hasNumber = false;
                    continue block23;
                }
                case '9': {
                    hasNumber = true;
                    number = number + character;
                    if (i != f.length() - 1) continue block23;
                    value = new Complex(new Double(number), 0.0);
                    number = "";
                    hasNumber = false;
                    continue block23;
                }
                case '.': {
                    if (i == f.length() - 1) {
                        throw new CalculatorException("The function is not well-formed");
                    }
                    if (!hasNumber || number.length() <= 0) continue block23;
                    number = number + character;
                    continue block23;
                }
                case '(': {
                    if (i == f.length() - 1) {
                        throw new CalculatorException("The function is not well-formed");
                    }
                    String new_f = f.substring(i + 1, this.nextBracket(f));
                    if (hasFunction) {
                        if (function.equals(SIN)) {
                            value = this.eval(new_f, values, variables).sin();
                        } else if (function.equals(COS)) {
                            value = this.eval(new_f, values, variables).cos();
                        } else if (function.equals(TAN)) {
                            value = this.eval(new_f, values, variables).tan();
                        } else if (function.equals(SINH)) {
                            value = this.eval(new_f, values, variables).sinh();
                        } else if (function.equals(COSH)) {
                            value = this.eval(new_f, values, variables).cosh();
                        } else if (function.equals(TANH)) {
                            value = this.eval(new_f, values, variables).tanh();
                        } else if (function.equals(ASIN)) {
                            value = this.eval(new_f, values, variables).asin();
                        } else if (function.equals(ACOS)) {
                            value = this.eval(new_f, values, variables).acos();
                        } else if (function.equals(ATAN)) {
                            value = this.eval(new_f, values, variables).atan();
                        } else if (function.equals(LN)) {
                            value = this.eval(new_f, values, variables).log();
                        } else if (function.equals(LOG)) {
                            value = this.eval(new_f, values, variables).log10();
                        } else if (function.equals(SQRT)) {
                            value = this.eval(new_f, values, variables).sqrt();
                        } else if (function.equals(CBRT)) {
                            value = Complex.cbrt(this.eval(new_f, values, variables));
                        } else {
                            throw new CalculatorException("The function is not well-formed");
                        }
                        hasFunction = false;
                        function = "";
                    } else {
                        value = this.eval(new_f, values, variables);
                    }
                    i = i + new_f.length() + 1;
                    continue block23;
                }
                case ')': {
                    throw new CalculatorException(" '(' is not finished ");
                }
                case ' ': {
                    continue block23;
                }
                case 'i': {
                    if (!hasFunction) {
                        if (hasNumber) {
                            value = new Complex(0.0, new Double(number));
                            number = "";
                            isImaginary = true;
                            continue block23;
                        }
                        value = new Complex(0.0, 1.0);
                        isImaginary = true;
                        continue block23;
                    }
                    function = function + character;
                    hasFunction = true;
                    if (i != f.length() - 1) continue block23;
                    if (function.equals(E)) {
                        value = new Complex(Math.E, 0.0);
                        continue block23;
                    }
                    if (function.equals(PI)) {
                        value = new Complex(Math.PI, 0.0);
                        continue block23;
                    }
                    if (function.length() == 1) {
                        int n = variables.indexOf(function);
                        if (n >= 0) {
                            value = values.get(n);
                            continue block23;
                        }
                        throw new CalculatorException("function is not well defined");
                    }
                    throw new CalculatorException("function is not well defined");
                }
                case 'j': {
                    if (!hasFunction) {
                        if (hasNumber) {
                            value = new Complex(0.0, new Double(number));
                            isImaginary = true;
                            continue block23;
                        }
                        value = new Complex(0.0, 1.0);
                        isImaginary = true;
                        continue block23;
                    }
                    function = function + character;
                    hasFunction = true;
                    if (i != f.length() - 1) continue block23;
                    if (function.equals(E)) {
                        value = new Complex(Math.E, 0.0);
                        continue block23;
                    }
                    if (function.equals(PI)) {
                        value = new Complex(Math.PI, 0.0);
                        continue block23;
                    }
                    if (function.length() == 1) {
                        int n = variables.indexOf(function);
                        if (n >= 0) {
                            value = values.get(n);
                            continue block23;
                        }
                        throw new CalculatorException("function is not well defined");
                    }
                    throw new CalculatorException("function is not well defined");
                }
                default: {
                    if (this.isValidCharacter(character)) {
                        function = function + character;
                        hasFunction = true;
                        if (i != f.length() - 1) continue block23;
                        if (function.equals(E)) {
                            value = new Complex(Math.E, 0.0);
                            continue block23;
                        }
                        if (function.equals(PI)) {
                            value = new Complex(Math.PI, 0.0);
                            continue block23;
                        }
                        if (function.length() == 1) {
                            int n = variables.indexOf(function);
                            if (n >= 0) {
                                value = values.get(n);
                                continue block23;
                            }
                            throw new CalculatorException("function is not well defined");
                        }
                        throw new CalculatorException("function is not well defined");
                    }
                    throw new CalculatorException("Invalid character");
                }
            }
        }
        return value;
    }

    private String nextFunction(String f) throws CalculatorException {
        String result = "";
        f = f.trim().toLowerCase();
        block11: for (int i = 0; i < f.length(); ++i) {
            char character = f.charAt(i);
            switch (character) {
                case '*': {
                    i = f.length();
                    continue block11;
                }
                case '/': {
                    i = f.length();
                    continue block11;
                }
                case '+': {
                    i = f.length();
                    continue block11;
                }
                case '-': {
                    i = f.length();
                    continue block11;
                }
                case '^': {
                    result = result + character;
                    continue block11;
                }
                case '.': {
                    result = result + character;
                    continue block11;
                }
                case '(': {
                    String new_f = f.substring(i, this.nextBracket(f) + 1);
                    result = result + new_f;
                    i = i + new_f.length() - 1;
                    continue block11;
                }
                case ')': {
                    throw new CalculatorException(" '(' is not finished ");
                }
                case ' ': {
                    result = result + character;
                    continue block11;
                }
                default: {
                    if (this.isValidNumericAndCharacter(character)) {
                        result = result + character;
                        continue block11;
                    }
                    throw new CalculatorException("Invalid character");
                }
            }
        }
        return result;
    }

    private String nextMinusFunction(String f) throws CalculatorException {
        String result = "";
        f = f.trim().toLowerCase();
        block11: for (int i = 0; i < f.length(); ++i) {
            char character = f.charAt(i);
            switch (character) {
                case '*': {
                    result = result + character;
                    continue block11;
                }
                case '/': {
                    result = result + character;
                    continue block11;
                }
                case '+': {
                    i = f.length();
                    continue block11;
                }
                case '-': {
                    i = f.length();
                    continue block11;
                }
                case '^': {
                    result = result + character;
                    continue block11;
                }
                case '.': {
                    result = result + character;
                    continue block11;
                }
                case '(': {
                    String new_f = f.substring(i, this.nextBracket(f) + 1);
                    result = result + new_f;
                    i = i + new_f.length() - 1;
                    continue block11;
                }
                case ')': {
                    throw new CalculatorException(" '(' is not finished ");
                }
                case ' ': {
                    result = result + character;
                    continue block11;
                }
                default: {
                    if (this.isValidNumericAndCharacter(character)) {
                        result = result + character;
                        continue block11;
                    }
                    throw new CalculatorException("Invalid character");
                }
            }
        }
        return result;
    }

    private boolean isValidCharacter(char character) {
        boolean result = false;
        switch (character) {
            case 'a': {
                result = true;
                break;
            }
            case 'b': {
                result = true;
                break;
            }
            case 'c': {
                result = true;
                break;
            }
            case 'd': {
                result = true;
                break;
            }
            case 'e': {
                result = true;
                break;
            }
            case 'f': {
                result = true;
                break;
            }
            case 'g': {
                result = true;
                break;
            }
            case 'h': {
                result = true;
                break;
            }
            case 'k': {
                result = true;
                break;
            }
            case 'l': {
                result = true;
                break;
            }
            case 'm': {
                result = true;
                break;
            }
            case 'n': {
                result = true;
                break;
            }
            case 'o': {
                result = true;
                break;
            }
            case 'p': {
                result = true;
                break;
            }
            case 'q': {
                result = true;
                break;
            }
            case 'r': {
                result = true;
                break;
            }
            case 's': {
                result = true;
                break;
            }
            case 't': {
                result = true;
                break;
            }
            case 'u': {
                result = true;
                break;
            }
            case 'v': {
                result = true;
                break;
            }
            case 'w': {
                result = true;
                break;
            }
            case 'x': {
                result = true;
                break;
            }
            case 'y': {
                result = true;
                break;
            }
            case 'z': {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    private boolean isValidNumericAndCharacter(char character) {
        boolean result = false;
        switch (character) {
            case 'a': {
                result = true;
                break;
            }
            case 'b': {
                result = true;
                break;
            }
            case 'c': {
                result = true;
                break;
            }
            case 'd': {
                result = true;
                break;
            }
            case 'e': {
                result = true;
                break;
            }
            case 'f': {
                result = true;
                break;
            }
            case 'g': {
                result = true;
                break;
            }
            case 'h': {
                result = true;
                break;
            }
            case 'i': {
                result = true;
                break;
            }
            case 'j': {
                result = true;
                break;
            }
            case 'k': {
                result = true;
                break;
            }
            case 'l': {
                result = true;
                break;
            }
            case 'm': {
                result = true;
                break;
            }
            case 'n': {
                result = true;
                break;
            }
            case 'o': {
                result = true;
                break;
            }
            case 'p': {
                result = true;
                break;
            }
            case 'q': {
                result = true;
                break;
            }
            case 'r': {
                result = true;
                break;
            }
            case 's': {
                result = true;
                break;
            }
            case 't': {
                result = true;
                break;
            }
            case 'u': {
                result = true;
                break;
            }
            case 'v': {
                result = true;
                break;
            }
            case 'w': {
                result = true;
                break;
            }
            case 'x': {
                result = true;
                break;
            }
            case 'y': {
                result = true;
                break;
            }
            case 'z': {
                result = true;
                break;
            }
            case '0': {
                result = true;
                break;
            }
            case '1': {
                result = true;
                break;
            }
            case '2': {
                result = true;
                break;
            }
            case '3': {
                result = true;
                break;
            }
            case '4': {
                result = true;
                break;
            }
            case '5': {
                result = true;
                break;
            }
            case '6': {
                result = true;
                break;
            }
            case '7': {
                result = true;
                break;
            }
            case '8': {
                result = true;
                break;
            }
            case '9': {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    private int nextBracket(String f) throws CalculatorException {
        int result = 0;
        int count = 0;
        block4: for (int i = 0; i < f.length(); ++i) {
            char character = f.charAt(i);
            switch (character) {
                case '(': {
                    result = i;
                    ++count;
                    continue block4;
                }
                case ')': {
                    result = i;
                    if (--count != 0) continue block4;
                    return i;
                }
                default: {
                    result = i;
                }
            }
        }
        if (count != 0) {
            throw new CalculatorException("( is not finished");
        }
        return result;
    }
}

