/*
 * Decompiled with CFR 0.152.
 */
package com.expression.parser.function;

import com.expression.parser.ParserManager;
import com.expression.parser.exception.CalculatorException;

public class FunctionX {
    public static final String SIN = "sin";
    public static final String COS = "cos";
    public static final String SINH = "sinh";
    public static final String COSH = "cosh";
    public static final String TAN = "tan";
    public static final String TANH = "tanh";
    public static final String ASIN = "asin";
    public static final String ACOS = "acos";
    public static final String ATAN = "atan";
    public static final String E = "e";
    public static final String PI = "pi";
    public static final String LN = "ln";
    public static final String LOG = "log";
    public static final String SQRT = "sqrt";
    public static final String CBRT = "cbrt";
    private boolean degree = false;
    private String f_x;

    public FunctionX(String f_x) {
        this.f_x = f_x.trim().replaceAll(" ", "");
        this.degree = ParserManager.getInstance().isDeegre();
    }

    public String getF_x() {
        return this.f_x;
    }

    public void setF_x(String f_x) {
        this.f_x = f_x;
    }

    public double getF_xo(double xo) throws CalculatorException {
        return this.eval(this.f_x, xo);
    }

    private double eval(String f_x, double xi) throws CalculatorException {
        f_x = f_x.trim().toLowerCase();
        double value = 0.0;
        String number = "";
        String function = "";
        boolean hasNumber = false;
        boolean hasFunction = false;
        block21: for (int i = 0; i < f_x.length(); ++i) {
            char character = f_x.charAt(i);
            switch (character) {
                case '*': {
                    String new_f_x;
                    String new_f_x2;
                    Double numb;
                    if (hasNumber) {
                        numb = new Double(number);
                        new_f_x2 = this.nextFunction(f_x.substring(i + 1, f_x.length()));
                        value = numb * this.eval(new_f_x2, xi);
                        i += new_f_x2.length();
                        hasNumber = false;
                        number = "";
                        continue block21;
                    }
                    if (hasFunction) {
                        new_f_x = this.nextFunction(f_x.substring(i + 1, f_x.length()));
                        value = this.eval(function, xi) * this.eval(new_f_x, xi);
                        i += new_f_x.length();
                        hasFunction = false;
                        function = "";
                        continue block21;
                    }
                    new_f_x = this.nextFunction(f_x.substring(i + 1, f_x.length()));
                    value *= this.eval(new_f_x, xi);
                    i += new_f_x.length();
                    continue block21;
                }
                case '+': {
                    String new_f_x;
                    String new_f_x2;
                    Double numb;
                    if (hasNumber) {
                        numb = new Double(number);
                        new_f_x2 = f_x.substring(i + 1, f_x.length());
                        value = numb + this.eval(new_f_x2, xi);
                        i += new_f_x2.length();
                        hasNumber = false;
                        number = "";
                        continue block21;
                    }
                    if (hasFunction) {
                        new_f_x = f_x.substring(i + 1, f_x.length());
                        value = this.eval(function, xi) + this.eval(new_f_x, xi);
                        i += new_f_x.length();
                        hasFunction = false;
                        function = "";
                        continue block21;
                    }
                    new_f_x = f_x.substring(i + 1, f_x.length());
                    value += this.eval(new_f_x, xi);
                    i += new_f_x.length();
                    continue block21;
                }
                case '-': {
                    String new_f_x;
                    String new_f_x2;
                    Double numb;
                    if (hasNumber) {
                        numb = new Double(number);
                        new_f_x2 = this.nextMinusFunction(f_x.substring(i + 1, f_x.length()));
                        value = numb - this.eval(new_f_x2, xi);
                        i += new_f_x2.length();
                        hasNumber = false;
                        number = "";
                        continue block21;
                    }
                    if (hasFunction) {
                        new_f_x = this.nextMinusFunction(f_x.substring(i + 1, f_x.length()));
                        value = this.eval(function, xi) - this.eval(new_f_x, xi);
                        i += new_f_x.length();
                        hasFunction = false;
                        function = "";
                        continue block21;
                    }
                    new_f_x = this.nextMinusFunction(f_x.substring(i + 1, f_x.length()));
                    value -= this.eval(new_f_x, xi);
                    i += new_f_x.length();
                    continue block21;
                }
                case '/': {
                    String new_f_x;
                    String new_f_x2;
                    Double numb;
                    if (hasNumber) {
                        numb = new Double(number);
                        new_f_x2 = this.nextFunction(f_x.substring(i + 1, f_x.length()));
                        value = numb / this.eval(new_f_x2, xi);
                        i += new_f_x2.length();
                        hasNumber = false;
                        number = "";
                        continue block21;
                    }
                    if (hasFunction) {
                        new_f_x = this.nextFunction(f_x.substring(i + 1, f_x.length()));
                        value = this.eval(function, xi) / this.eval(new_f_x, xi);
                        i += new_f_x.length();
                        hasFunction = false;
                        function = "";
                        continue block21;
                    }
                    new_f_x = this.nextFunction(f_x.substring(i + 1, f_x.length()));
                    value /= this.eval(new_f_x, xi);
                    i += new_f_x.length();
                    continue block21;
                }
                case '^': {
                    String new_f_x;
                    String new_f_x2;
                    Double numb;
                    if (hasNumber) {
                        numb = new Double(number);
                        new_f_x2 = this.nextFunction(f_x.substring(i + 1, f_x.length()));
                        value = Math.pow(numb, this.eval(new_f_x2, xi));
                        i += new_f_x2.length();
                        hasNumber = false;
                        number = "";
                        continue block21;
                    }
                    if (hasFunction) {
                        new_f_x = this.nextFunction(f_x.substring(i + 1, f_x.length()));
                        value = Math.pow(this.eval(function, xi), this.eval(new_f_x, xi));
                        i += new_f_x.length();
                        hasFunction = false;
                        function = "";
                        continue block21;
                    }
                    new_f_x = this.nextFunction(f_x.substring(i + 1, f_x.length()));
                    value = Math.pow(value, this.eval(new_f_x, xi));
                    i += new_f_x.length();
                    continue block21;
                }
                case '0': {
                    hasNumber = true;
                    number = number + character;
                    if (i != f_x.length() - 1) continue block21;
                    value = new Double(number);
                    number = "";
                    hasNumber = false;
                    continue block21;
                }
                case '1': {
                    hasNumber = true;
                    number = number + character;
                    if (i != f_x.length() - 1) continue block21;
                    value = new Double(number);
                    number = "";
                    hasNumber = false;
                    continue block21;
                }
                case '2': {
                    hasNumber = true;
                    number = number + character;
                    if (i != f_x.length() - 1) continue block21;
                    value = new Double(number);
                    number = "";
                    hasNumber = false;
                    continue block21;
                }
                case '3': {
                    hasNumber = true;
                    number = number + character;
                    if (i != f_x.length() - 1) continue block21;
                    value = new Double(number);
                    number = "";
                    hasNumber = false;
                    continue block21;
                }
                case '4': {
                    hasNumber = true;
                    number = number + character;
                    if (i != f_x.length() - 1) continue block21;
                    value = new Double(number);
                    number = "";
                    hasNumber = false;
                    continue block21;
                }
                case '5': {
                    hasNumber = true;
                    number = number + character;
                    if (i != f_x.length() - 1) continue block21;
                    value = new Double(number);
                    number = "";
                    hasNumber = false;
                    continue block21;
                }
                case '6': {
                    hasNumber = true;
                    number = number + character;
                    if (i != f_x.length() - 1) continue block21;
                    value = new Double(number);
                    number = "";
                    hasNumber = false;
                    continue block21;
                }
                case '7': {
                    hasNumber = true;
                    number = number + character;
                    if (i != f_x.length() - 1) continue block21;
                    value = new Double(number);
                    number = "";
                    hasNumber = false;
                    continue block21;
                }
                case '8': {
                    hasNumber = true;
                    number = number + character;
                    if (i != f_x.length() - 1) continue block21;
                    value = new Double(number);
                    number = "";
                    hasNumber = false;
                    continue block21;
                }
                case '9': {
                    hasNumber = true;
                    number = number + character;
                    if (i != f_x.length() - 1) continue block21;
                    value = new Double(number);
                    number = "";
                    hasNumber = false;
                    continue block21;
                }
                case '.': {
                    if (i == f_x.length() - 1) {
                        throw new CalculatorException("The function is not well-formed");
                    }
                    if (!hasNumber || number.length() <= 0) continue block21;
                    number = number + character;
                    continue block21;
                }
                case '(': {
                    if (i == f_x.length() - 1) {
                        throw new CalculatorException("The function is not well-formed");
                    }
                    String new_f_x = f_x.substring(i + 1, this.nextBracket(f_x));
                    if (hasFunction) {
                        if (function.equals(SIN)) {
                            value = this.degree ? Math.sin(Math.toRadians(this.eval(new_f_x, xi))) : Math.sin(this.eval(new_f_x, xi));
                        } else if (function.equals(COS)) {
                            value = this.degree ? Math.cos(Math.toRadians(this.eval(new_f_x, xi))) : Math.cos(this.eval(new_f_x, xi));
                        } else if (function.equals(TAN)) {
                            value = this.degree ? Math.tan(Math.toRadians(this.eval(new_f_x, xi))) : Math.tan(this.eval(new_f_x, xi));
                        } else if (function.equals(SINH)) {
                            value = Math.sinh(this.eval(new_f_x, xi));
                        } else if (function.equals(COSH)) {
                            value = Math.cosh(this.eval(new_f_x, xi));
                        } else if (function.equals(TANH)) {
                            value = Math.tanh(this.eval(new_f_x, xi));
                        } else if (function.equals(ASIN)) {
                            value = this.degree ? Math.asin(this.eval(new_f_x, xi)) * 57.29577951308232 : Math.asin(this.eval(new_f_x, xi));
                        } else if (function.equals(ACOS)) {
                            value = this.degree ? Math.acos(this.eval(new_f_x, xi)) * 57.29577951308232 : Math.acos(this.eval(new_f_x, xi));
                        } else if (function.equals(ATAN)) {
                            value = this.degree ? Math.atan(this.eval(new_f_x, xi)) * 57.29577951308232 : Math.atan(this.eval(new_f_x, xi));
                        } else if (function.equals(LN)) {
                            value = Math.log(this.eval(new_f_x, xi));
                        } else if (function.equals(LOG)) {
                            value = Math.log10(this.eval(new_f_x, xi));
                        } else if (function.equals(SQRT)) {
                            value = Math.sqrt(this.eval(new_f_x, xi));
                        } else if (function.equals(CBRT)) {
                            value = Math.cbrt(this.eval(new_f_x, xi));
                        } else {
                            throw new CalculatorException("The function is not well-formed");
                        }
                        hasFunction = false;
                        function = "";
                    } else {
                        value = this.eval(new_f_x, xi);
                    }
                    i = i + new_f_x.length() + 1;
                    continue block21;
                }
                case ')': {
                    throw new CalculatorException(" '(' is not finished ");
                }
                case ' ': {
                    continue block21;
                }
                default: {
                    if (this.isValidCharacter(character)) {
                        function = function + character;
                        hasFunction = true;
                        if (i != f_x.length() - 1) continue block21;
                        if (function.equals(E)) {
                            value = Math.E;
                            continue block21;
                        }
                        if (function.equals(PI)) {
                            value = Math.PI;
                            continue block21;
                        }
                        if (function.length() == 1) {
                            value = xi;
                            continue block21;
                        }
                        throw new CalculatorException("function is not well defined");
                    }
                    throw new CalculatorException("Invalid character");
                }
            }
        }
        return value;
    }

    private String nextFunction(String f_x) throws CalculatorException {
        String result = "";
        f_x = f_x.trim().toLowerCase();
        block11: for (int i = 0; i < f_x.length(); ++i) {
            char character = f_x.charAt(i);
            switch (character) {
                case '*': {
                    i = f_x.length();
                    continue block11;
                }
                case '/': {
                    i = f_x.length();
                    continue block11;
                }
                case '+': {
                    i = f_x.length();
                    continue block11;
                }
                case '-': {
                    i = f_x.length();
                    continue block11;
                }
                case '^': {
                    result = result + character;
                    continue block11;
                }
                case '.': {
                    result = result + character;
                    continue block11;
                }
                case '(': {
                    String new_f_x = f_x.substring(i, this.nextBracket(f_x) + 1);
                    result = result + new_f_x;
                    i = i + new_f_x.length() - 1;
                    continue block11;
                }
                case ')': {
                    throw new CalculatorException(" '(' is not finished ");
                }
                case ' ': {
                    result = result + character;
                    continue block11;
                }
                default: {
                    if (this.isValidNumericAndCharacter(character)) {
                        result = result + character;
                        continue block11;
                    }
                    throw new CalculatorException("Invalid character");
                }
            }
        }
        return result;
    }

    private String nextMinusFunction(String f_x) throws CalculatorException {
        String result = "";
        f_x = f_x.trim().toLowerCase();
        block11: for (int i = 0; i < f_x.length(); ++i) {
            char character = f_x.charAt(i);
            switch (character) {
                case '*': {
                    result = result + character;
                    continue block11;
                }
                case '/': {
                    result = result + character;
                    continue block11;
                }
                case '+': {
                    i = f_x.length();
                    continue block11;
                }
                case '-': {
                    i = f_x.length();
                    continue block11;
                }
                case '^': {
                    result = result + character;
                    continue block11;
                }
                case '.': {
                    result = result + character;
                    continue block11;
                }
                case '(': {
                    String new_f_x = f_x.substring(i, this.nextBracket(f_x) + 1);
                    result = result + new_f_x;
                    i = i + new_f_x.length() - 1;
                    continue block11;
                }
                case ')': {
                    throw new CalculatorException(" '(' is not finished ");
                }
                case ' ': {
                    result = result + character;
                    continue block11;
                }
                default: {
                    if (this.isValidNumericAndCharacter(character)) {
                        result = result + character;
                        continue block11;
                    }
                    throw new CalculatorException("Invalid character");
                }
            }
        }
        return result;
    }

    private boolean isValidCharacter(char character) {
        boolean result = false;
        switch (character) {
            case 'a': {
                result = true;
                break;
            }
            case 'b': {
                result = true;
                break;
            }
            case 'c': {
                result = true;
                break;
            }
            case 'd': {
                result = true;
                break;
            }
            case 'e': {
                result = true;
                break;
            }
            case 'f': {
                result = true;
                break;
            }
            case 'g': {
                result = true;
                break;
            }
            case 'h': {
                result = true;
                break;
            }
            case 'i': {
                result = true;
                break;
            }
            case 'j': {
                result = true;
                break;
            }
            case 'k': {
                result = true;
                break;
            }
            case 'l': {
                result = true;
                break;
            }
            case 'm': {
                result = true;
                break;
            }
            case 'n': {
                result = true;
                break;
            }
            case 'o': {
                result = true;
                break;
            }
            case 'p': {
                result = true;
                break;
            }
            case 'q': {
                result = true;
                break;
            }
            case 'r': {
                result = true;
                break;
            }
            case 's': {
                result = true;
                break;
            }
            case 't': {
                result = true;
                break;
            }
            case 'u': {
                result = true;
                break;
            }
            case 'v': {
                result = true;
                break;
            }
            case 'w': {
                result = true;
                break;
            }
            case 'x': {
                result = true;
                break;
            }
            case 'y': {
                result = true;
                break;
            }
            case 'z': {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    private boolean isValidNumericAndCharacter(char character) {
        boolean result = false;
        switch (character) {
            case 'a': {
                result = true;
                break;
            }
            case 'b': {
                result = true;
                break;
            }
            case 'c': {
                result = true;
                break;
            }
            case 'd': {
                result = true;
                break;
            }
            case 'e': {
                result = true;
                break;
            }
            case 'f': {
                result = true;
                break;
            }
            case 'g': {
                result = true;
                break;
            }
            case 'h': {
                result = true;
                break;
            }
            case 'i': {
                result = true;
                break;
            }
            case 'j': {
                result = true;
                break;
            }
            case 'k': {
                result = true;
                break;
            }
            case 'l': {
                result = true;
                break;
            }
            case 'm': {
                result = true;
                break;
            }
            case 'n': {
                result = true;
                break;
            }
            case 'o': {
                result = true;
                break;
            }
            case 'p': {
                result = true;
                break;
            }
            case 'q': {
                result = true;
                break;
            }
            case 'r': {
                result = true;
                break;
            }
            case 's': {
                result = true;
                break;
            }
            case 't': {
                result = true;
                break;
            }
            case 'u': {
                result = true;
                break;
            }
            case 'v': {
                result = true;
                break;
            }
            case 'w': {
                result = true;
                break;
            }
            case 'x': {
                result = true;
                break;
            }
            case 'y': {
                result = true;
                break;
            }
            case 'z': {
                result = true;
                break;
            }
            case '0': {
                result = true;
                break;
            }
            case '1': {
                result = true;
                break;
            }
            case '2': {
                result = true;
                break;
            }
            case '3': {
                result = true;
                break;
            }
            case '4': {
                result = true;
                break;
            }
            case '5': {
                result = true;
                break;
            }
            case '6': {
                result = true;
                break;
            }
            case '7': {
                result = true;
                break;
            }
            case '8': {
                result = true;
                break;
            }
            case '9': {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    private int nextBracket(String f_x) throws CalculatorException {
        int result = 0;
        int count = 0;
        block4: for (int i = 0; i < f_x.length(); ++i) {
            char character = f_x.charAt(i);
            switch (character) {
                case '(': {
                    result = i;
                    ++count;
                    continue block4;
                }
                case ')': {
                    result = i;
                    if (--count != 0) continue block4;
                    return i;
                }
                default: {
                    result = i;
                }
            }
        }
        if (count != 0) {
            throw new CalculatorException("( is not finished");
        }
        return result;
    }
}

