/*
 * Decompiled with CFR 0.152.
 */
package wile.engineerstools.items;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import wile.engineerstools.ModEngineersTools;
import wile.engineerstools.eapi.baubles.IBaubleItem;
import wile.engineerstools.items.EtItem;

public class DivingCapsuleItem
extends EtItem
implements IBaubleItem {
    private static int item_damage = 10;
    private static int trigger_threshold = 3;
    private static int instant_refresh = 6;

    public static void on_config(int maxuses, int trigger_threshold_bubbles, int instant_refresh_bubbles) {
        item_damage = Math.max(100 / MathHelper.func_76125_a((int)maxuses, (int)1, (int)100), 1);
        trigger_threshold = MathHelper.func_76125_a((int)trigger_threshold_bubbles, (int)2, (int)7);
        instant_refresh = MathHelper.func_76125_a((int)instant_refresh_bubbles, (int)1, (int)10);
        ModEngineersTools.LOGGER.info("Diving Capsule config: uses:" + maxuses + "(dmg " + item_damage + "), trigger:" + trigger_threshold + " bubbles, push:" + instant_refresh + " bubbles.");
    }

    public DivingCapsuleItem(Item.Properties properties) {
        super(properties.func_200917_a(1).func_200915_b(100).setNoRepair());
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof PlayerEntity) {
            this.inventoryTick(stack, world, (PlayerEntity)entity, itemSlot);
        }
    }

    @Override
    public void onBaubleTick(ItemStack stack, LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            this.inventoryTick(stack, entity.func_130014_f_(), (PlayerEntity)entity, -1);
        }
    }

    private void inventoryTick(ItemStack capsule, World world, PlayerEntity player, int itemSlot) {
        int air = player.func_70086_ai();
        int max_air = player.func_205010_bg();
        if (max_air <= 0) {
            return;
        }
        if (air > trigger_threshold * max_air / 10 || !player.func_70089_S()) {
            return;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_() && i != itemSlot; ++i) {
            if (!player.field_71071_by.func_70301_a(i).func_185136_b(capsule)) continue;
            return;
        }
        if (!world.field_72995_K) {
            player.func_70050_g(Math.min(player.func_70086_ai() + instant_refresh * max_air / 10, player.func_205010_bg()));
            int dmg = capsule.func_77952_i() + item_damage;
            if (dmg >= capsule.func_77958_k()) {
                capsule.func_190918_g(1);
            } else {
                capsule.func_196085_b(dmg);
            }
        } else if (capsule.func_77952_i() + item_damage >= capsule.func_77958_k()) {
            world.func_184133_a(player, player.func_180425_c(), SoundEvents.field_193805_fG, SoundCategory.PLAYERS, 1.2f, 1.4f);
        } else {
            world.func_184133_a(player, player.func_180425_c(), SoundEvents.field_203251_S, SoundCategory.PLAYERS, 1.0f, 2.2f);
        }
        if (!world.field_72995_K) {
            player.field_71071_by.func_70296_d();
        }
    }
}

