/*
 * Decompiled with CFR 0.152.
 */
package wile.engineerstools;

import net.minecraft.block.Block;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wile.engineerstools.ModConfig;
import wile.engineerstools.ModContent;
import wile.engineerstools.detail.ModResources;
import wile.engineerstools.items.SleepingBagItem;
import wile.engineerstools.libmc.detail.Auxiliaries;
import wile.engineerstools.libmc.detail.ExtendedShapelessRecipe;
import wile.engineerstools.libmc.detail.Networking;
import wile.engineerstools.libmc.detail.OptionalRecipeCondition;
import wile.engineerstools.libmc.detail.Overlay;

@Mod(value="engineerstools")
public class ModEngineersTools {
    public static final String MODID = "engineerstools";
    public static final String MODNAME = "Engineer's Tools";
    public static final int VERSION_DATAFIXER = 0;
    public static final Logger LOGGER = LogManager.getLogger();
    public static final ItemGroup ITEMGROUP = new ItemGroup("tabengineerstools"){

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ModContent.CRUSHING_HAMMER);
        }
    };

    public ModEngineersTools() {
        Auxiliaries.init(MODID, LOGGER, ModConfig::getServerConfig);
        Auxiliaries.logGitVersion(MODNAME);
        OptionalRecipeCondition.init(MODID, LOGGER);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ModConfig.COMMON_CONFIG_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ModConfig.SERVER_CONFIG_SPEC);
        MinecraftForge.EVENT_BUS.addListener(ForgeEvents::onSleepingLocationCheckEvent);
        MinecraftForge.EVENT_BUS.addListener(ForgeEvents::onPlayerWakeUpEvent);
    }

    public static final Logger logger() {
        return LOGGER;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static final class ForgeEvents {
        @SubscribeEvent
        public static final void onItemRegistry(RegistryEvent.Register<Item> event) {
            ModContent.registerItems(event);
        }

        @SubscribeEvent
        public static final void onRecipeRegistry(RegistryEvent.Register<IRecipeSerializer<?>> event) {
            event.getRegistry().register((IForgeRegistryEntry)ExtendedShapelessRecipe.SERIALIZER);
        }

        @SubscribeEvent
        public static final void onBlockRegistry(RegistryEvent.Register<Block> event) {
            ModContent.registerBlocks(event);
        }

        @SubscribeEvent
        public static final void onTileEntityRegistry(RegistryEvent.Register<TileEntityType<?>> event) {
            ModContent.registerTileEntities(event);
        }

        @SubscribeEvent
        public static final void onRegisterContainerTypes(RegistryEvent.Register<ContainerType<?>> event) {
            ModContent.registerContainers(event);
        }

        @SubscribeEvent
        public static final void onRegisterContainerTypes(ModelRegistryEvent event) {
            ModContent.registerModels();
        }

        @SubscribeEvent
        public static final void onRegisterSounds(RegistryEvent.Register<SoundEvent> event) {
            ModResources.registerSoundEvents(event);
        }

        @SubscribeEvent
        public static final void onCommonSetup(FMLCommonSetupEvent event) {
            Networking.init(ModEngineersTools.MODID);
            LOGGER.info("Registering recipe condition processor ...");
            CraftingHelper.register((IConditionSerializer)OptionalRecipeCondition.Serializer.INSTANCE);
            ModConfig.apply();
            ModContent.processRegisteredContent();
        }

        @SubscribeEvent
        public static final void onClientSetup(FMLClientSetupEvent event) {
            ModContent.processContentClientSide(event);
            ModContent.registerGuis(event);
            Overlay.register();
        }

        @SubscribeEvent
        public static final void onConfigLoad(ModConfig.Loading event) {
            ModConfig.onLoad(event.getConfig());
        }

        @SubscribeEvent
        public static final void onConfigChanged(ModConfig.Reloading event) {
            ModConfig.onFileChange(event.getConfig());
        }

        public final void onPlayerUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        }

        public static final void onSleepingLocationCheckEvent(SleepingLocationCheckEvent event) {
            SleepingBagItem.onSleepingLocationCheckEvent(event);
        }

        public static final void onPlayerWakeUpEvent(PlayerWakeUpEvent event) {
            SleepingBagItem.onPlayerWakeUpEvent(event);
        }
    }
}

